/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.Properties;

class JCEUtil {
    JCEUtil() {
    }

    private static Implementation getImplementation(String string, String string2, Provider provider) {
        String string3;
        while ((string3 = ((Properties)provider).getProperty("Alg.Alias." + string + "." + string2)) != null) {
            string2 = string3;
        }
        String string4 = ((Properties)provider).getProperty(string + "." + string2);
        if (string4 != null) {
            try {
                ClassLoader classLoader = provider.getClass().getClassLoader();
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string4) : Class.forName(string4);
                return new Implementation(clazz.newInstance(), provider);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but no class \"" + string4 + "\" found!");
            }
            catch (Exception exception) {
                throw new IllegalStateException("algorithm " + string2 + " in provider " + provider.getName() + " but class \"" + string4 + "\" inaccessible!");
            }
        }
        return null;
    }

    static Implementation getImplementation(String string, String string2, String string3) throws NoSuchProviderException {
        if (string3 == null) {
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n != providerArray.length) {
                Implementation implementation = JCEUtil.getImplementation(string, string2.toUpperCase(Locale.ENGLISH), providerArray[n]);
                if (implementation != null) {
                    return implementation;
                }
                implementation = JCEUtil.getImplementation(string, string2, providerArray[n]);
                if (implementation != null) {
                    return implementation;
                }
                ++n;
            }
        } else {
            Provider provider = Security.getProvider(string3);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string3 + " not found");
            }
            Implementation implementation = JCEUtil.getImplementation(string, string2.toUpperCase(Locale.ENGLISH), provider);
            if (implementation != null) {
                return implementation;
            }
            return JCEUtil.getImplementation(string, string2, provider);
        }
        return null;
    }

    static class Implementation {
        Object engine;
        Provider provider;

        Implementation(Object object, Provider provider) {
            this.engine = object;
            this.provider = provider;
        }

        Object getEngine() {
            return this.engine;
        }

        Provider getProvider() {
            return this.provider;
        }
    }
}

