/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Column {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$Column == null ? (class$org$dbunit$dataset$Column = Column.class$("org.dbunit.dataset.Column")) : class$org$dbunit$dataset$Column));
    public static final Nullable NO_NULLS = new Nullable("noNulls");
    public static final Nullable NULLABLE = new Nullable("nullable");
    public static final Nullable NULLABLE_UNKNOWN = new Nullable("nullableUnknown");
    private final String _columnName;
    private final DataType _dataType;
    private final String _sqlTypeName;
    private final Nullable _nullable;
    static /* synthetic */ Class class$org$dbunit$dataset$Column;
    static /* synthetic */ Class class$org$dbunit$dataset$Column$Nullable;

    public Column(String columnName, DataType dataType) {
        this._columnName = columnName;
        this._dataType = dataType;
        this._nullable = NULLABLE_UNKNOWN;
        this._sqlTypeName = dataType.toString();
    }

    public Column(String columnName, DataType dataType, Nullable nullable) {
        this._columnName = columnName;
        this._dataType = dataType;
        this._sqlTypeName = dataType.toString();
        this._nullable = nullable;
    }

    public Column(String columnName, DataType dataType, String sqlTypeName, Nullable nullable) {
        this._columnName = columnName;
        this._dataType = dataType;
        this._sqlTypeName = sqlTypeName;
        this._nullable = nullable;
    }

    public String getColumnName() {
        logger.debug("getColumnName() - start");
        return this._columnName;
    }

    public DataType getDataType() {
        logger.debug("getDataType() - start");
        return this._dataType;
    }

    public String getSqlTypeName() {
        logger.debug("getSqlTypeName() - start");
        return this._sqlTypeName;
    }

    public Nullable getNullable() {
        logger.debug("getNullable() - start");
        return this._nullable;
    }

    public static Nullable nullableValue(int nullable) {
        logger.debug("nullableValue(nullable=" + nullable + ") - start");
        switch (nullable) {
            case 0: {
                return NO_NULLS;
            }
            case 1: {
                return NULLABLE;
            }
            case 2: {
                return NULLABLE_UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unknown constant value " + nullable);
    }

    public static Nullable nullableValue(boolean nullable) {
        logger.debug("nullableValue(nullable=" + nullable + ") - start");
        return nullable ? NULLABLE : NO_NULLS;
    }

    public String toString() {
        logger.debug("toString() - start");
        return "(" + this._columnName + ", " + this._dataType + ", " + this._nullable + ")";
    }

    public boolean equals(Object o) {
        logger.debug("equals(o=" + o + ") - start");
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column column = (Column)o;
        if (!this._columnName.equals(column._columnName)) {
            return false;
        }
        if (!this._dataType.equals(column._dataType)) {
            return false;
        }
        if (!this._nullable.equals(column._nullable)) {
            return false;
        }
        return this._sqlTypeName.equals(column._sqlTypeName);
    }

    public int hashCode() {
        logger.debug("hashCode() - start");
        int result = this._columnName.hashCode();
        result = 29 * result + this._dataType.hashCode();
        result = 29 * result + this._sqlTypeName.hashCode();
        result = 29 * result + this._nullable.hashCode();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Nullable {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$Column$Nullable == null ? (class$org$dbunit$dataset$Column$Nullable = Column.class$("org.dbunit.dataset.Column$Nullable")) : class$org$dbunit$dataset$Column$Nullable));
        private final String _name;

        private Nullable(String name) {
            this._name = name;
        }

        public String toString() {
            logger.debug("toString() - start");
            return this._name;
        }
    }
}

