/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;
import org.dbunit.dataset.filter.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultColumnFilter
implements IColumnFilter {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$filter$DefaultColumnFilter == null ? (class$org$dbunit$dataset$filter$DefaultColumnFilter = DefaultColumnFilter.class$("org.dbunit.dataset.filter.DefaultColumnFilter")) : class$org$dbunit$dataset$filter$DefaultColumnFilter));
    private final PatternMatcher _includeMatcher = new PatternMatcher();
    private final PatternMatcher _excludeMatcher = new PatternMatcher();
    static /* synthetic */ Class class$org$dbunit$dataset$filter$DefaultColumnFilter;

    public void includeColumn(String columnPattern) {
        logger.debug("includeColumn(columnPattern=" + columnPattern + ") - start");
        this._includeMatcher.addPattern(columnPattern);
    }

    public void includeColumns(Column[] columns) {
        logger.debug("includeColumns(columns=" + columns + ") - start");
        for (int i = 0; i < columns.length; ++i) {
            this._includeMatcher.addPattern(columns[i].getColumnName());
        }
    }

    public void excludeColumn(String columnPattern) {
        logger.debug("excludeColumn(columnPattern=" + columnPattern + ") - start");
        this._excludeMatcher.addPattern(columnPattern);
    }

    public void excludeColumns(Column[] columns) {
        logger.debug("excludeColumns(columns=" + columns + ") - start");
        for (int i = 0; i < columns.length; ++i) {
            this._excludeMatcher.addPattern(columns[i].getColumnName());
        }
    }

    public static ITable includedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        logger.debug("includedColumnsTable(table=" + table + ", columnNames=" + columnNames + ") - start");
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            columnFilter.includeColumn(columnName);
        }
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable includedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        logger.debug("includedColumnsTable(table=" + table + ", columns=" + columns + ") - start");
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.includeColumns(columns);
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable excludedColumnsTable(ITable table, String[] columnNames) throws DataSetException {
        logger.debug("excludedColumnsTable(table=" + table + ", columnNames=" + columnNames + ") - start");
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            columnFilter.excludeColumn(columnName);
        }
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public static ITable excludedColumnsTable(ITable table, Column[] columns) throws DataSetException {
        logger.debug("excludedColumnsTable(table=" + table + ", columns=" + columns + ") - start");
        DefaultColumnFilter columnFilter = new DefaultColumnFilter();
        columnFilter.excludeColumns(columns);
        FilteredTableMetaData metaData = new FilteredTableMetaData(table.getTableMetaData(), columnFilter);
        return new CompositeTable((ITableMetaData)metaData, table);
    }

    public boolean accept(String tableName, Column column) {
        logger.debug("accept(tableName=" + tableName + ", column=" + column + ") - start");
        if (this._includeMatcher.isEmpty() || this._includeMatcher.accept(column.getColumnName())) {
            return !this._excludeMatcher.accept(column.getColumnName());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

