/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Scorevalidation;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class ScorevalidationDAO
implements clinical.server.dao.ScorevalidationDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, Scorevalidation bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_SCOREVALIDATION ");
            buf.append(" (DATATABLE,DATAID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,TIMESTAMP,COMMENTS,VALIDATORID,ASSESSMENTID,METHOD) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 12; ++i) {
                buf.append('?');
                if (i >= 11) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getDatatable(), 2);
            ps.setObject(2, bean.getDataid(), 2);
            ps.setObject(3, bean.getUniqueid(), 2);
            ps.setObject(4, bean.getTableid(), 2);
            ps.setObject(5, bean.getOwner(), 2);
            ps.setTimestamp(6, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(7, bean.getModuser(), 2);
            ps.setObject(8, bean.getTimestamp(), 93);
            ps.setObject(9, OracleUtils.getCLOB(con, bean.getComments()), 2005);
            ps.setObject(10, bean.getValidatorid(), 2);
            ps.setObject(11, bean.getAssessmentid(), 2);
            ps.setObject(12, bean.getMethod(), 12);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(Scorevalidation bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("DATATABLE");
        buf.append(',');
        buf.append("DATAID");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("TIMESTAMP");
        buf.append(',');
        buf.append("COMMENTS");
        buf.append(',');
        buf.append("VALIDATORID");
        buf.append(',');
        buf.append("ASSESSMENTID");
        buf.append(',');
        buf.append("METHOD");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Scorevalidation bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getDatatable() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATATABLE=?");
            qi.values.add(bean.getDatatable());
            valueSet = true;
        }
        if (bean.getDataid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATAID=?");
            qi.values.add(bean.getDataid());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getTimestamp() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TIMESTAMP=?");
            qi.values.add(bean.getTimestamp());
            valueSet = true;
        }
        if (bean.getComments() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COMMENTS=?");
            qi.values.add(bean.getComments());
            valueSet = true;
        }
        if (bean.getValidatorid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("VALIDATORID=?");
            qi.values.add(bean.getValidatorid());
            valueSet = true;
        }
        if (bean.getAssessmentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ASSESSMENTID=?");
            qi.values.add(bean.getAssessmentid());
            valueSet = true;
        }
        if (bean.getMethod() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("METHOD=?");
            qi.values.add(bean.getMethod());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Scorevalidation bean, Scorevalidation criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_SCOREVALIDATION SET ");
        if (bean.getDatatable() != null || bean.isNull("datatable")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATATABLE=? ");
            uqi.setValues.add(bean.getDatatable());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("datatable"), uqi);
            valueSet = true;
        }
        if (bean.getDataid() != null || bean.isNull("dataid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATAID=? ");
            uqi.setValues.add(bean.getDataid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("dataid"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getTimestamp() != null || bean.isNull("timestamp")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TIMESTAMP=? ");
            uqi.setValues.add(bean.getTimestamp());
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("timestamp"), uqi);
            valueSet = true;
        }
        if (bean.getComments() != null || bean.isNull("comments")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COMMENTS=? ");
            uqi.setValues.add(bean.getComments());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("comments"), uqi);
            valueSet = true;
        }
        if (bean.getValidatorid() != null || bean.isNull("validatorid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("VALIDATORID=? ");
            uqi.setValues.add(bean.getValidatorid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("validatorid"), uqi);
            valueSet = true;
        }
        if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ASSESSMENTID=? ");
            uqi.setValues.add(bean.getAssessmentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
            valueSet = true;
        }
        if (bean.getMethod() != null || bean.isNull("method")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("METHOD=? ");
            uqi.setValues.add(bean.getMethod());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("method"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Scorevalidation createObject(ResultSet rs) throws SQLException {
        Scorevalidation obj = new Scorevalidation();
        obj.setDatatable((BigDecimal)rs.getObject(1));
        obj.setDataid((BigDecimal)rs.getObject(2));
        obj.setUniqueid((BigDecimal)rs.getObject(3));
        obj.setTableid((BigDecimal)rs.getObject(4));
        obj.setOwner((BigDecimal)rs.getObject(5));
        if (rs.getTimestamp(6) != null) {
            obj.setModtime(new Date(rs.getTimestamp(6).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(7));
        obj.setTimestamp(OracleUtils.getTimestamp(rs.getObject(8)));
        obj.setComments(OracleUtils.readCLOB((CLOB)rs.getObject(9)));
        obj.setValidatorid((BigDecimal)rs.getObject(10));
        obj.setAssessmentid((BigDecimal)rs.getObject(11));
        obj.setMethod((String)rs.getObject(12));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Scorevalidation> find(Connection con, Scorevalidation criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Scorevalidation> results = new LinkedList<Scorevalidation>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_SCOREVALIDATION ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Scorevalidation item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, Scorevalidation bean, Scorevalidation criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, Scorevalidation criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_SCOREVALIDATION ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

