/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.web.DBUtils;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.services.AbstractSequenceHelper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgresSequenceHelper
extends AbstractSequenceHelper {
    protected PostgresSequenceHelper(String dbID) throws BaseException {
        super(dbID);
    }

    public static synchronized PostgresSequenceHelper getInstance(String dbID, String dbType) throws BaseException {
        PostgresSequenceHelper seqHelper = (PostgresSequenceHelper)instanceMap.get(dbID + '_' + dbType);
        if (seqHelper == null) {
            seqHelper = new PostgresSequenceHelper(dbID);
            instanceMap.put(dbID, seqHelper);
        }
        return seqHelper;
    }

    @Override
    public BigDecimal getNextUID(Connection con, String tableName, String columnName) throws BaseException {
        ResultSet rs;
        Statement st;
        block4: {
            BigDecimal bigDecimal;
            st = null;
            rs = null;
            try {
                st = con.createStatement();
                rs = st.executeQuery("select nextval('uid_seq')");
                if (!rs.next()) break block4;
                BigDecimal uid = rs.getBigDecimal(1);
                this.fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
                bigDecimal = uid;
            }
            catch (SQLException x) {
                try {
                    throw new BaseException(x);
                }
                catch (Throwable throwable) {
                    DBUtils.close(st, rs);
                    throw throwable;
                }
            }
            DBUtils.close(st, rs);
            return bigDecimal;
        }
        DBUtils.close(st, rs);
        return null;
    }

    @Override
    public BigDecimal getNextUID(UserInfo ui, String tableName, String columnName) throws BaseException {
        Statement st;
        Connection con;
        block4: {
            BigDecimal bigDecimal;
            con = null;
            st = null;
            try {
                con = this.dbPoolService.getConnection(ui.getName());
                st = con.createStatement();
                ResultSet rs = st.executeQuery("select nextval('uid_seq')");
                if (!rs.next()) break block4;
                BigDecimal uid = rs.getBigDecimal(1);
                this.fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
                bigDecimal = uid;
            }
            catch (Exception x) {
                try {
                    this.log.error((Object)"", (Throwable)x);
                    throw new BaseException(x);
                }
                catch (Throwable throwable) {
                    DBUtils.close(st);
                    this.releaseConnection(con, ui);
                    throw throwable;
                }
            }
            DBUtils.close(st);
            this.releaseConnection(con, ui);
            return bigDecimal;
        }
        DBUtils.close(st);
        this.releaseConnection(con, ui);
        return null;
    }
}

