/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider.test;

import COM.claymoresystems.provider.ClaymoreProvider;
import COM.claymoresystems.util.Bench;
import COM.claymoresystems.util.Util;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;

class DSATest
extends Bench {
    private static final byte[] testString = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    DSATest() {
    }

    public static void main(String[] args) {
        int iter = 1;
        Security.addProvider(new ClaymoreProvider());
        if (args.length != 0) {
            if (args.length == 1) {
                iter = Integer.parseInt(args[0]);
            } else {
                throw new InternalError("Bad arguments");
            }
        }
        int ss = Bench.register("SunSign");
        int sv = Bench.register("SunVerify");
        int cs = Bench.register("ClaymoreSign");
        int cv = Bench.register("ClaymoreVerify");
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
            keyGen.initialize(1024, new SecureRandom());
            KeyPair pair = keyGen.generateKeyPair();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(testString);
            PrivateKey priv = pair.getPrivate();
            byte[] digest = md.digest();
            int i = 0;
            while (i < iter) {
                Signature ourDSASign = Signature.getInstance("RawDSA");
                Signature ourDSAVerify = Signature.getInstance("RawDSA");
                Signature stockDSAVerify = Signature.getInstance("DSA");
                Signature stockDSASign = Signature.getInstance("DSA");
                Bench.start(cs);
                ourDSASign.initSign(priv);
                ourDSASign.update(digest);
                byte[] sig = ourDSASign.sign();
                Bench.end(cs);
                Util.xdump("signature", sig);
                ourDSASign = Signature.getInstance("RawDSA");
                ourDSASign.initSign(priv);
                ourDSASign.update(digest);
                sig = ourDSASign.sign();
                Util.xdump("second signature", sig);
                Bench.start(ss);
                stockDSASign.initSign(priv);
                stockDSASign.update(testString);
                byte[] sig2 = stockDSASign.sign();
                Bench.end(ss);
                if (!Util.areEqual(sig, sig2)) {
                    System.out.println("signatures don't match");
                }
                PublicKey pub = pair.getPublic();
                Bench.start(cv);
                ourDSAVerify.initVerify(pub);
                ourDSAVerify.update(digest);
                boolean verifies = ourDSAVerify.verify(sig);
                Bench.end(cv);
                if (verifies) {
                    System.out.println("Verifies with our implementation");
                } else {
                    System.out.println("Failed our verify");
                }
                Bench.start(sv);
                stockDSAVerify.initVerify(pub);
                stockDSAVerify.update(testString);
                verifies = stockDSAVerify.verify(sig);
                Bench.end(sv);
                if (verifies) {
                    System.out.println("Verifies with stock implementation");
                } else {
                    System.out.println("Failed stock verify");
                }
                byte[] badSig = new byte[sig.length];
                System.arraycopy(sig, 0, badSig, 0, sig.length);
                badSig[0] = (byte)(badSig[0] + 1);
                ourDSAVerify = Signature.getInstance("RawDSA");
                ourDSAVerify.initVerify(pub);
                ourDSAVerify.update(digest);
                boolean caughtExcept = false;
                try {
                    verifies = ourDSAVerify.verify(badSig);
                }
                catch (Exception e) {
                    caughtExcept = true;
                }
                if (!caughtExcept) {
                    System.out.println("Badly encoded sig Verifies with our implementation (BAD)");
                } else {
                    System.out.println("Badly encoded sig Failed our verify (OK)");
                }
                int n = digest.length - 1;
                digest[n] = (byte)(digest[n] + 1);
                ourDSAVerify = Signature.getInstance("RawDSA");
                ourDSAVerify.initVerify(pub);
                ourDSAVerify.update(digest);
                verifies = ourDSAVerify.verify(sig);
                if (verifies) {
                    System.out.println("Bad sig Verifies with our implementation (BAD)");
                } else {
                    System.out.println("Bad sig Failed our verify (OK)");
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
            e.printStackTrace(System.out);
        }
        Bench.dump();
    }
}

