/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.DefaultTransferHandler;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.Preferences;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseHandler;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class SimpleViewer {
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected final PdfDecoder decode_pdf = new PdfDecoder(true);
    protected GUIThumbnailPanel thumbnails = new SwingThumbnailPanel(this.commonValues, this.decode_pdf);
    private PropertiesFile properties = new PropertiesFile();
    public SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
    private GUISearchWindow searchFrame = new SwingSearchWindow(this.commonValues, this.currentGUI, this.decode_pdf);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
    protected GUIMouseHandler mouseHandler = new SwingMouseHandler(this.decode_pdf, this.currentGUI, this.commonValues, this.currentCommands);
    protected String[] scalingValues;
    final Preferences p = new Preferences();

    public void setupViewer(String string) {
        this.setupViewer();
        this.openDefaultFile(string);
    }

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    private void openDefaultFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(string);
                this.commonValues.setFileSize(file.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                String string4 = System.getProperty("org.jpedal.page");
                String string5 = System.getProperty("org.jpedal.bookmark");
                if (string4 != null) {
                    try {
                        int n = Integer.parseInt(string4);
                        if (n < 1) {
                            n = -1;
                            System.err.println(string4 + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(string4 + " must be 1 or larger. Opening on page 1");
                        }
                        if (n != -1) {
                            this.openFile(file, n);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(string4 + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(string4 + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (string5 != null) {
                    this.openFile(file, string5);
                } else {
                    this.currentCommands.openFile(string);
                }
            }
        }
    }

    public SimpleViewer() {
        PdfDecoder.showErrorMessages = true;
    }

    public SimpleViewer(int n) {
        PdfDecoder.showErrorMessages = true;
        this.commonValues.setModeOfOperation(n);
    }

    public void setupViewer() {
        String string;
        String string2;
        String string3 = this.properties.getValue("searchWindowType");
        if (string3 != null) {
            int n = Integer.parseInt(string3);
            this.searchFrame.setStyle(n);
            this.p.setSearchStyleDefaultValue(n);
        }
        this.currentGUI.setSearchFrame(this.searchFrame);
        String string4 = this.properties.getValue("borderType");
        if (string4 != null) {
            int n = Integer.parseInt(string4);
            this.decode_pdf.setBorderStyle(n);
            this.p.setBorderDefaultValue(n);
        }
        if ((string2 = this.properties.getValue("DPI")) != null) {
            int n = Integer.parseInt(string2);
            this.currentGUI.setDpi(n);
            this.p.setDpiDefaultValue(string2);
        }
        String string5 = this.properties.getValue("autoScroll");
        boolean bl = false;
        if (string5 != null) {
            if (string5.equals("true")) {
                bl = true;
            }
            this.currentGUI.setAutoScrolling(bl);
            this.p.setAutoScrollDefaultValue(bl);
        }
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_TABBED_PANE) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        if ((string = System.getProperty("org.jpedal.thumbnail")) != null) {
            if (string.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (string.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        this.init(null);
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.setupButtonsAndMenus();
        this.mouseHandler.setupMouse();
        this.decode_pdf.setMessageFrame(this.currentGUI.getFrame());
        boolean bl2 = this.properties.getValue("showfirsttimepopup").equals("true");
        if (bl2) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        if (JAIHelper.isJAIused() && this.properties != null && this.properties.getValue("showddmessage").equals("true")) {
            JOptionPane.showMessageDialog(this.decode_pdf, Messages.getMessage("PdfViewer.JAIWarning") + Messages.getMessage("PdfViewer.JAIWarning1") + Messages.getMessage("PdfViewer.JAIWarning2") + Messages.getMessage("PdfViewer.JAIWarning3") + Messages.getMessage("PdfViewer.JAIWarning4"));
            this.properties.setValue("showddmessage", "false");
        }
        if (!this.commonValues.isContentExtractor()) {
            boolean bl3 = this.properties.getValue("showitextmessage").equals("true");
            if (!this.commonValues.isItextOnClasspath() && bl3) {
                this.currentGUI.showItextPopup();
                this.properties.setValue("showitextmessage", "false");
            }
        }
        this.searchFrame.setStyle(SwingSearchWindow.SEARCH_EXTERNAL_WINDOW);
        String string6 = this.properties.getValue("searchWindowType");
        if (string6 != null && string6.length() != 0) {
            int n = Integer.parseInt(string6);
            this.searchFrame.setStyle(n);
        }
        DefaultTransferHandler defaultTransferHandler = new DefaultTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
        this.decode_pdf.setTransferHandler(defaultTransferHandler);
    }

    protected void init(ResourceBundle resourceBundle) {
        String[] stringArray;
        if (resourceBundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception exception) {
                System.out.println("Exception loading resource bundle");
            }
        } else {
            Messages.setBundle(resourceBundle);
        }
        this.scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"};
        if (this.commonValues.isContentExtractor()) {
            this.decode_pdf.setDisplayView(1, 1);
        } else {
            this.decode_pdf.setDisplayView(1, 2);
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        this.decode_pdf.init(true);
        this.decode_pdf.createPageHostspots(this.currentGUI.getAnnotTypes(), "org/jpedal/examples/simpleviewer/annots/");
        this.decode_pdf.setExtractionMode(0, 72, 1.0f);
        try {
            this.decode_pdf.setDefaultDisplayFont("SansSerif");
        }
        catch (PdfFontException pdfFontException) {
            System.out.println(pdfFontException.getMessage());
            stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            System.out.println(Messages.getMessage("PdfViewerFontsFound.message"));
            System.out.println("=====================\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Font font = new Font(stringArray[i], 1, 10);
                System.out.println(stringArray[i] + " (" + Messages.getMessage("PdfViewerFontsPostscript.message") + '=' + font.getPSName() + ')');
            }
            System.exit(1);
        }
        String[] stringArray2 = new String[]{"helvetica", "arial"};
        this.decode_pdf.setSubstitutedFontAliases("arial", stringArray2);
        stringArray = new String[]{"Helvetica-Bold"};
        this.decode_pdf.setSubstitutedFontAliases("Arial-BoldMT", stringArray);
        String[] stringArray3 = new String[]{"Times-Bold", "Times-Roman"};
        this.decode_pdf.setSubstitutedFontAliases("timesbd", stringArray3);
        PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
    }

    private void setupButtonsAndMenus() {
        this.createSwingMenu(true);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.createButtons();
        this.currentGUI.addCursor();
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR) {
            this.currentGUI.searchInMenu(this.searchFrame);
        }
        this.currentGUI.initStatus();
    }

    private void createButtons() {
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "/org/jpedal/examples/simpleviewer/res/open.gif", 10);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "/org/jpedal/examples/simpleviewer/res/print.gif", 6);
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_EXTERNAL_WINDOW) {
            this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "/org/jpedal/examples/simpleviewer/res/find.gif", 12);
        }
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "/org/jpedal/examples/simpleviewer/res/properties.gif", 9);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), "/org/jpedal/examples/simpleviewer/res/about.gif", 1);
        this.currentGUI.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "/org/jpedal/examples/simpleviewer/res/snapshotX.gif", 13);
    }

    protected void createSwingMenu(boolean bl) {
        JMenu jMenu;
        JMenu jMenu2 = new JMenu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.currentGUI.addToMainMenu(jMenu2);
        JMenu jMenu3 = new JMenu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.currentGUI.addToMainMenu(jMenu3);
        JMenu jMenu4 = new JMenu(Messages.getMessage("GoToViewMenuGoto.text"));
        jMenu3.add(jMenu4);
        this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        jMenu4.addSeparator();
        if (bl) {
            JMenuItem jMenuItem;
            JMenu jMenu5;
            this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
            this.currentGUI.addMenuItem(jMenu4, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
            jMenu = new JMenu(Messages.getMessage("PdfViewerExportMenu.text"));
            this.currentGUI.addToMainMenu(jMenu);
            if (this.commonValues.isItextOnClasspath()) {
                jMenu5 = new JMenu(Messages.getMessage("PdfViewerExportMenuPDF.text"));
                jMenu.add(jMenu5);
                this.currentGUI.addMenuItem(jMenu5, Messages.getMessage("PdfViewerExportMenuOnePerPage.text"), "", 501);
                this.currentGUI.addMenuItem(jMenu5, Messages.getMessage("PdfViewerExportMenuNUp.text"), "", 510);
                jMenuItem = new JMenu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
                this.currentGUI.addToMainMenu((JMenu)jMenuItem);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
                this.currentGUI.addMenuItem((JMenu)jMenuItem, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
            }
            this.currentGUI.addMenuItem(jMenu, "Bitmap", Messages.getMessage("PdfViewerExportMenuBitmap.text"), 2);
            jMenu5 = new JMenu(Messages.getMessage("PdfViewerExportMenuContent.text"));
            jMenu.add(jMenu5);
            this.currentGUI.addMenuItem(jMenu5, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
            this.currentGUI.addMenuItem(jMenu5, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
            jMenuItem = new JMenuItem(Messages.getMessage("PageLayoutViewMenu.Preferences"));
            jMenu3.add(jMenuItem);
            this.p.createPreferanceWindow(this.currentGUI);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleViewer.this.p.showPreferanceWindow();
                }
            });
            jMenu3.addSeparator();
        }
        this.currentGUI.addMenuItem(jMenu3, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 61);
        if (bl) {
            jMenu = new JMenu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
            jMenu2.add(jMenu);
            this.currentGUI.addMenuItem(jMenu, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
            this.currentGUI.addMenuItem(jMenu, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
            jMenu2.addSeparator();
        }
        if (bl) {
            this.currentGUI.addMenuItem(jMenu2, "Find", "Search PDF file ..", 12);
        }
        if (bl) {
            this.currentGUI.addMenuItem(jMenu2, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        }
        if (bl && this.commonValues.isItextOnClasspath()) {
            this.currentGUI.addMenuItem(jMenu2, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        jMenu2.addSeparator();
        this.currentGUI.addMenuItem(jMenu2, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        jMenu2.addSeparator();
        if (bl) {
            this.currentGUI.addMenuItem(jMenu2, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
            jMenu2.addSeparator();
        }
        if (bl) {
            this.currentCommands.recentDocumentsOption(jMenu2);
        }
        jMenu2.addSeparator();
        this.currentGUI.addMenuItem(jMenu2, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        if (bl) {
            jMenu = new JMenu(Messages.getMessage("PdfViewerHelpMenu.text"));
            this.currentGUI.addToMainMenu(jMenu);
            this.currentGUI.addMenuItem(jMenu, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
            this.currentGUI.addMenuItem(jMenu, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        SimpleViewer simpleViewer = new SimpleViewer();
        if (stringArray.length > 0) {
            simpleViewer.setupViewer(stringArray[0]);
        } else {
            simpleViewer.setupViewer();
        }
    }

    private void openFile(File file, String string) {
        try {
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            Node node = this.decode_pdf.getOutlineAsXML().getFirstChild();
            String string2 = null;
            if (node != null) {
                string2 = this.currentGUI.getBookmark(string);
            }
            if (string2 == null) {
                throw new PdfException("Unknown bookmark " + string);
            }
            int n = Integer.parseInt(string2);
            this.commonValues.setCurrentPage(n);
            if (bl) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.commonValues.setProcessing(false);
        }
    }

    private void openFile(File file, int n) {
        try {
            boolean bl = this.currentCommands.openUpFile(file.getCanonicalPath());
            this.commonValues.setCurrentPage(n);
            if (bl) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " processing file");
            this.commonValues.setProcessing(false);
        }
    }
}

