/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageTranslator {
    private static MessageTranslator instance = null;
    private ResourceBundle bundle;

    private MessageTranslator() {
        try {
            this.bundle = ResourceBundle.getBundle("org.postgresql.errors");
        }
        catch (MissingResourceException missingResourceException) {
            this.bundle = null;
        }
    }

    private final String _translate(String id, Object[] args) {
        String message;
        if (this.bundle != null && id != null) {
            try {
                message = this.bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                message = id;
            }
        } else {
            message = id;
        }
        if (args != null && message != null) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }

    private static final synchronized MessageTranslator getInstance() {
        if (instance == null) {
            instance = new MessageTranslator();
        }
        return instance;
    }

    public static final String translate(String id, Object arg) {
        MessageTranslator translator = MessageTranslator.getInstance();
        Object[] args = new Object[]{arg};
        return translator._translate(id, args);
    }

    public static final String translate(String id, Object[] args) {
        MessageTranslator translator = MessageTranslator.getInstance();
        return translator._translate(id, args);
    }
}

