/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.event.SequenceCreateEvent;
import clinical.event.SequenceCreateEventListener;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.DBPoolServiceException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSequenceHelper
implements ISequenceHelper {
    protected IDBPoolService dbPoolService;
    protected String dbType;
    protected Log log = LogFactory.getLog((String)"sequence");
    protected static Map<String, ISequenceHelper> instanceMap = new HashMap<String, ISequenceHelper>(7);
    public List<SequenceCreateEventListener> listeners = new ArrayList<SequenceCreateEventListener>(1);

    protected AbstractSequenceHelper(String dbID) throws BaseException {
        this.dbPoolService = MinimalServiceFactory.getPoolService(dbID);
        ISecurityService isec = MinimalServiceFactory.getSecurityService();
        this.dbType = isec.getDBType(dbID);
    }

    @Override
    public abstract BigDecimal getNextUID(Connection var1, String var2, String var3) throws BaseException;

    @Override
    public abstract BigDecimal getNextUID(UserInfo var1, String var2, String var3) throws BaseException;

    protected void releaseConnection(Connection con, UserInfo ui) {
        if (con == null) {
            return;
        }
        try {
            this.dbPoolService.releaseConnection(ui.getName(), con);
        }
        catch (DBPoolServiceException x) {
            this.log.error((Object)("Cannot release connection for user " + ui.getName()), (Throwable)x);
        }
    }

    @Override
    public void addListener(SequenceCreateEventListener lsnr) {
        this.listeners.add(lsnr);
    }

    @Override
    public void removeListener(SequenceCreateEventListener lsnr) {
        this.listeners.remove(lsnr);
    }

    protected void fireSequenceNumCreateEvent(String tableName, String columnName, String sequenceNum) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (this.listeners.size() == 1) {
            SequenceCreateEventListener lsnr = this.listeners.get(0);
            lsnr.sequenceNoCreated(new SequenceCreateEvent(tableName, columnName, sequenceNum));
        } else {
            ArrayList<SequenceCreateEventListener> copy = new ArrayList<SequenceCreateEventListener>(this.listeners);
            for (SequenceCreateEventListener lsnr : copy) {
                lsnr.sequenceNoCreated(new SequenceCreateEvent(tableName, columnName, sequenceNum));
            }
        }
    }
}

