/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.cache.CacheUtils;
import clinical.cache.DBChangeEvent;
import clinical.cache.DBChangeListener;
import clinical.cache.DBChangeSupport;
import clinical.cache.NullObject;
import clinical.cache.TableChange;
import clinical.server.dao.AnimalspeciesDAO;
import clinical.server.dao.ArgumenttypeDAO;
import clinical.server.dao.AssessmentDAO;
import clinical.server.dao.AssessmentscorecodeDAO;
import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.dao.DatabaseuserDAO;
import clinical.server.dao.DataclassificationDAO;
import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.MeasurementsystemDAO;
import clinical.server.dao.MeasurementtypeDAO;
import clinical.server.dao.MeasurementunitDAO;
import clinical.server.dao.OntologyconceptDAO;
import clinical.server.dao.OntologysourceDAO;
import clinical.server.dao.ProtocolDAO;
import clinical.server.dao.ResearchgroupDAO;
import clinical.server.dao.ResearchgrouptypeDAO;
import clinical.server.dao.SecurityclassificationDAO;
import clinical.server.dao.SiteDAO;
import clinical.server.dao.TableidDAO;
import clinical.server.dao.UserclassDAO;
import clinical.server.dao.UserstatusDAO;
import clinical.server.dao.VisittypeDAO;
import clinical.server.vo.Animalspecies;
import clinical.server.vo.Argumenttype;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscorecode;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Dataclassification;
import clinical.server.vo.Experiment;
import clinical.server.vo.Measurementsystem;
import clinical.server.vo.Measurementtype;
import clinical.server.vo.Measurementunit;
import clinical.server.vo.Ontologyconcept;
import clinical.server.vo.Ontologysource;
import clinical.server.vo.Protocol;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Researchgrouptype;
import clinical.server.vo.Securityclassification;
import clinical.server.vo.Site;
import clinical.server.vo.Tableid;
import clinical.server.vo.Userclass;
import clinical.server.vo.Userstatus;
import clinical.server.vo.Visittype;
import clinical.web.DAOFactory;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.exception.DBCacheException;
import clinical.web.exception.DBPoolServiceException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCache
implements IDBCache,
DBChangeListener {
    protected IDBPoolService dbPoolService;
    protected String dbID;
    protected Log log = LogFactory.getLog((String)"clinical");
    protected static Map<String, DBCache> instanceMap = new HashMap<String, DBCache>(7);
    protected CacheManager cacheMan;

    protected DBCache(String dbID) {
        this.dbPoolService = MinimalServiceFactory.getPoolService(dbID);
        this.dbID = dbID;
        this.log.info((Object)("DBCache for dbID:" + dbID + " - dbPoolService: " + this.dbPoolService));
        this.cacheMan = CacheManager.getInstance();
    }

    public static synchronized DBCache getInstance(String dbID) {
        DBCache dbCache = instanceMap.get(dbID);
        if (dbCache == null) {
            dbCache = new DBCache(dbID);
            instanceMap.put(dbID, dbCache);
            DBChangeSupport.getInstance().addDBChangeListener((DBChangeListener)dbCache);
        }
        return dbCache;
    }

    @Override
    public synchronized Databaseuser getDatabaseUser(UserInfo ui, String userName, String userClass) throws DBCacheException {
        Map dbUserMap;
        Databaseuser dbUser;
        String cacheKey = this.getKey("databaseuser");
        String key = userName.toUpperCase() + "_" + userClass;
        Object o = this.getFromCache(cacheKey);
        if (o != null && (dbUser = (Databaseuser)(dbUserMap = (Map)o).get(key)) != null) {
            return dbUser;
        }
        Connection con = null;
        try {
            this.log.info((Object)(">> looking for database user named " + userName.toUpperCase()));
            con = this.dbPoolService.getConnection(ui.getName());
            List<Userclass> ucList = this.getUserClasses(ui, false);
            Userclass theUC = null;
            HashMap<BigDecimal, Userclass> ucMap = new HashMap<BigDecimal, Userclass>(17);
            for (Userclass uc : ucList) {
                ucMap.put(uc.getUniqueid(), uc);
                if (!uc.getName().equals(userClass)) continue;
                theUC = uc;
            }
            assert (theUC != null);
            DatabaseuserDAO dao = DAOFactory.createDatabaseuserDAO(this.dbID);
            List<Databaseuser> dbUsers = dao.find(con, new Databaseuser());
            Map<String, Databaseuser> dbUserMap2 = new HashMap(17);
            for (Databaseuser aDBUser : dbUsers) {
                Userclass uc = (Userclass)ucMap.get(aDBUser.getUserclass());
                String aKey = aDBUser.getName().toUpperCase() + "_" + uc.getName();
                dbUserMap2.put(aKey, aDBUser);
            }
            dbUserMap2 = Collections.unmodifiableMap(dbUserMap2);
            this.put2Cache(cacheKey, dbUserMap2);
            Databaseuser databaseuser = (Databaseuser)dbUserMap2.get(key);
            this.releaseConnection(con, ui);
            return databaseuser;
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"getDatabaseUser", (Throwable)e);
                throw new DBCacheException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseConnection(con, ui);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized Tableid getTableID(UserInfo ui, String tableName) throws DBCacheException {
        Map tableIDMap;
        Tableid tid;
        String cacheKey = this.getKey("tableid");
        tableName = tableName.toUpperCase();
        Object o = this.getFromCache(cacheKey);
        if (o != null && (tid = (Tableid)(tableIDMap = (Map)o).get(tableName)) != null) {
            return tid;
        }
        Connection con = null;
        Map<String, Tableid> tableIDMap2 = new HashMap();
        Tableid tid2 = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            Tableid criteria = new Tableid();
            TableidDAO dao = DAOFactory.createTableidDAO(this.dbID);
            List<Tableid> tids = dao.find(con, criteria);
            for (Tableid ti : tids) {
                if (tableIDMap2.get(ti.getTablename()) == null) {
                    tableIDMap2.put(ti.getTablename(), ti);
                }
                if (!tableName.equals(ti.getTablename())) continue;
                tid2 = ti;
            }
            tableIDMap2 = Collections.unmodifiableMap(tableIDMap2);
            this.put2Cache(cacheKey, tableIDMap2);
            Tableid tableid = tid2;
            return tableid;
        }
        catch (Exception e) {
            this.log.error((Object)"getTableID", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Collectionequipment> getCollectionEquipments(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("collectionequipment");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Collectionequipment> ceList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            CollectionequipmentDAO dao = DAOFactory.createCollectionequipmentDAO(this.dbID);
            ceList = dao.find(con, new Collectionequipment());
            ceList = Collections.unmodifiableList(ceList);
            this.put2Cache(key, ceList);
            List<Collectionequipment> list = ceList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getCollectionEquipments", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Researchgrouptype> getResearchGroupTypes(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("researchgrouptype");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Researchgrouptype> rgtList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            ResearchgrouptypeDAO dao = DAOFactory.createResearchgrouptypeDAO(this.dbID);
            rgtList = dao.find(con, new Researchgrouptype());
            rgtList = Collections.unmodifiableList(rgtList);
            this.put2Cache(key, rgtList);
            List<Researchgrouptype> list = rgtList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getResearchGroupTypes", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Researchgroup> getResearchGroups(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("researchgroup");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Researchgroup> rgList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            ResearchgroupDAO dao = DAOFactory.createResearchgroupDAO(this.dbID);
            rgList = dao.find(con, new Researchgroup());
            rgList = Collections.unmodifiableList(rgList);
            this.put2Cache(key, rgList);
            List<Researchgroup> list = rgList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getResearchGroups", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Visittype> getVisitTypes(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("visittype");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Visittype> vtList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            VisittypeDAO dao = DAOFactory.createVisittypeDAO(this.dbID);
            vtList = dao.find(con, new Visittype());
            vtList = Collections.unmodifiableList(vtList);
            this.put2Cache(key, vtList);
            List<Visittype> list = vtList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getVisitTypes", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Userclass> getUserClasses(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("userclass");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Userclass> ucList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            UserclassDAO dao = DAOFactory.createUserclassDAO(this.dbID);
            ucList = dao.find(con, new Userclass());
            ucList = Collections.unmodifiableList(ucList);
            this.put2Cache(key, ucList);
            List<Userclass> list = ucList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getUserClasses", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Securityclassification> getSecurityClassifications(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("securityclassification");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Securityclassification> scList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            SecurityclassificationDAO dao = DAOFactory.createSecurityclassificationDAO(this.dbID);
            scList = dao.find(con, new Securityclassification());
            scList = Collections.unmodifiableList(scList);
            this.put2Cache(key, scList);
            List<Securityclassification> list = scList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getSecurityClassifications", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Assessment> getAssessments(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("assessment");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Assessment> asList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            AssessmentDAO dao = DAOFactory.createAssessmentDAO(this.dbID);
            asList = dao.find(con, new Assessment());
            asList = Collections.unmodifiableList(asList);
            this.put2Cache(key, asList);
            List<Assessment> list = asList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getAssessments", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public List<Protocol> getProtocols(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("protocol");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Protocol> prList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            ProtocolDAO dao = DAOFactory.createProtocolDAO(this.dbID);
            prList = dao.find(con, new Protocol());
            prList = Collections.unmodifiableList(prList);
            this.put2Cache(key, prList);
            List<Protocol> list = prList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getProtocols", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Site> getSites(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("site");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Site> stList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            SiteDAO dao = DAOFactory.createSiteDAO(this.dbID);
            stList = dao.find(con, new Site());
            stList = Collections.unmodifiableList(stList);
            this.put2Cache(key, stList);
            List<Site> list = stList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getSites", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    protected String getKey(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(':').append(this.dbID);
        return sb.toString();
    }

    @Override
    public synchronized Map<String, Experiment> getExperimentMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        List<Experiment> expList = this.getExperiments(ui, forceRecache);
        HashMap<String, Experiment> expMap = new HashMap<String, Experiment>(31);
        for (Experiment exp : expList) {
            expMap.put(exp.getName(), exp);
        }
        return expMap;
    }

    @Override
    public synchronized List<Experiment> getExperiments(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("experiment");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Experiment> expList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            ExperimentDAO dao = DAOFactory.createExperimentDAO(this.dbID);
            expList = dao.find(con, new Experiment());
            expList = Collections.unmodifiableList(expList);
            this.put2Cache(key, expList);
            List<Experiment> list = expList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getExperiments", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Dataclassification> getDataClassications(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("dataclassification");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Dataclassification> dcList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            DataclassificationDAO dao = DAOFactory.createDataclassificationDAO(this.dbID);
            dcList = dao.find(con, new Dataclassification());
            dcList = Collections.unmodifiableList(dcList);
            this.put2Cache(key, dcList);
            List<Dataclassification> list = dcList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getDataClassifications", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized List<Userstatus> getUserStatusList(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("userstatus");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        List<Userstatus> usList = null;
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            UserstatusDAO dao = DAOFactory.createUserstatusDAO(this.dbID);
            usList = dao.find(con, new Userstatus());
            usList = Collections.unmodifiableList(usList);
            this.put2Cache(key, usList);
            List<Userstatus> list = usList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getUserStatusList", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public List<Animalspecies> getAnimalSpecies(UserInfo ui, boolean forceRecache) throws DBCacheException {
        List<Animalspecies> asList = null;
        String key = this.getKey("animalspecies");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (List)o;
            }
        }
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            AnimalspeciesDAO dao = DAOFactory.createAnimalspeciesDAO(this.dbID);
            asList = dao.find(con, new Animalspecies());
            asList = Collections.unmodifiableList(asList);
            this.put2Cache(key, asList);
            List<Animalspecies> list = asList;
            return list;
        }
        catch (Exception e) {
            this.log.error((Object)"getAnimalSpecies", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public Map<String, List<Assessmentscorecode>> getScoreCodeMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("assessmentscorecode");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Connection con = null;
        try {
            HashMap<String, List<Assessmentscorecode>> scoreCodeMap = new HashMap(19);
            con = this.dbPoolService.getConnection(ui.getName());
            AssessmentscorecodeDAO dao = DAOFactory.createAssessmentscorecodeDAO(this.dbID);
            List<Assessmentscorecode> scoreCodes = null;
            scoreCodes = dao.find(con, new Assessmentscorecode());
            for (Assessmentscorecode asc : scoreCodes) {
                String aKey = asc.getAssessmentid().toString() + "_" + asc.getScorename();
                LinkedList<Assessmentscorecode> scList = (LinkedList<Assessmentscorecode>)scoreCodeMap.get(aKey);
                if (scList == null) {
                    scList = new LinkedList<Assessmentscorecode>();
                    scoreCodeMap.put(key, scList);
                }
                scList.add(asc);
            }
            scoreCodeMap = Collections.unmodifiableMap(scoreCodeMap);
            this.put2Cache(key, scoreCodeMap);
            HashMap<String, List<Assessmentscorecode>> hashMap = scoreCodeMap;
            this.releaseConnection(con, ui);
            return hashMap;
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"getScoreMap", (Throwable)e);
                throw new DBCacheException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseConnection(con, ui);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, Measurementsystem> getMeasurementSystemMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("measurementsystem");
        List<Measurementsystem> msList = null;
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Connection con = null;
        Map<String, Measurementsystem> measurementSystemMap = new HashMap(7);
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            MeasurementsystemDAO dao = DAOFactory.createMeasurementsystemDAO(this.dbID);
            msList = dao.find(con, new Measurementsystem());
            for (Measurementsystem ms : msList) {
                measurementSystemMap.put(ms.getName(), ms);
            }
            measurementSystemMap = Collections.unmodifiableMap(measurementSystemMap);
            this.put2Cache(key, measurementSystemMap);
            Map<String, Measurementsystem> map = measurementSystemMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getMeasurementSystemMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public Map<String, Measurementtype> getMeasurementTypeMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("measurementtype");
        List<Measurementtype> mtList = null;
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Map<String, Measurementtype> measurementTypeMap = new HashMap(31);
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            MeasurementtypeDAO dao = DAOFactory.createMeasurementtypeDAO(this.dbID);
            mtList = dao.find(con, new Measurementtype());
            for (Measurementtype mt : mtList) {
                measurementTypeMap.put(mt.getName(), mt);
            }
            measurementTypeMap = Collections.unmodifiableMap(measurementTypeMap);
            this.put2Cache(key, measurementTypeMap);
            Map<String, Measurementtype> map = measurementTypeMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getMeasurementTypeMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public Map<String, Measurementunit> getMeasurementUnitMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("measurementunit");
        List<Measurementunit> muList = null;
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Map<String, Measurementunit> measurementUnitMap = new HashMap();
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            MeasurementunitDAO dao = DAOFactory.createMeasurementunitDAO(this.dbID);
            muList = dao.find(con, new Measurementunit());
            for (Measurementunit mu : muList) {
                measurementUnitMap.put(mu.getUnit(), mu);
            }
            measurementUnitMap = Collections.unmodifiableMap(measurementUnitMap);
            this.put2Cache(key, measurementUnitMap);
            Map<String, Measurementunit> map = measurementUnitMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getMeasurementUnitMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public Map<String, Ontologysource> getOntologySourceMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("ontologysource");
        List<Ontologysource> osList = null;
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Map<String, Ontologysource> ontSourceMap = new HashMap();
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            OntologysourceDAO dao = DAOFactory.createOntologysourceDAO(this.dbID);
            osList = dao.find(con, new Ontologysource());
            for (Ontologysource os : osList) {
                ontSourceMap.put(os.getOntologysource(), os);
            }
            ontSourceMap = Collections.unmodifiableMap(ontSourceMap);
            this.put2Cache(key, ontSourceMap);
            Map<String, Ontologysource> map = ontSourceMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getOntologySourceMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public Map<String, Ontologyconcept> getOntologyConceptMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("ontologyconcept");
        List<Ontologyconcept> ocList = null;
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        Map<String, Ontologyconcept> ontConceptMap = new HashMap();
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            OntologyconceptDAO dao = DAOFactory.createOntologyconceptDAO(this.dbID);
            ocList = dao.find(con, new Ontologyconcept());
            for (Ontologyconcept oc : ocList) {
                ontConceptMap.put(oc.getConceptid(), oc);
            }
            ontConceptMap = Collections.unmodifiableMap(ontConceptMap);
            this.put2Cache(key, ontConceptMap);
            Map<String, Ontologyconcept> map = ontConceptMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getOntologyConceptMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    @Override
    public synchronized Map<String, Argumenttype> getArgumentTypeMap(UserInfo ui, boolean forceRecache) throws DBCacheException {
        String key = this.getKey("argumenttype");
        if (forceRecache) {
            this.dropFromCache(key);
        } else {
            Object o = this.getFromCache(key);
            if (o != null) {
                return (Map)o;
            }
        }
        List<Argumenttype> argList = null;
        Map<String, Argumenttype> argTypeMap = new HashMap(17);
        Connection con = null;
        try {
            con = this.dbPoolService.getConnection(ui.getName());
            ArgumenttypeDAO dao = DAOFactory.createArgumenttypeDAO(this.dbID);
            argList = dao.find(con, new Argumenttype());
            for (Argumenttype arg : argList) {
                argTypeMap.put(arg.getArgumenttype(), arg);
            }
            argTypeMap = Collections.unmodifiableMap(argTypeMap);
            this.put2Cache(key, argTypeMap);
            Map<String, Argumenttype> map = argTypeMap;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)"getArgumentTypeMap", (Throwable)e);
            throw new DBCacheException(e.getMessage());
        }
        finally {
            this.releaseConnection(con, ui);
        }
    }

    protected void releaseConnection(Connection con, UserInfo ui) {
        if (con == null) {
            return;
        }
        try {
            this.dbPoolService.releaseConnection(ui.getName(), con);
        }
        catch (DBPoolServiceException x) {
            this.log.error((Object)("Cannot release connection for user " + ui.getName()), (Throwable)x);
        }
    }

    protected Object getFromCache(String key) {
        Cache cache = this.cacheMan.getCache("remote");
        Element el = cache.get((Serializable)((Object)key));
        if (el == null || el.getObjectValue() == NullObject.getInstance()) {
            return null;
        }
        return el.getObjectValue();
    }

    protected void put2Cache(String key, Object value) {
        Cache cache = this.cacheMan.getCache("remote");
        Element el = new Element((Object)key, value);
        cache.put(el);
    }

    protected void dropFromCache(String key) {
        Cache cache = this.cacheMan.getCache("remote");
        cache.remove((Serializable)((Object)key));
    }

    public void dbContentChanged(DBChangeEvent event) {
        String siteID = event.getDbChange().getSiteID();
        if (siteID == null) {
            return;
        }
        String siteDBID = CacheUtils.getDBID4SiteID((String)siteID);
        if (siteDBID == null || !siteDBID.equals(this.dbID)) {
            return;
        }
        List tcList = event.getDbChange().getChanges();
        for (TableChange tc : tcList) {
            String key = this.getKey(tc.getTableName());
            this.dropFromCache(key);
        }
    }
}

