/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.utils.NamedUserPool;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.DBPoolServiceException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBPoolService
implements IDBPoolService {
    private NamedUserPool pool;
    private static Log log = LogFactory.getLog((String)"clinical");
    private String driverClass;
    private String dbURL;
    private String dbID;
    private Map<String, User> userMap;
    private boolean showStats = false;
    private static Map<String, String> driverClassMap;
    private static DBPoolService instance;
    private static Map<String, DBPoolService> instanceMap;

    private DBPoolService(String driverClass, String dbURL, Map<String, User> userMap) {
        this.driverClass = driverClass;
        this.dbURL = dbURL;
        this.userMap = userMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DBPoolService getInstance(ISecurityService securityService, Map<String, DBConfig> dbConfigMap) {
        if (instanceMap == null) {
            ArrayList<String> badDBList = new ArrayList<String>(1);
            log.debug((Object)"creating a new DBPoolService");
            instanceMap = new LinkedHashMap<String, DBPoolService>(7);
            for (DBConfig dbConfig : dbConfigMap.values()) {
                String driverClassName = driverClassMap.get(dbConfig.getDbType());
                DBPoolService poolService = new DBPoolService(driverClassName, dbConfig.getDbURL(), dbConfig.getUserMap());
                User adminUser = dbConfig.getUser("admin");
                if (adminUser == null) {
                    log.error((Object)("No admin web user for database:" + dbConfig.getId() + "! Skipping..."));
                    badDBList.add(dbConfig.getId());
                    continue;
                }
                Connection con = null;
                try {
                    poolService.startup();
                    con = poolService.getConnection(adminUser.getName());
                }
                catch (Throwable t) {
                    log.error((Object)("No connection to database " + dbConfig.getId()), t);
                    badDBList.add(dbConfig.getId());
                    continue;
                }
                finally {
                    if (con == null) continue;
                    try {
                        poolService.releaseConnection(adminUser.getName(), con);
                    }
                    catch (DBPoolServiceException e1) {}
                    continue;
                }
                poolService.dbID = dbConfig.getId();
                instanceMap.put(dbConfig.getId(), poolService);
                if (!dbConfig.isDefaultDB()) continue;
                instance = poolService;
            }
            if (!badDBList.isEmpty()) {
                for (String dbID : badDBList) {
                    dbConfigMap.remove(dbID);
                }
            }
        }
        return instance;
    }

    public static synchronized DBPoolService getInstance(String dbID) {
        if (instanceMap == null) {
            throw new RuntimeException("DBPoolService not properly initiated!");
        }
        DBPoolService poolService = instanceMap.get(dbID);
        if (poolService == null) {
            throw new RuntimeException("No DBPoolService for database ID " + dbID);
        }
        return poolService;
    }

    public static synchronized Set<String> getAvailablePoolServices() {
        return new HashSet<String>(instanceMap.keySet());
    }

    public static synchronized IDBPoolService getPoolService(String dbID) {
        return instanceMap.get(dbID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized IDBPoolService addDatabase(DBConfig dbConfig) {
        DBPoolService poolService;
        block14: {
            if (instanceMap == null) {
                throw new RuntimeException("DBPoolService not properly initiated!");
            }
            poolService = instanceMap.get(dbConfig.getId());
            if (poolService != null) {
                return poolService;
            }
            String driverClassName = driverClassMap.get(dbConfig.getDbType());
            poolService = new DBPoolService(driverClassName, dbConfig.getDbURL(), dbConfig.getUserMap());
            User adminUser = dbConfig.getUser("admin");
            Connection con = null;
            try {
                poolService.startup();
                con = poolService.getConnection(adminUser.getName());
                if (con == null) break block14;
            }
            catch (Throwable t) {
                try {
                    log.error((Object)("No connection to database " + dbConfig.getId()), t);
                    IDBPoolService iDBPoolService = null;
                    return iDBPoolService;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (con != null) {
                        try {
                            poolService.releaseConnection(adminUser.getName(), con);
                        }
                        catch (DBPoolServiceException e1) {}
                    }
                }
            }
            try {
                poolService.releaseConnection(adminUser.getName(), con);
            }
            catch (DBPoolServiceException e1) {}
        }
        poolService.dbID = dbConfig.getId();
        log.info((Object)("adding poolService " + poolService.dbID + " (" + dbConfig.getDbType() + ") " + dbConfig.getDbURL()));
        instanceMap.put(dbConfig.getId(), poolService);
        return poolService;
    }

    public static synchronized void removeDatabase(String dbID) {
        if (instanceMap == null) {
            throw new RuntimeException("DBPoolService not properly initiated!");
        }
        DBPoolService poolService = instanceMap.get(dbID);
        if (poolService != null) {
            try {
                poolService.shutdown();
            }
            catch (DBPoolServiceException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public void setShowStats(boolean newShowStats) {
        this.showStats = newShowStats;
        if (this.pool != null) {
            this.pool.setShowStats(this.showStats);
        }
    }

    public boolean getShowStats() {
        return this.showStats;
    }

    @Override
    public synchronized void addUser(User webUser) {
        if (!this.userMap.containsKey(webUser.getName())) {
            log.info((Object)("adding user " + webUser));
            this.userMap.put(webUser.getName(), webUser);
        }
    }

    @Override
    public synchronized void removeUser(User webUser) {
        if (this.userMap.containsKey(webUser.getName())) {
            log.info((Object)("removing user " + webUser));
            this.userMap.remove(webUser.getName());
        }
    }

    @Override
    public synchronized Connection getConnection(String userName) throws DBPoolServiceException {
        Connection con = null;
        User user = this.userMap.get(userName);
        if (user == null) {
            throw new DBPoolServiceException("Cannot connect:Not a valid user!:" + userName);
        }
        try {
            con = this.pool.getConnection(user.getDbUser().getName(), user.getDbUser().getPwd());
            if (log.isDebugEnabled()) {
                log.debug((Object)("returning connection for user " + user.getDbUser().getName() + " con=" + con));
            }
            return con;
        }
        catch (Exception x) {
            log.error((Object)"getConnection", (Throwable)x);
            throw new DBPoolServiceException(x);
        }
    }

    @Override
    public synchronized void releaseConnection(String userName, Connection con) throws DBPoolServiceException {
        if (con != null) {
            User user = this.userMap.get(userName);
            if (user == null) {
                throw new DBPoolServiceException("Cannot return connection:Not a valid user!");
            }
            try {
                this.pool.releaseConnection(user.getDbUser().getName(), con);
                log.debug((Object)("released connection for user " + user.getDbUser().getName()));
            }
            catch (Exception x) {
                log.error((Object)"releaseConnection", (Throwable)x);
                throw new DBPoolServiceException(x);
            }
        }
    }

    @Override
    public void startup() throws DBPoolServiceException {
        try {
            this.pool = NamedUserPool.getInstance(this.driverClass, this.dbURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("pool is created using driverClass=" + this.driverClass + ", dbURL=" + this.dbURL));
            }
        }
        catch (Exception x) {
            log.fatal((Object)"startup", (Throwable)x);
            throw new DBPoolServiceException(x);
        }
    }

    @Override
    public synchronized void shutdown() throws DBPoolServiceException {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection pool is shutdown.");
        }
        instanceMap.remove(DBPoolService.instance.dbID);
        if (instanceMap.isEmpty()) {
            instanceMap = null;
        }
        instance = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DBPoolService::[");
        buf.append("dbID=").append(this.dbID);
        buf.append(",dbURL=").append(this.dbURL);
        buf.append(']');
        return buf.toString();
    }

    static {
        instanceMap = null;
        driverClassMap = new HashMap<String, String>(3);
        driverClassMap.put("oracle", "oracle.jdbc.driver.OracleDriver");
        driverClassMap.put("postgres", "org.postgresql.Driver");
    }
}

