/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.anatproc;

import com.pixelmed.anatproc.DictionaryOfConcepts;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.StringUtilities;

public class CTAnatomy {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/anatproc/CTAnatomy.java,v 1.5 2010/11/12 09:07:54 dclunie Exp $";
    protected static int debugLevel = 0;
    protected static String[] badLateralityOrViewOrAnatomyPhraseTriggers = new String[]{"History", "Hx of"};
    protected static String[] badAnatomyWords = new String[]{"research", "and", "head first", "feet first", "entra di piedi", "axials", "sagittals", "coronals"};
    protected static DisplayableAnatomicConcept[] anatomicConceptEntries = new DisplayableAnatomicConcept[]{new DisplayableAnatomicConcept("416949008", false, "SRT", "SNM3", null, "R-FAB57", "Abdomen and Pelvis", "ABDOMENPELVIS", CTAnatomy.newStringArray("Abdomen Pelvis", "Abdo Pelvis", "Abd Pelvis", "Abd Pelv", "Abd Pel", "AbdoPelv"), CTAnatomy.newStringArray("Abdomen and Pelvis"), CTAnatomy.newStringArray("Abdomen and Pelvis")), new DisplayableAnatomicConcept("416550000", false, "SRT", "SNM3", null, "R-FAB55", "Chest and Abdomen", "CHESTABDOMEN", CTAnatomy.newStringArray("Chest Abdomen", "Chest Abdo", "Chest Abd", "Thorax Abdomen", "Thorax Abdo", "Thorax Abd", "Chest Liver", "Thorax Liver", "torace addome"), CTAnatomy.newStringArray("Chest and Abdomen"), CTAnatomy.newStringArray("Chest and Abdomen")), new DisplayableAnatomicConcept("416775004", false, "SRT", "SNM3", null, "R-FAB56", "Chest, Abdomen and Pelvis", "CHESTABDPELVIS", CTAnatomy.newStringArray("Chest Abdomen Pelvis", "Chest Abdo Pelvis", "Chest Abdo Pelv", "Chest Abdo Pel", "Chest Abd Pelvis", "Chest Abd Pelv", "Chest Abd Pel", "Chest AbdoPelv", "Chest Abdomen Pelv", "Chest Abdomen Pel", "Thorax Abdomen Pelvis", "Thorax Abdo Pelvis", "Thorax Abdo Pelv", "Thorax Abdo Pel", "Thorax Abd Pelvis", "Thorax Abd Pelv", "Thorax Abd Pel", "Thorax AbdoPelv", "Thorax Abdomen Pelv", "Thorax Abdomen Pel", "Thoraco Abdomino Pelvien", "Torax Abdomen Pelvis", "Th Abd Pel", "C A P", "CAP", "T A P", "TAP", ""), CTAnatomy.newStringArray("Chest, Abdomen and Pelvis"), CTAnatomy.newStringArray("Chest, Abdomen and Pelvis")), new DisplayableAnatomicConcept("774007", false, "SRT", "SNM3", null, "T-D1000", "Head and Neck", "HEADNECK", CTAnatomy.newStringArray("Head Neck"), CTAnatomy.newStringArray("Head and Neck"), CTAnatomy.newStringArray("Head and Neck")), new DisplayableAnatomicConcept("417437006", false, "SRT", "SNM3", null, "R-FAB52", "Neck and Chest", "NECKCHEST", CTAnatomy.newStringArray("Neck Chest", "Neck Thorax"), CTAnatomy.newStringArray("Neck and Chest"), CTAnatomy.newStringArray("Neck and Chest")), new DisplayableAnatomicConcept("416152001", false, "SRT", "SNM3", null, "R-FAB53", "Neck, Chest and Abdomen", "NECKCHESTABDOMEN", CTAnatomy.newStringArray("Neck Chest Abdomen", "Neck Chest Abdo", "Neck Chest Abd", "Neck Thorax Abdomen", "Neck Thorax Abdo", "Neck Thorax Abd"), CTAnatomy.newStringArray("Neck, Chest and Abdomen"), CTAnatomy.newStringArray("Neck, Chest and Abdomen")), new DisplayableAnatomicConcept("416319003", false, "SRT", "SNM3", null, "R-FAB54", "Neck, Chest, Abdomen and Pelvis", "NECKCHESTABDPELV", CTAnatomy.newStringArray("Neck Chest Abdomen Pelvis", "Neck Chest Abdo Pelvis", "Neck Chest Abd Pelvis", "Neck Chest Abdo Pelv", "Neck Chest Abdo Pel", "Neck Chest Abd Pelv", "Neck Chest Abd Pel", "Neck Thorax Abdomen Pelvis", "Neck Thorax Abdo Pelvis", "Neck Thorax Abd Pelvis", "Neck Thorax Abdo Pelv", "Neck Thorax Abdo Pel", "Neck Thorax Abd Pelv", "Neck Thorax Abd Pel"), CTAnatomy.newStringArray("Neck, Chest, Abdomen and Pelvis"), CTAnatomy.newStringArray("Neck, Chest, Abdomen and Pelvis")), new DisplayableAnatomicConcept("C0000726", false, "SRT", "SNM3", null, "T-D4000", "Abdomen", "ABDOMEN", CTAnatomy.newStringArray("Abdominal", "B\u00d8ICHO", "bruco", "Buik", "Vatsa", "Ventre", "Addome", "Abdome", "\u306f\u3089", "\u5fc3\u7aa9\u90e8", "\u80f4", "\u8179", "\u8179\u90e8", "\u0416\u0418\u0412\u041e\u0422", "Buk", "Pilvo"), CTAnatomy.newStringArray("Abdomen"), CTAnatomy.newStringArray("Abdomen")), new DisplayableAnatomicConcept("23451007", true, "SRT", "SNM3", null, "T-B3000", "Adrenal gland", "ADRENAL", CTAnatomy.newStringArray("Adrenal"), CTAnatomy.newStringArray("Adrenal gland"), CTAnatomy.newStringArray("Adrenal gland")), new DisplayableAnatomicConcept("70258002", true, "SRT", "SNM3", null, "T-15750", "Ankle joint", "ANKLE", CTAnatomy.newStringArray("Ankle", "Tobillo", "Kn\u00f6chel", "Enkel", "Cheville", "Tornozelo", "\u03b1\u03c3\u03c4\u03c1\u03ac\u03b3\u03b1\u03bb\u03bf\u03c2", "\u8db3\u9996", "\ubc1c\ubaa9", "\u043b\u043e\u0434\u044b\u0436\u043a\u0430"), CTAnatomy.newStringArray("Ankle joint"), CTAnatomy.newStringArray("Ankle joint")), new DisplayableAnatomicConcept("15825003", false, "SRT", "SNM3", null, "T-42000", "Aorta", "AORTA", null, CTAnatomy.newStringArray("Aorta"), CTAnatomy.newStringArray("Aorta")), new DisplayableAnatomicConcept("40983000", true, "SRT", "SNM3", null, "T-D8200", "Arm", "ARM", null, CTAnatomy.newStringArray("Arm"), CTAnatomy.newStringArray("Arm")), new DisplayableAnatomicConcept("34797008", true, "SRT", "SNM3", null, "T-D8100", "Axilla", "AXILLA", null, CTAnatomy.newStringArray("Axilla"), CTAnatomy.newStringArray("Axilla")), new DisplayableAnatomicConcept("77568009", false, "SRT", "SNM3", null, "T-D2100", "Back", "BACK", null, CTAnatomy.newStringArray("Back"), CTAnatomy.newStringArray("Back")), new DisplayableAnatomicConcept("89837001", false, "SRT", "SNM3", null, "T-74000", "Bladder", "BLADDER", null, CTAnatomy.newStringArray("Bladder"), CTAnatomy.newStringArray("Bladder")), new DisplayableAnatomicConcept("12738006", false, "SRT", "SNM3", null, "T-A0100", "Brain", "BRAIN", null, CTAnatomy.newStringArray("Brain"), CTAnatomy.newStringArray("Brain")), new DisplayableAnatomicConcept("76752008", true, "SRT", "SNM3", null, "T-04000", "Breast", "BREAST", null, CTAnatomy.newStringArray("Breast"), CTAnatomy.newStringArray("Breast")), new DisplayableAnatomicConcept("955009", true, "SRT", "SNM3", null, "T-26000", "Bronchus", "BRONCHUS", null, CTAnatomy.newStringArray("Bronchus"), CTAnatomy.newStringArray("Bronchus")), new DisplayableAnatomicConcept("46862004", true, "SRT", "SNM3", null, "T-D2600", "Buttock", "BUTTOCK", null, CTAnatomy.newStringArray("Buttock"), CTAnatomy.newStringArray("Buttock")), new DisplayableAnatomicConcept("80144004", true, "SRT", "SNM3", null, "T-12770", "Calcaneus", "CALCANEUS", null, CTAnatomy.newStringArray("Calcaneus"), CTAnatomy.newStringArray("Calcaneus")), new DisplayableAnatomicConcept("53840002", true, "SRT", "SNM3", null, "T-D9440", "Calf of leg", "CALF", CTAnatomy.newStringArray("Calf"), CTAnatomy.newStringArray("Calf of leg"), CTAnatomy.newStringArray("Calf of leg")), new DisplayableAnatomicConcept("69105007", true, "SRT", "SNM3", null, "T-45010", "Carotid Artery", "CAROTID", CTAnatomy.newStringArray("Carotid"), CTAnatomy.newStringArray("Carotid Artery"), CTAnatomy.newStringArray("Carotid Artery")), new DisplayableAnatomicConcept("180924008", false, "SRT", "SNM3", null, "T-A600A", "Cerebellum", "CEREBELLUM", null, CTAnatomy.newStringArray("Cerebellum"), CTAnatomy.newStringArray("Cerebellum")), new DisplayableAnatomicConcept("C0728985", false, "SRT", "SNM3", null, "T-11501", "Cervical spine", "CSPINE", CTAnatomy.newStringArray("CS", "CWK", "CWZ", "HWS", "H Rygg", "Cspine", "C spine", "Spine Cervical", "Cervical", "Cervic", "Kaelal\u00fclid", "KR\u00c8N\u00cd OBRATLE", "Halswervels", "Vertebrae cervicalis", "Wervel hals", "Kaulanikamat", "Rachis cervical", "Vert\u00e8bre cervicale", "Vert\u00e8bres cervicales", "COLONNE CERVICALE", "CERVICALE", "Halswirbel", "Vertebrae cervicales", "Vertebre cervicali", "\u981a\u690e", "\u9838\u690e", "V\u00e9rtebras Cervicais", "\u0428\u0415\u0419\u041d\u042b\u0415 \u041f\u041e\u0417\u0412\u041e\u041d\u041a\u0418", "columna cervical", "columna cerv", "columna espinal cervical", "columna vertebral cervical", "v\u00e9rtebras cervicales", "Cervikalkotor", "Halskotor", "Halsrygg", "Cervicale wervelzuil", "C chrbtica"), CTAnatomy.newStringArray("Cervical spine"), CTAnatomy.newStringArray("Cervical spine")), new DisplayableAnatomicConcept(null, false, "SRT", "SRT", null, "T-D00F7", "Cervico-thoracic spine", "CTSPINE", CTAnatomy.newStringArray("CTSPINE", "Cervico-thoracic", "Cervicothoracic"), CTAnatomy.newStringArray("Cervico-thoracic spine"), CTAnatomy.newStringArray("Cervico-thoracic spine")), new DisplayableAnatomicConcept("71252005", false, "SRT", "SNM3", null, "T-83200", "Cervix", "CERVIX", null, CTAnatomy.newStringArray("Cervix"), CTAnatomy.newStringArray("Cervix")), new DisplayableAnatomicConcept("60819002", true, "SRT", "SNM3", null, "T-D1206", "Cheek", "CHEEK", null, CTAnatomy.newStringArray("Cheek"), CTAnatomy.newStringArray("Cheek")), new DisplayableAnatomicConcept("C0817096", false, "SRT", "SNM3", null, "T-D3000", "Chest", "CHEST", CTAnatomy.newStringArray("Thorax", "Rindkere", "HRUDN\u00cdK", "hrudn\u00edk", "Borst", "Rintakeh\u00e4", "Poitrine", "Potter", "Torse", "Brustkorb", "Torace", "Peito", "\u0413\u0420\u0423\u0414\u041d\u0410\u042f \u041a\u041b\u0415\u0422\u041a\u0410", "\u0413\u0420\u0423\u0414\u042c", "pecho", "tor\u00e1cico", "Br\u00f6stkorg", "Torax", "hrudn\u043dk", "hrudn", "mellkas", "Kr\u016btin\u0117s l\u0105sta"), CTAnatomy.newStringArray("Chest"), CTAnatomy.newStringArray("Chest")), new DisplayableAnatomicConcept("362047009", false, "SRT", "SNM3", null, "T-45526", "Circle of Willis", "CIRCLEOFWILLIS", null, CTAnatomy.newStringArray("Circle of Willis"), CTAnatomy.newStringArray("Circle of Willis")), new DisplayableAnatomicConcept("51299004", true, "SRT", "SNM3", null, "T-12310", "Clavicle", "CLAVICLE", null, CTAnatomy.newStringArray("Clavicle"), CTAnatomy.newStringArray("Clavicle")), new DisplayableAnatomicConcept("64688005", false, "SRT", "SNM3", null, "T-11BF0", "Coccyx", "COCCYX", null, CTAnatomy.newStringArray("Coccyx"), CTAnatomy.newStringArray("Coccyx")), new DisplayableAnatomicConcept("71854001", false, "SRT", "SNM3", null, "T-59300", "Colon", "COLON", null, CTAnatomy.newStringArray("Colon"), CTAnatomy.newStringArray("Colon")), new DisplayableAnatomicConcept("28726007", true, "SRT", "SNM3", null, "T-AA200", "Cornea", "CORNEA", null, CTAnatomy.newStringArray("Cornea"), CTAnatomy.newStringArray("Cornea")), new DisplayableAnatomicConcept("41801008", false, "SRT", "SNM3", null, "T-43000", "Coronary artery", "CORONARYARTERY", CTAnatomy.newStringArray("Coronary"), CTAnatomy.newStringArray("Coronary artery"), CTAnatomy.newStringArray("Coronary artery")), new DisplayableAnatomicConcept("38848004", false, "SRT", "SNM3", null, "T-58200", "Duodenum", "DUODENUM", null, CTAnatomy.newStringArray("Duodenum"), CTAnatomy.newStringArray("Duodenum")), new DisplayableAnatomicConcept("1910005", true, "SRT", "SNM3", null, "T-AB000", "Ear", "EAR", null, CTAnatomy.newStringArray("Ear"), CTAnatomy.newStringArray("Ear")), new DisplayableAnatomicConcept("76248009", true, "SRT", "SNM3", null, "T-D8300", "Elbow", "ELBOW", CTAnatomy.newStringArray("Ellbogen", "Coude", "K\u00fc\u00fcnar", "Armb\u00e5ge", "Codo", "Cotovelo"), CTAnatomy.newStringArray("Elbow"), CTAnatomy.newStringArray("Elbow")), new DisplayableAnatomicConcept("38266002", false, "SRT", "SNM3", null, "T-D0010", "Entire body", "WHOLEBODY", CTAnatomy.newStringArray("Entire body", "Whole body", "Mid body"), CTAnatomy.newStringArray("Entire body"), CTAnatomy.newStringArray("Entire body")), new DisplayableAnatomicConcept("32849002", false, "SRT", "SNM3", null, "T-56000", "Esophagus", "ESOPHAGUS", null, CTAnatomy.newStringArray("Esophagus"), CTAnatomy.newStringArray("Esophagus")), new DisplayableAnatomicConcept("66019005", true, "SRT", "SNM3", null, "T-D0300", "Extremity", "EXTREMITY", CTAnatomy.newStringArray("Extremety", "Extremidad"), CTAnatomy.newStringArray("Extremity"), CTAnatomy.newStringArray("Extremity")), new DisplayableAnatomicConcept("81745001", true, "SRT", "SNM3", null, "T-AA000", "Eye", "EYE", null, CTAnatomy.newStringArray("Eye"), CTAnatomy.newStringArray("Eye")), new DisplayableAnatomicConcept("80243003", true, "SRT", "SNM3", null, "T-AA810", "Eyelid", "EYELID", null, CTAnatomy.newStringArray("Eyelid"), CTAnatomy.newStringArray("Eyelid")), new DisplayableAnatomicConcept("71341001", true, "SRT", "SNM3", null, "T-12710", "Femur", "FEMUR", null, CTAnatomy.newStringArray("Femur"), CTAnatomy.newStringArray("Femur")), new DisplayableAnatomicConcept("7569003", true, "SRT", "SNM3", null, "T-D8800", "Finger", "FINGER", null, CTAnatomy.newStringArray("Finger"), CTAnatomy.newStringArray("Finger")), new DisplayableAnatomicConcept("56459004", true, "SRT", "SNM3", null, "T-D9700", "Foot", "FOOT", CTAnatomy.newStringArray("Pied", "Pie", "Voet", "Fu\u00df", "\u03c0\u03cc\u03b4\u03b9", "Piede", "\u043d\u043e\u0433\u0430"), CTAnatomy.newStringArray("Foot"), CTAnatomy.newStringArray("Foot")), new DisplayableAnatomicConcept("55797009", true, "SRT", "SNM3", null, "T-12402", "Forearm bone", "FOREARM", CTAnatomy.newStringArray("Forearm", "U ARM", "Unterarm", "Avambraccio", "P\u00d8EDLOKT\u00cd", "Onderarm", "Kyyn\u00e4rvarsi", "Avant-bras", "\u307e\u3048\u3046\u3067", "\u524d\u8155", "Antebra\u00e7o", "\u041f\u0420\u0415\u0414\u041f\u041b\u0415\u0427\u042c\u0415", "antebrazo", "Underarm", "predlaktie"), CTAnatomy.newStringArray("Forearm"), CTAnatomy.newStringArray("Forearm")), new DisplayableAnatomicConcept("28231008", false, "SRT", "SNM3", null, "T-63000", "Gallbladder", "GALLBLADDER", null, CTAnatomy.newStringArray("Gallbladder"), CTAnatomy.newStringArray("Gallbladder")), new DisplayableAnatomicConcept("85562004", true, "SRT", "SNM3", null, "T-D8700", "Hand", "HAND", null, CTAnatomy.newStringArray("Hand"), CTAnatomy.newStringArray("Hand")), new DisplayableAnatomicConcept("69536005", false, "SRT", "SNM3", null, "T-D1100", "Head", "HEAD", CTAnatomy.newStringArray("Schaedel", "Sch\u00e6del", "Tete"), CTAnatomy.newStringArray("Head"), CTAnatomy.newStringArray("Head")), new DisplayableAnatomicConcept("774007", false, "SRT", "SNM3", null, "T-D1000", "Head and Neck", "HEADNECK", CTAnatomy.newStringArray("Head Neck"), CTAnatomy.newStringArray("Head and Neck"), CTAnatomy.newStringArray("Head and Neck")), new DisplayableAnatomicConcept("80891009", false, "SRT", "SNM3", null, "T-32000", "Heart", "HEART", null, CTAnatomy.newStringArray("Heart"), CTAnatomy.newStringArray("Heart")), new DisplayableAnatomicConcept("24136001", true, "SRT", "SNM3", null, "T-15710", "Hip joint", "HIP", CTAnatomy.newStringArray("Hip", "Heup", "Hanche", "H\u00fcfte", "Puus", "H\u00d6FT", "Cadera", "\u03b9\u03c3\u03c7\u03af\u03bf", "anca", "\u30d2\u30c3\u30d7", "\uc5c9\ub369\uc774", "\u0432\u0430\u043b\u044c\u043c\u0430"), CTAnatomy.newStringArray("Hip"), CTAnatomy.newStringArray("Hip")), new DisplayableAnatomicConcept("85050009", true, "SRT", "SNM3", null, "T-12410", "Humerus", "HUMERUS", CTAnatomy.newStringArray("UP_EXM", "O ARM", "Oberarm", "\u00d5lavars", "Bovenarm", "h\u00famero"), CTAnatomy.newStringArray("Humerus"), CTAnatomy.newStringArray("Humerus")), new DisplayableAnatomicConcept("34516001", false, "SRT", "SNM3", null, "T-58600", "Ileum", "ILEUM", null, CTAnatomy.newStringArray("Ileum"), CTAnatomy.newStringArray("Ileum")), new DisplayableAnatomicConcept("22356005", true, "SRT", "SNM3", null, "T-12340", "Ilium", "ILIUM", null, CTAnatomy.newStringArray("Ilium"), CTAnatomy.newStringArray("Ilium")), new DisplayableAnatomicConcept("361078006", true, "SRT", "SNM3", null, "T-AB959", "Internal Auditory Canal", "IAC", CTAnatomy.newStringArray("IAC"), CTAnatomy.newStringArray("Internal Auditory Canal"), CTAnatomy.newStringArray("Internal Auditory Canal")), new DisplayableAnatomicConcept("661005", true, "SRT", "SNM3", null, "T-D1213", "Jaw region", "JAW", null, CTAnatomy.newStringArray("Jaw region"), CTAnatomy.newStringArray("Jaw region")), new DisplayableAnatomicConcept("21306003", false, "SRT", "SNM3", null, "T-58400", "Jejunum", "JEJUNUM", null, CTAnatomy.newStringArray("Jejunum"), CTAnatomy.newStringArray("Jejunum")), new DisplayableAnatomicConcept("64033007", true, "SRT", "SNM3", null, "T-71000", "Kidney", "KIDNEY", null, CTAnatomy.newStringArray("Kidney"), CTAnatomy.newStringArray("Kidney")), new DisplayableAnatomicConcept("72696002", true, "SRT", "SNM3", null, "T-D9200", "Knee", "KNEE", CTAnatomy.newStringArray("Knie", "Genou", "P\u00f5lv", "P\u00f6lv", "Kn\u00e4", "Rodilla"), CTAnatomy.newStringArray("Knee"), CTAnatomy.newStringArray("Knee")), new DisplayableAnatomicConcept("4596009", false, "SRT", "SNM3", null, "T-24100", "Larynx", "LARYNX", null, CTAnatomy.newStringArray("Larynx"), CTAnatomy.newStringArray("Larynx")), new DisplayableAnatomicConcept("30021000", true, "SRT", "SNM3", null, "T-D9400", "Leg", "LEG", CTAnatomy.newStringArray("LOW_EXM", "LOWEXM", "TIB FIB ANKLE", "Jambe"), CTAnatomy.newStringArray("Leg"), CTAnatomy.newStringArray("Leg")), new DisplayableAnatomicConcept("10200004", false, "SRT", "SNM3", null, "T-62000", "Liver", "LIVER", CTAnatomy.newStringArray("foie", "Kepenys"), CTAnatomy.newStringArray("Liver"), CTAnatomy.newStringArray("Liver")), new DisplayableAnatomicConcept("C0024091", false, "SRT", "SNM3", null, "T-11503", "Lumbar spine", "LSPINE", CTAnatomy.newStringArray("LS", "LWK", "LWZ", "LWS", "L Rygg", "Lspine", "L spine", "Spine Lumbar", "Lumbar", "Rachis lombaire", "COLONNE LOMBAIRE", "Rach.Lomb", "lombaire", "Nimmel\u00fclid", "Columna lumbar", "L\u00c4NDRYGG", "L chrbtica", "COL LOMBARE"), CTAnatomy.newStringArray("Lumbar spine"), CTAnatomy.newStringArray("Lumbar spine")), new DisplayableAnatomicConcept("C0223603", false, "SRT", "SRT", null, "T-D00F9", "Lumbo-sacral spine", "LSSPINE", CTAnatomy.newStringArray("LSSPINE", "Lumbosacral spine", "Lumbo-sacrale wervelzuil", "columna vertebral lumbosacra", "v\u00e9rtebras lumbosacras", "Colonna Lombosacrale"), CTAnatomy.newStringArray("Lumbo-sacral spine"), CTAnatomy.newStringArray("Lumbo-sacral spine")), new DisplayableAnatomicConcept("39607008", true, "SRT", "SNM3", null, "T-28000", "Lung", "LUNG", CTAnatomy.newStringArray("pluco", "pluca"), CTAnatomy.newStringArray("Lung"), CTAnatomy.newStringArray("Lung")), new DisplayableAnatomicConcept("91609006", true, "SRT", "SNM3", null, "T-11180", "Mandible", "JAW", null, CTAnatomy.newStringArray("Mandible"), CTAnatomy.newStringArray("Mandible")), new DisplayableAnatomicConcept("70925003", true, "SRT", "SNM3", null, "T-11170", "Maxilla", "MAXILLA", null, CTAnatomy.newStringArray("Maxilla"), CTAnatomy.newStringArray("Maxilla")), new DisplayableAnatomicConcept("72410000", false, "SRT", "SNM3", null, "T-D3300", "Mediastinum", "MEDIASTINUM", null, CTAnatomy.newStringArray("Mediastinum"), CTAnatomy.newStringArray("Mediastinum")), new DisplayableAnatomicConcept("21082005", false, "SRT", "SNM3", null, "T-51000", "Mouth", "MOUTH", null, CTAnatomy.newStringArray("Mouth"), CTAnatomy.newStringArray("Mouth")), new DisplayableAnatomicConcept("45048000", false, "SRT", "SNM3", null, "T-D1600", "Neck", "NECK", CTAnatomy.newStringArray("Kael"), CTAnatomy.newStringArray("Neck"), CTAnatomy.newStringArray("Neck")), new DisplayableAnatomicConcept("45206002", false, "SRT", "SNM3", null, "T-21000", "Nose", "NOSE", null, CTAnatomy.newStringArray("Nose"), CTAnatomy.newStringArray("Nose")), new DisplayableAnatomicConcept("371398005", true, "SRT", "SNM3", null, "T-D0801", "Orbital region", "ORBIT", CTAnatomy.newStringArray("Orbit"), CTAnatomy.newStringArray("Orbital region"), CTAnatomy.newStringArray("Orbital region")), new DisplayableAnatomicConcept("15497006", true, "SRT", "SNM3", null, "T-87000", "Ovary", "OVARY", null, CTAnatomy.newStringArray("Ovary"), CTAnatomy.newStringArray("Ovary")), new DisplayableAnatomicConcept("181277001", false, "SRT", "SNM3", null, "T-D4034", "Pancreas", "PANCREAS", null, CTAnatomy.newStringArray("Pancreas"), CTAnatomy.newStringArray("Pancreas")), new DisplayableAnatomicConcept("45289007", true, "SRT", "SNM3", null, "T-61100", "Parotid gland", "PAROTID", CTAnatomy.newStringArray("Parotid"), CTAnatomy.newStringArray("Parotid gland"), CTAnatomy.newStringArray("Parotid gland")), new DisplayableAnatomicConcept("64234005", true, "SRT", "SNM3", null, "T-12730", "Patella", "PATELLA", null, CTAnatomy.newStringArray("Patella"), CTAnatomy.newStringArray("Patella")), new DisplayableAnatomicConcept("12921003", false, "SRT", "SNM3", null, "T-D6000", "Pelvis", "PELVIS", CTAnatomy.newStringArray("PV", "Pelv", "Pel", "Bekken", "Becken", "Bassin", "Vaagen", "B\u00c4CKEN", "\u03bb\u03b5\u03ba\u03ac\u03bd\u03b7", "Bacino", "\u9aa8\u76e4", "\uace8\ubc18"), CTAnatomy.newStringArray("Pelvis"), CTAnatomy.newStringArray("Pelvis")), new DisplayableAnatomicConcept("18911002", false, "SRT", "SNM3", null, "T-91000", "Penis", "PENIS", null, CTAnatomy.newStringArray("Penis"), CTAnatomy.newStringArray("Penis")), new DisplayableAnatomicConcept("181211006", false, "SRT", "SNM3", null, "T-55002", "Pharynx", "PHARYNX", null, CTAnatomy.newStringArray("Pharynx"), CTAnatomy.newStringArray("Pharynx")), new DisplayableAnatomicConcept("181422007", false, "SRT", "SNM3", null, "T-9200B", "Prostate", "PROSTATE", null, CTAnatomy.newStringArray("Prostate"), CTAnatomy.newStringArray("Prostate")), new DisplayableAnatomicConcept("34402009", false, "SRT", "SNM3", null, "T-59600", "Rectum", "RECTUM", null, CTAnatomy.newStringArray("Rectum"), CTAnatomy.newStringArray("Rectum")), new DisplayableAnatomicConcept("113197003", true, "SRT", "SNM3", null, "T-11300", "Rib", "RIB", CTAnatomy.newStringArray("Gril costal", "Gril cost"), CTAnatomy.newStringArray("Rib"), CTAnatomy.newStringArray("Rib")), new DisplayableAnatomicConcept("54735007", false, "SRT", "SNM3", null, "T-11AD0", "Sacrum", "SSPINE", CTAnatomy.newStringArray("SSPINE"), CTAnatomy.newStringArray("Sacrum"), CTAnatomy.newStringArray("Sacrum")), new DisplayableAnatomicConcept("41695006", false, "SRT", "SNM3", null, "T-D1160", "Scalp", "SCALP", null, CTAnatomy.newStringArray("Scalp"), CTAnatomy.newStringArray("Scalp")), new DisplayableAnatomicConcept("79601000", true, "SRT", "SNM3", null, "T-12280", "Scapula", "SCAPULA", null, CTAnatomy.newStringArray("Scapula"), CTAnatomy.newStringArray("Scapula")), new DisplayableAnatomicConcept("18619003", true, "SRT", "SNM3", null, "T-AA110", "Sclera", "SCLERA", null, CTAnatomy.newStringArray("Sclera"), CTAnatomy.newStringArray("Sclera")), new DisplayableAnatomicConcept("20233005", true, "SRT", "SNM3", null, "T-98000", "Scrotum", "SCROTUM", null, CTAnatomy.newStringArray("Scrotum"), CTAnatomy.newStringArray("Scrotum")), new DisplayableAnatomicConcept("16982005", true, "SRT", "SNM3", null, "T-D2220", "Shoulder", "SHOULDER", CTAnatomy.newStringArray("Schouder", "Schulter", "Epaule", "\u00e9paule", "\u00f5lg", "\u00d6lg", "Hombro", "Ombro", "Rameno", "Rippe"), CTAnatomy.newStringArray("Shoulder"), CTAnatomy.newStringArray("Shoulder")), new DisplayableAnatomicConcept("C0037303", false, "SRT", "SNM3", null, "T-11100", "Skull", "SKULL", CTAnatomy.newStringArray("Kolju", "LEBKA", "Schedel", "Kallo", "Cr\u00e2ne", "Cranium", "Sch\u00e4del", "Cranio", "Calota Craniana", "Cr\u00e2nio", "\u0427\u0415\u0420\u0415\u041f", "Calota Craneal", "Cr\u00e1neo", "Kalvarium", "Kranium", "Skalle", "Lebka"), CTAnatomy.newStringArray("Skull"), CTAnatomy.newStringArray("Skull")), new DisplayableAnatomicConcept("280717001", false, "SRT", "SNM3", null, "T-D0146", "Spine", "SPINE", CTAnatomy.newStringArray("Rachis", "Rygg", "chrbtica"), CTAnatomy.newStringArray("Spine"), CTAnatomy.newStringArray("Spine")), new DisplayableAnatomicConcept("78961009", false, "SRT", "SNM3", null, "T-C3000", "Spleen", "SPLEEN", null, CTAnatomy.newStringArray("Spleen"), CTAnatomy.newStringArray("Spleen")), new DisplayableAnatomicConcept("56873002", false, "SRT", "SNM3", null, "T-11210", "Sternum", "STERNUM", null, CTAnatomy.newStringArray("Sternum"), CTAnatomy.newStringArray("Sternum")), new DisplayableAnatomicConcept("69695003", false, "SRT", "SNM3", null, "T-57000", "Stomach", "STOMACH", null, CTAnatomy.newStringArray("Stomach"), CTAnatomy.newStringArray("Stomach")), new DisplayableAnatomicConcept("54019009", true, "SRT", "SNM3", null, "T-61300", "Submandibular gland", "SUBMANDIBULAR", CTAnatomy.newStringArray("Submandibular"), CTAnatomy.newStringArray("Submandibular gland"), CTAnatomy.newStringArray("Submandibular gland")), new DisplayableAnatomicConcept("53620006", true, "SRT", "SNM3", null, "T-15290", "Temporomandibular joint", "TMJ", CTAnatomy.newStringArray("Temporomandibular", "TMJ"), CTAnatomy.newStringArray("Temporomandibular joint"), CTAnatomy.newStringArray("Temporomandibular joint")), new DisplayableAnatomicConcept("40689003", true, "SRT", "SNM3", null, "T-94000", "Testis", "TESTIS", null, CTAnatomy.newStringArray("Testis"), CTAnatomy.newStringArray("Testis")), new DisplayableAnatomicConcept("68367000", true, "SRT", "SNM3", null, "T-D9100", "Thigh", "THIGH", CTAnatomy.newStringArray("Oberschenkel", "Bovenbeen", "Reis"), CTAnatomy.newStringArray("Thigh"), CTAnatomy.newStringArray("Thigh")), new DisplayableAnatomicConcept("C0581269", false, "SRT", "SNM3", null, "T-11502", "Thoracic spine", "TSPINE", CTAnatomy.newStringArray("TSPINE", "TS", "THWK", "DWZ", "BWS", "B Rygg", "T spine", "Spine Thoracic", "Thoracic", "Dorsal", "Dorsal spine", "Spine Dorsal", "Rachis dorsal", "COLONNE THORACIQUE", "THORACIQUE", "Rinnaosa", "Rinnal\u00fclid", "Columna dorsal", "Columna vertebral dorsal", "Thoracale wervelzuil", "BR\u00d6STRYGG", "Th chrbtica"), CTAnatomy.newStringArray("Thoracic spine"), CTAnatomy.newStringArray("Thoracic spine")), new DisplayableAnatomicConcept(null, false, "SRT", "SRT", null, "T-D00F8", "Thoraco-lumbar spine", "TLSPINE", CTAnatomy.newStringArray("TLSPINE", "Thoraco-lumbar", "Thoracolumbar", "Col.Dors.Lomb", "THORACOLUMBALE"), CTAnatomy.newStringArray("Thoraco-lumbar spine"), CTAnatomy.newStringArray("Thoraco-lumbar spine")), new DisplayableAnatomicConcept("76505004", true, "SRT", "SNM3", null, "T-D8810", "Thumb", "THUMB", null, CTAnatomy.newStringArray("Thumb"), CTAnatomy.newStringArray("Thumb")), new DisplayableAnatomicConcept("118507000", false, "SRT", "SNM3", null, "T-C8001", "Thymus", "THYMUS", null, CTAnatomy.newStringArray("Thymus"), CTAnatomy.newStringArray("Thymus")), new DisplayableAnatomicConcept("69748006", false, "SRT", "SNM3", null, "T-B6000", "Thyroid", "THYROID", null, CTAnatomy.newStringArray("Thyroid"), CTAnatomy.newStringArray("Thyroid")), new DisplayableAnatomicConcept("29707007", true, "SRT", "SNM3", null, "T-D9800", "Toe", "TOE", null, CTAnatomy.newStringArray("Toe"), CTAnatomy.newStringArray("Toe")), new DisplayableAnatomicConcept("21974007", false, "SRT", "SNM3", null, "T-53000", "Tongue", "TONGUE", null, CTAnatomy.newStringArray("Tongue"), CTAnatomy.newStringArray("Tongue")), new DisplayableAnatomicConcept("44567001", false, "SRT", "SNM3", null, "T-25000", "Trachea", "TRACHEA", null, CTAnatomy.newStringArray("Trachea"), CTAnatomy.newStringArray("Trachea")), new DisplayableAnatomicConcept("65364008", true, "SRT", "SNM3", null, "T-73800", "Ureter", "URETER", null, CTAnatomy.newStringArray("Ureter"), CTAnatomy.newStringArray("Ureter")), new DisplayableAnatomicConcept("13648007", false, "SRT", "SNM3", null, "T-75000", "Urethra", "URETHRA", null, CTAnatomy.newStringArray("Urethra"), CTAnatomy.newStringArray("Urethra")), new DisplayableAnatomicConcept("35039007", false, "SRT", "SNM3", null, "T-83000", "Uterus", "UTERUS", null, CTAnatomy.newStringArray("Uterus"), CTAnatomy.newStringArray("Uterus")), new DisplayableAnatomicConcept("76784001", false, "SRT", "SNM3", null, "T-82000", "Vagina", "VAGINA", null, CTAnatomy.newStringArray("Vagina"), CTAnatomy.newStringArray("Vagina")), new DisplayableAnatomicConcept("45292006", false, "SRT", "SNM3", null, "T-81000", "Vulva", "VULVA", null, CTAnatomy.newStringArray("Vulva"), CTAnatomy.newStringArray("Vulva")), new DisplayableAnatomicConcept("74670003", true, "SRT", "SNM3", null, "T-15460", "Wrist joint", "WRIST", CTAnatomy.newStringArray("Wrist", "mu\u00f1eca", "MU\u00d2ECA", "pols", "poignet", "Handgelenk", "\u03ba\u03b1\u03c1\u03c0\u03cc\u03c2", "polso", "\u624b\u9996", "\uc190\ubaa9", "\u0437\u0430\u043f\u044f\u0441\u0442\u044c\u0435 \u0440\u0443\u043a\u0438", "ranne", "k\u00e4e"), CTAnatomy.newStringArray("Wrist joint"), CTAnatomy.newStringArray("Wrist joint")), new DisplayableAnatomicConcept("51204001", true, "SRT", "SNM3", null, "T-11167", "Zygomatic arch", "ZYGOMA", CTAnatomy.newStringArray("Zygoma"), CTAnatomy.newStringArray("Zygomatic arch"), CTAnatomy.newStringArray("Zygomatic arch"))};
    protected static DictionaryOfConcepts anatomyConcepts = new DictionaryOfConcepts(anatomicConceptEntries, badAnatomyWords, "Anatomy");

    protected static String[] newStringArray(String ... stringArray) {
        return stringArray;
    }

    public static DisplayableAnatomicConcept findAnatomicConcept(AttributeList attributeList) {
        DisplayableConcept displayableConcept = null;
        Object object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.AnatomicRegionSequence);
        if (object != null) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAnatomicConcept(): anatomicRegionSequence = " + object);
            }
            displayableConcept = anatomyConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAnatomicConcept(): found Anatomy in AnatomicRegionSequence = " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.BodyPartExamined)) != null) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAnatomicConcept(): bodyPartExamined = " + (String)object);
            }
            displayableConcept = anatomyConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAnatomicConcept(): found Anatomy in BodyPartExamined = " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null) {
            displayableConcept = CTAnatomy.findAmongstGeneralAttributes(attributeList, anatomyConcepts, badLateralityOrViewOrAnatomyPhraseTriggers);
        }
        return (DisplayableAnatomicConcept)displayableConcept;
    }

    public static DisplayableConcept findAmongstGeneralAttributes(AttributeList attributeList, DictionaryOfConcepts dictionaryOfConcepts, String[] stringArray) {
        DisplayableConcept displayableConcept = null;
        Object object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ImageComments);
        if (object != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): imageComments = " + (String)object);
            }
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in = ImageComments " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): seriesDescription = " + (String)object);
            }
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in SeriesDescription = " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ProtocolName)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): protocolName = " + (String)object);
            }
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in ProtocolName = " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.PerformedProtocolCodeSequence)) != null) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): performedProtocolCodeSequence = " + object);
            }
            displayableConcept = dictionaryOfConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in = PerformedProtocolCodeSequence " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PerformedProcedureStepDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): performedProcedureStepDescription = " + (String)object);
            }
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in = PerformedProcedureStepDescription " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ProcedureCodeSequence)) != null) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): procedureCodeSequence = " + object);
            }
            displayableConcept = dictionaryOfConcepts.findCodeInEntriesFirstThenTryCodeMeaningInEntriesThenTryLongestIndividualEntryContainedWithinCodeMeaning((CodedSequenceItem)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in = ProcedureCodeSequence " + displayableConcept.toStringBrief());
            }
        }
        if (displayableConcept == null && (object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDescription)) != null && !StringUtilities.containsRegardlessOfCase((String)object, stringArray)) {
            if (debugLevel > 0) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): seriesDescription = " + (String)object);
            }
            displayableConcept = dictionaryOfConcepts.findInEntriesFirstThenTryLongestIndividualEntryContainedWithin((String)object);
            if (debugLevel > 0 && displayableConcept != null) {
                System.err.println("CTAnatomy.findAmongstGeneralAttributes(): found " + dictionaryOfConcepts.getDescriptionOfConcept() + " in = StudyDescription " + displayableConcept.toStringBrief());
            }
        }
        return displayableConcept;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            String string = stringArray[0];
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string, null, true, true, TagFromName.PixelData);
                DisplayableAnatomicConcept displayableAnatomicConcept = CTAnatomy.findAnatomicConcept(attributeList);
                if (displayableAnatomicConcept != null) {
                    System.err.print(displayableAnatomicConcept);
                } else {
                    System.err.println("########################### - ANATOMY NOT FOUND - ###########################");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

