/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.GetSOPClassSCU;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.MoveSOPClassSCU;
import com.pixelmed.network.NetworkConfigurationFromMulticastDNS;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SynchronizeFromRemoteSCP {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/SynchronizeFromRemoteSCP.java,v 1.8 2010/11/27 13:54:12 dclunie Exp $";
    private static int sleepTimeBetweenCheckingForNothingExpectedBeforeExiting = 10000;
    private static int sleepTimeAfterRegisteringWithBonjour = 10000;
    private static int inactivityTimeOut = 600000;
    private DatabaseInformationModel databaseInformationModel;
    private File savedInstancesFolder;
    private String remoteHost;
    private int remotePort;
    private String remoteAE;
    private int localPort;
    private String localAE;
    private int verbosityLevel;
    private int debugLevel;
    private QueryInformationModel queryInformationModel;
    private ReceivedObjectHandler receivedObjectHandler;
    private IdentifierHandler identifierHandler;
    private boolean useGet;
    private boolean queryAll;
    private Set setofInstancesExpected;
    private Set setofClassesExpected;
    private int numberOfSOPInstancesReceived;
    private int numberOfValidSOPInstancesReceived;
    private int numberOfUnrequestedSOPInstancesReceived;
    private long inactivityTime;

    private void walkTreeDownToInstanceLevelAndRetrieve(QueryTreeRecord queryTreeRecord, AttributeList attributeList, boolean bl) throws DicomException, DicomNetworkException, IOException {
        int n;
        String string;
        Object object;
        Object object2;
        InformationEntity informationEntity = queryTreeRecord.getInformationEntity();
        Attribute attribute = queryTreeRecord.getUniqueKey();
        AttributeList attributeList2 = null;
        AttributeList attributeList3 = null;
        ArrayList arrayList = null;
        if (informationEntity != null && attribute != null) {
            attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
            }
            AttributeTag attributeTag = this.queryInformationModel.getUniqueKeyForInformationEntity(informationEntity);
            object2 = attribute.getSingleStringValueOrNull();
            if (object2 == null) {
                System.err.println("Could not get UID to use");
            } else {
                System.err.println("Searching for existing records for " + informationEntity + " " + (String)object2);
                arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(informationEntity, (String)object2);
                object = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)object).addValue((String)object2);
                attributeList2.put((Attribute)object);
                if (!bl && arrayList.size() == 0) {
                    System.err.println("No existing records for " + informationEntity + " " + (String)object2);
                    if (this.verbosityLevel > 0) {
                        System.err.println("Performing retrieve for " + queryTreeRecord + " (" + Attribute.getSingleStringValueOrEmptyString(queryTreeRecord.getUniqueKey()) + ")");
                    }
                    object = new SpecificCharacterSet((String[])null);
                    attributeList3 = new AttributeList();
                    attributeList3.putAll(attributeList2);
                    string = this.queryInformationModel.getQueryLevelName(informationEntity);
                    CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
                    ((Attribute)codeStringAttribute).addValue(string);
                    attributeList3.put(codeStringAttribute);
                    System.err.println("Retrieve identifier " + attributeList3);
                    bl = true;
                }
            }
        }
        if ((n = queryTreeRecord.getChildCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)queryTreeRecord.getChildAt(i), attributeList2, bl);
            }
        } else if (informationEntity != null && informationEntity.equals(InformationEntity.INSTANCE) && arrayList.size() == 0) {
            object2 = queryTreeRecord.getAllAttributesReturnedInIdentifier();
            object = Attribute.getSingleStringValueOrNull((AttributeList)object2, TagFromName.SOPInstanceUID);
            System.err.println("Adding to set to retrieve: SOPInstanceUID = " + (String)object);
            this.setofInstancesExpected.add(object);
            if (this.useGet) {
                string = Attribute.getSingleStringValueOrNull((AttributeList)object2, TagFromName.SOPClassUID);
                System.err.println("Adding to set to retrieve: SOPClassUID = " + string);
                this.setofClassesExpected.add(string);
            }
        }
        if (attributeList3 != null) {
            if (this.useGet) {
                System.err.println("Retrieving with C-GET");
                GetSOPClassSCU getSOPClassSCU = new GetSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.3", attributeList3, this.identifierHandler, this.savedInstancesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, this.receivedObjectHandler, this.setofClassesExpected, false, true, true, this.debugLevel);
                this.setofClassesExpected.clear();
            } else {
                MoveSOPClassSCU moveSOPClassSCU = new MoveSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", attributeList3, this.debugLevel);
                int n2 = moveSOPClassSCU.getStatus();
                if (n2 != 0) {
                    System.err.println("SynchronizeFromRemoteSCP: unsuccessful move status = " + "0x" + Integer.toHexString(n2));
                }
            }
        }
    }

    private void performQueryAndWalkTreeDownToInstanceLevelAndRetrieve() throws DicomException, DicomNetworkException, IOException {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
        AttributeList attributeList = new AttributeList();
        attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
        attributeList.putNewAttribute(TagFromName.SeriesInstanceUID);
        attributeList.putNewAttribute(TagFromName.SOPInstanceUID);
        if (this.useGet) {
            attributeList.putNewAttribute(TagFromName.SOPClassUID);
        }
        if (this.verbosityLevel > 0) {
            attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.StudyDate);
            attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.SeriesNumber);
            attributeList.putNewAttribute(TagFromName.SeriesDescription, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.Modality);
            attributeList.putNewAttribute(TagFromName.InstanceNumber);
        }
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{"A*", "B*", "C*", "D*", "E*", "F*", "G*", "H*", "I*", "J*", "K*", "L*", "M*", "N*", "O*", "P*", "Q*", "R*", "S*", "T*", "U*", "V*", "W*", "X*", "Y*", "Z*"};
        String[] stringArray3 = this.queryAll ? stringArray : stringArray2;
        for (int i = 0; i < stringArray3.length; ++i) {
            Object object = new PersonNameAttribute(TagFromName.PatientName, specificCharacterSet);
            ((Attribute)object).addValue(stringArray3[i]);
            attributeList.put((Attribute)object);
            object = this.queryInformationModel.performHierarchicalQuery(attributeList);
            this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)((QueryTreeModel)object).getRoot(), null, false);
        }
    }

    public SynchronizeFromRemoteSCP(DatabaseInformationModel databaseInformationModel, File file, String string, int n, String string2, int n2, String string3, boolean bl, boolean bl2, int n3, int n4) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this.databaseInformationModel = databaseInformationModel;
        this.savedInstancesFolder = file;
        this.remoteHost = string;
        this.remotePort = n;
        this.remoteAE = string2;
        this.localPort = n2;
        this.localAE = string3;
        this.useGet = bl;
        this.queryAll = bl2;
        this.verbosityLevel = n3;
        this.debugLevel = n4;
        if (!file.exists() || !file.isDirectory()) {
            throw new DicomException("Folder in which to save received instances does not exist or is not a directory - " + file);
        }
        this.receivedObjectHandler = new OurReceivedObjectHandler();
        this.identifierHandler = new IdentifierHandler();
        if (bl) {
            this.setofClassesExpected = new HashSet();
        } else {
            new Thread(new StorageSOPClassSCPDispatcher(n2, string3, file, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, this.receivedObjectHandler, n4)).start();
        }
        this.setofInstancesExpected = new HashSet();
        this.numberOfSOPInstancesReceived = 0;
        this.numberOfValidSOPInstancesReceived = 0;
        this.numberOfUnrequestedSOPInstancesReceived = 0;
        this.queryInformationModel = new StudyRootQueryInformationModel(string, n, string2, string3, n4);
        this.performQueryAndWalkTreeDownToInstanceLevelAndRetrieve();
        this.inactivityTime = 0L;
        while (!this.setofInstancesExpected.isEmpty() && this.inactivityTime > (long)inactivityTimeOut) {
            System.err.println("Sleeping since " + this.setofInstancesExpected.size() + " remaining");
            Thread.currentThread();
            Thread.sleep(sleepTimeBetweenCheckingForNothingExpectedBeforeExiting);
            this.inactivityTime += (long)sleepTimeBetweenCheckingForNothingExpectedBeforeExiting;
        }
        System.err.println("Finished with " + this.numberOfSOPInstancesReceived + " instances received, of which " + this.numberOfValidSOPInstancesReceived + " were valid, and " + this.numberOfUnrequestedSOPInstancesReceived + " were unrequested; requested but never received were " + this.setofInstancesExpected.size() + " instances");
    }

    public static void main(String[] stringArray) {
        block5: {
            try {
                if (stringArray.length >= 7 && stringArray.length <= 11) {
                    boolean bl;
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    String string3 = stringArray[2];
                    int n = Integer.parseInt(stringArray[3]);
                    String string4 = stringArray[4];
                    int n2 = Integer.parseInt(stringArray[5]);
                    String string5 = stringArray[6];
                    boolean bl2 = stringArray.length > 7 ? stringArray[7].trim().toUpperCase().equals("GET") : (bl = false);
                    boolean bl3 = stringArray.length > 8 ? stringArray[8].trim().toUpperCase().equals("ALL") : true;
                    int n3 = stringArray.length > 9 ? Integer.parseInt(stringArray[9]) : 0;
                    int n4 = stringArray.length > 10 ? Integer.parseInt(stringArray[10]) : 0;
                    File file = new File(string2);
                    PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel(string);
                    try {
                        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS(n4);
                        networkConfigurationFromMulticastDNS.activateDiscovery();
                        networkConfigurationFromMulticastDNS.registerDicomService(string5, n2, "WSD");
                        Thread.currentThread();
                        Thread.sleep(sleepTimeAfterRegisteringWithBonjour);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    new SynchronizeFromRemoteSCP(patientStudySeriesConcatenationInstanceModel, file, string3, n, string4, n2, string5, bl, bl3, n3, n4);
                    patientStudySeriesConcatenationInstanceModel.close();
                    System.exit(0);
                    break block5;
                }
                System.err.println("Usage: java -cp ./pixelmed.jar:./lib/additional/hsqldb.jar:./lib/additional/commons-codec-1.3.jar:./lib/additional/jmdns.jar com.pixelmed.apps.SynchronizeFromRemoteSCP databasepath savedfilesfolder remoteHost remotePort remoteAET ooutPort ourAET [GET|MOVE [ALL|SELECTIVE [verbositylevel [debuglevel]]]]");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                SynchronizeFromRemoteSCP.this.inactivityTime = 0L;
                if (SynchronizeFromRemoteSCP.this.verbosityLevel > 1) {
                    System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                }
                ++SynchronizeFromRemoteSCP.this.numberOfSOPInstancesReceived;
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                    System.err.println("Received: " + string + " with SOPInstanceUID " + string4);
                    if (string4 != null) {
                        ++SynchronizeFromRemoteSCP.this.numberOfValidSOPInstancesReceived;
                        if (!SynchronizeFromRemoteSCP.this.setofInstancesExpected.contains(string4)) {
                            ++SynchronizeFromRemoteSCP.this.numberOfUnrequestedSOPInstancesReceived;
                            SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string, "C");
                            throw new DicomException("Unrequested SOPInstanceUID in received object ... stored it anyway");
                        }
                    } else {
                        throw new DicomException("Missing SOPInstanceUID in received object ... ignoring");
                    }
                    SynchronizeFromRemoteSCP.this.setofInstancesExpected.remove(string4);
                    SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

