/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DatabaseTreeRecord
implements Comparable,
MutableTreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseTreeRecord.java,v 1.22 2011/01/23 19:55:25 dclunie Exp $";
    private DatabaseInformationModel d;
    private DatabaseTreeRecord parent;
    private List children;
    private InformationEntity ie;
    private String localPrimaryKeyValue;
    private String localFileNameValue;
    private String localFileReferenceTypeValue;
    private String value;
    private boolean childrenPopulated;

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public int compareTo(Object object) {
        DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)object;
        String string = databaseTreeRecord.getLocalPrimaryKeyValue();
        if (this.getLocalPrimaryKeyValue() == null && string == null) {
            return 0;
        }
        int n = this.getLocalPrimaryKeyValue().compareTo(string);
        int n2 = StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(this.getValue(), databaseTreeRecord.getValue());
        if (n2 == 0) {
            return n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (DatabaseTreeRecord)mutableTreeNode;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null) {
            int n = this.getChildCount();
            if (this.children != null && n > 0) {
                Vector<DatabaseTreeRecord> vector = new Vector<DatabaseTreeRecord>(n - 1);
                for (int i = 0; i < n; ++i) {
                    DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)this.children.get(i);
                    if (databaseTreeRecord.equals(mutableTreeNode)) {
                        try {
                            this.d.deleteRecord(databaseTreeRecord.getInformationEntity(), databaseTreeRecord.getLocalPrimaryKeyValue());
                        }
                        catch (DicomException dicomException) {
                            dicomException.printStackTrace(System.err);
                        }
                        continue;
                    }
                    vector.add(databaseTreeRecord);
                }
            }
            mutableTreeNode.setParent(null);
        }
    }

    public void remove(int n) {
        if (n > 0) {
            MutableTreeNode mutableTreeNode;
            int n2 = this.getChildCount();
            if (this.children != null && n2 > 0 && n < n2 && (mutableTreeNode = (MutableTreeNode)this.children.get(n)) != null) {
                this.remove(mutableTreeNode);
            }
        }
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        assert (false);
    }

    public void setUserObject(Object object) {
        assert (false);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int n) {
        return n < this.getChildCount() ? (TreeNode)this.children.get(n) : null;
    }

    public int getIndex(TreeNode treeNode) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get(i).equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getChildCount() {
        if (!this.childrenPopulated) {
            this.populateChildren();
            this.childrenPopulated = true;
        }
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        this.getChildCount();
        return this.children == null ? null : new Vector(this.children).elements();
    }

    private void populateChildren() {
        InformationEntity informationEntity = this.ie == null ? this.d.getRootInformationEntity() : this.d.getChildTypeForParent(this.ie);
        String string = this.d.getDescriptiveColumnName(informationEntity);
        String string2 = this.d.getOtherDescriptiveColumnName(informationEntity);
        String string3 = this.d.getOtherOtherDescriptiveColumnName(informationEntity);
        String string4 = this.d.getLocalPrimaryKeyColumnName(informationEntity).toUpperCase();
        String string5 = this.d.getLocalFileNameColumnName(informationEntity).toUpperCase();
        String string6 = this.d.getLocalFileReferenceTypeColumnName(informationEntity).toUpperCase();
        Object var8_8 = null;
        ArrayList arrayList = null;
        try {
            ArrayList arrayList2 = arrayList = this.localPrimaryKeyValue == null ? this.d.findAllAttributeValuesForAllRecordsForThisInformationEntity(informationEntity) : this.d.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(informationEntity, this.localPrimaryKeyValue);
            if ((informationEntity != null && this.localPrimaryKeyValue != null && arrayList == null || arrayList.size() == 0) && (informationEntity = this.d.getChildTypeForParent(informationEntity)) != null) {
                string = this.d.getDescriptiveColumnName(informationEntity);
                string2 = this.d.getOtherDescriptiveColumnName(informationEntity);
                string3 = this.d.getOtherOtherDescriptiveColumnName(informationEntity);
                string4 = this.d.getLocalPrimaryKeyColumnName(informationEntity).toUpperCase();
                string5 = this.d.getLocalFileNameColumnName(informationEntity).toUpperCase();
                string6 = this.d.getLocalFileReferenceTypeColumnName(informationEntity).toUpperCase();
                arrayList = this.d.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(informationEntity, this.localPrimaryKeyValue);
            }
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
            arrayList = null;
        }
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string7 = null;
                Map map = (Map)arrayList.get(i);
                if (map == null) continue;
                String string8 = string == null ? null : (String)map.get(string.toUpperCase());
                String string9 = string2 == null ? null : (String)map.get(string2.toUpperCase());
                String string10 = string3 == null ? null : (String)map.get(string3.toUpperCase());
                String string11 = string4 == null ? null : (String)map.get(string4);
                String string12 = string5 == null ? null : (String)map.get(string5);
                String string13 = string6 == null ? null : (String)map.get(string6);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.d.getNametoDescribeThisInstanceOfInformationEntity(informationEntity, map));
                String string14 = (String)map.get("SOPCLASSUID");
                if (informationEntity == InformationEntity.INSTANCE && string14 != null && SOPClass.isImageStorage(string14)) {
                    stringBuffer.append(" ");
                    stringBuffer.append(DescriptionFactory.makeImageDescription(map));
                } else if (informationEntity == InformationEntity.SERIES) {
                    stringBuffer.append(" ");
                    stringBuffer.append(DescriptionFactory.makeSeriesDescription(map));
                } else if (informationEntity == InformationEntity.PATIENT) {
                    stringBuffer.append(" ");
                    stringBuffer.append(DescriptionFactory.makePatientDescription(map));
                } else {
                    if (string8 != null) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string8);
                    }
                    if (string9 != null) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string9);
                    }
                    if (string10 != null) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string10);
                    }
                }
                string7 = stringBuffer.toString();
                DatabaseTreeRecord databaseTreeRecord = new DatabaseTreeRecord(this.d, this, string7, informationEntity, string11, string12, string13);
                this.addChild(databaseTreeRecord);
            }
        }
    }

    public DatabaseTreeRecord(DatabaseInformationModel databaseInformationModel, DatabaseTreeRecord databaseTreeRecord, String string, InformationEntity informationEntity, String string2, String string3) {
        this(databaseInformationModel, databaseTreeRecord, string, informationEntity, string2, string3, "");
    }

    public DatabaseTreeRecord(DatabaseInformationModel databaseInformationModel, DatabaseTreeRecord databaseTreeRecord, String string, InformationEntity informationEntity, String string2, String string3, String string4) {
        this.d = databaseInformationModel;
        this.parent = databaseTreeRecord;
        this.value = string;
        this.ie = informationEntity;
        this.localPrimaryKeyValue = string2;
        this.localFileNameValue = string3;
        this.localFileReferenceTypeValue = string4;
        this.childrenPopulated = false;
    }

    public void addChild(DatabaseTreeRecord databaseTreeRecord) {
        int n;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((n = Collections.binarySearch(this.children, databaseTreeRecord)) < 0) {
            this.children.add(-n - 1, databaseTreeRecord);
        }
    }

    public void addSibling(DatabaseTreeRecord databaseTreeRecord) {
        this.parent.addChild(databaseTreeRecord);
    }

    public String getValue() {
        return this.value;
    }

    public InformationEntity getInformationEntity() {
        return this.ie;
    }

    public String getLocalPrimaryKeyValue() {
        return this.localPrimaryKeyValue;
    }

    public String getLocalFileNameValue() {
        return this.localFileNameValue;
    }

    public String getLocalFileReferenceTypeValue() {
        return this.localFileReferenceTypeValue;
    }

    public DatabaseInformationModel getDatabaseInformationModel() {
        return this.d;
    }
}

