/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public abstract class Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/Attribute.java,v 1.23 2009/02/15 15:54:22 dclunie Exp $";
    private AttributeTag tag;
    protected long valueLength;
    protected int valueMultiplicity = 0;

    protected Attribute(AttributeTag attributeTag) {
        this.tag = attributeTag;
        this.valueLength = 0L;
        this.valueMultiplicity = 0;
    }

    public AttributeTag getTag() {
        return this.tag;
    }

    public int getGroup() {
        return this.tag.getGroup();
    }

    public int getElement() {
        return this.tag.getElement();
    }

    public long getVL() {
        return this.valueLength;
    }

    public int getVM() {
        return this.valueMultiplicity;
    }

    public byte[] getVR() {
        return ValueRepresentation.UN;
    }

    public String getVRAsString() {
        return ValueRepresentation.getAsString(this.getVR());
    }

    public long getPaddedVL() {
        return this.valueLength;
    }

    public String[] getOriginalStringValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public String[] getStringValues() throws DicomException {
        return this.getStringValues(null);
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public byte[] getByteValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public short[] getShortValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public int[] getIntegerValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public long[] getLongValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public float[] getFloatValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public double[] getDoubleValues() throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void addValue(String string) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(String string) throws DicomException {
        this.removeValues();
        this.addValue(string);
    }

    public void addValue(byte by) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(byte by) throws DicomException {
        this.removeValues();
        this.addValue(by);
    }

    public void addValue(short s) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(short s) throws DicomException {
        this.removeValues();
        this.addValue(s);
    }

    public void addValue(int n) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(int n) throws DicomException {
        this.removeValues();
        this.addValue(n);
    }

    public void addValue(long l) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(long l) throws DicomException {
        this.removeValues();
        this.addValue(l);
    }

    public void addValue(float f) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(float f) throws DicomException {
        this.removeValues();
        this.addValue(f);
    }

    public void addValue(double d) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValue(double d) throws DicomException {
        this.removeValues();
        this.addValue(d);
    }

    public void setValues(byte[] byArray) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValues(short[] sArray) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public void setValues(float[] fArray) throws DicomException {
        throw new DicomException("internal error - wrong value type for attribute " + this.tag);
    }

    public abstract void removeValues() throws DicomException;

    protected void writeBase(DicomOutputStream dicomOutputStream) throws IOException {
        dicomOutputStream.writeUnsigned16(this.getGroup());
        dicomOutputStream.writeUnsigned16(this.getElement());
        if (dicomOutputStream.isExplicitVR()) {
            byte[] byArray = this.getVR();
            dicomOutputStream.write(byArray, 0, 2);
            if (ValueRepresentation.isShortValueLengthVR(byArray)) {
                dicomOutputStream.writeUnsigned16((int)this.getPaddedVL());
            } else {
                dicomOutputStream.writeUnsigned16(0);
                dicomOutputStream.writeUnsigned32(this.getPaddedVL());
            }
        } else {
            dicomOutputStream.writeUnsigned32(this.getPaddedVL());
        }
    }

    public abstract void write(DicomOutputStream var1) throws DicomException, IOException;

    public String toString(DicomDictionary dicomDictionary) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag.toString());
        if (dicomDictionary != null && (string = dicomDictionary.getNameFromTag(this.tag)) != null) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" VR=<");
        stringBuffer.append(this.getVRAsString());
        stringBuffer.append("> VL=<0x");
        stringBuffer.append(Long.toHexString(this.getVL()));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String getSingleStringValueOrDefault(String string) {
        return this.getSingleStringValueOrDefault(string, null);
    }

    public String getSingleStringValueOrDefault(String string, NumberFormat numberFormat) {
        String string2 = string;
        try {
            String string3;
            String[] stringArray = this.getStringValues(numberFormat);
            if (stringArray != null && stringArray.length > 0 && (string3 = stringArray[0]) != null) {
                string2 = string3;
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return string2;
    }

    public String getSingleStringValueOrEmptyString() {
        return this.getSingleStringValueOrDefault("");
    }

    public String getSingleStringValueOrEmptyString(NumberFormat numberFormat) {
        return this.getSingleStringValueOrDefault("", numberFormat);
    }

    public String getSingleStringValueOrNull() {
        return this.getSingleStringValueOrDefault(null);
    }

    public String getSingleStringValueOrNull(NumberFormat numberFormat) {
        return this.getSingleStringValueOrDefault(null, numberFormat);
    }

    public String getDelimitedStringValuesOrDefault(String string) {
        return this.getDelimitedStringValuesOrDefault(string, null);
    }

    public String getDelimitedStringValuesOrDefault(String string, NumberFormat numberFormat) {
        String string2 = string;
        try {
            String[] stringArray = this.getStringValues(numberFormat);
            if (stringArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3;
                    if (i > 0) {
                        stringBuffer.append("\\");
                    }
                    if ((string3 = stringArray[i]) == null) continue;
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return string2;
    }

    public String getDelimitedStringValuesOrEmptyString() {
        return this.getDelimitedStringValuesOrDefault("");
    }

    public String getDelimitedStringValuesOrEmptyString(NumberFormat numberFormat) {
        return this.getDelimitedStringValuesOrDefault("", numberFormat);
    }

    public String getDelimitedStringValuesOrNull() {
        return this.getDelimitedStringValuesOrDefault(null);
    }

    public String getDelimitedStringValuesOrNull(NumberFormat numberFormat) {
        return this.getDelimitedStringValuesOrDefault(null, numberFormat);
    }

    public int getSingleIntegerValueOrDefault(int n) {
        int n2 = n;
        try {
            int[] nArray = this.getIntegerValues();
            if (nArray != null && nArray.length > 0) {
                n2 = nArray[0];
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return n2;
    }

    public double getSingleDoubleValueOrDefault(double d) {
        double d2 = d;
        try {
            double[] dArray = this.getDoubleValues();
            if (dArray != null && dArray.length > 0) {
                d2 = dArray[0];
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return d2;
    }

    public long getSingleLongValueOrDefault(long l) {
        long l2 = l;
        try {
            long[] lArray = this.getLongValues();
            if (lArray != null && lArray.length > 0) {
                l2 = lArray[0];
            }
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        return l2;
    }

    public static String getSingleStringValueOrDefault(Attribute attribute, String string) {
        String string2 = string;
        if (attribute != null) {
            string2 = attribute.getSingleStringValueOrDefault(string);
        }
        return string2;
    }

    public static String getSingleStringValueOrDefault(Attribute attribute, String string, NumberFormat numberFormat) {
        String string2 = string;
        if (attribute != null) {
            string2 = attribute.getSingleStringValueOrDefault(string, numberFormat);
        }
        return string2;
    }

    public static String getSingleStringValueOrEmptyString(Attribute attribute) {
        return Attribute.getSingleStringValueOrDefault(attribute, "");
    }

    public static String getSingleStringValueOrEmptyString(Attribute attribute, NumberFormat numberFormat) {
        return Attribute.getSingleStringValueOrDefault(attribute, "", numberFormat);
    }

    public static String getSingleStringValueOrNull(Attribute attribute) {
        return Attribute.getSingleStringValueOrDefault(attribute, null);
    }

    public static String getSingleStringValueOrNull(Attribute attribute, NumberFormat numberFormat) {
        return Attribute.getSingleStringValueOrDefault(attribute, null, numberFormat);
    }

    public static String getDelimitedStringValuesOrDefault(Attribute attribute, String string) {
        String string2 = string;
        if (attribute != null) {
            string2 = attribute.getDelimitedStringValuesOrDefault(string);
        }
        return string2;
    }

    public static String getDelimitedStringValuesOrDefault(Attribute attribute, String string, NumberFormat numberFormat) {
        String string2 = string;
        if (attribute != null) {
            string2 = attribute.getDelimitedStringValuesOrDefault(string, numberFormat);
        }
        return string2;
    }

    public static String getDelimitedStringValuesOrEmptyString(Attribute attribute) {
        return Attribute.getDelimitedStringValuesOrDefault(attribute, "");
    }

    public static String getDelimitedStringValuesOrEmptyString(Attribute attribute, NumberFormat numberFormat) {
        return Attribute.getDelimitedStringValuesOrDefault(attribute, "", numberFormat);
    }

    public static String getDelimitedStringValuesOrNull(Attribute attribute) {
        return Attribute.getDelimitedStringValuesOrDefault(attribute, null);
    }

    public static String getDelimitedStringValuesOrNull(Attribute attribute, NumberFormat numberFormat) {
        return Attribute.getDelimitedStringValuesOrDefault(attribute, null, numberFormat);
    }

    public static String[] getStringValues(Attribute attribute) {
        String[] stringArray = null;
        if (attribute != null) {
            try {
                stringArray = attribute.getStringValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static String[] getStringValues(Attribute attribute, NumberFormat numberFormat) {
        String[] stringArray = null;
        if (attribute != null) {
            try {
                stringArray = attribute.getStringValues(numberFormat);
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public static int getSingleIntegerValueOrDefault(Attribute attribute, int n) {
        int n2 = n;
        if (attribute != null) {
            n2 = attribute.getSingleIntegerValueOrDefault(n);
        }
        return n2;
    }

    public static int[] getIntegerValues(Attribute attribute) {
        int[] nArray = null;
        if (attribute != null) {
            try {
                nArray = attribute.getIntegerValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        return nArray;
    }

    public static long getSingleLongValueOrDefault(Attribute attribute, long l) {
        long l2 = l;
        if (attribute != null) {
            l2 = attribute.getSingleLongValueOrDefault(l);
        }
        return l2;
    }

    public static long[] getLongValues(Attribute attribute) {
        long[] lArray = null;
        if (attribute != null) {
            try {
                lArray = attribute.getLongValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        return lArray;
    }

    public static double getSingleDoubleValueOrDefault(Attribute attribute, double d) {
        double d2 = d;
        if (attribute != null) {
            d2 = attribute.getSingleDoubleValueOrDefault(d);
        }
        return d2;
    }

    public static double[] getDoubleValues(Attribute attribute) {
        double[] dArray = null;
        if (attribute != null) {
            try {
                dArray = attribute.getDoubleValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        return dArray;
    }

    public static String getSingleStringValueOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string) {
        return attributeList == null ? string : Attribute.getSingleStringValueOrDefault(attributeList.get(attributeTag), string);
    }

    public static String getSingleStringValueOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string, NumberFormat numberFormat) {
        return attributeList == null ? string : Attribute.getSingleStringValueOrDefault(attributeList.get(attributeTag), string, numberFormat);
    }

    public static String getSingleStringValueOrEmptyString(AttributeList attributeList, AttributeTag attributeTag) {
        return Attribute.getSingleStringValueOrDefault(attributeList, attributeTag, "");
    }

    public static String getSingleStringValueOrEmptyString(AttributeList attributeList, AttributeTag attributeTag, NumberFormat numberFormat) {
        return Attribute.getSingleStringValueOrDefault(attributeList, attributeTag, "", numberFormat);
    }

    public static String getSingleStringValueOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        return Attribute.getSingleStringValueOrDefault(attributeList, attributeTag, null);
    }

    public static String getSingleStringValueOrNull(AttributeList attributeList, AttributeTag attributeTag, NumberFormat numberFormat) {
        return Attribute.getSingleStringValueOrDefault(attributeList, attributeTag, null, numberFormat);
    }

    public static String getDelimitedStringValuesOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string) {
        return attributeList == null ? string : Attribute.getDelimitedStringValuesOrDefault(attributeList.get(attributeTag), string);
    }

    public static String getDelimitedStringValuesOrDefault(AttributeList attributeList, AttributeTag attributeTag, String string, NumberFormat numberFormat) {
        return attributeList == null ? string : Attribute.getDelimitedStringValuesOrDefault(attributeList.get(attributeTag), string, numberFormat);
    }

    public static String getDelimitedStringValuesOrEmptyString(AttributeList attributeList, AttributeTag attributeTag) {
        return Attribute.getDelimitedStringValuesOrDefault(attributeList, attributeTag, "");
    }

    public static String getDelimitedStringValuesOrEmptyString(AttributeList attributeList, AttributeTag attributeTag, NumberFormat numberFormat) {
        return Attribute.getDelimitedStringValuesOrDefault(attributeList, attributeTag, "", numberFormat);
    }

    public static String getDelimitedStringValuesOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        return Attribute.getDelimitedStringValuesOrDefault(attributeList, attributeTag, null);
    }

    public static String getDelimitedStringValuesOrNull(AttributeList attributeList, AttributeTag attributeTag, NumberFormat numberFormat) {
        return Attribute.getDelimitedStringValuesOrDefault(attributeList, attributeTag, null, numberFormat);
    }

    public static String[] getStringValues(AttributeList attributeList, AttributeTag attributeTag) {
        return attributeList == null ? null : Attribute.getStringValues(attributeList.get(attributeTag));
    }

    public static String[] getStringValues(AttributeList attributeList, AttributeTag attributeTag, NumberFormat numberFormat) {
        return attributeList == null ? null : Attribute.getStringValues(attributeList.get(attributeTag), numberFormat);
    }

    public static int getSingleIntegerValueOrDefault(AttributeList attributeList, AttributeTag attributeTag, int n) {
        return attributeList == null ? n : Attribute.getSingleIntegerValueOrDefault(attributeList.get(attributeTag), n);
    }

    public static int[] getIntegerValues(AttributeList attributeList, AttributeTag attributeTag) {
        return attributeList == null ? null : Attribute.getIntegerValues(attributeList.get(attributeTag));
    }

    public static long getSingleLongValueOrDefault(AttributeList attributeList, AttributeTag attributeTag, long l) {
        return attributeList == null ? l : Attribute.getSingleLongValueOrDefault(attributeList.get(attributeTag), l);
    }

    public static long[] getLongValues(AttributeList attributeList, AttributeTag attributeTag) {
        return attributeList == null ? null : Attribute.getLongValues(attributeList.get(attributeTag));
    }

    public static double getSingleDoubleValueOrDefault(AttributeList attributeList, AttributeTag attributeTag, double d) {
        return attributeList == null ? d : Attribute.getSingleDoubleValueOrDefault(attributeList.get(attributeTag), d);
    }

    public static double[] getDoubleValues(AttributeList attributeList, AttributeTag attributeTag) {
        return attributeList == null ? null : Attribute.getDoubleValues(attributeList.get(attributeTag));
    }
}

