/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonIdentification;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public abstract class ClinicalTrialsAttributes {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ClinicalTrialsAttributes.java,v 1.49 2011/01/23 19:55:25 dclunie Exp $";
    protected static final String defaultValueForMissingNonZeroLengthStrings = "NONE";
    protected static final String defaultValueForMissingPossiblyZeroLengthStrings = "";
    protected static Map mapOfOriginalToReplacementUIDs = null;
    protected static UIDGenerator uidGenerator = null;

    private ClinicalTrialsAttributes() {
    }

    protected static void addType1LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null || string.length() == 0) {
            string = defaultValueForMissingNonZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType2LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null) {
            string = defaultValueForMissingPossiblyZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType3ShortTextAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortTextAttribute shortTextAttribute = new ShortTextAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortTextAttribute).addValue(string);
            attributeList.put(attributeTag, shortTextAttribute);
        }
    }

    protected static void addType3ShortStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortStringAttribute).addValue(string);
            attributeList.put(attributeTag, shortStringAttribute);
        }
    }

    protected static void addType3LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)longStringAttribute).addValue(string);
            attributeList.put(attributeTag, longStringAttribute);
        }
    }

    protected static void addType3DateTimeAttribute(AttributeList attributeList, AttributeTag attributeTag, String string) throws DicomException {
        if (string != null) {
            DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(attributeTag);
            ((Attribute)dateTimeAttribute).addValue(string);
            attributeList.put(attributeTag, dateTimeAttribute);
        }
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), string, string2, string3, string4, string5, string6, string7, string8, "Deidentified", DateTimeAttribute.getFormattedString(new Date()));
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, codedSequenceItem, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, null, null);
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String[] stringArray, PersonIdentification[] personIdentificationArray) throws DicomException {
        int n;
        Attribute attribute;
        Attribute attribute2 = attributeList.get(TagFromName.SpecificCharacterSet);
        SpecificCharacterSet specificCharacterSet = attribute2 == null ? null : new SpecificCharacterSet(attribute2.getStringValues());
        AttributeList attributeList2 = new AttributeList();
        if (codedSequenceItem != null) {
            attribute = new SequenceAttribute(TagFromName.PurposeOfReferenceCodeSequence);
            ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
            attributeList2.put(attribute);
        }
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.Manufacturer, string, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.InstitutionName, string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.InstitutionalDepartmentName, string3, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, TagFromName.InstitutionAddress, string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortStringAttribute(attributeList2, TagFromName.StationName, string5, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.ManufacturerModelName, string6, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.DeviceSerialNumber, string7, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.SoftwareVersions, string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, TagFromName.ContributionDescription, string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType3DateTimeAttribute(attributeList2, TagFromName.ContributionDateTime, string10);
        if (stringArray != null && stringArray.length > 0) {
            attribute = new PersonNameAttribute(TagFromName.OperatorsName);
            for (n = 0; n < stringArray.length; ++n) {
                attribute.addValue(stringArray[n]);
            }
            attributeList2.put(attribute);
        }
        if (personIdentificationArray != null && personIdentificationArray.length > 0) {
            attribute = new SequenceAttribute(TagFromName.OperatorIdentificationSequence);
            for (n = 0; n < personIdentificationArray.length; ++n) {
                PersonIdentification personIdentification = personIdentificationArray[n];
                if (personIdentification == null) continue;
                ((SequenceAttribute)attribute).addItem(new SequenceItem(personIdentification.getAttributeList()));
            }
            attributeList2.put(attribute);
        }
        attribute = null;
        if (bl) {
            attribute = (SequenceAttribute)attributeList.get(TagFromName.ContributingEquipmentSequence);
        }
        if (attribute == null) {
            attribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        }
        ((SequenceAttribute)attribute).addItem(attributeList2);
        attributeList.remove(TagFromName.ContributingEquipmentSequence);
        attributeList.put(attribute);
    }

    public static void removeClinicalTrialsAttributes(AttributeList attributeList) {
        attributeList.remove(TagFromName.ClinicalTrialSponsorName);
        attributeList.remove(TagFromName.ClinicalTrialProtocolID);
        attributeList.remove(TagFromName.ClinicalTrialProtocolName);
        attributeList.remove(TagFromName.ClinicalTrialSiteID);
        attributeList.remove(TagFromName.ClinicalTrialSiteName);
        attributeList.remove(TagFromName.ClinicalTrialSubjectID);
        attributeList.remove(TagFromName.ClinicalTrialSubjectReadingID);
        attributeList.remove(TagFromName.ClinicalTrialTimePointID);
        attributeList.remove(TagFromName.ClinicalTrialTimePointDescription);
        attributeList.remove(TagFromName.ClinicalTrialCoordinatingCenterName);
    }

    public static void addClinicalTrialsAttributes(AttributeList attributeList, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        Attribute attribute = attributeList.get(TagFromName.SpecificCharacterSet);
        SpecificCharacterSet specificCharacterSet = attribute == null ? null : new SpecificCharacterSet(attribute.getStringValues());
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSponsorName, string, specificCharacterSet);
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialProtocolID, string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialProtocolName, string3, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialSiteID, string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialSiteName, string5, specificCharacterSet);
        if (string6 != null || string7 == null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSubjectID, string6, specificCharacterSet);
        }
        if (string7 != null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSubjectReadingID, string7, specificCharacterSet);
        }
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialTimePointID, string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList, TagFromName.ClinicalTrialTimePointDescription, string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialCoordinatingCenterName, string10, specificCharacterSet);
        if (bl) {
            String string11 = string6;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new PersonNameAttribute(TagFromName.PatientName, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.PatientName, stringAttributeAffectedBySpecificCharacterSet);
            stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.PatientID, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.PatientID, stringAttributeAffectedBySpecificCharacterSet);
            string11 = string8;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.StudyID, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.StudyID, stringAttributeAffectedBySpecificCharacterSet);
        }
    }

    public static boolean isSafePrivateAttribute(AttributeTag attributeTag, AttributeList attributeList) {
        boolean bl = false;
        if (attributeTag.isPrivateCreator()) {
            bl = true;
        } else {
            String string = attributeList.getPrivateCreatorString(attributeTag);
            bl = ClinicalTrialsAttributes.isSafePrivateAttribute(string, attributeTag);
        }
        return bl;
    }

    public static boolean isSafePrivateAttribute(String string, AttributeTag attributeTag) {
        boolean bl = false;
        if (attributeTag.isPrivateCreator()) {
            bl = true;
        } else {
            int n = attributeTag.getGroup();
            int n2 = attributeTag.getElement();
            int n3 = n2 & 0xFF;
            if (n == 28755) {
                if (string.equals("Philips PET Private Group")) {
                    if (n3 == 0) {
                        bl = true;
                    } else if (n3 == 9) {
                        bl = true;
                    }
                }
            } else if (n == 225) {
                if (string.equals("ELSCINT1") && n3 == 33) {
                    bl = true;
                }
            } else if (n == 481) {
                if (string.equals("ELSCINT1")) {
                    if (n3 == 38) {
                        bl = true;
                    } else if (n3 == 80) {
                        bl = true;
                    }
                }
            } else if (n == 497) {
                if (string.equals("ELSCINT1")) {
                    if (n3 == 1) {
                        bl = true;
                    } else if (n3 == 7) {
                        bl = true;
                    } else if (n3 == 38) {
                        bl = true;
                    } else if (n3 == 39) {
                        bl = true;
                    }
                }
            } else if (n == 25) {
                if (string.equals("GEMS_ACQU_01")) {
                    if (n3 == 35) {
                        bl = true;
                    } else if (n3 == 36) {
                        bl = true;
                    } else if (n3 == 39) {
                        bl = true;
                    }
                }
            } else if (n == 67) {
                if (string.equals("GEMS_PARM_01") && n3 == 39) {
                    bl = true;
                }
            } else if (n == 69) {
                if (string.equals("GEMS_HELIOS_01")) {
                    if (n3 == 1) {
                        bl = true;
                    } else if (n3 == 2) {
                        bl = true;
                    }
                }
            } else if (n == 2307 && string.equals("GEIIS PACS")) {
                if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static void flushMapOfUIDs() {
        mapOfOriginalToReplacementUIDs = null;
    }

    public static void remapUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 2);
    }

    public static void removeUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 1);
    }

    protected static void removeOrRemapUIDAttributes(AttributeList attributeList, int n) throws DicomException {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Object> linkedList = null;
        for (Object object4 : attributeList.values()) {
            Object object5;
            if (object4 instanceof SequenceAttribute) {
                object5 = (SequenceAttribute)object4;
                object3 = ((SequenceAttribute)object5).iterator();
                if (object3 == null) continue;
                while (object3.hasNext()) {
                    object2 = (SequenceItem)object3.next();
                    if (object2 == null || (object = ((SequenceItem)object2).getAttributeList()) == null) continue;
                    ClinicalTrialsAttributes.removeOrRemapUIDAttributes((AttributeList)object, n);
                }
                continue;
            }
            if (n == 0 || !(object4 instanceof UniqueIdentifierAttribute) || !UniqueIdentifierAttribute.isTransient((AttributeTag)(object3 = ((Attribute)(object5 = (UniqueIdentifierAttribute)object4)).getTag()))) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Object>();
            }
            linkedList.add(object3);
        }
        if (linkedList != null) {
            for (Object object5 : linkedList) {
                if (n == 1) {
                    attributeList.remove((AttributeTag)object5);
                    continue;
                }
                if (n != 2) continue;
                object3 = Attribute.getSingleStringValueOrNull(attributeList, (AttributeTag)object5);
                if (object3 != null) {
                    object2 = null;
                    if (mapOfOriginalToReplacementUIDs == null) {
                        mapOfOriginalToReplacementUIDs = new HashMap();
                    }
                    if ((object2 = (String)mapOfOriginalToReplacementUIDs.get(object3)) == null) {
                        if (uidGenerator == null) {
                            uidGenerator = new UIDGenerator();
                        }
                        object2 = uidGenerator.getAnotherNewUID();
                        mapOfOriginalToReplacementUIDs.put(object3, object2);
                    }
                    assert (object2 != null);
                    attributeList.remove((AttributeTag)object5);
                    object = new UniqueIdentifierAttribute((AttributeTag)object5);
                    ((Attribute)object).addValue((String)object2);
                    attributeList.put((AttributeTag)object5, (Attribute)object);
                    continue;
                }
                attributeList.remove((AttributeTag)object5);
            }
        }
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, boolean bl, boolean bl2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, bl, bl2, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, bl ? 0 : 1, bl2, bl3);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, false, bl2, false, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributesRecursively(attributeList, n, bl, bl2, bl3, bl4, bl5);
        if (n != 0) {
            ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, n);
        }
        AttributeTag attributeTag = TagFromName.PatientIdentityRemoved;
        attributeList.remove(attributeTag);
        Attribute attribute = new CodeStringAttribute(attributeTag);
        attribute.addValue("YES");
        attributeList.put(attributeTag, attribute);
        attributeTag = TagFromName.DeidentificationMethod;
        attribute = attributeList.get(attributeTag);
        if (attribute == null) {
            attribute = new LongStringAttribute(attributeTag);
            attributeList.put(attributeTag, attribute);
        }
        attribute.addValue("Deidentified");
        attribute.addValue("Descriptors " + (bl ? "retained" : (bl2 ? "removed except series" : "removed")));
        attribute.addValue("Patient Characteristics " + (bl3 ? "retained" : "removed"));
        attribute.addValue("Device identity " + (bl4 ? "retained" : "removed"));
        attribute.addValue("Institution identity " + (bl5 ? "retained" : "removed"));
        if (n != 0) {
            attribute.addValue("UIDs " + (n == 2 ? "remapped" : "removed"));
        }
        if ((attribute = (SequenceAttribute)attributeList.get(attributeTag = TagFromName.DeidentificationMethodCodeSequence)) == null) {
            attribute = new SequenceAttribute(attributeTag);
            attributeList.put(attributeTag, attribute);
        }
        ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113100", "DCM", "Basic Application Confidentiality Profile").getAttributeList());
        if (bl) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210005", "99PMP", "Retain all descriptors unchanged").getAttributeList());
        } else if (bl2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210003", "99PMP", "Remove all descriptors except Series Description").getAttributeList());
        } else {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210004", "99PMP", "Remove all descriptors including Series Description").getAttributeList());
        }
        if (bl3) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113108", "DCM", "Retain Patient Characteristics Option").getAttributeList());
        }
        if (bl4) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113109", "DCM", "Retain Device Identity Option").getAttributeList());
        }
        if (bl5) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210006", "99PMP", "Retain institution identity").getAttributeList());
        }
        if (n == 0) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113110", "DCM", "Retain UIDs Option").getAttributeList());
        } else if (n == 2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
        } else if (n == 1) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210007", "99PMP", "Remove UIDs").getAttributeList());
        }
    }

    protected static void removeOrNullIdentifyingAttributesRecursively(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DicomException {
        if (!bl) {
            attributeList.remove(TagFromName.StudyDescription);
            if (!bl2) {
                attributeList.remove(TagFromName.SeriesDescription);
            }
        }
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.AccessionNumber);
        if (!bl5) {
            attributeList.remove(TagFromName.InstitutionName);
            attributeList.remove(TagFromName.InstitutionAddress);
            attributeList.remove(TagFromName.InstitutionalDepartmentName);
        }
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.ReferringPhysicianName);
        attributeList.remove(TagFromName.ReferringPhysicianAddress);
        attributeList.remove(TagFromName.ReferringPhysicianTelephoneNumbers);
        attributeList.remove(TagFromName.PhysiciansOfRecord);
        attributeList.remove(TagFromName.PerformingPhysicianName);
        attributeList.remove(TagFromName.NameOfPhysiciansReadingStudy);
        attributeList.remove(TagFromName.RequestingPhysician);
        attributeList.remove(TagFromName.OperatorsName);
        attributeList.remove(TagFromName.AdmittingDiagnosesDescription);
        attributeList.remove(TagFromName.DerivationDescription);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientName);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientID);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientBirthDate);
        attributeList.remove(TagFromName.PatientBirthTime);
        attributeList.remove(TagFromName.OtherPatientIDs);
        attributeList.remove(TagFromName.OtherPatientNames);
        if (!bl3) {
            attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientSex);
            attributeList.remove(TagFromName.PatientAge);
            attributeList.remove(TagFromName.PatientSize);
            attributeList.remove(TagFromName.PatientWeight);
            attributeList.remove(TagFromName.EthnicGroup);
            attributeList.remove(TagFromName.PregnancyStatus);
            attributeList.remove(TagFromName.SmokingStatus);
            attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientSexNeutered);
            attributeList.remove(TagFromName.SpecialNeeds);
        }
        attributeList.remove(TagFromName.MedicalRecordLocator);
        attributeList.remove(TagFromName.Occupation);
        attributeList.remove(TagFromName.AdditionalPatientHistory);
        attributeList.remove(TagFromName.PatientComments);
        if (!bl4) {
            attributeList.remove(TagFromName.StationName);
            attributeList.remove(TagFromName.DeviceSerialNumber);
            attributeList.remove(TagFromName.DeviceUID);
            attributeList.remove(TagFromName.PlateID);
            attributeList.remove(TagFromName.GantryID);
            attributeList.remove(TagFromName.CassetteID);
            attributeList.remove(TagFromName.GeneratorID);
            attributeList.remove(TagFromName.DetectorID);
            attributeList.remove(TagFromName.PerformedStationAETitle);
            attributeList.remove(TagFromName.PerformedStationGeographicLocationCodeSequence);
            attributeList.remove(TagFromName.PerformedStationName);
            attributeList.remove(TagFromName.PerformedStationNameCodeSequence);
            attributeList.remove(TagFromName.ScheduledProcedureStepLocation);
            attributeList.remove(TagFromName.ScheduledStationAETitle);
            attributeList.remove(TagFromName.ScheduledStationGeographicLocationCodeSequence);
            attributeList.remove(TagFromName.ScheduledStationName);
            attributeList.remove(TagFromName.ScheduledStationNameCodeSequence);
            attributeList.remove(TagFromName.ScheduledStudyLocation);
            attributeList.remove(TagFromName.ScheduledStudyLocationAETitle);
        }
        attributeList.remove(TagFromName.ProtocolName);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.StudyID);
        attributeList.remove(TagFromName.RequestAttributesSequence);
        attributeList.remove(TagFromName.IssuerOfAccessionNumberSequence);
        attributeList.remove(TagFromName.IssuerOfPatientID);
        attributeList.remove(TagFromName.IssuerOfPatientIDQualifiersSequence);
        attributeList.remove(TagFromName.StudyIDIssuer);
        attributeList.remove(TagFromName.IssuerOfAdmissionID);
        attributeList.remove(TagFromName.IssuerOfAdmissionIDSequence);
        attributeList.remove(TagFromName.IssuerOfServiceEpisodeID);
        attributeList.remove(TagFromName.IssuerOfServiceEpisodeIDSequence);
        attributeList.remove(TagFromName.ResultsIDIssuer);
        attributeList.remove(TagFromName.InterpretationIDIssuer);
        attributeList.remove(TagFromName.StudyStatusID);
        attributeList.remove(TagFromName.StudyPriorityID);
        attributeList.remove(TagFromName.CurrentPatientLocation);
        attributeList.remove(TagFromName.PatientAddress);
        attributeList.remove(TagFromName.MilitaryRank);
        attributeList.remove(TagFromName.BranchOfService);
        attributeList.remove(TagFromName.PatientBirthName);
        attributeList.remove(TagFromName.PatientMotherBirthName);
        attributeList.remove(TagFromName.ConfidentialityConstraintOnPatientDataDescription);
        attributeList.remove(TagFromName.PatientInsurancePlanCodeSequence);
        attributeList.remove(TagFromName.PatientPrimaryLanguageCodeSequence);
        attributeList.remove(TagFromName.CountryOfResidence);
        attributeList.remove(TagFromName.RegionOfResidence);
        attributeList.remove(TagFromName.PatientTelephoneNumbers);
        attributeList.remove(TagFromName.PatientReligiousPreference);
        attributeList.remove(TagFromName.MedicalAlerts);
        attributeList.remove(TagFromName.Allergies);
        attributeList.remove(TagFromName.LastMenstrualDate);
        attributeList.remove(TagFromName.SpecialNeeds);
        attributeList.remove(TagFromName.PatientState);
        attributeList.remove(TagFromName.AdmissionID);
        attributeList.remove(TagFromName.AdmittingDate);
        attributeList.remove(TagFromName.AdmittingTime);
        if (!bl) {
            attributeList.remove(TagFromName.ImageComments);
        }
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.ContentCreatorName);
        attributeList.remove(TagFromName.ContentCreatorIdentificationCodeSequence);
        attributeList.remove(TagFromName.ReferencedPatientSequence);
        attributeList.remove(TagFromName.ReferringPhysicianIdentificationSequence);
        attributeList.remove(TagFromName.PhysiciansOfRecordIdentificationSequence);
        attributeList.remove(TagFromName.PhysiciansReadingStudyIdentificationSequence);
        attributeList.remove(TagFromName.ReferencedStudySequence);
        attributeList.remove(TagFromName.AdmittingDiagnosesCodeSequence);
        attributeList.remove(TagFromName.PerformingPhysicianIdentificationSequence);
        attributeList.remove(TagFromName.OperatorIdentificationSequence);
        attributeList.remove(TagFromName.PerformedProcedureStepID);
        attributeList.remove(TagFromName.DataSetTrailingPadding);
        attributeList.remove(TagFromName.ActualHumanPerformersSequence);
        attributeList.remove(TagFromName.Arbitrary);
        attributeList.remove(TagFromName.AuthorObserverSequence);
        attributeList.remove(TagFromName.ContributionDescription);
        attributeList.remove(TagFromName.CustodialOrganizationSequence);
        attributeList.remove(TagFromName.DistributionAddress);
        attributeList.remove(TagFromName.DistributionName);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.FillerOrderNumberImagingServiceRequest);
        attributeList.remove(TagFromName.HumanPerformerName);
        attributeList.remove(TagFromName.HumanPerformerOrganization);
        attributeList.remove(TagFromName.IconImageSequence);
        attributeList.remove(TagFromName.IdentifyingComments);
        attributeList.remove(TagFromName.InsurancePlanIdentification);
        attributeList.remove(TagFromName.IntendedRecipientsOfResultsIdentificationSequence);
        attributeList.remove(TagFromName.InterpretationApproverSequence);
        attributeList.remove(TagFromName.InterpretationAuthor);
        attributeList.remove(TagFromName.InterpretationIDIssuer);
        attributeList.remove(TagFromName.InterpretationRecorder);
        attributeList.remove(TagFromName.InterpretationTranscriber);
        attributeList.remove(TagFromName.IssuerOfAdmissionID);
        attributeList.remove(TagFromName.IssuerOfServiceEpisodeID);
        attributeList.remove(TagFromName.ModifyingDeviceID);
        attributeList.remove(TagFromName.ModifyingDeviceManufacturer);
        attributeList.remove(TagFromName.NamesOfIntendedRecipientsOfResults);
        attributeList.remove(TagFromName.OrderCallbackPhoneNumber);
        attributeList.remove(TagFromName.OrderEnteredBy);
        attributeList.remove(TagFromName.OrderEntererLocation);
        attributeList.remove(TagFromName.ParticipantSequence);
        attributeList.remove(TagFromName.PerformedLocation);
        attributeList.remove(TagFromName.PersonAddress);
        attributeList.remove(TagFromName.PersonIdentificationCodeSequence);
        attributeList.remove(TagFromName.PersonName);
        attributeList.remove(TagFromName.PersonTelephoneNumbers);
        attributeList.remove(TagFromName.PhysicianApprovingInterpretation);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PlacerOrderNumberImagingServiceRequest);
        attributeList.remove(TagFromName.PreMedication);
        attributeList.remove(TagFromName.ReferencedPatientAliasSequence);
        attributeList.remove(TagFromName.RequestedProcedureLocation);
        attributeList.remove(TagFromName.RequestedProcedureID);
        attributeList.remove(TagFromName.RequestingService);
        attributeList.remove(TagFromName.ResponsibleOrganization);
        attributeList.remove(TagFromName.ResponsiblePerson);
        attributeList.remove(TagFromName.ResultsDistributionListSequence);
        attributeList.remove(TagFromName.ResultsIDIssuer);
        attributeList.remove(TagFromName.ScheduledHumanPerformersSequence);
        attributeList.remove(TagFromName.ScheduledPatientInstitutionResidence);
        attributeList.remove(TagFromName.ScheduledPerformingPhysicianIdentificationSequence);
        attributeList.remove(TagFromName.ScheduledPerformingPhysicianName);
        attributeList.remove(TagFromName.ServiceEpisodeID);
        attributeList.remove(TagFromName.StudyIDIssuer);
        attributeList.remove(TagFromName.TextComments);
        attributeList.remove(TagFromName.TextString);
        attributeList.remove(TagFromName.TopicAuthor);
        attributeList.remove(TagFromName.TopicKeywords);
        attributeList.remove(TagFromName.TopicSubject);
        attributeList.remove(TagFromName.TopicTitle);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.VerifyingObserverIdentificationCodeSequence);
        attributeList.replaceWithDummyValueIfPresent(TagFromName.VerifyingObserverName, "Observer^Deidentified");
        attributeList.remove(TagFromName.VerifyingOrganization);
        if (!bl) {
            attributeList.remove(TagFromName.PerformedProcedureStepDescription);
            attributeList.remove(TagFromName.CommentsOnThePerformedProcedureStep);
            attributeList.remove(TagFromName.AcquisitionComments);
            attributeList.remove(TagFromName.ReasonForStudy);
            attributeList.remove(TagFromName.RequestedProcedureDescription);
            attributeList.remove(TagFromName.StudyComments);
            attributeList.replaceWithZeroLengthIfPresent(TagFromName.AcquisitionDeviceProcessingDescription);
            attributeList.remove(TagFromName.DischargeDiagnosisDescription);
            attributeList.remove(TagFromName.ImagePresentationComments);
            attributeList.remove(TagFromName.ImagingServiceRequestComments);
            attributeList.remove(TagFromName.Impressions);
            attributeList.remove(TagFromName.InterpretationDiagnosisDescription);
            attributeList.remove(TagFromName.InterpretationText);
            attributeList.remove(TagFromName.OverlayComments);
            attributeList.remove(TagFromName.ReasonForTheImagingServiceRequest);
            attributeList.remove(TagFromName.RequestedContrastAgent);
            attributeList.remove(TagFromName.RequestedProcedureComments);
            attributeList.remove(TagFromName.ResultsComments);
            attributeList.remove(TagFromName.ScheduledProcedureStepDescription);
            attributeList.remove(TagFromName.ServiceEpisodeDescription);
            attributeList.remove(TagFromName.VisitComments);
        }
        if (n == 1) {
            attributeList.remove(TagFromName.ReferencedImageSequence);
            attributeList.remove(TagFromName.SourceImageSequence);
            attributeList.remove(TagFromName.ReferencedPerformedProcedureStepSequence);
        }
        for (Object v : attributeList.values()) {
            Iterator iterator;
            SequenceAttribute sequenceAttribute;
            if (!(v instanceof SequenceAttribute) || (sequenceAttribute = (SequenceAttribute)v).getTag().equals(TagFromName.ContentSequence) || (iterator = sequenceAttribute.iterator()) == null) continue;
            while (iterator.hasNext()) {
                AttributeList attributeList2;
                SequenceItem sequenceItem = (SequenceItem)iterator.next();
                if (sequenceItem == null || (attributeList2 = sequenceItem.getAttributeList()) == null) continue;
                ClinicalTrialsAttributes.removeOrNullIdentifyingAttributesRecursively(attributeList2, n, bl, bl2, bl3, bl4, bl5);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.println("do it buffered, looking for metaheader, no uid specified");
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0]);
            System.err.println("As read ...");
            System.err.print(attributeList.toString());
            attributeList.removeUnsafePrivateAttributes();
            System.err.println("After remove unsafe private ...");
            System.err.print(attributeList.toString());
            attributeList.removePrivateAttributes();
            System.err.println("After remove private ...");
            System.err.print(attributeList.toString());
            attributeList.removeGroupLengthAttributes();
            System.err.println("After remove group lengths ...");
            System.err.print(attributeList.toString());
            attributeList.removeMetaInformationHeaderAttributes();
            System.err.println("After remove meta information header ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, true);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and device identity and institution identity and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, false);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and device identity and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, false, false);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, true, true, false, false);
            System.err.println("After deidentify, keeping patient characteristics and series description and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, true, false, false);
            System.err.println("After deidentify, keeping patient characteristics and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, false, false, false);
            System.err.println("After deidentify, keeping only UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false);
            System.err.println("After deidentify, remapping UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 1, false, false, false, false, false);
            System.err.println("After deidentify, removing everything ...");
            System.err.print(attributeList.toString());
            String[] stringArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID);
            CodedSequenceItem[] codedSequenceItemArray = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber);
            CodedSequenceItem[] codedSequenceItemArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber);
            String[] stringArray3 = new UIDGenerator();
            PersonIdentification[] personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewSOPInstanceUID((String)stringArray2, (String)codedSequenceItemArray, (String)codedSequenceItemArray2));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewSeriesInstanceUID((String)stringArray2, (String)codedSequenceItemArray));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewStudyInstanceUID((String)stringArray2));
            attributeList.put((Attribute)personIdentificationArray);
            ClinicalTrialsAttributes.addClinicalTrialsAttributes(attributeList, true, "ourSponsorName", "ourProtocolID", "ourProtocolName", "ourSiteID", "ourSiteName", "ourSubjectID", "ourSubjectReadingID", "ourTimePointID", "ourTimePointDescription", "ourCoordinatingCenterName");
            System.err.println("After addClinicalTrialsAttributes ...");
            System.err.print(attributeList.toString());
            stringArray2 = new String[]{"smithj", "doej"};
            codedSequenceItemArray = new CodedSequenceItem[]{new CodedSequenceItem("634872364", "99MYH", "Smith^John")};
            codedSequenceItemArray2 = new CodedSequenceItem[]{new CodedSequenceItem("346234622", "99MYH", "Doe^Jane")};
            stringArray3 = new String[]{"555-1212"};
            personIdentificationArray = new PersonIdentification[]{new PersonIdentification(codedSequenceItemArray, "John address", stringArray3, null, "My hospital address", new CodedSequenceItem("47327864", "99MYH", "My Hospital")), new PersonIdentification(codedSequenceItemArray2, "Jane address", stringArray3, "My hospital", "My hospital address", null)};
            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.dicom.ClinicalTrialsAttributes.main()", null, "Vers. 20080429", "Deidentified", DateTimeAttribute.getFormattedString(new Date()), stringArray2, personIdentificationArray);
            System.err.println("After addContributingEquipmentSequence ...");
            System.err.print(attributeList.toString());
            attributeList.remove(TagFromName.DataSetTrailingPadding);
            attributeList.correctDecompressedImagePixelModule();
            FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
            attributeList.write(stringArray[1], "1.2.840.10008.1.2.1", true, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public class HandleUIDs {
        public static final int keep = 0;
        public static final int remove = 1;
        public static final int remap = 2;
    }
}

