/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodingSchemeIdentificationItem;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodingSchemeIdentification {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodingSchemeIdentification.java,v 1.1 2010/11/28 18:10:16 dclunie Exp $";
    protected List<CodingSchemeIdentificationItem> listOfItems;
    public static final String REGISTRY_HL7 = "HL7";
    public static final CodingSchemeIdentificationItem SRT = new CodingSchemeIdentificationItem("SRT", "HL7", "2.16.840.1.113883.6.96", "SNOMED-CT using SNOMED-RT style values");
    public static final CodingSchemeIdentificationItem I10P = new CodingSchemeIdentificationItem("I10P", "HL7", "2.16.840.1.113883.6.4", "ICD-10 Procedure Coding System");
    protected static CodingSchemeIdentificationItem[] knownCodingSchemes = new CodingSchemeIdentificationItem[]{I10P, SRT};

    protected static CodingSchemeIdentificationItem lookupByCodingSchemeDesignator(String string) {
        CodingSchemeIdentificationItem codingSchemeIdentificationItem = null;
        if (string != null && string.length() > 0) {
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem2 : knownCodingSchemes) {
                if (!codingSchemeIdentificationItem2.getCodingSchemeDesignator().equals(string)) continue;
                codingSchemeIdentificationItem = codingSchemeIdentificationItem2;
                break;
            }
        }
        return codingSchemeIdentificationItem;
    }

    public CodingSchemeIdentification(AttributeList attributeList) {
        SequenceAttribute sequenceAttribute;
        int n;
        Attribute attribute;
        if (attributeList != null && (attribute = attributeList.get(TagFromName.CodingSchemeIdentificationSequence)) != null && attribute instanceof SequenceAttribute && (n = (sequenceAttribute = (SequenceAttribute)attribute).getNumberOfItems()) > 0) {
            this.listOfItems = new ArrayList<CodingSchemeIdentificationItem>();
            for (int i = 0; i < n; ++i) {
                SequenceItem sequenceItem = sequenceAttribute.getItem(i);
                CodingSchemeIdentificationItem codingSchemeIdentificationItem = new CodingSchemeIdentificationItem(sequenceItem);
                this.listOfItems.add(codingSchemeIdentificationItem);
            }
        }
    }

    public CodingSchemeIdentification(List<CodingSchemeIdentificationItem> list) {
        this.listOfItems = list;
    }

    public SequenceAttribute getAsSequenceAttribute() {
        SequenceAttribute sequenceAttribute = null;
        if (this.listOfItems != null) {
            sequenceAttribute = new SequenceAttribute(TagFromName.CodingSchemeIdentificationSequence);
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem : this.listOfItems) {
                SequenceItem sequenceItem = codingSchemeIdentificationItem.getAsSequenceItem();
                sequenceAttribute.addItem(sequenceItem);
            }
        }
        return sequenceAttribute;
    }

    public CodingSchemeIdentificationItem getByCodingSchemeDesignator(String string) {
        CodingSchemeIdentificationItem codingSchemeIdentificationItem = null;
        if (this.listOfItems != null && string != null && string.length() > 0) {
            for (CodingSchemeIdentificationItem codingSchemeIdentificationItem2 : this.listOfItems) {
                if (!codingSchemeIdentificationItem2.getCodingSchemeDesignator().equals(string)) continue;
                codingSchemeIdentificationItem = codingSchemeIdentificationItem2;
            }
        }
        return codingSchemeIdentificationItem;
    }

    protected static void recursivelyCollectCodingSchemeDesignators(AttributeList attributeList, Set<String> set) {
        for (Object v : attributeList.values()) {
            Object object;
            Object object2;
            Attribute attribute;
            if (v instanceof SequenceAttribute) {
                attribute = (SequenceAttribute)v;
                object2 = ((SequenceAttribute)attribute).iterator();
                if (object2 == null) continue;
                while (object2.hasNext()) {
                    AttributeList attributeList2;
                    object = (SequenceItem)object2.next();
                    if (object == null || (attributeList2 = ((SequenceItem)object).getAttributeList()) == null) continue;
                    CodingSchemeIdentification.recursivelyCollectCodingSchemeDesignators(attributeList2, set);
                }
                continue;
            }
            attribute = (Attribute)v;
            object2 = attribute.getTag();
            if (!((AttributeTag)object2).equals(TagFromName.CodingSchemeDesignator) || ((String)(object = attribute.getSingleStringValueOrEmptyString())).length() <= 0) continue;
            set.add((String)object);
        }
    }

    public static CodingSchemeIdentification getCodingSchemesFromExistingAttributeList(AttributeList attributeList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        CodingSchemeIdentification.recursivelyCollectCodingSchemeDesignators(attributeList, treeSet);
        ArrayList<CodingSchemeIdentificationItem> arrayList = null;
        for (String string : treeSet) {
            CodingSchemeIdentificationItem codingSchemeIdentificationItem = CodingSchemeIdentification.lookupByCodingSchemeDesignator(string);
            if (codingSchemeIdentificationItem == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<CodingSchemeIdentificationItem>();
            }
            arrayList.add(codingSchemeIdentificationItem);
        }
        return new CodingSchemeIdentification(arrayList);
    }
}

