/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;

public class CodingSchemeIdentificationItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodingSchemeIdentificationItem.java,v 1.1 2010/11/28 18:10:16 dclunie Exp $";
    protected String codingSchemeDesignator;
    protected String codingSchemeRegistry;
    protected String codingSchemeUID;
    protected String codingSchemeName;

    public CodingSchemeIdentificationItem(String string, String string2, String string3, String string4) {
        this.codingSchemeDesignator = string;
        this.codingSchemeRegistry = string2;
        this.codingSchemeUID = string3;
        this.codingSchemeName = string4;
    }

    public CodingSchemeIdentificationItem(SequenceItem sequenceItem) {
        if (sequenceItem != null) {
            AttributeList attributeList = sequenceItem.getAttributeList();
            this.codingSchemeDesignator = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodingSchemeDesignator);
            this.codingSchemeRegistry = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodingSchemeRegistry);
            this.codingSchemeUID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodingSchemeUID);
            this.codingSchemeName = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodingSchemeName);
        }
    }

    public String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public String getCodingSchemeRegistry() {
        return this.codingSchemeRegistry;
    }

    public String getCodingSchemeUID() {
        return this.codingSchemeUID;
    }

    public String getCodingSchemeName() {
        return this.codingSchemeName;
    }

    public SequenceItem getAsSequenceItem() {
        Object object;
        AttributeList attributeList = new AttributeList();
        try {
            object = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
            ((Attribute)object).addValue(this.codingSchemeDesignator);
            attributeList.put((Attribute)object);
            object = new LongStringAttribute(TagFromName.CodingSchemeRegistry);
            ((Attribute)object).addValue(this.codingSchemeRegistry);
            attributeList.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.CodingSchemeUID);
            ((Attribute)object).addValue(this.codingSchemeUID);
            attributeList.put((Attribute)object);
            object = new ShortTextAttribute(TagFromName.CodingSchemeName);
            ((Attribute)object).addValue(this.codingSchemeName);
            attributeList.put((Attribute)object);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        object = new SequenceItem(attributeList);
        return object;
    }
}

