/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ColorPaletteHotIron;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.utils.ByteArray;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ColorPalette {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ColorPalette.java,v 1.4 2010/01/31 11:59:04 dclunie Exp $";
    protected String sopInstanceUID = null;
    protected String contentLabel = null;
    protected String contentDescription = null;
    protected String contentCreatorName = null;
    protected String referenceEncodedInstanceURL = null;
    protected String[] alternateContentDescription = null;
    protected String[] alternateContentLanguageCodeValue = null;
    protected String[] alternateContentLanguageCodeMeaning = null;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected byte[] iccProfile;
    protected AttributeList list = null;

    protected ColorPalette() {
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getContentLabel() {
        return this.contentLabel;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public String getReferenceEncodedInstanceURL() {
        return this.referenceEncodedInstanceURL;
    }

    public byte[] getICCProfile() {
        return this.iccProfile;
    }

    public void setICCProfileFromFile(String string) throws IOException {
        this.iccProfile = ByteArray.readFully(string);
    }

    public AttributeList getAttributeList() throws DicomException {
        if (this.list == null && this.red != null && this.green != null && this.blue != null) {
            this.list = new AttributeList();
            Object object = new UnsignedShortAttribute(TagFromName.RedPaletteColorLookupTableDescriptor);
            ((Attribute)object).addValue(this.red.length);
            ((Attribute)object).addValue(0);
            ((Attribute)object).addValue(8);
            this.list.put((Attribute)object);
            object = new UnsignedShortAttribute(TagFromName.GreenPaletteColorLookupTableDescriptor);
            ((Attribute)object).addValue(this.green.length);
            ((Attribute)object).addValue(0);
            ((Attribute)object).addValue(8);
            this.list.put((Attribute)object);
            object = new UnsignedShortAttribute(TagFromName.BluePaletteColorLookupTableDescriptor);
            ((Attribute)object).addValue(this.blue.length);
            ((Attribute)object).addValue(0);
            ((Attribute)object).addValue(8);
            this.list.put((Attribute)object);
            object = new OtherWordAttribute(TagFromName.RedPaletteColorLookupTableData);
            ((Attribute)object).setValues(ArrayCopyUtilities.packByteArrayIntoShortArrayLittleEndian(this.red));
            this.list.put((Attribute)object);
            object = new OtherWordAttribute(TagFromName.GreenPaletteColorLookupTableData);
            ((Attribute)object).setValues(ArrayCopyUtilities.packByteArrayIntoShortArrayLittleEndian(this.green));
            this.list.put((Attribute)object);
            object = new OtherWordAttribute(TagFromName.BluePaletteColorLookupTableData);
            ((Attribute)object).setValues(ArrayCopyUtilities.packByteArrayIntoShortArrayLittleEndian(this.blue));
            this.list.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
            ((Attribute)object).addValue("1.2.840.10008.5.1.4.39.1");
            this.list.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)object).addValue(this.sopInstanceUID);
            this.list.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.PaletteColorLookupTableUID);
            ((Attribute)object).addValue(this.sopInstanceUID);
            this.list.put((Attribute)object);
            object = new CodeStringAttribute(TagFromName.ContentLabel);
            ((Attribute)object).addValue(this.contentLabel);
            this.list.put((Attribute)object);
            object = new LongStringAttribute(TagFromName.ContentDescription);
            ((Attribute)object).addValue(this.contentDescription);
            this.list.put((Attribute)object);
            object = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)object).addValue("1");
            this.list.put((Attribute)object);
            object = new PersonNameAttribute(TagFromName.ContentCreatorName);
            ((Attribute)object).addValue(this.contentCreatorName);
            this.list.put((Attribute)object);
            object = new Date();
            StringAttribute stringAttribute = new DateAttribute(TagFromName.InstanceCreationDate);
            ((Attribute)stringAttribute).addValue(new SimpleDateFormat("yyyyMMdd").format((Date)object));
            this.list.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.InstanceCreationTime);
            ((Attribute)stringAttribute).addValue(new SimpleDateFormat("HHmmss.SSS").format((Date)object));
            this.list.put(stringAttribute);
            if (this.iccProfile != null && this.iccProfile.length > 0) {
                object = new OtherByteAttribute(TagFromName.ICCProfile);
                ((Attribute)object).setValues(this.iccProfile);
                this.list.put((Attribute)object);
            }
            if (this.alternateContentDescription != null && this.alternateContentLanguageCodeValue != null && this.alternateContentLanguageCodeMeaning != null) {
                object = null;
                for (int i = 0; i < this.alternateContentDescription.length && i < this.alternateContentLanguageCodeValue.length && i < this.alternateContentLanguageCodeMeaning.length; ++i) {
                    if (object == null) {
                        object = new SequenceAttribute(TagFromName.AlternateContentDescriptionSequence);
                        this.list.put((Attribute)object);
                    }
                    AttributeList attributeList = new AttributeList();
                    Attribute attribute = new LongStringAttribute(TagFromName.ContentDescription);
                    attribute.addValue(this.alternateContentDescription[i]);
                    attributeList.put(attribute);
                    attribute = new SequenceAttribute(TagFromName.LanguageCodeSequence);
                    CodedSequenceItem codedSequenceItem = new CodedSequenceItem(this.alternateContentLanguageCodeValue[i], "RFC3066", this.alternateContentLanguageCodeMeaning[i]);
                    ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
                    attributeList.put(attribute);
                    ((SequenceAttribute)object).addItem(attributeList);
                }
            }
            this.list.insertSuitableSpecificCharacterSetForAllStringValues();
        }
        return this.list;
    }

    protected void createDICOMInstance(String string, String string2, String string3) throws IOException, DicomException {
        if (string2 != null) {
            this.setICCProfileFromFile(string2);
        }
        AttributeList attributeList = this.getAttributeList();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", string3);
        attributeList.write(string, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            new ColorPaletteHotIron().createDICOMInstance(stringArray[0], stringArray.length > 1 ? stringArray[1] : null, "OURAETITLE");
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

