/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.text.NumberFormat;

public class DecimalStringAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DecimalStringAttribute.java,v 1.11 2009/02/22 16:35:03 dclunie Exp $";

    public DecimalStringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public DecimalStringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public DecimalStringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public byte[] getVR() {
        return ValueRepresentation.DS;
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        if (numberFormat == null) {
            stringArray = super.getStringValues(null);
        } else {
            double[] dArray = this.getDoubleValues();
            if (dArray != null) {
                stringArray = new String[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    stringArray[i] = numberFormat.format(dArray[i]);
                }
            }
        }
        return stringArray;
    }

    public void addValue(long l) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(l, 16, false));
    }

    public void addValue(float f) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(f, 16, false));
    }

    public void addValue(double d) throws DicomException {
        this.addValue(FloatFormatter.toStringOfFixedMaximumLength(d, 16, false));
    }
}

