/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.FloatFormatter;
import java.io.IOException;
import java.text.NumberFormat;

public class FloatSingleAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FloatSingleAttribute.java,v 1.19 2008/08/14 18:54:03 dclunie Exp $";
    float[] values;
    static int bytesPerValue = 4;

    private void flushCachedCopies() {
    }

    public FloatSingleAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.flushCachedCopies();
        this.values = null;
    }

    public FloatSingleAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public FloatSingleAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.flushCachedCopies();
        if (l % (long)bytesPerValue != 0L) {
            dicomInputStream.skipInsistently(l);
            throw new DicomException("incorrect value length (" + l + " dec) for VR " + this.getVRAsString() + " - skipping value length bytes to get to next data element");
        }
        int n = (int)(l / (long)bytesPerValue);
        this.values = null;
        for (int i = 0; i < n; ++i) {
            this.addValue(dicomInputStream.readFloat());
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        float[] fArray = this.getFloatValues();
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                dicomOutputStream.writeFloat(fArray[i]);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            float[] fArray = this.getFloatValues();
            if (fArray != null) {
                for (int i = 0; i < fArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(fArray[i]);
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        float[] fArray = this.getFloatValues();
        if (fArray != null) {
            stringArray = new String[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                stringArray[i] = numberFormat == null ? FloatFormatter.toString(fArray[i]) : numberFormat.format(fArray[i]);
            }
        }
        return stringArray;
    }

    public float[] getFloatValues() throws DicomException {
        return this.values;
    }

    public void addValue(float f) throws DicomException {
        this.flushCachedCopies();
        this.values = ArrayCopyUtilities.expandArray(this.values);
        this.values[this.valueMultiplicity++] = f;
        this.valueLength += 4L;
    }

    public void addValue(double d) throws DicomException {
        this.addValue((float)d);
    }

    public void addValue(short s) throws DicomException {
        this.addValue((float)s);
    }

    public void addValue(int n) throws DicomException {
        this.addValue((float)n);
    }

    public void addValue(long l) throws DicomException {
        this.addValue((float)l);
    }

    public void addValue(String string) throws DicomException {
        float f = 0.0f;
        try {
            f = (float)Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException(numberFormatException.toString());
        }
        this.addValue(f);
    }

    public void removeValues() {
        this.flushCachedCopies();
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.FL;
    }
}

