/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalSOPInstanceReference {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/HierarchicalSOPInstanceReference.java,v 1.1 2010/08/29 08:25:47 dclunie Exp $";
    protected String studyInstanceUID;
    protected String seriesInstanceUID;
    protected String sopInstanceUID;
    protected String sopClassUID;

    public HierarchicalSOPInstanceReference(String string, String string2, String string3, String string4) {
        this.studyInstanceUID = string;
        this.seriesInstanceUID = string2;
        this.sopInstanceUID = string3;
        this.sopClassUID = string4;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public static Map<String, HierarchicalSOPInstanceReference> findHierarchicalReferencesForSOPInstances(AttributeList attributeList) {
        Attribute attribute;
        HashMap<String, HierarchicalSOPInstanceReference> hashMap = new HashMap<String, HierarchicalSOPInstanceReference>();
        if (attributeList != null && (attribute = attributeList.get(TagFromName.CurrentRequestedProcedureEvidenceSequence)) != null && attribute instanceof SequenceAttribute) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            Iterator iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = (SequenceItem)iterator.next();
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                if (attributeList2 == null) continue;
                String string = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.StudyInstanceUID);
                Attribute attribute2 = attributeList2.get(TagFromName.ReferencedSeriesSequence);
                if (string == null || string.length() <= 0 || attribute2 == null || !(attribute2 instanceof SequenceAttribute)) continue;
                SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attribute2;
                Iterator iterator2 = sequenceAttribute2.iterator();
                while (iterator2.hasNext()) {
                    SequenceItem sequenceItem2 = (SequenceItem)iterator2.next();
                    AttributeList attributeList3 = sequenceItem2.getAttributeList();
                    if (attributeList3 == null) continue;
                    String string2 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.SeriesInstanceUID);
                    Attribute attribute3 = attributeList3.get(TagFromName.ReferencedSOPSequence);
                    if (string2 == null || string2.length() <= 0 || attribute3 == null || !(attribute3 instanceof SequenceAttribute)) continue;
                    SequenceAttribute sequenceAttribute3 = (SequenceAttribute)attribute3;
                    Iterator iterator3 = sequenceAttribute3.iterator();
                    while (iterator3.hasNext()) {
                        SequenceItem sequenceItem3 = (SequenceItem)iterator3.next();
                        AttributeList attributeList4 = sequenceItem3.getAttributeList();
                        String string3 = Attribute.getSingleStringValueOrNull(attributeList4, TagFromName.ReferencedSOPClassUID);
                        String string4 = Attribute.getSingleStringValueOrNull(attributeList4, TagFromName.ReferencedSOPInstanceUID);
                        if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                        hashMap.put(string4, new HierarchicalSOPInstanceReference(string, string2, string4, string3));
                    }
                }
            }
        }
        return hashMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Study: ");
        stringBuffer.append(this.studyInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Series: ");
        stringBuffer.append(this.seriesInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Instance: ");
        stringBuffer.append(this.sopInstanceUID);
        stringBuffer.append(", ");
        stringBuffer.append("Class: ");
        stringBuffer.append(this.sopClassUID);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0]);
            Map<String, HierarchicalSOPInstanceReference> map = HierarchicalSOPInstanceReference.findHierarchicalReferencesForSOPInstances(attributeList);
            for (String string : map.keySet()) {
                HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = map.get(string);
                System.err.println(hierarchicalSOPInstanceReference);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

