/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.utils.XPathQuery;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ImageToDicom.java,v 1.13 2010/04/09 10:55:24 dclunie Exp $";

    private static String dumpTree(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = node.getNodeName();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(node2.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(node2.getNodeValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        String string2 = node.getNodeValue();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(ImageToDicom.dumpTree(node3, n + 1));
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }

    private static String dumpTree(Node node) {
        return ImageToDicom.dumpTree(node, 0);
    }

    protected static String getCompressionType(Node node) {
        String string = null;
        try {
            string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//CompressionTypeName", node, XPathConstants.NODE), "value");
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace(System.err);
        }
        return string;
    }

    protected static short getBitsPerSample(Node node) {
        short s = 0;
        try {
            String string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//BitsPerSample", node, XPathConstants.NODE), "value");
            if (string != null && string.length() > 0) {
                s = (short)Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace(System.err);
        }
        return s;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string, AttributeList attributeList) throws IOException, DicomException {
        return ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(new File(string), attributeList);
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(File file, AttributeList attributeList) throws IOException, DicomException {
        int unsignedShortAttribute;
        Object n10;
        int object3;
        int n3 = 0;
        BufferedImage bufferedImage = null;
        Node node = null;
        ImageReader imageReader = null;
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(fileImageInputStream);
        if (iterator.hasNext()) {
            String[] stringArray;
            imageReader = iterator.next();
            imageReader.setInput(fileImageInputStream);
            try {
                n3 = imageReader.getNumImages(true);
            }
            catch (Exception exception) {
                n3 = 1;
            }
            bufferedImage = imageReader.read(0);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            if (iIOMetadata != null && (stringArray = iIOMetadata.getMetadataFormatNames()) != null) {
                for (String object22 : stringArray) {
                    if (object22 == null) continue;
                    if (object22.equals("javax_imageio_1.0")) {
                        node = iIOMetadata.getAsTree(object22);
                        continue;
                    }
                    Node n7 = iIOMetadata.getAsTree(object22);
                }
            }
            try {
                imageReader.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (bufferedImage == null) {
            throw new DicomException("Unrecognized image file type");
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        String[] stringArray = bufferedImage.getSampleModel();
        int n6 = stringArray.getDataType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n = writableRaster.getNumBands();
        int[] nArray = null;
        nArray = stringArray.getPixels(0, 0, n4, n5, nArray, dataBuffer);
        short s = nArray.length;
        short s2 = (short)n5;
        short s3 = (short)n4;
        Attribute attribute = null;
        short s4 = 0;
        short s5 = 0;
        short s6 = 0;
        short s7 = (short)n;
        short s8 = 0;
        String string = n == 3 ? "RGB" : (n == 1 ? "MONOCHROME2" : "");
        short s9 = 0;
        if (dataBuffer instanceof DataBufferByte) {
            object3 = n4 * n5 * n * n3;
            n10 = new byte[object3];
            unsignedShortAttribute = 0;
            int n9 = 0;
            boolean bl = true;
            while (bl) {
                short s11 = 0;
                while (s11 < s) {
                    n10[unsignedShortAttribute++] = (byte)nArray[s11++];
                }
                if (++n9 < n3) {
                    bufferedImage = imageReader.read(n9);
                    nArray = null;
                    nArray = bufferedImage.getSampleModel().getPixels(0, 0, n4, n5, nArray, bufferedImage.getRaster().getDataBuffer());
                    continue;
                }
                bl = false;
            }
            attribute = new OtherByteAttribute(TagFromName.PixelData);
            attribute.setValues((byte[])n10);
            s4 = 8;
            s5 = 8;
            s6 = 7;
        } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
            String string2;
            short s10;
            object3 = n4 * n5 * n * n3;
            n10 = new short[object3];
            unsignedShortAttribute = 0;
            int n2 = 0;
            boolean bl = true;
            while (bl) {
                s10 = 0;
                while (s10 < s) {
                    n10[unsignedShortAttribute++] = (short)nArray[s10++];
                }
                if (++n2 < n3) {
                    bufferedImage = imageReader.read(n2);
                    nArray = null;
                    nArray = bufferedImage.getSampleModel().getPixels(0, 0, n4, n5, nArray, bufferedImage.getRaster().getDataBuffer());
                    continue;
                }
                bl = false;
            }
            attribute = new OtherWordAttribute(TagFromName.PixelData);
            attribute.setValues((short[])n10);
            s10 = ImageToDicom.getBitsPerSample(node);
            if (s10 == 0 && (string2 = ImageToDicom.getCompressionType(node)) != null && string2.equals("JPEG")) {
                s10 = 12;
            }
            s4 = (short)(((s10 - 1) / 8 + 1) * 8);
            s5 = s10;
            s6 = (short)(s10 - 1);
            s8 = (short)(dataBuffer instanceof DataBufferShort ? 1 : 0);
        } else {
            throw new DicomException("Unsupported pixel data form (" + n + " bands)");
        }
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if (attribute != null) {
            Object object;
            int unsignedShortAttribute2;
            attributeList.put(attribute);
            object3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, -1);
            if (object3 == -1) {
                n10 = new UnsignedShortAttribute(TagFromName.BitsStored);
                ((Attribute)n10).addValue(s5);
                attributeList.put((Attribute)n10);
            }
            if ((unsignedShortAttribute2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, -1)) == -1) {
                if (object3 != -1) {
                    s6 = (short)(object3 - 1);
                }
                UnsignedShortAttribute unsignedShortAttribute3 = new UnsignedShortAttribute(TagFromName.HighBit);
                ((Attribute)unsignedShortAttribute3).addValue(s6);
                attributeList.put(unsignedShortAttribute3);
            }
            if ((object3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, -1)) == -1) {
                UnsignedShortAttribute codeStringAttribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
                ((Attribute)codeStringAttribute).addValue(s8);
                attributeList.put(codeStringAttribute);
            }
            if ((object = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation)) == null) {
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList.put(codeStringAttribute);
            }
            attributeList.remove(TagFromName.BitsAllocated);
            object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
            ((Attribute)object).addValue(s4);
            attributeList.put((Attribute)object);
            attributeList.remove(TagFromName.Rows);
            object = new UnsignedShortAttribute(TagFromName.Rows);
            ((Attribute)object).addValue(s2);
            attributeList.put((Attribute)object);
            attributeList.remove(TagFromName.Columns);
            object = new UnsignedShortAttribute(TagFromName.Columns);
            ((Attribute)object).addValue(s3);
            attributeList.put((Attribute)object);
            attributeList.remove(TagFromName.NumberOfFrames);
            if (n3 > 1) {
                object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
                ((Attribute)object).addValue(n3);
                attributeList.put((Attribute)object);
            }
            attributeList.remove(TagFromName.SamplesPerPixel);
            object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
            ((Attribute)object).addValue(s7);
            attributeList.put((Attribute)object);
            attributeList.remove(TagFromName.PlanarConfiguration);
            if (s7 > 1) {
                object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                ((Attribute)object).addValue(s9);
                attributeList.put((Attribute)object);
            }
        }
        return attributeList;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string) throws IOException, DicomException {
        return ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(string, null);
    }

    public ImageToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException, DicomException {
        this(string, string2, string3, string4, string5, string6, string7, null, null);
    }

    public ImageToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException, DicomException {
        AttributeList attributeList = ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(string);
        UIDGenerator uIDGenerator = new UIDGenerator();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewSOPInstanceUID(string5, string6, string7));
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewSeriesInstanceUID(string5, string6));
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getNewStudyInstanceUID(string5));
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string3);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string4);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue("^^^^");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
        ((Attribute)object).addValue("YES");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("DERIVED");
        ((Attribute)object).addValue("SECONDARY");
        attributeList.put((Attribute)object);
        object = new Date();
        StringAttribute stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("yyyyMMdd").format((Date)object));
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)stringAttribute).addValue(new SimpleDateFormat("HHmmss.SSS").format((Date)object));
        attributeList.put(stringAttribute);
        object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList.put((Attribute)object);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        if (string9 == null) {
            string9 = "1.2.840.10008.5.1.4.1.1.7";
            if (n > 1) {
                if (n2 == 1) {
                    int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 1);
                    if (n3 == 8) {
                        string9 = "1.2.840.10008.5.1.4.1.1.7.2";
                    } else if (n3 == 16) {
                        string9 = "1.2.840.10008.5.1.4.1.1.7.3";
                    }
                } else if (n2 == 3) {
                    string9 = "1.2.840.10008.5.1.4.1.1.7.4";
                }
            }
        }
        if (n > 1) {
            Attribute attribute = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
            ((AttributeTagAttribute)attribute).addValue(TagFromName.PageNumberVector);
            attributeList.put(attribute);
            attribute = new IntegerStringAttribute(TagFromName.PageNumberVector);
            for (int i = 1; i <= n; ++i) {
                attribute.addValue(i);
            }
            attributeList.put(attribute);
        }
        if (SOPClass.isMultiframeSecondaryCaptureImageStorage(string9) && n2 == 1) {
            StringAttribute stringAttribute2 = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)stringAttribute2).addValue("IDENTITY");
            attributeList.put(stringAttribute2);
            stringAttribute2 = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)stringAttribute2).addValue("1");
            attributeList.put(stringAttribute2);
            stringAttribute2 = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)stringAttribute2).addValue("0");
            attributeList.put(stringAttribute2);
            stringAttribute2 = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)stringAttribute2).addValue("US");
            attributeList.put(stringAttribute2);
        }
        StringAttribute stringAttribute3 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)stringAttribute3).addValue(string9);
        attributeList.put(stringAttribute3);
        if (SOPClass.isSecondaryCaptureImageStorage(string9)) {
            stringAttribute3 = new CodeStringAttribute(TagFromName.ConversionType);
            ((Attribute)stringAttribute3).addValue("WSD");
            attributeList.put(stringAttribute3);
        }
        if (string8 == null) {
            string8 = "OT";
        }
        stringAttribute3 = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)stringAttribute3).addValue(string8);
        attributeList.put(stringAttribute3);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 7) {
                if (stringArray.length == 8) {
                    string = stringArray[7];
                } else if (stringArray.length == 9) {
                    string = stringArray[7];
                    string2 = stringArray[8];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: ImageToDicom inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new ImageToDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

