/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class InformationEntity
implements Comparable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/InformationEntity.java,v 1.10 2005/07/04 16:32:39 dclunie Exp $";
    private int value;
    public static InformationEntity PATIENT = new InformationEntity(2);
    public static InformationEntity STUDY = new InformationEntity(3);
    public static InformationEntity PROCEDURESTEP = new InformationEntity(4);
    public static InformationEntity SERIES = new InformationEntity(5);
    public static InformationEntity CONCATENATION = new InformationEntity(6);
    public static InformationEntity INSTANCE = new InformationEntity(7);
    public static InformationEntity FRAME = new InformationEntity(8);

    private InformationEntity(int n) {
        this.value = n;
    }

    public String toString() {
        if (this == PATIENT) {
            return "Patient";
        }
        if (this == STUDY) {
            return "Study";
        }
        if (this == PROCEDURESTEP) {
            return "ProcedureStep";
        }
        if (this == SERIES) {
            return "Series";
        }
        if (this == CONCATENATION) {
            return "Concatenation";
        }
        if (this == INSTANCE) {
            return "Instance";
        }
        if (this == FRAME) {
            return "Frame";
        }
        return null;
    }

    public static InformationEntity fromString(String string) {
        if (string != null) {
            String string2 = string.toUpperCase();
            if (string2.equals("PATIENT")) {
                return PATIENT;
            }
            if (string2.equals("STUDY")) {
                return STUDY;
            }
            if (string2.equals("PROCEDURESTEP")) {
                return PROCEDURESTEP;
            }
            if (string2.equals("SERIES")) {
                return SERIES;
            }
            if (string2.equals("CONCATENATION")) {
                return CONCATENATION;
            }
            if (string2.equals("INSTANCE")) {
                return INSTANCE;
            }
            if (string2.equals("FRAME")) {
                return FRAME;
            }
            return null;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public int compareTo(Object object) {
        return this.value - ((InformationEntity)object).getValue();
    }
}

