/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class MediaImporter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/MediaImporter.java,v 1.7 2009/02/08 14:09:13 dclunie Exp $";
    protected String mediaDirectoryPath;
    protected MessageLogger logger;
    protected JProgressBar progressBar;

    protected void logLn(String string) {
        if (this.logger != null) {
            this.logger.sendLn(string);
        }
    }

    public MediaImporter(MessageLogger messageLogger) {
        this.mediaDirectoryPath = null;
        this.logger = messageLogger;
        this.progressBar = null;
    }

    public MediaImporter(String string, MessageLogger messageLogger) {
        this.mediaDirectoryPath = string;
        this.logger = messageLogger;
        this.progressBar = null;
    }

    public MediaImporter(String string, MessageLogger messageLogger, JProgressBar jProgressBar) {
        this.mediaDirectoryPath = string;
        this.logger = messageLogger;
        this.progressBar = jProgressBar;
    }

    public void choosePathAndImportDicomFiles() throws IOException, DicomException {
        JFileChooser jFileChooser = new JFileChooser(this.mediaDirectoryPath);
        jFileChooser.setFileSelectionMode(2);
        if (jFileChooser.showOpenDialog(null) == 0) {
            this.mediaDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.importDicomFiles(string);
        }
    }

    protected boolean isOKToImport(String string, String string2) {
        return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2"));
    }

    public void importDicomFiles(String string) throws IOException, DicomException {
        if (string != null) {
            Object object;
            File file = new File(string);
            Object object2 = null;
            if (file != null && file.exists()) {
                if (file.isFile() && file.getName().toUpperCase().equals("DICOMDIR")) {
                    object2 = file;
                } else if (file.isDirectory()) {
                    object = new File(file, "DICOMDIR");
                    if (object != null && ((File)object).exists()) {
                        object2 = object;
                    } else {
                        object = new File(file, "Dicomdir");
                        if (object != null && ((File)object).exists()) {
                            object2 = object;
                        } else {
                            object = new File(file, "dicomdir");
                            if (object != null && ((File)object).exists()) {
                                object2 = object;
                            }
                        }
                    }
                }
            }
            if (object2 != null) {
                this.logLn("Found DICOMDIR at: " + object2);
                object = new DicomInputStream(new BufferedInputStream(new FileInputStream((File)object2)));
                AttributeList attributeList = new AttributeList();
                attributeList.read((DicomInputStream)object);
                ((FilterInputStream)object).close();
                DicomDirectory dicomDirectory = new DicomDirectory(attributeList);
                HashMap hashMap = dicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(((File)object2).getParentFile().getPath());
                if (this.progressBar != null) {
                    this.progressBar.setValue(0);
                    this.progressBar.setMaximum(hashMap.size());
                    this.progressBar.repaint();
                }
                int n = 0;
                for (String string2 : hashMap.keySet()) {
                    if (string2 != null) {
                        AttributeList attributeList2;
                        boolean bl = false;
                        DicomDirectoryRecord dicomDirectoryRecord = (DicomDirectoryRecord)hashMap.get(string2);
                        if (dicomDirectoryRecord != null && (attributeList2 = dicomDirectoryRecord.getAttributeList()) != null) {
                            String string3 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedSOPClassUIDInFile);
                            String string4 = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.ReferencedTransferSyntaxUIDInFile);
                            if (string3 == null || string4 == null) {
                                try {
                                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string2)));
                                    if (dicomInputStream.haveMetaHeader()) {
                                        AttributeList attributeList3 = new AttributeList();
                                        attributeList3.readOnlyMetaInformationHeader(dicomInputStream);
                                        if (string3 == null) {
                                            string3 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.MediaStorageSOPClassUID);
                                        }
                                        if (string4 == null) {
                                            string4 = Attribute.getSingleStringValueOrNull(attributeList3, TagFromName.TransferSyntaxUID);
                                        }
                                    }
                                    dicomInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.isOKToImport(string3, string4)) {
                                bl = true;
                            } else {
                                this.logLn("Is a DICOM file but bad meta-header, not a storage object, or is compressed: " + string2 + " SOP Class=" + string3 + ", Transfer Syntax=" + string4);
                            }
                        }
                        if (bl) {
                            this.logLn("Is a suitable DICOMDIR referenced file: " + string2);
                            this.doSomethingWithDicomFileOnMedia(string2);
                        } else {
                            this.logLn("Not a suitable DICOMDIR referenced file: " + string2);
                        }
                    }
                    ++n;
                    if (this.progressBar == null) continue;
                    this.progressBar.setValue(n);
                    this.progressBar.repaint();
                }
            } else {
                object = FileUtilities.listFilesRecursively(file);
                if (this.progressBar != null) {
                    this.progressBar.setValue(0);
                    this.progressBar.setMaximum(((ArrayList)object).size());
                    this.progressBar.repaint();
                }
                int n = 0;
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    if (file2 != null) {
                        try {
                            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(file2)));
                            boolean bl = false;
                            if (dicomInputStream.haveMetaHeader()) {
                                AttributeList attributeList = new AttributeList();
                                attributeList.readOnlyMetaInformationHeader(dicomInputStream);
                                String string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPClassUID);
                                String string6 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
                                if (this.isOKToImport(string5, string6)) {
                                    bl = true;
                                } else {
                                    this.logLn("Is a DICOM file but bad meta-header, not a storage object, or is compressed: " + file2 + " SOP Class=" + string5 + ", Transfer Syntax=" + string6);
                                }
                            }
                            dicomInputStream.close();
                            if (bl) {
                                this.logLn("Is a DICOM file: " + file2);
                                this.doSomethingWithDicomFileOnMedia(file2.getPath());
                            } else {
                                this.logLn("Not a DICOM PS 3.10 file: " + file2);
                            }
                        }
                        catch (Exception exception) {
                            this.logLn("Not a DICOM file: " + file2);
                        }
                    }
                    ++n;
                    if (this.progressBar == null) continue;
                    this.progressBar.setValue(n);
                    this.progressBar.repaint();
                }
            }
        }
        this.logLn("Media import complete");
    }

    protected void doSomethingWithDicomFileOnMedia(String string) {
    }

    public static void main(String[] stringArray) {
        block4: {
            try {
                if (stringArray.length == 0) {
                    DialogMessageLogger dialogMessageLogger = new DialogMessageLogger("MediaImporter", 512, 384, true);
                    MediaImporter mediaImporter = new MediaImporter("/", dialogMessageLogger);
                    mediaImporter.choosePathAndImportDicomFiles();
                    break block4;
                }
                if (stringArray.length == 1) {
                    String string = stringArray[0];
                    PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                    MediaImporter mediaImporter = new MediaImporter(printStreamMessageLogger);
                    mediaImporter.importDicomFiles(string);
                    break block4;
                }
                throw new Exception("Argument list must be zero or one value");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }
}

