/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherFloatAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherFloatAttribute.java,v 1.8 2008/02/21 04:45:04 dclunie Exp $";
    private float[] values;

    public OtherFloatAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherFloatAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public OtherFloatAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.values = null;
        this.valueLength = l;
        if (l > 0L) {
            int n = (int)(l / 4L);
            float[] fArray = new float[n];
            dicomInputStream.readFloat(fArray, n);
            this.setValues(fArray);
        }
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            dicomOutputStream.writeFloat(this.values, this.values.length);
            if (this.getVL() != (long)(this.values.length * 4)) {
                throw new DicomException("Internal error - float array length (" + this.values.length * 2 + ") not equal to expected VL(" + this.getVL() + ")");
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public void setValues(float[] fArray) throws DicomException {
        this.values = fArray;
        this.valueMultiplicity = 1;
        this.valueLength = fArray.length * 4;
    }

    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public float[] getFloatValues() throws DicomException {
        return this.values;
    }

    public byte[] getVR() {
        return ValueRepresentation.OF;
    }
}

