/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;

public class PixelSpacing {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/PixelSpacing.java,v 1.2 2009/04/06 22:19:20 dclunie Exp $";
    protected double spacing;
    protected String description;

    public double getSpacing() {
        return this.spacing;
    }

    public String getDescription() {
        return this.description;
    }

    public PixelSpacing(AttributeList attributeList, GeometryOfVolume geometryOfVolume, boolean bl, boolean bl2) {
        double[] dArray;
        GeometryOfSlice[] geometryOfSliceArray;
        boolean bl3 = false;
        if (geometryOfVolume != null && (geometryOfSliceArray = geometryOfVolume.getGeometryOfSlices()) != null && geometryOfSliceArray.length > 0 && (dArray = geometryOfSliceArray[0].getVoxelSpacingArray()) != null && dArray.length > 2 && dArray[0] == dArray[1]) {
            this.spacing = dArray[0];
            this.description = "3D";
            bl3 = true;
        }
        if (!bl3) {
            this.spacing = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.ImagerPixelSpacing, 0.0);
            if (this.spacing > 0.0) {
                if (bl2) {
                    double d = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.DistanceSourceToDetector, 0.0);
                    double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.DistanceSourceToPatient, 0.0);
                    double d3 = d2 > 0.0 ? d / d2 : 0.0;
                    double d4 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.EstimatedRadiographicMagnificationFactor, d3);
                    if (d4 > 0.0) {
                        this.spacing /= d4;
                        this.description = "magnified";
                    } else {
                        this.description = "detector";
                    }
                } else {
                    this.description = "detector";
                }
                bl3 = true;
            } else {
                this.spacing = 0.0;
            }
            if (!bl3 || bl && attributeList.get(TagFromName.PixelSpacing) != null) {
                String string = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.PixelSpacingCalibrationType, "calibrated").toLowerCase();
                string = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.PixelSpacingCalibrationDescription, string).toLowerCase();
                double d = this.spacing;
                this.spacing = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.PixelSpacing, 0.0);
                if (this.spacing > 0.0) {
                    this.description = this.spacing == d ? "detector" : (bl3 ? string : "unknown");
                    bl3 = true;
                } else {
                    this.spacing = 0.0;
                    this.description = null;
                }
            }
        }
    }

    public PixelSpacing(AttributeList attributeList, GeometryOfVolume geometryOfVolume) {
        this(attributeList, geometryOfVolume, true, false);
    }

    public PixelSpacing(AttributeList attributeList) {
        this(attributeList, null, true, false);
    }

    public String toString() {
        return Double.toString(this.spacing) + " (" + this.description + ")";
    }
}

