/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.utils.MessageLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;

public class DialogMessageLogger
implements MessageLogger {
    protected JDialog outputDialog;
    protected JScrollPane outputScrollPane;
    protected JTextArea outputTextArea;

    public DialogMessageLogger(String string, int n, int n2, boolean bl) {
        this(string, n, n2, bl, true);
    }

    public DialogMessageLogger(String string, int n, int n2, boolean bl, boolean bl2) {
        Border border = BorderFactory.createEtchedBorder();
        this.outputTextArea = new JTextArea();
        Object object = this.outputTextArea.getCaret();
        if (object != null && object instanceof DefaultCaret) {
            ((DefaultCaret)object).setUpdatePolicy(2);
        }
        this.outputScrollPane = new JScrollPane(this.outputTextArea);
        this.outputScrollPane.setBorder(border);
        this.outputDialog = new JDialog();
        this.outputDialog.setPreferredSize(new Dimension(n, n2));
        this.outputDialog.setTitle(string);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(1));
        ((JComponent)object).setBorder(border);
        JButton jButton = new JButton("Clear");
        jButton.setToolTipText("Clear log");
        ((Container)object).add(jButton);
        jButton.addActionListener(new ClearActionListener());
        Container container = this.outputDialog.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.outputScrollPane, gridBagConstraints);
        container.add(this.outputScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        container.add((Component)object);
        this.outputDialog.pack();
        this.outputDialog.setVisible(bl2);
        if (bl) {
            this.outputDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
    }

    public void setVisible(boolean bl) {
        this.outputDialog.setVisible(bl);
    }

    public void send(String string) {
        this.outputTextArea.append(string);
    }

    public void sendLn(String string) {
        this.outputTextArea.append(string + "\n");
    }

    protected class ClearActionListener
    implements ActionListener {
        protected ClearActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogMessageLogger.this.outputTextArea.setText("");
            DialogMessageLogger.this.outputScrollPane.repaint();
        }
    }
}

