/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.DicomImageBlackout;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationConfigurationDialog;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.TransferSyntaxSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.MessageLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DicomCleaner
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomCleaner.java,v 1.34 2011/01/23 19:45:47 dclunie Exp $";
    protected static String propertiesFileName = ".com.pixelmed.display.DicomCleaner.properties";
    protected static String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    protected static String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    protected static String rootNameForDicomInstanceFilesOnInterchangeMedia = "DICOM";
    protected static String filePrefixForDicomInstanceFilesOnInterchangeMedia = "I";
    protected static String fileSuffixForDicomInstanceFilesOnInterchangeMedia = "";
    protected static String nameForDicomDirectoryOnInterchangeMedia = "DICOMDIR";
    protected static String exportedZipFileName = "export.zip";
    protected static String defaultReplacementPatientName = "NAME^NONE";
    protected static String defaultReplacementPatientID = "NOID";
    protected static String defaultReplacementAccessionNumber = "";
    protected static int textFieldLengthForQueryPatientName = 16;
    protected static int textFieldLengthForQueryPatientID = 10;
    protected static int textFieldLengthForQueryStudyDate = 8;
    protected static int textFieldLengthForReplacementPatientName = 16;
    protected static int textFieldLengthForReplacementPatientID = 10;
    protected static int textFieldLengthForReplacementAccessionNumber = 10;
    protected static String queryIntroductionLabelText = "Query -";
    protected static String queryPatientNameLabelText = "Patient's Name:";
    protected static String queryPatientIDLabelText = "Patient's ID:";
    protected static String queryStudyDateLabelText = "Study Date:";
    protected static String queryPatientNameToolTipText = "The text to use for the Patient's Name when querying";
    protected static String queryPatientIDToolTipText = "The text to use for the Patient's ID when querying";
    protected static String queryStudyDateToolTipText = "The text to use for the Study Date when querying";
    protected static String replacementIntroductionLabelText = "Replace -";
    protected static String replacementPatientNameLabelText = "Patient's Name:";
    protected static String replacementPatientIDLabelText = "Patient's ID:";
    protected static String replacementAccessionNumberLabelText = "Accession #:";
    protected static String replacementPatientNameToolTipText = "The text to use for the Patient's Name when cleaning (ignored otherwise)";
    protected static String replacementPatientIDToolTipText = "The text to use for the Patient's ID when cleaning (ignored otherwise)";
    protected static String replacementAccessionNumberToolTipText = "The text to use for the Accession Number when cleaning (ignored otherwise)";
    protected static String removeIdentityLabelText = "Remove all unreplaced identities";
    protected static String removeDescriptionsLabelText = "Remove descriptions";
    protected static String removeSeriesDescriptionsLabelText = "Remove series description";
    protected static String removeCharacteristicsLabelText = "Remove patient characteristics";
    protected static String removeDeviceIdentityLabelText = "Remove device identifiers";
    protected static String removeInstitutionIdentityLabelText = "Remove institution identifiers";
    protected static String cleanUIDsLabelText = "Replace all UIDs";
    protected static String removePrivateLabelText = "Remove unsafe private attributes";
    protected static String addContributingEquipmentLabelText = "Add contributing equipment";
    protected static String removeClinicalTrialAttributesLabelText = "Remove clinical trial attributes";
    protected static String zipExportLabelText = "Zip exported files";
    protected DatabaseInformationModel srcDatabase;
    protected DatabaseInformationModel dstDatabase;
    protected JFrame mainFrame;
    protected JPanel srcDatabasePanel;
    protected JPanel dstDatabasePanel;
    protected JPanel remoteQueryRetrievePanel;
    protected JCheckBox removeIdentityCheckBox;
    protected JCheckBox removeDescriptionsCheckBox;
    protected JCheckBox removeSeriesDescriptionsCheckBox;
    protected JCheckBox removeCharacteristicsCheckBox;
    protected JCheckBox removeDeviceIdentityCheckBox;
    protected JCheckBox removeInstitutionIdentityCheckBox;
    protected JCheckBox cleanUIDsCheckBox;
    protected JCheckBox removePrivateCheckBox;
    protected JCheckBox addContributingEquipmentCheckBox;
    protected JCheckBox removeClinicalTrialAttributesBox;
    protected JCheckBox zipExportCheckBox;
    protected JCheckBox replacePatientNameCheckBox;
    protected JCheckBox replacePatientIDCheckBox;
    protected JCheckBox replaceAccessionNumberCheckBox;
    protected JTextField replacementPatientNameTextField;
    protected JTextField replacementPatientIDTextField;
    protected JTextField replacementAccessionNumberTextField;
    protected JTextField queryFilterPatientNameTextField;
    protected JTextField queryFilterPatientIDTextField;
    protected JTextField queryFilterStudyDateTextField;
    protected JProgressBar progressBar;
    protected MessageLogger logger;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformation networkApplicationInformation;
    protected QueryInformationModel currentRemoteQueryInformationModel;
    protected QueryTreeRecord currentRemoteQuerySelectionQueryTreeRecord;
    protected AttributeList currentRemoteQuerySelectionUniqueKeys;
    protected Attribute currentRemoteQuerySelectionUniqueKey;
    protected String currentRemoteQuerySelectionRetrieveAE;
    protected String currentRemoteQuerySelectionLevel;
    protected String ourCalledAETitle;
    protected static boolean haveScannedForCodecs = false;
    protected static boolean haveCheckedForJPEGLosslessCodec = false;
    protected static boolean haveFoundJPEGLosslessCodec = false;
    protected static boolean haveCheckedForJPEG2000Part1Codec = false;
    protected static boolean haveFoundJPEG2000Part1Codec = false;
    protected File savedImagesFolder;
    protected StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;
    protected DatabaseTreeRecord currentSourceDatabaseSelection;
    protected Vector currentSourceFilePathSelections;
    protected DatabaseTreeRecord currentDestinationDatabaseSelection;
    protected Vector currentDestinationFilePathSelections;
    protected String exportDirectoryPath;
    Thread activeThread;

    protected boolean haveJPEGLosslessCodec() {
        if (!haveCheckedForJPEGLosslessCodec) {
            if (!haveScannedForCodecs) {
                System.err.println("DicomCleaner.haveJPEGLosslessCodec(): Scanning for ImageIO plugin codecs");
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEGLosslessCodec = false;
            String string = "jpeg-lossless";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    System.err.println("DicomCleaner.haveJPEGLosslessCodec(): Found jpeg-lossless reader");
                    haveFoundJPEGLosslessCodec = true;
                    try {
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                } else {
                    System.err.println("DicomCleaner.haveJPEGLosslessCodec(): No jpeg-lossless reader");
                }
            }
            catch (Exception exception) {
                System.err.println("DicomCleaner.haveJPEGLosslessCodec(): No jpeg-lossless reader");
                haveFoundJPEGLosslessCodec = false;
            }
            haveCheckedForJPEGLosslessCodec = true;
        }
        return haveFoundJPEGLosslessCodec;
    }

    protected boolean haveJPEG2000Part1Codec() {
        if (!haveCheckedForJPEG2000Part1Codec) {
            if (!haveScannedForCodecs) {
                System.err.println("DicomCleaner.haveJPEG2000Part1Codec(): Scanning for ImageIO plugin codecs");
                ImageIO.scanForPlugins();
                haveScannedForCodecs = true;
            }
            haveFoundJPEG2000Part1Codec = false;
            String string = "JPEG2000";
            try {
                ImageReader imageReader = ImageIO.getImageReadersByFormatName(string).next();
                if (imageReader != null) {
                    System.err.println("DicomCleaner.haveJPEG2000Part1Codec(): Found JPEG2000 reader");
                    haveFoundJPEG2000Part1Codec = true;
                    try {
                        imageReader.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                } else {
                    System.err.println("DicomCleaner.haveJPEG2000Part1Codec(): No JPEG2000 reader");
                }
            }
            catch (Exception exception) {
                System.err.println("DicomCleaner.haveJPEG2000Part1Codec(): No JPEG2000 reader");
                haveFoundJPEG2000Part1Codec = false;
            }
            haveCheckedForJPEG2000Part1Codec = true;
        }
        return haveFoundJPEG2000Part1Codec;
    }

    protected void setCurrentRemoteQueryInformationModel(String string) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                int n2 = this.networkApplicationProperties.getQueryDebugLevel();
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n, string4, string3, n2);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationInformation != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(null, string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    protected static void importFileIntoDatabase(DatabaseInformationModel databaseInformationModel, String string, String string2) throws FileNotFoundException, IOException, DicomException {
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing: " + string));
        FileInputStream fileInputStream = new FileInputStream(string);
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream, TagFromName.PixelData);
        dicomInputStream.close();
        fileInputStream.close();
        databaseInformationModel.insertObject(attributeList, string, string2);
    }

    protected void activateStorageSCP() throws DicomException, IOException {
        if (this.networkApplicationProperties != null) {
            int n = this.networkApplicationProperties.getListeningPort();
            this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle));
            System.err.println("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle);
            int n2 = this.networkApplicationProperties.getStorageSCPDebugLevel();
            int n3 = this.networkApplicationProperties.getQueryDebugLevel();
            this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.savedImagesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDINSINGLEFOLDER, new OurReceivedObjectHandler(), this.srcDatabase == null ? null : this.srcDatabase.getQueryResponseGeneratorFactory(n3), this.srcDatabase == null ? null : this.srcDatabase.getRetrieveResponseGeneratorFactory(n3), this.networkApplicationInformation, new OurPresentationContextSelectionPolicy(), false, n2);
            new Thread(this.storageSOPClassSCPDispatcher).start();
        }
    }

    protected void activateTemporaryDatabases() throws DicomException {
        this.srcDatabase = new PatientStudySeriesConcatenationInstanceModel("mem:src", null, "Original");
        this.dstDatabase = new PatientStudySeriesConcatenationInstanceModel("mem:dst", null, "Cleaned");
    }

    protected static void updateProgressBase(JProgressBar jProgressBar, int n, int n2) {
        if (jProgressBar != null) {
            jProgressBar.setValue(n);
            jProgressBar.setMaximum(n2);
            jProgressBar.setStringPainted(true);
            jProgressBar.repaint();
        }
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord databaseTreeRecord, MessageLogger messageLogger, JProgressBar jProgressBar, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            DicomCleaner.updateProgressBase(jProgressBar, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || !informationEntity.equals(InformationEntity.INSTANCE)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.purgeFilesAndDatabaseInformation(databaseTreeRecord2, messageLogger, jProgressBar, n, n2);
                        ++n;
                    }
                }
                if (informationEntity != null) {
                    messageLogger.sendLn("Purging " + databaseTreeRecord);
                    databaseTreeRecord.removeFromParent();
                }
            } else {
                String string = databaseTreeRecord.getLocalFileNameValue();
                String string2 = databaseTreeRecord.getLocalFileReferenceTypeValue();
                if (string2 != null && string2.equals("C")) {
                    try {
                        messageLogger.sendLn("Deleting file " + string);
                        if (!new File(string).delete()) {
                            messageLogger.sendLn("Failed to delete local copy of file " + string);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        messageLogger.sendLn("Failed to delete local copy of file " + string);
                    }
                }
                messageLogger.sendLn("Purging " + databaseTreeRecord);
                databaseTreeRecord.removeFromParent();
            }
        }
    }

    protected void copyFromOriginalToCleanedPerformingAction(Vector vector, MessageLogger messageLogger, JProgressBar jProgressBar) throws DicomException, IOException {
        if (vector != null) {
            jProgressBar.setValue(0);
            jProgressBar.setMaximum(vector.size());
            jProgressBar.setStringPainted(true);
            jProgressBar.repaint();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (string != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaning " + string));
                    File file = new File(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(file);
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream);
                    dicomInputStream.close();
                    attributeList.removeGroupLengthAttributes();
                    attributeList.correctDecompressedImagePixelModule();
                    attributeList.insertLossyImageCompressionHistoryIfDecompressed();
                    attributeList.removeMetaInformationHeaderAttributes();
                    if (this.removeClinicalTrialAttributesBox.isSelected()) {
                        ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                    }
                    if (this.removeIdentityCheckBox.isSelected()) {
                        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, !this.removeDescriptionsCheckBox.isSelected(), !this.removeSeriesDescriptionsCheckBox.isSelected(), !this.removeCharacteristicsCheckBox.isSelected(), !this.removeDeviceIdentityCheckBox.isSelected(), !this.removeInstitutionIdentityCheckBox.isSelected());
                    }
                    if (this.replacePatientNameCheckBox.isSelected()) {
                        object3 = this.replacementPatientNameTextField.getText().trim();
                        object2 = TagFromName.PatientName;
                        attributeList.remove((AttributeTag)object2);
                        object = new PersonNameAttribute((AttributeTag)object2);
                        ((Attribute)object).addValue((String)object3);
                        attributeList.put((AttributeTag)object2, (Attribute)object);
                    }
                    if (this.replacePatientIDCheckBox.isSelected()) {
                        object3 = this.replacementPatientIDTextField.getText().trim();
                        object2 = TagFromName.PatientID;
                        attributeList.remove((AttributeTag)object2);
                        object = new LongStringAttribute((AttributeTag)object2);
                        ((Attribute)object).addValue((String)object3);
                        attributeList.put((AttributeTag)object2, (Attribute)object);
                    }
                    if (this.replaceAccessionNumberCheckBox.isSelected()) {
                        object3 = this.replacementAccessionNumberTextField.getText().trim();
                        object2 = TagFromName.AccessionNumber;
                        attributeList.remove((AttributeTag)object2);
                        object = new ShortStringAttribute((AttributeTag)object2);
                        ((Attribute)object).addValue((String)object3);
                        attributeList.put((AttributeTag)object2, (Attribute)object);
                    }
                    if (this.removePrivateCheckBox.isSelected()) {
                        attributeList.removeUnsafePrivateAttributes();
                        object3 = attributeList.get(TagFromName.DeidentificationMethod);
                        if (object3 != null) {
                            ((Attribute)object3).addValue("Unsafe private removed");
                        }
                        if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                            ((SequenceAttribute)object3).addItem(new CodedSequenceItem("113111", "DCM", "Retain Safe Private Option").getAttributeList());
                        }
                    } else {
                        object3 = attributeList.get(TagFromName.DeidentificationMethod);
                        if (object3 != null) {
                            ((Attribute)object3).addValue("All private retained");
                        }
                        if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                            ((SequenceAttribute)object3).addItem(new CodedSequenceItem("210002", "99PMP", "Retain all private elements").getAttributeList());
                        }
                    }
                    if (this.cleanUIDsCheckBox.isSelected()) {
                        ClinicalTrialsAttributes.remapUIDAttributes(attributeList);
                        object3 = attributeList.get(TagFromName.DeidentificationMethod);
                        if (object3 != null) {
                            ((Attribute)object3).addValue("UIDs remapped");
                        }
                        if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                            object2 = ((SequenceAttribute)object3).iterator();
                            while (object2.hasNext()) {
                                CodedSequenceItem codedSequenceItem;
                                object = (SequenceItem)object2.next();
                                if (object == null || (codedSequenceItem = new CodedSequenceItem(((SequenceItem)object).getAttributeList())) == null) continue;
                                String string2 = codedSequenceItem.getCodeValue();
                                String string3 = codedSequenceItem.getCodingSchemeDesignator();
                                if (string2 == null || !string2.equals("113110") || string3 == null || !string3.equals("DCM")) continue;
                                object2.remove();
                            }
                        }
                        if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                            ((SequenceAttribute)object3).addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
                        }
                    }
                    if (this.addContributingEquipmentCheckBox.isSelected()) {
                        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, this.ourCalledAETitle, "DicomCleaner", null, this.getBuildDate(), "Cleaned", DateTimeAttribute.getFormattedString(new Date()));
                    }
                    FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", this.ourCalledAETitle);
                    attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                    object3 = File.createTempFile("clean", ".dcm");
                    ((File)object3).deleteOnExit();
                    attributeList.write((File)object3);
                    messageLogger.sendLn("Cleaned " + string + " into " + ((File)object3).getCanonicalPath());
                    this.dstDatabase.insertObject(attributeList, ((File)object3).getCanonicalPath(), "C");
                }
                jProgressBar.setValue(i + 1);
                jProgressBar.setStringPainted(true);
                jProgressBar.repaint();
            }
        }
    }

    protected String makeNewFullyQualifiedInterchangeMediaInstancePathName(int n) throws IOException {
        return new File(rootNameForDicomInstanceFilesOnInterchangeMedia, filePrefixForDicomInstanceFilesOnInterchangeMedia + Integer.toString(n) + fileSuffixForDicomInstanceFilesOnInterchangeMedia).getPath();
    }

    protected void setCurrentRemoteQuerySelection(AttributeList attributeList, Attribute attribute, AttributeList attributeList2) {
        Object object;
        this.currentRemoteQuerySelectionUniqueKeys = attributeList;
        this.currentRemoteQuerySelectionUniqueKey = attribute;
        this.currentRemoteQuerySelectionRetrieveAE = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.RetrieveAETitle)) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionRetrieveAE == null && this.currentRemoteQueryInformationModel != null) {
            this.currentRemoteQuerySelectionRetrieveAE = this.currentRemoteQueryInformationModel.getCalledAETitle();
        }
        this.currentRemoteQuerySelectionLevel = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.QueryRetrieveLevel)) != null) {
            this.currentRemoteQuerySelectionLevel = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionLevel == null) {
            if (attribute != null && (object = attribute.getTag()) != null) {
                if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                    this.currentRemoteQuerySelectionLevel = "PATIENT";
                } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "STUDY";
                } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "SERIES";
                } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "IMAGE";
                }
            }
            System.err.println("DicomCleaner.setCurrentRemoteQuerySelection(): Guessed missing currentRemoteQuerySelectionLevel to be " + this.currentRemoteQuerySelectionLevel);
        }
    }

    protected void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(attributeTag);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put(attributeTag, codeStringAttribute);
                this.currentRemoteQueryInformationModel.performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected void createGUI() {
        this.setBackground(Color.lightGray);
        this.setInternationalizedFontsForGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (DicomCleaner.this.networkApplicationInformation != null && DicomCleaner.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DicomCleaner.this.networkApplicationInformation).removeAllSources();
                }
                DicomCleaner.this.dispose();
                System.exit(0);
            }
        });
    }

    public DicomCleaner(String string) throws DicomException, IOException {
        super(string, propertiesFileName);
        this.activateTemporaryDatabases();
        this.savedImagesFolder = new File(System.getProperty("java.io.tmpdir"));
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(this.getProperties());
        }
        catch (Exception exception) {
            this.networkApplicationProperties = null;
        }
        Object object = new NetworkApplicationInformationFederated();
        ((NetworkApplicationInformationFederated)object).startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = object;
        this.activateStorageSCP();
        this.logger = new DialogMessageLogger("DicomCleaner Log", 512, 384, false, false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (DicomCleaner.this.networkApplicationInformation != null && DicomCleaner.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DicomCleaner.this.networkApplicationInformation).removeAllSources();
                }
            }
        });
        this.mainFrame = this;
        this.srcDatabasePanel = new JPanel();
        this.dstDatabasePanel = new JPanel();
        this.remoteQueryRetrievePanel = new JPanel();
        this.srcDatabasePanel.setLayout(new GridLayout(1, 1));
        this.dstDatabasePanel.setLayout(new GridLayout(1, 1));
        this.remoteQueryRetrievePanel.setLayout(new GridLayout(1, 1));
        object = new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
        OurDestinationDatabaseTreeBrowser ourDestinationDatabaseTreeBrowser = new OurDestinationDatabaseTreeBrowser(this.dstDatabase, this.dstDatabasePanel);
        Border border = BorderFactory.createEtchedBorder();
        JSplitPane jSplitPane = new JSplitPane(1, this.srcDatabasePanel, this.dstDatabasePanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(1, this.remoteQueryRetrievePanel, jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setResizeWeight(0.4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setBorder(border);
        JButton jButton = new JButton("Configure");
        jButton.setToolTipText("Configure the application, including DICOM network properties");
        jPanel.add(jButton);
        jButton.addActionListener(new ConfigureActionListener());
        JButton jButton2 = new JButton("Log");
        jButton2.setToolTipText("Show the log of activities");
        jPanel.add(jButton2);
        jButton2.addActionListener(new LogActionListener());
        JButton jButton3 = new JButton("Query");
        jButton3.setToolTipText("Query a remote network host");
        jPanel.add(jButton3);
        jButton3.addActionListener(new QueryActionListener());
        JButton jButton4 = new JButton("Retrieve");
        jButton4.setToolTipText("Retrieve query selection from remote host");
        jPanel.add(jButton4);
        jButton4.addActionListener(new RetrieveActionListener());
        JButton jButton5 = new JButton("Import");
        jButton5.setToolTipText("Import from media into originals database");
        jPanel.add(jButton5);
        jButton5.addActionListener(new ImportActionListener());
        JButton jButton6 = new JButton("Clean");
        jButton6.setToolTipText("Clean the selected originals and copy to cleaned database");
        jPanel.add(jButton6);
        jButton6.addActionListener(new CleanActionListener());
        JButton jButton7 = new JButton("Blackout");
        jButton7.setToolTipText("Blackout burned in annotation in the selected cleaned database files");
        jPanel.add(jButton7);
        jButton7.addActionListener(new BlackoutActionListener());
        JButton jButton8 = new JButton("Export");
        jButton8.setToolTipText("Export from cleaned database to folder with DICOMDIR for burning to media");
        jPanel.add(jButton8);
        jButton8.addActionListener(new ExportActionListener());
        JButton jButton9 = new JButton("Send");
        jButton9.setToolTipText("Send the selected cleaned objects over the network");
        jPanel.add(jButton9);
        jButton9.addActionListener(new SendActionListener());
        JButton jButton10 = new JButton("Purge");
        jButton10.setToolTipText("Remove selected entries from the original and cleaned databases and delete any local copy of files");
        jPanel.add(jButton10);
        jButton10.addActionListener(new PurgeActionListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(border);
        JLabel jLabel = new JLabel(queryIntroductionLabelText);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(queryPatientNameLabelText);
        jLabel2.setToolTipText(queryPatientNameToolTipText);
        jPanel2.add(jLabel2);
        this.queryFilterPatientNameTextField = new JTextField("", textFieldLengthForQueryPatientName);
        jPanel2.add(this.queryFilterPatientNameTextField);
        JLabel jLabel3 = new JLabel(queryPatientIDLabelText);
        jLabel3.setToolTipText(queryPatientIDToolTipText);
        jPanel2.add(jLabel3);
        this.queryFilterPatientIDTextField = new JTextField("", textFieldLengthForQueryPatientID);
        jPanel2.add(this.queryFilterPatientIDTextField);
        JLabel jLabel4 = new JLabel(queryStudyDateLabelText);
        jLabel4.setToolTipText(queryStudyDateToolTipText);
        jPanel2.add(jLabel4);
        this.queryFilterStudyDateTextField = new JTextField("", textFieldLengthForQueryStudyDate);
        jPanel2.add(this.queryFilterStudyDateTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setBorder(border);
        JLabel jLabel5 = new JLabel(replacementIntroductionLabelText);
        jPanel3.add(jLabel5);
        this.replacePatientNameCheckBox = new JCheckBox(replacementPatientNameLabelText);
        this.replacePatientNameCheckBox.setSelected(true);
        this.replacePatientNameCheckBox.setToolTipText(replacementPatientNameToolTipText);
        jPanel3.add(this.replacePatientNameCheckBox);
        this.replacementPatientNameTextField = new JTextField(defaultReplacementPatientName, textFieldLengthForReplacementPatientName);
        jPanel3.add(this.replacementPatientNameTextField);
        this.replacePatientIDCheckBox = new JCheckBox(replacementPatientIDLabelText);
        this.replacePatientIDCheckBox.setSelected(true);
        this.replacePatientIDCheckBox.setToolTipText(replacementPatientIDToolTipText);
        jPanel3.add(this.replacePatientIDCheckBox);
        this.replacementPatientIDTextField = new JTextField(defaultReplacementPatientID, textFieldLengthForReplacementPatientID);
        jPanel3.add(this.replacementPatientIDTextField);
        this.replaceAccessionNumberCheckBox = new JCheckBox(replacementAccessionNumberLabelText);
        this.replaceAccessionNumberCheckBox.setSelected(true);
        this.replaceAccessionNumberCheckBox.setToolTipText(replacementAccessionNumberToolTipText);
        jPanel3.add(this.replaceAccessionNumberCheckBox);
        this.replacementAccessionNumberTextField = new JTextField(defaultReplacementAccessionNumber, textFieldLengthForReplacementAccessionNumber);
        jPanel3.add(this.replacementAccessionNumberTextField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 4));
        jPanel4.setBorder(border);
        this.removeIdentityCheckBox = new JCheckBox(removeIdentityLabelText);
        this.removeIdentityCheckBox.setSelected(true);
        jPanel4.add(this.removeIdentityCheckBox);
        this.removeDescriptionsCheckBox = new JCheckBox(removeDescriptionsLabelText);
        this.removeDescriptionsCheckBox.setSelected(false);
        jPanel4.add(this.removeDescriptionsCheckBox);
        this.removeSeriesDescriptionsCheckBox = new JCheckBox(removeSeriesDescriptionsLabelText);
        this.removeSeriesDescriptionsCheckBox.setSelected(false);
        jPanel4.add(this.removeSeriesDescriptionsCheckBox);
        this.removeCharacteristicsCheckBox = new JCheckBox(removeCharacteristicsLabelText);
        this.removeCharacteristicsCheckBox.setSelected(false);
        jPanel4.add(this.removeCharacteristicsCheckBox);
        this.cleanUIDsCheckBox = new JCheckBox(cleanUIDsLabelText);
        this.cleanUIDsCheckBox.setSelected(true);
        jPanel4.add(this.cleanUIDsCheckBox);
        this.removePrivateCheckBox = new JCheckBox(removePrivateLabelText);
        this.removePrivateCheckBox.setSelected(true);
        jPanel4.add(this.removePrivateCheckBox);
        this.removeDeviceIdentityCheckBox = new JCheckBox(removeDeviceIdentityLabelText);
        this.removeDeviceIdentityCheckBox.setSelected(false);
        jPanel4.add(this.removeDeviceIdentityCheckBox);
        this.removeInstitutionIdentityCheckBox = new JCheckBox(removeInstitutionIdentityLabelText);
        this.removeInstitutionIdentityCheckBox.setSelected(false);
        jPanel4.add(this.removeInstitutionIdentityCheckBox);
        this.removeClinicalTrialAttributesBox = new JCheckBox(removeClinicalTrialAttributesLabelText);
        this.removeClinicalTrialAttributesBox.setSelected(false);
        jPanel4.add(this.removeClinicalTrialAttributesBox);
        this.addContributingEquipmentCheckBox = new JCheckBox(addContributingEquipmentLabelText);
        this.addContributingEquipmentCheckBox.setSelected(true);
        jPanel4.add(this.addContributingEquipmentCheckBox);
        this.zipExportCheckBox = new JCheckBox(zipExportLabelText);
        this.zipExportCheckBox.setSelected(false);
        jPanel4.add(this.zipExportCheckBox);
        JPanel jPanel5 = new JPanel();
        Serializable serializable = new GridBagLayout();
        jPanel5.setLayout((LayoutManager)((Object)serializable));
        Serializable serializable2 = this.getStatusBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        ((GridBagLayout)serializable).setConstraints((Component)serializable2, gridBagConstraints);
        jPanel5.add((Component)serializable2);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(false);
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).weightx = 0.5;
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).anchor = 13;
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(this.progressBar, (GridBagConstraints)serializable2);
        jPanel5.add(this.progressBar);
        serializable = new JPanel();
        serializable2 = new GridBagLayout();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ((GridBagLayout)serializable2).setConstraints(jSplitPane2, gridBagConstraints);
        ((Container)serializable).add(jSplitPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel, gridBagConstraints);
        ((Container)serializable).add(jPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel2, gridBagConstraints);
        ((Container)serializable).add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel3, gridBagConstraints);
        ((Container)serializable).add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel4, gridBagConstraints);
        ((Container)serializable).add(jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel5, gridBagConstraints);
        ((Container)serializable).add(jPanel5);
        serializable2 = this.getContentPane();
        ((Container)serializable2).add((Component)serializable);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().startsWith("windows")) {
                System.err.println("DicomCleaner.main(): detected Windows - using Windows LAF");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            new DicomCleaner("Dicom Cleaner");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class CancelActionListener
    implements ActionListener {
        protected CancelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.activeThread != null) {
                    DicomCleaner.this.activeThread.interrupt();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ConfigureActionListener
    implements ActionListener {
        protected ConfigureActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DicomCleaner.this.storageSOPClassSCPDispatcher.shutdown();
                new NetworkApplicationConfigurationDialog(DicomCleaner.this.mainFrame, DicomCleaner.this.networkApplicationInformation, DicomCleaner.this.networkApplicationProperties);
                DicomCleaner.this.networkApplicationProperties.getProperties(DicomCleaner.this.getProperties());
                DicomCleaner.this.storeProperties("Edited and saved from user interface");
                DicomCleaner.this.activateStorageSCP();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class LogActionListener
    implements ActionListener {
        protected LogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DicomCleaner.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DicomCleaner.this.logger).setVisible(true);
            }
        }
    }

    protected class RetrieveActionListener
    implements ActionListener {
        protected RetrieveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
            if (DicomCleaner.this.currentRemoteQuerySelectionLevel == null) {
                QueryTreeRecord queryTreeRecord = DicomCleaner.this.currentRemoteQuerySelectionQueryTreeRecord;
                if (queryTreeRecord != null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving everything from " + string));
                    DicomCleaner.this.logger.sendLn("Retrieving everything from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                    Enumeration enumeration = queryTreeRecord.children();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)enumeration.nextElement();
                            if (queryTreeRecord2 == null) continue;
                            DicomCleaner.this.setCurrentRemoteQuerySelection(queryTreeRecord2.getUniqueKeys(), queryTreeRecord2.getUniqueKey(), queryTreeRecord2.getAllAttributesReturnedInIdentifier());
                            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                            DicomCleaner.this.logger.sendLn("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                            DicomCleaner.this.performRetrieve(DicomCleaner.this.currentRemoteQuerySelectionUniqueKeys, DicomCleaner.this.currentRemoteQuerySelectionLevel, DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
                        }
                    }
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
                    DicomCleaner.this.setCurrentRemoteQuerySelection(null, null, null);
                }
            } else {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                DicomCleaner.this.logger.sendLn("Request retrieval of " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                DicomCleaner.this.performRetrieve(DicomCleaner.this.currentRemoteQuerySelectionUniqueKeys, DicomCleaner.this.currentRemoteQuerySelectionLevel, DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
            }
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class QueryActionListener
    implements ActionListener {
        protected QueryActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DicomCleaner.this.getProperties();
            String string = properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DicomCleaner.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select remote system", "Query ...", string);
            DicomCleaner.this.remoteQueryRetrievePanel.removeAll();
            if (string != null) {
                DicomCleaner.this.setCurrentRemoteQueryInformationModel(string);
                if (DicomCleaner.this.currentRemoteQueryInformationModel == null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cannot query " + string));
                } else {
                    try {
                        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
                        AttributeList attributeList = new AttributeList();
                        AttributeTag attributeTag = TagFromName.PatientName;
                        StringAttribute stringAttribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
                        String string2 = DicomCleaner.this.queryFilterPatientNameTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        string2 = DicomCleaner.this.queryFilterPatientIDTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientBirthDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientSex;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ModalitiesInStudy;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        string2 = DicomCleaner.this.queryFilterStudyDateTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientAge;
                        stringAttribute = new AgeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.Modality;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.InstanceNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ImageType;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.NumberOfFrames;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPClassUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SpecificCharacterSet;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        ((Attribute)stringAttribute).addValue("ISO_IR 100");
                        DicomCleaner.this.activeThread = new Thread(new QueryWorker(attributeList));
                        DicomCleaner.this.activeThread.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string + " failed"));
                    }
                }
            }
            DicomCleaner.this.remoteQueryRetrievePanel.validate();
        }
    }

    protected class QueryWorker
    implements Runnable {
        AttributeList filter;

        QueryWorker(AttributeList attributeList) {
            this.filter = attributeList;
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = DicomCleaner.this.currentRemoteQueryInformationModel.getCalledAETitle();
            String string2 = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Performing query on " + string2));
            DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") starting");
            try {
                QueryTreeModel queryTreeModel = DicomCleaner.this.currentRemoteQueryInformationModel.performHierarchicalQuery(this.filter);
                new OurQueryTreeBrowser(DicomCleaner.this.currentRemoteQueryInformationModel, queryTreeModel, DicomCleaner.this.remoteQueryRetrievePanel);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying " + string2));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string2 + " failed " + exception));
                DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") failed due to" + exception);
                exception.printStackTrace(System.err);
            }
            DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying  " + string2));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, Container container) throws DicomException {
            super(queryInformationModel, queryTreeModel, container);
        }

        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                        DicomCleaner.this.setCurrentRemoteQuerySelection(queryTreeRecord.getUniqueKeys(), queryTreeRecord.getUniqueKey(), queryTreeRecord.getAllAttributesReturnedInIdentifier());
                        DicomCleaner.this.currentRemoteQuerySelectionQueryTreeRecord = queryTreeRecord;
                    }
                }
            };
        }
    }

    protected class BlackoutActionListener
    implements ActionListener {
        protected BlackoutActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.logger.sendLn("Blackout starting");
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                try {
                    DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
                    int n = DicomCleaner.this.currentDestinationFilePathSelections.size();
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = (String)DicomCleaner.this.currentDestinationFilePathSelections.get(i);
                    }
                    new OurDicomImageBlackout("Dicom Image Blackout", stringArray, 4, DicomCleaner.this.ourCalledAETitle);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class OurDicomImageBlackout
    extends DicomImageBlackout {
        OurDicomImageBlackout(String string, String[] stringArray, int n, String string2) {
            super(string, stringArray, null, n);
            this.statusNotificationHandler = new ApplicationStatusChangeEventNotificationHandler();
            this.ourAETitle = string2;
        }

        public class ApplicationStatusChangeEventNotificationHandler
        extends DicomImageBlackout.StatusNotificationHandler {
            public ApplicationStatusChangeEventNotificationHandler() {
                super(OurDicomImageBlackout.this);
            }

            public void notify(int n, String string, Throwable throwable) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Blackout " + string));
                DicomCleaner.this.logger.sendLn("Blackout " + string);
                System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): status = " + n);
                System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): message = " + string);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }

    protected class SendActionListener
    implements ActionListener {
        protected SendActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Cursor cursor = DicomCleaner.this.getCursor();
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                Properties properties = DicomCleaner.this.getProperties();
                String string = properties.getProperty(propertyName_DicomCurrentlySelectedStorageTargetAE);
                if ((string = DicomCleaner.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select destination", "Send ...", string)) != null && DicomCleaner.this.networkApplicationProperties != null) {
                    try {
                        String string2 = DicomCleaner.this.networkApplicationProperties.getCallingAETitle();
                        String string3 = DicomCleaner.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                        PresentationAddress presentationAddress = DicomCleaner.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                        String string4 = presentationAddress.getHostname();
                        int n = presentationAddress.getPort();
                        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles(DicomCleaner.this.currentDestinationFilePathSelections);
                        new Thread(new SendWorker(string4, n, string3, string2, setOfDicomFiles)).start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending."));
        }
    }

    protected class SendWorker
    implements Runnable {
        String hostname;
        int port;
        String calledAETitle;
        String callingAETitle;
        SetOfDicomFiles setOfDicomFiles;

        SendWorker(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles) {
            this.hostname = string;
            this.port = n;
            this.calledAETitle = string2;
            this.callingAETitle = string3;
            this.setOfDicomFiles = setOfDicomFiles;
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            DicomCleaner.this.logger.sendLn("Send starting");
            try {
                int n = this.setOfDicomFiles.size();
                DicomCleaner.this.progressBar.setMaximum(n);
                DicomCleaner.this.progressBar.setStringPainted(true);
                DicomCleaner.this.progressBar.repaint();
                new StorageSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, this.setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandler(n), 0);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send failed: " + exception));
                DicomCleaner.this.logger.sendLn("Send failed");
                exception.printStackTrace(System.err);
            }
            DicomCleaner.this.progressBar.setValue(DicomCleaner.this.progressBar.getMaximum());
            DicomCleaner.this.progressBar.setStringPainted(false);
            DicomCleaner.this.progressBar.repaint();
            DicomCleaner.this.logger.sendLn("Send complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to " + this.calledAETitle));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class OurMultipleInstanceTransferStatusHandler
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int nFiles;

        OurMultipleInstanceTransferStatusHandler(int n) {
            this.nFiles = n;
        }

        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Remaining " + n + ", completed " + n2 + ", failed " + n3 + ", warning " + n4));
            DicomCleaner.this.progressBar.setValue(this.nFiles - n);
            DicomCleaner.this.progressBar.repaint();
            DicomCleaner.this.logger.sendLn((bl ? "Sent " : "Failed to send ") + string2);
        }
    }

    protected class ExportActionListener
    implements ActionListener {
        protected ExportActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                JFileChooser jFileChooser = new JFileChooser(DicomCleaner.this.exportDirectoryPath);
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(null) == 0) {
                    try {
                        DicomCleaner.this.exportDirectoryPath = jFileChooser.getSelectedFile().getCanonicalPath();
                        File file = new File(DicomCleaner.this.exportDirectoryPath);
                        new Thread(new ExportWorker(DicomCleaner.this.currentDestinationFilePathSelections, file)).start();
                    }
                    catch (Exception exception) {
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Export failed: " + exception));
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    protected class ExportWorker
    implements Runnable {
        Vector destinationFilePathSelections;
        File exportDirectory;

        ExportWorker(Vector vector, File file) {
            this.destinationFilePathSelections = vector;
            this.exportDirectory = file;
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            DicomCleaner.this.logger.sendLn("Export started");
            try {
                Object object;
                Object object2;
                Object object3;
                int n = this.destinationFilePathSelections.size();
                DicomCleaner.this.progressBar.setMaximum(n + 1);
                DicomCleaner.this.progressBar.setStringPainted(true);
                DicomCleaner.this.progressBar.repaint();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    object3 = (String)this.destinationFilePathSelections.get(i);
                    object2 = DicomCleaner.this.makeNewFullyQualifiedInterchangeMediaInstancePathName(i);
                    object = new File(this.exportDirectory, (String)object2);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Exporting " + (String)object2));
                    DicomCleaner.this.logger.sendLn("Exporting " + (String)object3 + " to " + ((File)object).getCanonicalPath());
                    ((File)object).getParentFile().mkdirs();
                    CopyStream.copy(new File((String)object3), (File)object);
                    stringArray[i] = object2;
                    DicomCleaner.this.progressBar.setValue(i + 1);
                    DicomCleaner.this.progressBar.repaint();
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Exporting DICOMDIR"));
                DicomCleaner.this.logger.sendLn("Exporting DICOMDIR");
                DicomDirectory dicomDirectory = new DicomDirectory(this.exportDirectory, stringArray);
                dicomDirectory.write(new File(this.exportDirectory, nameForDicomDirectoryOnInterchangeMedia).getCanonicalPath());
                DicomCleaner.this.progressBar.setValue(n + 1);
                DicomCleaner.this.progressBar.repaint();
                if (DicomCleaner.this.zipExportCheckBox.isSelected()) {
                    Object object4;
                    Object object5;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Zipping exported files"));
                    DicomCleaner.this.logger.sendLn("Zipping exported files");
                    object3 = new File(this.exportDirectory, exportedZipFileName);
                    ((File)object3).delete();
                    object2 = new FileOutputStream((File)object3);
                    object = new ZipOutputStream((OutputStream)object2);
                    ((ZipOutputStream)object).setMethod(8);
                    ((ZipOutputStream)object).setLevel(9);
                    DicomCleaner.this.progressBar.setMaximum(n + 1);
                    DicomCleaner.this.progressBar.setStringPainted(true);
                    DicomCleaner.this.progressBar.repaint();
                    DicomCleaner.this.progressBar.setValue(0);
                    for (int i = 0; i < n; ++i) {
                        object5 = stringArray[i];
                        object4 = new File(this.exportDirectory, (String)object5);
                        ZipEntry zipEntry = new ZipEntry((String)object5);
                        ((ZipOutputStream)object).putNextEntry(zipEntry);
                        FileInputStream fileInputStream = new FileInputStream((File)object4);
                        CopyStream.copy(fileInputStream, (OutputStream)object);
                        ((ZipOutputStream)object).closeEntry();
                        fileInputStream.close();
                        ((File)object4).delete();
                        DicomCleaner.this.progressBar.setValue(i + 1);
                        DicomCleaner.this.progressBar.repaint();
                    }
                    File file = new File(this.exportDirectory, nameForDicomDirectoryOnInterchangeMedia);
                    object5 = new ZipEntry(nameForDicomDirectoryOnInterchangeMedia);
                    ((ZipEntry)object5).setMethod(8);
                    ((ZipOutputStream)object).putNextEntry((ZipEntry)object5);
                    object4 = new FileInputStream(file);
                    CopyStream.copy((InputStream)object4, (OutputStream)object);
                    ((ZipOutputStream)object).closeEntry();
                    ((FileInputStream)object4).close();
                    file.delete();
                    DicomCleaner.this.progressBar.setValue(n + 1);
                    DicomCleaner.this.progressBar.repaint();
                    ((ZipOutputStream)object).close();
                    ((FileOutputStream)object2).close();
                    new File(this.exportDirectory, rootNameForDicomInstanceFilesOnInterchangeMedia).delete();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Export failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DicomCleaner.this.progressBar.setValue(DicomCleaner.this.progressBar.getMaximum());
            DicomCleaner.this.progressBar.setStringPainted(false);
            DicomCleaner.this.progressBar.repaint();
            DicomCleaner.this.logger.sendLn("Export complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done exporting to " + this.exportDirectory));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class ImportActionListener
    implements ActionListener {
        protected ImportActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.logger instanceof DialogMessageLogger) {
                    ((DialogMessageLogger)DicomCleaner.this.logger).setVisible(true);
                }
                new Thread(new ImportWorker("/", DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel)).start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class ImportWorker
    implements Runnable {
        MediaImporter importer;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;

        ImportWorker(String string, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.importer = new OurMediaImporter(string, DicomCleaner.this.logger, DicomCleaner.this.progressBar);
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            DicomCleaner.this.logger.sendLn("Import starting");
            DicomCleaner.this.progressBar.setStringPainted(true);
            DicomCleaner.this.progressBar.repaint();
            try {
                this.importer.choosePathAndImportDicomFiles();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.srcDatabasePanel.validate();
            DicomCleaner.this.progressBar.setValue(DicomCleaner.this.progressBar.getMaximum());
            DicomCleaner.this.progressBar.setStringPainted(false);
            DicomCleaner.this.progressBar.repaint();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done importing"));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        protected boolean canUseBzip;

        public OurMediaImporter(String string, MessageLogger messageLogger, JProgressBar jProgressBar) {
            super(string, messageLogger, jProgressBar);
            this.canUseBzip = PresentationContextListFactory.haveBzip2Support();
        }

        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomCleaner.importFileIntoDatabase(DicomCleaner.this.srcDatabase, string, "R");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        protected boolean isOKToImport(String string, String string2) {
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.2.840.10008.1.2.1.99") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.4.50") || DicomCleaner.this.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || DicomCleaner.this.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")));
        }
    }

    protected class CleanActionListener
    implements ActionListener {
        protected CleanActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DicomCleaner.this.activeThread = new Thread(new CleanWorker(DicomCleaner.this.currentSourceFilePathSelections, DicomCleaner.this.dstDatabase, DicomCleaner.this.dstDatabasePanel));
                DicomCleaner.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaned failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class CleanWorker
    implements Runnable {
        Vector sourceFilePathSelections;
        DatabaseInformationModel dstDatabase;
        JPanel dstDatabasePanel;

        CleanWorker(Vector vector, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.sourceFilePathSelections = vector;
            this.dstDatabase = databaseInformationModel;
            this.dstDatabasePanel = jPanel;
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            DicomCleaner.this.logger.sendLn("Cleaning started");
            DicomCleaner.this.progressBar.setStringPainted(true);
            DicomCleaner.this.progressBar.repaint();
            try {
                DicomCleaner.this.copyFromOriginalToCleanedPerformingAction(this.sourceFilePathSelections, DicomCleaner.this.logger, DicomCleaner.this.progressBar);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaned failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.dstDatabasePanel.removeAll();
            try {
                new OurDestinationDatabaseTreeBrowser(this.dstDatabase, this.dstDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh destination database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            this.dstDatabasePanel.validate();
            DicomCleaner.this.progressBar.setValue(DicomCleaner.this.progressBar.getMaximum());
            DicomCleaner.this.progressBar.setStringPainted(false);
            DicomCleaner.this.progressBar.repaint();
            DicomCleaner.this.logger.sendLn("Cleaning complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done cleaning"));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class PurgeActionListener
    implements ActionListener {
        protected PurgeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DicomCleaner.this.activeThread = new Thread(new PurgeWorker());
                DicomCleaner.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
        }
    }

    protected class PurgeWorker
    implements Runnable {
        protected PurgeWorker() {
        }

        public void run() {
            Cursor cursor = DicomCleaner.this.getCursor();
            DicomCleaner.this.setCursor(Cursor.getPredefinedCursor(3));
            DicomCleaner.this.logger.sendLn("Purging started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging started"));
            DicomCleaner.this.progressBar.setStringPainted(true);
            DicomCleaner.this.progressBar.repaint();
            try {
                DicomCleaner.this.purgeFilesAndDatabaseInformation(DicomCleaner.this.currentSourceDatabaseSelection, DicomCleaner.this.logger, DicomCleaner.this.progressBar, 0, 1);
                DicomCleaner.this.purgeFilesAndDatabaseInformation(DicomCleaner.this.currentDestinationDatabaseSelection, DicomCleaner.this.logger, DicomCleaner.this.progressBar, 0, 1);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DicomCleaner.this.srcDatabasePanel.removeAll();
            DicomCleaner.this.dstDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel);
                new OurDestinationDatabaseTreeBrowser(DicomCleaner.this.dstDatabase, DicomCleaner.this.dstDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                exception.printStackTrace(System.err);
            }
            DicomCleaner.this.srcDatabasePanel.validate();
            DicomCleaner.this.progressBar.setValue(DicomCleaner.this.progressBar.getMaximum());
            DicomCleaner.this.progressBar.setStringPainted(false);
            DicomCleaner.this.progressBar.repaint();
            DicomCleaner.this.logger.sendLn("Purging complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done purging"));
            DicomCleaner.this.setCursor(cursor);
        }
    }

    protected class OurDestinationDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurDestinationDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        protected boolean doSomethingWithSelection(DatabaseTreeRecord databaseTreeRecord) {
            DicomCleaner.this.currentDestinationDatabaseSelection = databaseTreeRecord;
            return false;
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomCleaner.this.currentDestinationFilePathSelections = vector;
        }
    }

    protected class OurSourceDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurSourceDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        protected boolean doSomethingWithSelection(DatabaseTreeRecord databaseTreeRecord) {
            DicomCleaner.this.currentSourceDatabaseSelection = databaseTreeRecord;
            return false;
        }

        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomCleaner.this.currentSourceFilePathSelections = vector;
        }
    }

    class OurTransferSyntaxSelectionPolicy
    extends TransferSyntaxSelectionPolicy {
        OurTransferSyntaxSelectionPolicy() {
        }

        public LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList, int n, int n2) {
            boolean bl = PresentationContextListFactory.haveBzip2Support();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                List list = presentationContext.getTransferSyntaxUIDs();
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    String string = (String)listIterator2.next();
                    if (string == null) continue;
                    if (string.equals("1.2.840.10008.1.2")) {
                        bl3 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1")) {
                        bl2 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.2")) {
                        bl4 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1.99")) {
                        bl5 = true;
                        continue;
                    }
                    if (string.equals("1.3.6.1.4.1.5962.300.1")) {
                        bl6 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.50")) {
                        bl7 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.57")) {
                        bl8 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.70")) {
                        bl9 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.91")) {
                        bl10 = true;
                        continue;
                    }
                    if (!string.equals("1.2.840.10008.1.2.4.90")) continue;
                    bl11 = true;
                }
                presentationContext.newTransferSyntaxUIDs();
                if (bl6 && bl) {
                    presentationContext.addTransferSyntaxUID("1.3.6.1.4.1.5962.300.1");
                    continue;
                }
                if (bl5) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1.99");
                    continue;
                }
                if (bl2) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1");
                    continue;
                }
                if (bl4) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.2");
                    continue;
                }
                if (bl3) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2");
                    continue;
                }
                if (bl7) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.50");
                    continue;
                }
                if (bl8 && DicomCleaner.this.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.57");
                    continue;
                }
                if (bl9 && DicomCleaner.this.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.70");
                    continue;
                }
                if (bl10 && DicomCleaner.this.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.91");
                    continue;
                }
                if (bl11 && DicomCleaner.this.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.90");
                    continue;
                }
                presentationContext.setResultReason((byte)4);
            }
            return linkedList;
        }
    }

    class OurPresentationContextSelectionPolicy
    extends UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy {
        OurPresentationContextSelectionPolicy() {
            this.transferSyntaxSelectionPolicy = new OurTransferSyntaxSelectionPolicy();
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                String string4 = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string3);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Received " + string + " from " + string3 + " in " + string2));
                DicomCleaner.this.logger.sendLn("Received " + string + " from " + string4 + " (" + string3 + ")");
                try {
                    DicomCleaner.importFileIntoDatabase(DicomCleaner.this.srcDatabase, string, "C");
                    DicomCleaner.this.srcDatabasePanel.removeAll();
                    new OurSourceDatabaseTreeBrowser(DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel);
                    DicomCleaner.this.srcDatabasePanel.validate();
                    new File(string).deleteOnExit();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

