/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.display.SourceImage;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class ImageEditUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ImageEditUtilities.java,v 1.16 2010/04/30 17:01:14 dclunie Exp $";

    private ImageEditUtilities() {
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector) throws DicomException {
        ImageEditUtilities.blackout(sourceImage, attributeList, vector, false, false, false, 0);
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector, boolean bl) throws DicomException {
        ImageEditUtilities.blackout(sourceImage, attributeList, vector, bl, false, false, 0);
    }

    public static void blackout(SourceImage sourceImage, AttributeList attributeList, Vector vector, boolean bl, boolean bl2, boolean bl3, int n) throws DicomException {
        Object object;
        int n2;
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, n4 - 1);
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        byte[] byArray = null;
        Object[] objectArray = null;
        Attribute attribute = null;
        Overlay overlay = sourceImage.getOverlay();
        boolean bl4 = sourceImage.isInverted();
        boolean bl5 = sourceImage.isSigned();
        int n11 = sourceImage.getMaskValue();
        int n12 = 0;
        int n13 = sourceImage.getNumberOfBufferedImages();
        boolean bl6 = true;
        for (n2 = 0; n2 < n13; ++n2) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            Object object22;
            int n23;
            Object object3;
            short s;
            short s2;
            int n24;
            int n25;
            object = sourceImage.getBufferedImage(n2);
            n10 = ((BufferedImage)object).getWidth();
            n9 = ((BufferedImage)object).getHeight();
            SampleModel sampleModel = ((BufferedImage)object).getSampleModel();
            int n26 = sampleModel.getDataType();
            WritableRaster writableRaster = ((BufferedImage)object).getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n27 = dataBuffer.getDataType();
            int n28 = n25 = writableRaster.getNumBands();
            int n29 = n10 * n25;
            if (n25 > 1 && sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                n28 = componentSampleModel.getPixelStride();
                n29 = componentSampleModel.getScanlineStride();
                n8 = n28 == n25 ? 0 : 1;
            }
            int n30 = dataBuffer.getOffset();
            int n31 = n9 * n10 * n25;
            int n32 = dataBuffer.getNumBanks();
            if (n32 > 1) {
                throw new DicomException("Unsupported type of image - DataBuffer number of banks is > 1, is " + n32);
            }
            int n33 = n8 == 0 ? n25 : 1;
            int n34 = n24 = n8 == 0 ? 1 : n9 * n10;
            if (n27 == 0) {
                int n35;
                s2 = (short)(bl3 ? n : (bl2 && sourceImage.isPadded() ? sourceImage.getPadValue() : (bl4 ? (bl5 ? n11 >> 1 : n11) : (bl5 ? (n11 >> 1) + 1 : 0))));
                s = (short)(bl4 ? (bl5 ? (n11 >> 1) + 1 : 0) : (bl5 ? n11 >> 1 : n11));
                object3 = null;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_BYTE but not instance of DataBufferByte, is " + dataBuffer.getClass().getName());
                }
                object3 = ((DataBufferByte)dataBuffer).getBankData();
                n23 = object3[0].length;
                if (byArray == null) {
                    if (n3 > 8) {
                        n3 = 8;
                    }
                    if (n4 > 8) {
                        n4 = 8;
                    }
                    if (n5 > 7) {
                        n5 = 7;
                    }
                    n6 = n25;
                    n35 = n31 * n13;
                    if (n35 == n23) {
                        byArray = object3[0];
                        bl6 = false;
                    } else {
                        byArray = new byte[n35];
                    }
                    attribute = new OtherByteAttribute(TagFromName.PixelData);
                    attribute.setValues(byArray);
                }
                if (bl6) {
                    System.arraycopy(object3[0], n30, byArray, n12, n31);
                }
                if (bl && overlay != null && overlay.getNumberOfOverlays(n2) > 0) {
                    for (n35 = 0; n35 < 16; ++n35) {
                        object22 = overlay.getOverlayAsBinaryBufferedImage(n2, n35);
                        if (object22 == null) continue;
                        int n36 = overlay.getRowOrigin(n2, n35);
                        n22 = overlay.getColumnOrigin(n2, n35);
                        for (n21 = 0; n21 < ((BufferedImage)object22).getHeight(); ++n21) {
                            for (n20 = 0; n20 < ((BufferedImage)object22).getWidth(); ++n20) {
                                n19 = ((BufferedImage)object22).getRGB(n20, n21);
                                if (n19 == 0) continue;
                                n18 = n22 + n20 + 1;
                                n17 = n36 + n21 + 1;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n33 + n15 * n24;
                                    byArray[n14] = s2;
                                }
                            }
                        }
                        for (n21 = 0; n21 < ((BufferedImage)object22).getHeight(); ++n21) {
                            for (n20 = 0; n20 < ((BufferedImage)object22).getWidth(); ++n20) {
                                n19 = ((BufferedImage)object22).getRGB(n20, n21);
                                if (n19 == 0) continue;
                                n18 = n22 + n20;
                                n17 = n36 + n21;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n33 + n15 * n24;
                                    byArray[n14] = s;
                                }
                            }
                        }
                    }
                }
                if (vector != null) {
                    for (Object object22 : vector) {
                        if (!(object22 instanceof RectangularShape)) continue;
                        RectangularShape rectangularShape = (RectangularShape)object22;
                        n22 = (int)rectangularShape.getX();
                        n21 = (int)rectangularShape.getY();
                        n20 = (int)((double)n22 + rectangularShape.getWidth());
                        n19 = (int)((double)n21 + rectangularShape.getHeight());
                        for (n18 = n21; n18 < n19; ++n18) {
                            n17 = n18 * n10 + n22;
                            for (n16 = n22; n16 < n20; ++n16) {
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n17 * n33 + n15 * n24;
                                    byArray[n14] = s2;
                                }
                                ++n17;
                            }
                        }
                    }
                }
                n12 += n31;
                continue;
            }
            if (n27 == 1 || n27 == 2) {
                s2 = (short)(bl3 ? n : (bl2 && sourceImage.isPadded() ? sourceImage.getPadValue() : (bl4 ? (bl5 ? n11 >> 1 : n11) : (bl5 ? (n11 >> 1) + 1 : 0))));
                s = (short)(bl4 ? (bl5 ? (n11 >> 1) + 1 : 0) : (bl5 ? n11 >> 1 : n11));
                object3 = null;
                if (dataBuffer instanceof DataBufferShort) {
                    object3 = ((DataBufferShort)dataBuffer).getBankData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    object3 = ((DataBufferUShort)dataBuffer).getBankData();
                } else {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_USHORT or TYPE_SHORT but not instance of DataBufferShort, is " + dataBuffer.getClass().getName());
                }
                n23 = object3[0].length;
                if (objectArray == null) {
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    if (n4 > 16) {
                        n4 = 16;
                    }
                    if (n5 > 15) {
                        n5 = 15;
                    }
                    n6 = n25;
                    int n37 = n31 * n13;
                    if (n37 == n23) {
                        objectArray = object3[0];
                        bl6 = false;
                    } else {
                        objectArray = new short[n37];
                    }
                    attribute = new OtherWordAttribute(TagFromName.PixelData);
                    attribute.setValues((short[])objectArray);
                }
                if (bl6) {
                    System.arraycopy(object3[0], n30, objectArray, n12, n31);
                }
                if (bl && overlay != null && overlay.getNumberOfOverlays(n2) > 0) {
                    for (int i = 0; i < 16; ++i) {
                        object22 = overlay.getOverlayAsBinaryBufferedImage(n2, i);
                        if (object22 == null) continue;
                        int n38 = overlay.getRowOrigin(n2, i);
                        n22 = overlay.getColumnOrigin(n2, i);
                        for (n21 = 0; n21 < ((BufferedImage)object22).getHeight(); ++n21) {
                            for (n20 = 0; n20 < ((BufferedImage)object22).getWidth(); ++n20) {
                                n19 = ((BufferedImage)object22).getRGB(n20, n21);
                                if (n19 == 0) continue;
                                n18 = n22 + n20 + 1;
                                n17 = n38 + n21 + 1;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n33 + n15 * n24;
                                    objectArray[n14] = s2;
                                }
                            }
                        }
                        for (n21 = 0; n21 < ((BufferedImage)object22).getHeight(); ++n21) {
                            for (n20 = 0; n20 < ((BufferedImage)object22).getWidth(); ++n20) {
                                n19 = ((BufferedImage)object22).getRGB(n20, n21);
                                if (n19 == 0) continue;
                                n18 = n22 + n20;
                                n17 = n38 + n21;
                                if (n18 >= n10 || n17 >= n9) continue;
                                n16 = n17 * n10 + n18;
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n16 * n33 + n15 * n24;
                                    objectArray[n14] = s;
                                }
                            }
                        }
                    }
                }
                if (vector != null) {
                    for (Object object22 : vector) {
                        if (!(object22 instanceof RectangularShape)) continue;
                        RectangularShape rectangularShape = (RectangularShape)object22;
                        n22 = (int)rectangularShape.getX();
                        n21 = (int)rectangularShape.getY();
                        n20 = (int)((double)n22 + rectangularShape.getWidth());
                        n19 = (int)((double)n21 + rectangularShape.getHeight());
                        for (n18 = n21; n18 < n19; ++n18) {
                            n17 = n18 * n10 + n22;
                            for (n16 = n22; n16 < n20; ++n16) {
                                for (n15 = 0; n15 < n25; ++n15) {
                                    n14 = n12 + n17 * n33 + n15 * n24;
                                    objectArray[n14] = s2;
                                }
                                ++n17;
                            }
                        }
                    }
                }
                n12 += n31;
                continue;
            }
            throw new DicomException("Unsupported pixel data form - DataBufferType = " + n27);
        }
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.BitsAllocated);
        attributeList.remove(TagFromName.BitsStored);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.SamplesPerPixel);
        attributeList.remove(TagFromName.PixelRepresentation);
        attributeList.remove(TagFromName.PhotometricInterpretation);
        attributeList.remove(TagFromName.PlanarConfiguration);
        n2 = attributeList.get(TagFromName.NumberOfFrames) != null ? 1 : 0;
        attributeList.remove(TagFromName.NumberOfFrames);
        if (bl) {
            attributeList.removeOverlayAttributes();
        }
        attributeList.put(attribute);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(n3);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object).addValue(n4);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object).addValue(n5);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object).addValue(n9);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object).addValue(n10);
        attributeList.put((Attribute)object);
        if (n13 > 1 || n2 != 0) {
            object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object).addValue(n13);
            attributeList.put((Attribute)object);
        }
        object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object).addValue(n6);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(n7);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        if (n6 > 1) {
            object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object).addValue(n8);
            attributeList.put((Attribute)object);
        }
        sourceImage.constructSourceImage(attributeList);
    }

    public static final int getOffsetIntoMatrix(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = 0;
        if (n6 == 0) {
            n7 = n + n2 * n5 + (bl ? n5 - n3 - 1 : n3);
        } else if (n6 == 90) {
            n7 = n + n3 * n4 + (bl ? n2 : n4 - n2 - 1);
        } else if (n6 == 180) {
            n7 = n + (n4 - n2 - 1) * n5 + (bl ? n3 : n5 - n3 - 1);
        } else if (n6 == 270) {
            n7 = n + (n5 - n3 - 1) * n4 + (bl ? n4 - n2 - 1 : n2);
        }
        return n7;
    }

    public static final int getOffsetIntoMatrix(int n, int n2, int n3, int n4) {
        return ImageEditUtilities.getOffsetIntoMatrix(n, n2, n3, 0, n4, 0, false);
    }

    public static void rotateAndFlip(SourceImage sourceImage, AttributeList attributeList, int n, boolean bl) throws DicomException {
        Object object;
        int n2;
        if (n % 90 != 0) {
            throw new DicomException("Rotation of " + n + " not supported");
        }
        while (n >= 360) {
            n -= 360;
        }
        while (n < 0) {
            n += 360;
        }
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 0);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, n4 - 1);
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray = null;
        short[] sArray = null;
        Attribute attribute = null;
        int n13 = 0;
        int n14 = sourceImage.getNumberOfBufferedImages();
        for (n2 = 0; n2 < n14; ++n2) {
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            Object object2;
            int n21;
            int n22;
            object = sourceImage.getBufferedImage(n2);
            n10 = ((BufferedImage)object).getWidth();
            n9 = ((BufferedImage)object).getHeight();
            n12 = n == 90 || n == 270 ? n9 : n10;
            n11 = n == 90 || n == 270 ? n10 : n9;
            SampleModel sampleModel = ((BufferedImage)object).getSampleModel();
            int n23 = sampleModel.getDataType();
            WritableRaster writableRaster = ((BufferedImage)object).getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            int n24 = dataBuffer.getDataType();
            int n25 = n22 = writableRaster.getNumBands();
            int n26 = n10 * n22;
            if (n22 > 1 && sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                n25 = componentSampleModel.getPixelStride();
                n26 = componentSampleModel.getScanlineStride();
                n8 = n25 == n22 ? 0 : 1;
            }
            int n27 = dataBuffer.getOffset();
            int n28 = n9 * n10 * n22;
            int n29 = dataBuffer.getNumBanks();
            if (n29 > 1) {
                throw new DicomException("Unsupported type of image - DataBuffer number of banks is > 1, is " + n29);
            }
            int n30 = n8 == 0 ? 1 : n9 * n10;
            int n31 = n8 == 0 ? n22 : 1;
            int n32 = n21 = n8 == 0 ? 1 : n9 * n10;
            if (n24 == 0) {
                object2 = null;
                if (!(dataBuffer instanceof DataBufferByte)) {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_BYTE but not instance of DataBufferByte, is " + dataBuffer.getClass().getName());
                }
                object2 = ((DataBufferByte)dataBuffer).getBankData();
                n20 = object2[0].length;
                if (byArray == null) {
                    if (n3 > 8) {
                        n3 = 8;
                    }
                    if (n4 > 8) {
                        n4 = 8;
                    }
                    if (n5 > 7) {
                        n5 = 7;
                    }
                    n6 = n22;
                    n19 = n28 * n14;
                    byArray = new byte[n19];
                    attribute = new OtherByteAttribute(TagFromName.PixelData);
                    attribute.setValues(byArray);
                }
                for (n19 = 0; n19 < n9; ++n19) {
                    for (n18 = 0; n18 < n10; ++n18) {
                        n17 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n10);
                        n16 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n9, n10, n, bl);
                        for (n15 = 0; n15 < n22; ++n15) {
                            byArray[n13 + n16 * n31 + n15 * n21] = object2[0][n27 + n17 * n25 + n15 * n30];
                        }
                    }
                }
                n13 += n28;
                continue;
            }
            if (n24 == 1 || n24 == 2) {
                object2 = null;
                if (dataBuffer instanceof DataBufferShort) {
                    object2 = ((DataBufferShort)dataBuffer).getBankData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    object2 = ((DataBufferUShort)dataBuffer).getBankData();
                } else {
                    throw new DicomException("Unsupported type of image - DataBuffer is TYPE_USHORT or TYPE_SHORT but not instance of DataBufferShort, is " + dataBuffer.getClass().getName());
                }
                n20 = object2[0].length;
                if (sArray == null) {
                    if (n3 > 16) {
                        n3 = 16;
                    }
                    if (n4 > 16) {
                        n4 = 16;
                    }
                    if (n5 > 15) {
                        n5 = 15;
                    }
                    n6 = n22;
                    n19 = n28 * n14;
                    sArray = new short[n19];
                    attribute = new OtherWordAttribute(TagFromName.PixelData);
                    attribute.setValues(sArray);
                }
                for (n19 = 0; n19 < n9; ++n19) {
                    for (n18 = 0; n18 < n10; ++n18) {
                        n17 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n10);
                        n16 = ImageEditUtilities.getOffsetIntoMatrix(0, n19, n18, n9, n10, n, bl);
                        for (n15 = 0; n15 < n22; ++n15) {
                            sArray[n13 + n16 * n31 + n15 * n21] = object2[0][n27 + n17 * n25 + n15 * n30];
                        }
                    }
                }
                n13 += n28;
                continue;
            }
            throw new DicomException("Unsupported pixel data form - DataBufferType = " + n24);
        }
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.BitsAllocated);
        attributeList.remove(TagFromName.BitsStored);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.SamplesPerPixel);
        attributeList.remove(TagFromName.PixelRepresentation);
        attributeList.remove(TagFromName.PhotometricInterpretation);
        attributeList.remove(TagFromName.PlanarConfiguration);
        n2 = attributeList.get(TagFromName.NumberOfFrames) != null ? 1 : 0;
        attributeList.remove(TagFromName.NumberOfFrames);
        attributeList.put(attribute);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(n3);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object).addValue(n4);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object).addValue(n5);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object).addValue(n11);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object).addValue(n12);
        attributeList.put((Attribute)object);
        if (n14 > 1 || n2 != 0) {
            object = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object).addValue(n14);
            attributeList.put((Attribute)object);
        }
        object = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object).addValue(n6);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(n7);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object).addValue(string);
        attributeList.put((Attribute)object);
        if (n6 > 1) {
            object = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object).addValue(n8);
            attributeList.put((Attribute)object);
        }
        sourceImage.constructSourceImage(attributeList);
    }
}

