/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotation;
import com.pixelmed.event.EventContext;
import com.pixelmed.geometry.GeometryOfVolume;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SingleImagePanelWithLineDrawing
extends SingleImagePanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanelWithLineDrawing.java,v 1.2 2009/04/06 16:13:49 dclunie Exp $";
    protected Point2D startPoint;
    static final int crossSize = 5;

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, geometryOfVolume);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext) {
        super(sourceImage, eventContext);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage) {
        super(sourceImage);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            this.setSelectedDrawingShapes(null);
            this.repaint();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.checkForHitOnPersistentShapes(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dragInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.startInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.endInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    protected void startInteractiveDrawing(int n, int n2) {
        this.startPoint = this.getImageCoordinateFromWindowCoordinate(n, n2);
    }

    protected void dragInteractiveDrawing(int n, int n2) {
        int n3 = (int)this.startPoint.getX();
        int n4 = (int)this.startPoint.getY();
        Point point = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n5 = (int)point.getX();
        int n6 = (int)point.getY();
        if (n3 != n5 || n4 != n6) {
            this.interactiveDrawingShapes = new Vector();
            this.interactiveDrawingShapes.add(new Line2D.Float(this.startPoint, point));
            this.repaint();
        }
    }

    protected void endInteractiveDrawing(int n, int n2) {
        int n3 = (int)this.startPoint.getX();
        int n4 = (int)this.startPoint.getY();
        Point point = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n5 = (int)point.getX();
        int n6 = (int)point.getY();
        if (n3 != n5 || n4 != n6) {
            int n7 = n5 - n3;
            int n8 = n6 - n4;
            double d = Math.sqrt(n7 * n7 + n8 * n8);
            DecimalFormat decimalFormat = new DecimalFormat("###.#");
            String string = decimalFormat.format(d * this.pixelSpacingInSourceImage) + " mm" + (this.typeOfPixelSpacing == null ? " " : " (" + this.typeOfPixelSpacing + ")");
            System.err.println("Length=" + d + " pixels, " + string);
            this.interactiveDrawingShapes = null;
            if (this.persistentDrawingShapes == null) {
                this.persistentDrawingShapes = new Vector();
            }
            this.persistentDrawingShapes.add(new Line2D.Float(this.startPoint, point));
            if (this.persistentDrawingText == null) {
                this.persistentDrawingText = new Vector();
            }
            this.persistentDrawingText.add(new TextAnnotation(string, n5, n6));
            this.repaint();
        }
    }

    protected void checkForHitOnPersistentShapes(int n, int n2) {
        Shape shape;
        Iterator iterator;
        Point point = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        boolean bl = false;
        Vector<Shape> vector = new Vector<Shape>();
        if (this.selectedDrawingShapes != null) {
            iterator = this.selectedDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(n3, n4)) continue;
                vector.add(shape);
                if (this.persistentDrawingShapes == null) {
                    this.persistentDrawingShapes = new Vector();
                }
                this.persistentDrawingShapes.add(shape);
                this.selectedDrawingShapes.remove(shape);
                iterator = this.selectedDrawingShapes.iterator();
                bl = true;
            }
        }
        if (this.persistentDrawingShapes != null) {
            iterator = this.persistentDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(n3, n4)) continue;
                if (this.selectedDrawingShapes == null) {
                    this.selectedDrawingShapes = new Vector();
                }
                this.selectedDrawingShapes.add(shape);
                this.persistentDrawingShapes.remove(shape);
                iterator = this.persistentDrawingShapes.iterator();
                bl = true;
            }
        }
        if (bl) {
            this.repaint();
        }
    }
}

