/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.VOIFunctionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SourceImageVOILUTSelectorPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImageVOILUTSelectorPanel.java,v 1.5 2005/09/28 10:50:47 dclunie Exp $";
    private EventContext eventContext;
    private ButtonGroup voiLUTShapeButtons;
    private JRadioButton linearButton;
    private JRadioButton logisticButton;

    public void sendEventCorrespondingToCurrentButtonState() {
        String string = this.voiLUTShapeButtons.getSelection().getActionCommand();
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new VOIFunctionChangeEvent(this.eventContext, string));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public SourceImageVOILUTSelectorPanel(EventContext eventContext) {
        this.eventContext = eventContext;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Use VOI LUT shape:"));
        this.voiLUTShapeButtons = new ButtonGroup();
        VOILUTShapeActionListener vOILUTShapeActionListener = new VOILUTShapeActionListener();
        this.linearButton = new JRadioButton("linear", true);
        this.linearButton.setActionCommand("LIN");
        this.linearButton.setToolTipText("Use linear ramp");
        this.linearButton.addActionListener(vOILUTShapeActionListener);
        this.voiLUTShapeButtons.add(this.linearButton);
        jPanel.add(this.linearButton);
        this.logisticButton = new JRadioButton("logistic", false);
        this.logisticButton.setActionCommand("LOG");
        this.logisticButton.setToolTipText("Use logistic curve with window center and width parameters");
        this.logisticButton.addActionListener(vOILUTShapeActionListener);
        this.voiLUTShapeButtons.add(this.logisticButton);
        jPanel.add(this.logisticButton);
    }

    private class VOILUTShapeActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SourceImageVOILUTSelectorPanel.this.sendEventCorrespondingToCurrentButtonState();
        }
    }
}

