/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.utils.FloatFormatter;

public class CTAcquisitionParameters {
    protected String irradiationEventUID;
    protected CTScanType scanType;
    protected CodedSequenceItem anatomy;
    protected String exposureTimeInSeconds;
    protected String scanningLengthInMM;
    protected String nominalSingleCollimationWidthInMM;
    protected String nominalTotalCollimationWidthInMM;
    protected String pitchFactor;
    protected String kvp;
    protected String tubeCurrent;
    protected String tubeCurrentMaximum;
    protected String exposureTimePerRotation;
    protected ContentItem contentItemFragment;

    public boolean equals(Object object) {
        CTAcquisitionParameters cTAcquisitionParameters;
        boolean bl = false;
        bl = object instanceof CTAcquisitionParameters ? ((cTAcquisitionParameters = (CTAcquisitionParameters)object).getIrradiationEventUID() == null && this.getIrradiationEventUID() == null || cTAcquisitionParameters.getIrradiationEventUID().equals(this.getIrradiationEventUID())) && (cTAcquisitionParameters.getScanType() == null && this.getScanType() == null || cTAcquisitionParameters.getScanType().equals(this.getScanType())) && (cTAcquisitionParameters.getAnatomy() == null && this.getAnatomy() == null || cTAcquisitionParameters.getAnatomy().equals(this.getAnatomy())) && (cTAcquisitionParameters.getExposureTimeInSeconds() == null && this.getExposureTimeInSeconds() == null || cTAcquisitionParameters.getExposureTimeInSeconds().equals(this.getExposureTimeInSeconds())) && (cTAcquisitionParameters.getScanningLengthInMM() == null && this.getScanningLengthInMM() == null || cTAcquisitionParameters.getScanningLengthInMM().equals(this.getScanningLengthInMM())) && (cTAcquisitionParameters.getNominalSingleCollimationWidthInMM() == null && this.getNominalSingleCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalSingleCollimationWidthInMM().equals(this.getNominalSingleCollimationWidthInMM())) && (cTAcquisitionParameters.getNominalTotalCollimationWidthInMM() == null && this.getNominalTotalCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalTotalCollimationWidthInMM().equals(this.getNominalTotalCollimationWidthInMM())) && (cTAcquisitionParameters.getPitchFactor() == null && this.getPitchFactor() == null || cTAcquisitionParameters.getPitchFactor().equals(this.getPitchFactor())) && (cTAcquisitionParameters.getKVP() == null && this.getKVP() == null || cTAcquisitionParameters.getKVP().equals(this.getKVP())) && (cTAcquisitionParameters.getTubeCurrent() == null && this.getTubeCurrent() == null || cTAcquisitionParameters.getTubeCurrent().equals(this.getTubeCurrent())) && (cTAcquisitionParameters.getTubeCurrentMaximum() == null && this.getTubeCurrentMaximum() == null || cTAcquisitionParameters.getTubeCurrentMaximum().equals(this.getTubeCurrentMaximum())) && (cTAcquisitionParameters.getExposureTimePerRotation() == null && this.getExposureTimePerRotation() == null || cTAcquisitionParameters.getExposureTimePerRotation().equals(this.getExposureTimePerRotation())) : false;
        return bl;
    }

    public boolean equalsApartFromIrradiationEventUID(Object object) {
        CTAcquisitionParameters cTAcquisitionParameters;
        boolean bl = false;
        bl = object instanceof CTAcquisitionParameters ? ((cTAcquisitionParameters = (CTAcquisitionParameters)object).getScanType() == null && this.getScanType() == null || cTAcquisitionParameters.getScanType().equals(this.getScanType())) && (cTAcquisitionParameters.getAnatomy() == null && this.getAnatomy() == null || cTAcquisitionParameters.getAnatomy().equals(this.getAnatomy())) && (cTAcquisitionParameters.getExposureTimeInSeconds() == null && this.getExposureTimeInSeconds() == null || cTAcquisitionParameters.getExposureTimeInSeconds().equals(this.getExposureTimeInSeconds())) && (cTAcquisitionParameters.getScanningLengthInMM() == null && this.getScanningLengthInMM() == null || cTAcquisitionParameters.getScanningLengthInMM().equals(this.getScanningLengthInMM())) && (cTAcquisitionParameters.getNominalSingleCollimationWidthInMM() == null && this.getNominalSingleCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalSingleCollimationWidthInMM().equals(this.getNominalSingleCollimationWidthInMM())) && (cTAcquisitionParameters.getNominalTotalCollimationWidthInMM() == null && this.getNominalTotalCollimationWidthInMM() == null || cTAcquisitionParameters.getNominalTotalCollimationWidthInMM().equals(this.getNominalTotalCollimationWidthInMM())) && (cTAcquisitionParameters.getPitchFactor() == null && this.getPitchFactor() == null || cTAcquisitionParameters.getPitchFactor().equals(this.getPitchFactor())) && (cTAcquisitionParameters.getKVP() == null && this.getKVP() == null || cTAcquisitionParameters.getKVP().equals(this.getKVP())) && (cTAcquisitionParameters.getTubeCurrent() == null && this.getTubeCurrent() == null || cTAcquisitionParameters.getTubeCurrent().equals(this.getTubeCurrent())) && (cTAcquisitionParameters.getTubeCurrentMaximum() == null && this.getTubeCurrentMaximum() == null || cTAcquisitionParameters.getTubeCurrentMaximum().equals(this.getTubeCurrentMaximum())) && (cTAcquisitionParameters.getExposureTimePerRotation() == null && this.getExposureTimePerRotation() == null || cTAcquisitionParameters.getExposureTimePerRotation().equals(this.getExposureTimePerRotation())) : false;
        return bl;
    }

    public CTAcquisitionParameters(String string, CTScanType cTScanType, CodedSequenceItem codedSequenceItem, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.irradiationEventUID = string;
        this.scanType = cTScanType;
        this.anatomy = codedSequenceItem;
        this.exposureTimeInSeconds = string2;
        this.scanningLengthInMM = string3;
        this.nominalSingleCollimationWidthInMM = string4;
        this.nominalTotalCollimationWidthInMM = string5;
        this.pitchFactor = string6;
        this.kvp = string7;
        this.tubeCurrent = string8;
        this.tubeCurrentMaximum = string9;
        this.exposureTimePerRotation = string10;
    }

    public CTAcquisitionParameters(ContentItem contentItem) {
        if (contentItem != null) {
            ContentItem contentItem2;
            ContentItem contentItem3 = (ContentItem)contentItem.getParent();
            if (contentItem3 != null) {
                ContentItem contentItem4;
                this.irradiationEventUID = contentItem3.getSingleStringValueOrNullOfNamedChild("DCM", "113769");
                contentItem2 = contentItem3.getNamedChild("DCM", "113820");
                if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem) {
                    this.scanType = CTScanType.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode());
                }
                if ((contentItem4 = contentItem3.getNamedChild("DCM", "123014")) != null && contentItem4 instanceof ContentItemFactory.CodeContentItem) {
                    this.anatomy = ((ContentItemFactory.CodeContentItem)contentItem4).getConceptCode();
                }
            }
            this.exposureTimeInSeconds = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113824");
            this.scanningLengthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113825");
            this.nominalSingleCollimationWidthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113826");
            this.nominalTotalCollimationWidthInMM = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113827");
            this.pitchFactor = contentItem.getSingleStringValueOrNullOfNamedChild("DCM", "113828");
            contentItem2 = contentItem.getNamedChild("DCM", "113831");
            if (contentItem2 != null) {
                this.kvp = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113733");
                this.tubeCurrent = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113734");
                this.tubeCurrentMaximum = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113833");
                this.exposureTimePerRotation = contentItem2.getSingleStringValueOrNullOfNamedChild("DCM", "113834");
            }
        }
    }

    public String getIrradiationEventUID() {
        return this.irradiationEventUID;
    }

    public CTScanType getScanType() {
        return this.scanType;
    }

    public CodedSequenceItem getAnatomy() {
        return this.anatomy;
    }

    public String getExposureTimeInSeconds() {
        return this.exposureTimeInSeconds;
    }

    public String getScanningLengthInMM() {
        return this.scanningLengthInMM;
    }

    public String getNominalSingleCollimationWidthInMM() {
        return this.nominalSingleCollimationWidthInMM;
    }

    public String getNominalTotalCollimationWidthInMM() {
        return this.nominalTotalCollimationWidthInMM;
    }

    public String getPitchFactor() {
        return this.pitchFactor;
    }

    public String getKVP() {
        return this.kvp;
    }

    public String getTubeCurrent() {
        return this.tubeCurrent;
    }

    public String getTubeCurrentMaximum() {
        return this.tubeCurrentMaximum;
    }

    public String getExposureTimePerRotation() {
        return this.exposureTimePerRotation;
    }

    public void deriveScanningLengthFromDLPAndCTDIVol(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            try {
                double d = new Double(string);
                double d2 = new Double(string2);
                if (d > 0.0 && d2 > 0.0) {
                    this.scanningLengthInMM = FloatFormatter.toString(d / d2 * 10.0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("\tIrradiationEventUID=");
            stringBuffer.append(this.irradiationEventUID);
        }
        stringBuffer.append("\t");
        stringBuffer.append(this.scanType);
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Anatomy=");
            stringBuffer.append(this.anatomy);
        } else if (this.anatomy != null) {
            stringBuffer.append(this.anatomy.getCodeMeaning());
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("ScanningLength=");
        }
        if (!bl || this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
            stringBuffer.append(this.scanningLengthInMM);
            stringBuffer.append(" mm");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Collimation single/total=");
        }
        if (!bl || this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.length() > 0 || this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.length() > 0) {
            stringBuffer.append(this.nominalSingleCollimationWidthInMM == null ? "" : this.nominalSingleCollimationWidthInMM);
            stringBuffer.append("/");
            stringBuffer.append(this.nominalTotalCollimationWidthInMM == null ? "" : this.nominalTotalCollimationWidthInMM);
            stringBuffer.append(" mm");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("PitchFactor=");
        }
        if (!bl || this.pitchFactor != null && this.pitchFactor.trim().length() > 0) {
            stringBuffer.append(this.pitchFactor);
            stringBuffer.append(":1");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("KVP=");
        }
        if (!bl || this.kvp != null && this.kvp.trim().length() > 0) {
            stringBuffer.append(this.kvp);
            stringBuffer.append(" kVP");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("TubeCurrent/Max=");
        }
        if (!bl || this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0 || this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
            stringBuffer.append(this.tubeCurrent);
            stringBuffer.append("/");
            stringBuffer.append(this.tubeCurrentMaximum);
            stringBuffer.append(" mA");
        }
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Exposure time/per rotation=");
        }
        if (!bl || this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0 || this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
            stringBuffer.append(this.exposureTimeInSeconds == null ? "" : this.exposureTimeInSeconds);
            stringBuffer.append("/");
            stringBuffer.append(this.exposureTimePerRotation == null ? "" : this.exposureTimePerRotation);
            stringBuffer.append(" s");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String getHTMLTableHeaderRowFragment() {
        return "<th>Type</th><th>Anatomy</th><th>Scanning Length mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th>";
    }

    public String getHTMLTableRowFragment() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<td>");
        if (this.scanType != null) {
            stringBuffer.append(this.scanType);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.anatomy != null) {
            stringBuffer.append(this.anatomy.getCodeMeaning());
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
            stringBuffer.append(this.scanningLengthInMM);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.length() > 0 || this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.length() > 0) {
            stringBuffer.append(this.nominalSingleCollimationWidthInMM == null ? "" : this.nominalSingleCollimationWidthInMM);
            stringBuffer.append("/");
            stringBuffer.append(this.nominalTotalCollimationWidthInMM == null ? "" : this.nominalTotalCollimationWidthInMM);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.pitchFactor != null && this.pitchFactor.trim().length() > 0) {
            stringBuffer.append(this.pitchFactor);
            stringBuffer.append(":1");
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.kvp != null && this.kvp.trim().length() > 0) {
            stringBuffer.append(this.kvp);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0 || this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
            stringBuffer.append(this.tubeCurrent);
            stringBuffer.append("/");
            stringBuffer.append(this.tubeCurrentMaximum);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0 || this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
            stringBuffer.append(this.exposureTimeInSeconds == null ? "" : this.exposureTimeInSeconds);
            stringBuffer.append("/");
            stringBuffer.append(this.exposureTimePerRotation == null ? "" : this.exposureTimePerRotation);
        }
        stringBuffer.append("</td>");
        return stringBuffer.toString();
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem) throws DicomException {
        if (this.contentItemFragment == null) {
            ContentItemFactory contentItemFactory;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            this.contentItemFragment = contentItemFactory2.new ContentItemFactory.ContainerContentItem(contentItem, "CONTAINS", new CodedSequenceItem("113822", "DCM", "CT Acquisition Parameters"), true);
            if (this.exposureTimeInSeconds != null && this.exposureTimeInSeconds.trim().length() > 0) {
                ContentItemFactory contentItemFactory3 = contentItemFactory;
                contentItemFactory3.getClass();
                contentItemFactory3.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113824", "DCM", "Exposure Time"), this.exposureTimeInSeconds, new CodedSequenceItem("s", "UCUM", "1.8", "s"));
            }
            if (this.scanningLengthInMM != null && this.scanningLengthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory4 = contentItemFactory;
                contentItemFactory4.getClass();
                contentItemFactory4.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113825", "DCM", "Scanning Length"), this.scanningLengthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.nominalSingleCollimationWidthInMM != null && this.nominalSingleCollimationWidthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113826", "DCM", "Nominal Single Collimation Width"), this.nominalSingleCollimationWidthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.nominalTotalCollimationWidthInMM != null && this.nominalTotalCollimationWidthInMM.trim().length() > 0) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                contentItemFactory6.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113827", "DCM", "Nominal Total Collimation Width"), this.nominalTotalCollimationWidthInMM, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.pitchFactor != null && this.pitchFactor.trim().length() > 0 && (this.scanType == null || this.scanType.equals(CTScanType.AXIAL) || this.scanType.equals(CTScanType.HELICAL) || this.scanType.equals(CTScanType.UNKNOWN))) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                contentItemFactory7.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113828", "DCM", "Pitch Factor"), this.pitchFactor, new CodedSequenceItem("{ratio}", "UCUM", "1.8", "ratio"));
            }
            ContentItemFactory contentItemFactory8 = contentItemFactory;
            contentItemFactory8.getClass();
            contentItemFactory8.new ContentItemFactory.NumericContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113823", "DCM", "Number of X-Ray Sources"), "1", new CodedSequenceItem("{X-Ray sources}", "UCUM", "1.8", "X-Ray sources"));
            ContentItemFactory contentItemFactory9 = contentItemFactory;
            contentItemFactory9.getClass();
            ContentItemFactory.ContainerContentItem containerContentItem = contentItemFactory9.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113831", "DCM", "CT X-Ray Source Parameters"), true);
            ContentItemFactory contentItemFactory10 = contentItemFactory;
            contentItemFactory10.getClass();
            contentItemFactory10.new ContentItemFactory.TextContentItem(containerContentItem, "CONTAINS", new CodedSequenceItem("113832", "DCM", "Identification of the X-Ray Source"), "1");
            if (this.kvp != null && this.kvp.trim().length() > 0) {
                ContentItemFactory contentItemFactory11 = contentItemFactory;
                contentItemFactory11.getClass();
                contentItemFactory11.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113733", "DCM", "KVP"), this.kvp, new CodedSequenceItem("kV", "UCUM", "1.8", "kV"));
            }
            if (this.tubeCurrentMaximum != null && this.tubeCurrentMaximum.trim().length() > 0) {
                ContentItemFactory contentItemFactory12 = contentItemFactory;
                contentItemFactory12.getClass();
                contentItemFactory12.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113833", "DCM", "Maximum X-Ray Tube Current"), this.tubeCurrentMaximum, new CodedSequenceItem("mA", "UCUM", "1.8", "mA"));
            }
            if (this.tubeCurrent != null && this.tubeCurrent.trim().length() > 0) {
                ContentItemFactory contentItemFactory13 = contentItemFactory;
                contentItemFactory13.getClass();
                contentItemFactory13.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113734", "DCM", "X-Ray Tube Current"), this.tubeCurrent, new CodedSequenceItem("mA", "UCUM", "1.8", "mA"));
            }
            if (this.exposureTimePerRotation != null && this.exposureTimePerRotation.trim().length() > 0) {
                ContentItemFactory contentItemFactory14 = contentItemFactory;
                contentItemFactory14.getClass();
                contentItemFactory14.new ContentItemFactory.NumericContentItem((ContentItem)containerContentItem, "CONTAINS", new CodedSequenceItem("113834", "DCM", "Exposure Time per Rotation"), this.exposureTimePerRotation, new CodedSequenceItem("s", "UCUM", "1.8", "s"));
            }
        }
        return this.contentItemFragment;
    }
}

