/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScanRange;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CTDoseAcquisition {
    protected String scopeUID;
    protected boolean seriesOrAcquisitionNumberIsSeries;
    protected String seriesOrAcquisitionNumber;
    protected CTScanType scanType;
    protected ScanRange scanRange;
    protected String CTDIvol;
    protected String DLP;
    protected CTPhantomType phantomType;
    protected CTAcquisitionParameters acquisitionParameters;
    protected ContentItem contentItemFragment;

    public CTDoseAcquisition(String string, boolean bl, String string2, CTScanType cTScanType, ScanRange scanRange, String string3, String string4, CTPhantomType cTPhantomType) {
        this.scopeUID = string;
        this.seriesOrAcquisitionNumberIsSeries = bl;
        this.seriesOrAcquisitionNumber = string2;
        this.scanType = cTScanType;
        this.scanRange = scanRange;
        this.CTDIvol = string3;
        this.DLP = string4;
        this.phantomType = cTPhantomType;
        this.acquisitionParameters = null;
        this.contentItemFragment = null;
    }

    public CTDoseAcquisition(String string, ContentItem contentItem) {
        ContentItem contentItem2;
        ContentItem contentItem3;
        this.scopeUID = string;
        ContentItem contentItem4 = contentItem.getNamedChild("DCM", "113820");
        if (contentItem4 != null && contentItem4 instanceof ContentItemFactory.CodeContentItem) {
            this.scanType = CTScanType.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem4).getConceptCode());
        }
        if ((contentItem3 = contentItem.getNamedChild("DCM", "113822")) != null) {
            this.acquisitionParameters = new CTAcquisitionParameters(contentItem3);
        }
        if ((contentItem2 = contentItem.getNamedChild("DCM", "113829")) != null) {
            Object object;
            Object object2;
            ContentItem contentItem5 = contentItem2.getNamedChild("DCM", "113830");
            if (contentItem5 != null && contentItem5 instanceof ContentItemFactory.NumericContentItem) {
                object2 = ((ContentItemFactory.NumericContentItem)contentItem5).getUnits();
                if (CTDoseAcquisition.checkUnitIs_mGy((CodedSequenceItem)object2)) {
                    this.CTDIvol = ((ContentItemFactory.NumericContentItem)contentItem5).getNumericValue();
                } else {
                    System.err.println("CT Dose Acquisition Mean CTDIvol units are not mGy - ignoring value");
                }
            } else {
                System.err.println("CT Dose Acquisition Mean CTDIvol not found");
            }
            object2 = contentItem2.getNamedChild("DCM", "113838");
            if (object2 != null && object2 instanceof ContentItemFactory.NumericContentItem) {
                object = ((ContentItemFactory.NumericContentItem)object2).getUnits();
                if (CTDoseAcquisition.checkUnitIs_mGycm((CodedSequenceItem)object)) {
                    this.DLP = ((ContentItemFactory.NumericContentItem)object2).getNumericValue();
                } else {
                    System.err.println("CT Dose Acquisition DLP units are not mGy.cm - ignoring value");
                }
            } else {
                System.err.println("CT Dose Acquisition DLP not found");
            }
            object = contentItem2.getNamedChild("DCM", "113835");
            if (object != null && object instanceof ContentItemFactory.CodeContentItem) {
                this.phantomType = CTPhantomType.selectFromCode(((ContentItemFactory.CodeContentItem)object).getConceptCode());
            }
        }
    }

    public static boolean checkUnitIs_mGy(CodedSequenceItem codedSequenceItem) {
        boolean bl = false;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string != null && string.equals("mGy") && string2 != null && string2.equals("UCUM")) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkUnitIs_mGycm(CodedSequenceItem codedSequenceItem) {
        boolean bl = false;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string != null && (string.equals("mGy.cm") || string.equals("mGycm")) && string2 != null && string2.equals("UCUM")) {
                bl = true;
            }
        }
        return bl;
    }

    public String getScopeUID() {
        return this.scopeUID;
    }

    public boolean isSeriesNumberNotAcquisitionNumber() {
        return this.seriesOrAcquisitionNumberIsSeries;
    }

    public String getSeriesOrAcquisitionNumber() {
        return this.seriesOrAcquisitionNumber;
    }

    public CTScanType getScanType() {
        return this.scanType;
    }

    public ScanRange getScanRange() {
        return this.scanRange;
    }

    public String getCTDIvol() {
        return this.CTDIvol;
    }

    public String getDLP() {
        return this.DLP;
    }

    public CTPhantomType getPhantomType() {
        return this.phantomType;
    }

    public void setAcquisitionParameters(CTAcquisitionParameters cTAcquisitionParameters) {
        CTScanType cTScanType;
        this.acquisitionParameters = cTAcquisitionParameters;
        if (this.scanType.equals(CTScanType.UNKNOWN) && cTAcquisitionParameters != null && (cTScanType = cTAcquisitionParameters.getScanType()) != null) {
            this.scanType = cTScanType;
        }
    }

    public CTAcquisitionParameters getAcquisitionParameters() {
        return this.acquisitionParameters;
    }

    public boolean equals(Object object) {
        CTDoseAcquisition cTDoseAcquisition;
        boolean bl = false;
        bl = object instanceof CTDoseAcquisition ? (cTDoseAcquisition = (CTDoseAcquisition)object).isSeriesNumberNotAcquisitionNumber() == this.isSeriesNumberNotAcquisitionNumber() && (cTDoseAcquisition.getSeriesOrAcquisitionNumber() == null && this.getSeriesOrAcquisitionNumber() == null || cTDoseAcquisition.getSeriesOrAcquisitionNumber().equals(this.getSeriesOrAcquisitionNumber())) && (cTDoseAcquisition.getScopeUID() == null && this.getScopeUID() == null || cTDoseAcquisition.getScopeUID().equals(this.getScopeUID())) && (cTDoseAcquisition.getScanType() == null && this.getScanType() == null || cTDoseAcquisition.getScanType().equals(this.getScanType())) && (cTDoseAcquisition.getScanRange() == null && this.getScanRange() == null || cTDoseAcquisition.getScanRange().equals(this.getScanRange())) && (cTDoseAcquisition.getCTDIvol() == null && this.getCTDIvol() == null || cTDoseAcquisition.getCTDIvol().equals(this.getCTDIvol())) && (cTDoseAcquisition.getDLP() == null && this.getDLP() == null || cTDoseAcquisition.getDLP().equals(this.getDLP())) && (cTDoseAcquisition.getPhantomType() == null && this.getPhantomType() == null || cTDoseAcquisition.getPhantomType().equals(this.getPhantomType())) : false;
        return bl;
    }

    public int hashCode() {
        return this.getSeriesOrAcquisitionNumber().hashCode() + this.getScopeUID().hashCode() + this.getScanType().hashCode() + this.getScanRange().hashCode();
    }

    public String getDLPFromRangeAndCTDIvol() {
        String string = null;
        if (this.scanRange != null && this.CTDIvol != null && this.CTDIvol.length() > 0) {
            try {
                double d = Double.parseDouble(this.scanRange.getAbsoluteRange()) * Double.parseDouble(this.CTDIvol) / 10.0;
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
                decimalFormat.setMaximumFractionDigits(2);
                decimalFormat.setMinimumFractionDigits(2);
                decimalFormat.setDecimalSeparatorAlwaysShown(true);
                decimalFormat.setGroupingUsed(false);
                string = decimalFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
        return string;
    }

    public boolean specifiedDLPMatchesDLPFromRangeAndCTDIvol() {
        String string = this.getDLPFromRangeAndCTDIvol();
        return this.DLP != null && string != null && this.DLP.equals(string);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        stringBuffer.append(bl && (this.seriesOrAcquisitionNumber == null || this.seriesOrAcquisitionNumber.trim().length() == 0) ? "-" : (this.seriesOrAcquisitionNumberIsSeries ? "Series" : "Acq") + "=" + this.seriesOrAcquisitionNumber);
        stringBuffer.append("\t");
        stringBuffer.append(this.scanType);
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Range=");
        }
        stringBuffer.append(bl && this.scanRange == null ? "-" : this.scanRange + " mm");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("CTDIvol=");
        }
        stringBuffer.append(bl && (this.CTDIvol == null || this.CTDIvol.trim().length() == 0) ? "-" : this.CTDIvol + " mGy");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("DLP=");
        }
        stringBuffer.append(bl && (this.DLP == null || this.DLP.trim().length() == 0) ? "-" : this.DLP + " mGy.cm");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Phantom=");
        }
        stringBuffer.append(bl && this.phantomType == null ? "-" : this.phantomType);
        if (this.acquisitionParameters != null) {
            stringBuffer.append("\n\t");
            stringBuffer.append(this.acquisitionParameters.toString(bl));
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getHTMLTableHeaderRow() {
        return "<tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th>" + (this.acquisitionParameters == null ? "" : CTAcquisitionParameters.getHTMLTableHeaderRowFragment()) + "</tr>\n";
    }

    public String getHTMLTableRow() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>");
        if (this.seriesOrAcquisitionNumber != null && this.seriesOrAcquisitionNumber.trim().length() > 0) {
            stringBuffer.append(this.seriesOrAcquisitionNumberIsSeries ? "Series" : "Acq");
            stringBuffer.append("=");
            stringBuffer.append(this.seriesOrAcquisitionNumber);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanType != null) {
            stringBuffer.append(this.scanType);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanRange != null) {
            stringBuffer.append(this.scanRange);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0) {
            stringBuffer.append(this.CTDIvol);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.DLP != null && this.DLP.trim().length() > 0) {
            stringBuffer.append(this.DLP);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.phantomType != null) {
            stringBuffer.append(this.phantomType);
        }
        stringBuffer.append("</td>");
        if (this.acquisitionParameters != null) {
            stringBuffer.append(this.acquisitionParameters.getHTMLTableRowFragment());
        }
        stringBuffer.append("</tr>\n");
        return stringBuffer.toString();
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem) throws DicomException {
        if (this.contentItemFragment == null) {
            String string;
            ContentItemFactory contentItemFactory;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            this.contentItemFragment = contentItemFactory2.new ContentItemFactory.ContainerContentItem(contentItem, "CONTAINS", new CodedSequenceItem("113819", "DCM", "CT Acquisition"), true, "DCMR", "10013");
            Object object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getAnatomy();
            ContentItemFactory contentItemFactory3 = contentItemFactory;
            contentItemFactory3.getClass();
            contentItemFactory3.new ContentItemFactory.CodeContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("123014", "DCM", "Target Region"), (CodedSequenceItem)(object == null ? new CodedSequenceItem("T-D0010", "SRT", "Entire body") : object));
            object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getIrradiationEventUID();
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.UIDContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113769", "DCM", "Irradiation Event UID"), (String)(object == null ? new UIDGenerator().getNewUID() : object));
            object = this.scanType.getCodedSequenceItem();
            if (object != null) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.CodeContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113820", "DCM", "CT Acquisition Type"), (CodedSequenceItem)object);
            }
            if (this.acquisitionParameters != null) {
                this.acquisitionParameters.getStructuredReportFragment(this.contentItemFragment);
            }
            if ((object = this.contentItemFragment.getNamedChild("DCM", "113822")) == null) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                object = contentItemFactory6.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113822", "DCM", "CT Acquisition Parameters"), true);
            }
            if (this.scanRange != null && ((string = ((ContentItem)object).getSingleStringValueOrNullOfNamedChild("DCM", "113825")) == null || string.length() == 0)) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                contentItemFactory7.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113825", "DCM", "Scanning Length"), this.scanRange.getAbsoluteRange(), new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0 || this.phantomType != null || this.DLP != null && this.DLP.trim().length() > 0) {
                ContentItemFactory contentItemFactory8 = contentItemFactory;
                contentItemFactory8.getClass();
                object = contentItemFactory8.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113829", "DCM", "CT Dose"), true);
                if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0) {
                    ContentItemFactory contentItemFactory9 = contentItemFactory;
                    contentItemFactory9.getClass();
                    contentItemFactory9.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113830", "DCM", "Mean CTDIvol"), this.CTDIvol, new CodedSequenceItem("mGy", "UCUM", "1.8", "mGy"));
                }
                if (this.phantomType != null) {
                    ContentItemFactory contentItemFactory10 = contentItemFactory;
                    contentItemFactory10.getClass();
                    contentItemFactory10.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113835", "DCM", "CTDIw Phantom Type"), this.phantomType.getCodedSequenceItem());
                }
                if (this.DLP != null && this.DLP.trim().length() > 0) {
                    ContentItemFactory contentItemFactory11 = contentItemFactory;
                    contentItemFactory11.getClass();
                    contentItemFactory11.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113838", "DCM", "DLP"), this.DLP, new CodedSequenceItem("mGy.cm", "UCUM", "1.8", "mGy.cm"));
                }
            }
        }
        return this.contentItemFragment;
    }
}

