/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTIrradiationEventDataFromImages {
    protected ArrayList<String> doseScreenFilenames = new ArrayList();
    protected ArrayList<String> doseStructuredReportFilenames = new ArrayList();
    protected Set<String> irradiationEventUIDs = new TreeSet<String>();
    protected String patientAge;
    boolean patientAgeIsClean = true;
    protected String patientSex;
    boolean patientSexIsClean = true;
    protected String patientWeight;
    boolean patientWeightIsClean = true;
    protected String patientSize;
    boolean patientSizeIsClean = true;
    protected Map<String, String> studyInstanceUIDByEvent = new TreeMap<String, String>();
    boolean studyInstanceUIDByEventIsClean = true;
    protected Map<String, String> imageTypeByEvent = new TreeMap<String, String>();
    boolean imageTypeByEventIsClean = true;
    protected Map<String, String> acquisitionNumberByEvent = new TreeMap<String, String>();
    boolean acquisitionNumberByEventIsClean = true;
    protected Map<String, String> seriesNumberByEvent = new TreeMap<String, String>();
    boolean seriesNumberByEventIsClean = true;
    protected Map<String, String> seriesDescriptionByEvent = new TreeMap<String, String>();
    boolean seriesDescriptionByEventIsClean = true;
    protected Map<String, String> imageTypeValue3ByEvent = new TreeMap<String, String>();
    boolean imageTypeValue3ByEventIsClean = true;
    protected Map<String, String> exposureTimeByEvent = new TreeMap<String, String>();
    boolean exposureTimeByEventIsClean = true;
    protected Map<String, String> kvpByEvent = new TreeMap<String, String>();
    boolean kvpByEventIsClean = true;
    protected Map<String, String> tubeCurrentByEvent = new TreeMap<String, String>();
    boolean tubeCurrentByEventIsClean = true;
    protected Map<String, Double> tubeCurrentTotalByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> tubeCurrentCountByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> tubeCurrentMaximumByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> midScanTimeCountByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> midScanTimeMinimumByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> midScanTimeMaximumByEvent = new TreeMap<String, Double>();
    protected Map<String, String> exposureTimePerRotationByEvent = new TreeMap<String, String>();
    boolean exposureTimePerRotationByEventIsClean = true;
    protected Map<String, String> nominalSingleCollimationWidthInMMByEvent = new TreeMap<String, String>();
    boolean nominalSingleCollimationWidthInMMByEventIsClean = true;
    protected Map<String, String> nominalTotalCollimationWidthInMMByEvent = new TreeMap<String, String>();
    boolean nominalTotalCollimationWidthInMMByEventIsClean = true;
    protected Map<String, String> pitchFactorByEvent = new TreeMap<String, String>();
    boolean pitchFactorByEventIsClean = true;
    protected Map<String, CodedSequenceItem> anatomyByEvent = new TreeMap<String, CodedSequenceItem>();
    boolean anatomyByEventIsClean = true;
    protected Map<String, String> startAcquisitionDateTimeByEvent = new TreeMap<String, String>();
    protected Map<String, String> endAcquisitionDateTimeByEvent = new TreeMap<String, String>();
    protected Map<String, Double> lowestSliceLocationByEvent = new TreeMap<String, Double>();
    protected Map<String, Double> highestSliceLocationByEvent = new TreeMap<String, Double>();
    protected Map<String, CTAcquisitionParameters> acquisitionParametersBySeriesNumberScanRangeKey = null;
    protected Map<String, CTAcquisitionParameters> acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey = null;
    protected Map<String, String> overallEarliestAcquisitionDateTimeByStudy = new TreeMap<String, String>();
    protected Map<String, String> overallLatestAcquisitionDateTimeByStudy = new TreeMap<String, String>();

    public ArrayList<String> getDoseScreenOrStructuredReportFilenames() {
        return this.getDoseScreenOrStructuredReportFilenames(true, true);
    }

    public ArrayList<String> getDoseScreenOrStructuredReportFilenames(boolean bl, boolean bl2) {
        ArrayList<String> arrayList;
        if (bl && bl2) {
            arrayList = new ArrayList<String>(this.doseScreenFilenames);
            arrayList.addAll(this.doseStructuredReportFilenames);
        } else {
            arrayList = bl ? this.doseScreenFilenames : (bl2 ? this.doseStructuredReportFilenames : new ArrayList());
        }
        return arrayList;
    }

    public String getPatientAge() {
        return this.patientAgeIsClean ? this.patientAge : null;
    }

    public String getPatientSex() {
        return this.patientSexIsClean ? this.patientSex : null;
    }

    public String getPatientWeight() {
        return this.patientWeightIsClean ? this.patientWeight : null;
    }

    public String getPatientSize() {
        return this.patientSizeIsClean ? this.patientSize : null;
    }

    public String getOverallEarliestAcquisitionDateTimeForStudy(String string) {
        return this.overallEarliestAcquisitionDateTimeByStudy.get(string);
    }

    public String getOverallLatestAcquisitionDateTimeForStudy(String string) {
        return this.overallLatestAcquisitionDateTimeByStudy.get(string);
    }

    protected static boolean putCodedSequenceItemByStringIndexIfNotDifferentElseFlagAsUnclean(Map<String, CodedSequenceItem> map, String string, CodedSequenceItem codedSequenceItem) {
        boolean bl = true;
        if (codedSequenceItem != null) {
            CodedSequenceItem codedSequenceItem2 = map.get(string);
            if (codedSequenceItem2 == null) {
                map.put(string, codedSequenceItem);
            } else if (!codedSequenceItem2.equals(codedSequenceItem)) {
                bl = false;
            }
        }
        return bl;
    }

    protected static void putNumericStringValueByStringIndexInStringMapIfNumericSortIsEarlier(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                Double d = new Double(string2);
                String string3 = map.get(string);
                if (string3 == null) {
                    map.put(string, string2);
                } else {
                    Double d2 = new Double(string3);
                    if (d.compareTo(d2) < 0) {
                        map.put(string, string2);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static void putNumericStringValueByStringIndexIfNumericSortIsEarlier(Map<String, Double> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                Double d = new Double(string2);
                Double d2 = map.get(string);
                if (d2 == null) {
                    map.put(string, d);
                } else if (d.compareTo(d2) < 0) {
                    map.put(string, d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static void putNumericStringValueByStringIndexIfNumericSortIsLater(Map<String, Double> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                Double d = new Double(string2);
                Double d2 = map.get(string);
                if (d2 == null) {
                    map.put(string, d);
                } else if (d.compareTo(d2) > 0) {
                    map.put(string, d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected static void putStringValueByStringIndexIfLexicographicSortIsEarlier(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            String string3 = map.get(string);
            if (string3 == null || string3.equals("")) {
                map.put(string, string2);
            } else if (string2.compareTo(string3) < 0) {
                map.put(string, string2);
            }
        }
    }

    protected static void putStringValueByStringIndexIfLexicographicSortIsLater(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            String string3 = map.get(string);
            if (string3 == null || string3.equals("")) {
                map.put(string, string2);
            } else if (string2.compareTo(string3) > 0) {
                map.put(string, string2);
            }
        }
    }

    protected static boolean putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(Map<String, String> map, String string, String string2) {
        boolean bl = true;
        if (string2 != null && !string2.equals("")) {
            String string3 = map.get(string);
            if (string3 == null || string3.equals("")) {
                map.put(string, string2);
            } else if (!string3.equals(string2)) {
                bl = false;
            }
        }
        return bl;
    }

    public CTAcquisitionParameters getAcquisitionParametersForIrradiationEvent(String string) {
        Double d;
        Object object;
        Object object2;
        Double d2;
        String string2;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        decimalFormat.setGroupingUsed(false);
        CTScanType cTScanType = CTScanType.UNKNOWN;
        if (this.imageTypeValue3ByEventIsClean && (string2 = this.imageTypeValue3ByEvent.get(string)) != null && string2.toUpperCase().equals("LOCALIZER")) {
            cTScanType = CTScanType.LOCALIZER;
        }
        String string3 = string2 = this.pitchFactorByEventIsClean ? this.pitchFactorByEvent.get(string) : null;
        if (!cTScanType.equals(CTScanType.LOCALIZER) && string2 != null && string2.length() > 0) {
            try {
                double d3 = Double.parseDouble(string2);
                if (d3 == 0.0) {
                    cTScanType = CTScanType.STATIONARY;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean bl = cTScanType.equals(CTScanType.LOCALIZER);
        String string4 = null;
        if (bl) {
            if (this.exposureTimeByEventIsClean) {
                string4 = this.exposureTimeByEvent.get(string);
            }
        } else {
            d2 = this.midScanTimeCountByEvent.get(string);
            object2 = this.midScanTimeMinimumByEvent.get(string);
            object = this.midScanTimeMaximumByEvent.get(string);
            if (d2 != null && object2 != null && object != null) {
                double d4 = d2;
                double d5 = (Double)object2;
                double d6 = (Double)object;
                double d7 = (d6 - d5) * (d4 + 1.0) / d4;
                if (d7 > 0.0) {
                    string4 = decimalFormat.format(d7);
                }
            }
        }
        d2 = this.kvpByEventIsClean ? this.kvpByEvent.get(string) : null;
        object2 = null;
        object = null;
        if (this.tubeCurrentByEventIsClean) {
            object = object2 = this.tubeCurrentByEvent.get(string);
        } else {
            double d8;
            Double d9 = this.tubeCurrentTotalByEvent.get(string);
            d = this.tubeCurrentCountByEvent.get(string);
            Double d10 = this.tubeCurrentMaximumByEvent.get(string);
            if (d9 != null && d != null && (d8 = d.doubleValue()) > 0.0) {
                double d11 = d9 / d8;
                object2 = decimalFormat.format(d11);
            }
            if (d10 != null) {
                object = decimalFormat.format(d10);
            }
        }
        String string5 = null;
        if (!bl) {
            String string6 = string5 = this.exposureTimePerRotationByEventIsClean ? this.exposureTimePerRotationByEvent.get(string) : null;
            if ((string5 == null || string5.trim().length() == 0) && this.exposureTimeByEventIsClean) {
                string5 = this.exposureTimeByEvent.get(string);
            }
        }
        d = this.anatomyByEventIsClean ? this.anatomyByEvent.get(string) : null;
        String string7 = this.nominalSingleCollimationWidthInMMByEventIsClean ? this.nominalSingleCollimationWidthInMMByEvent.get(string) : null;
        String string8 = this.nominalTotalCollimationWidthInMMByEventIsClean ? this.nominalTotalCollimationWidthInMMByEvent.get(string) : null;
        return new CTAcquisitionParameters(string, cTScanType, (CodedSequenceItem)((Object)d), string4, null, string7, string8, string2, (String)((Object)d2), (String)object2, (String)object, string5);
    }

    public CTAcquisitionParameters getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID(String string) {
        if (this.acquisitionParametersBySeriesNumberScanRangeKey == null) {
            this.acquisitionParametersBySeriesNumberScanRangeKey = new TreeMap<String, CTAcquisitionParameters>();
            for (String string2 : this.irradiationEventUIDs) {
                String string3;
                String string4 = this.seriesNumberByEventIsClean ? this.seriesNumberByEvent.get(string2) : "";
                String string5 = CTIrradiationEventDataFromImages.getLocationAsString(this.highestSliceLocationByEvent.get(string2));
                String string6 = CTIrradiationEventDataFromImages.getLocationAsString(this.lowestSliceLocationByEvent.get(string2));
                String string7 = string3 = this.studyInstanceUIDByEventIsClean ? this.studyInstanceUIDByEvent.get(string2) : "";
                String string8 = string4 + "+" + string5 + "+" + string6 + "+" + string3;
                if (string8.equals("+++")) continue;
                CTAcquisitionParameters cTAcquisitionParameters = this.getAcquisitionParametersForIrradiationEvent(string2);
                this.acquisitionParametersBySeriesNumberScanRangeKey.put(string8, cTAcquisitionParameters);
            }
        }
        CTAcquisitionParameters cTAcquisitionParameters = this.acquisitionParametersBySeriesNumberScanRangeKey.get(string);
        return cTAcquisitionParameters;
    }

    public CTAcquisitionParameters getAcquisitionParametersByAcquisitionNumberAndStudyInstanceUID(String string) {
        if (this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey == null) {
            this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey = new TreeMap<String, CTAcquisitionParameters>();
            for (String string2 : this.irradiationEventUIDs) {
                String string3;
                String string4 = this.acquisitionNumberByEventIsClean ? this.acquisitionNumberByEvent.get(string2) : "";
                String string5 = string3 = this.studyInstanceUIDByEventIsClean ? this.studyInstanceUIDByEvent.get(string2) : "";
                String string6 = string4 + "+" + string3;
                if (string6.equals("+")) continue;
                boolean bl = true;
                CTAcquisitionParameters cTAcquisitionParameters = this.getAcquisitionParametersForIrradiationEvent(string2);
                CTAcquisitionParameters cTAcquisitionParameters2 = this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.get(string6);
                if (cTAcquisitionParameters2 != null && !cTAcquisitionParameters2.equalsApartFromIrradiationEventUID(cTAcquisitionParameters)) {
                    bl = false;
                    CTScanType cTScanType = cTAcquisitionParameters.getScanType();
                    CTScanType cTScanType2 = cTAcquisitionParameters2.getScanType();
                    if (cTScanType != null && cTScanType2 != null) {
                        boolean bl2 = cTScanType.equals(CTScanType.LOCALIZER);
                        boolean bl3 = cTScanType2.equals(CTScanType.LOCALIZER);
                        if (bl3 && !bl2) {
                            bl = true;
                        } else if (!bl3 && bl2) {
                            bl = false;
                        }
                    }
                }
                if (!bl) continue;
                this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.put(string6, cTAcquisitionParameters);
            }
        }
        CTAcquisitionParameters cTAcquisitionParameters = this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.get(string);
        return cTAcquisitionParameters;
    }

    public CTIrradiationEventDataFromImages() {
    }

    public CTIrradiationEventDataFromImages(String string) {
        this.add(string);
    }

    public CTIrradiationEventDataFromImages(Vector<String> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.add(vector.get(i));
        }
    }

    public void add(String string) {
        this.add(new File(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(File file) {
        if (!file.exists()) return;
        if (file.isDirectory()) {
            ArrayList arrayList = FileUtilities.listFilesRecursively(file);
            for (File file2 : arrayList) {
                this.add(file2);
            }
            return;
        }
        if (file.isFile() && file.getName().toUpperCase().equals("DICOMDIR")) {
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(file.getCanonicalPath());
                DicomDirectory dicomDirectory = new DicomDirectory(attributeList);
                HashMap hashMap = dicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(file.getParentFile().getCanonicalPath());
                for (String string : hashMap.keySet()) {
                    if (string == null) continue;
                    this.add(string);
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return;
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
                return;
            }
        }
        if (!file.isFile() || !DicomFileUtilities.isDicomOrAcrNemaFile(file)) return;
        try {
            double d;
            double d2;
            Double d3;
            double d4;
            Double d5;
            Object object;
            double d6;
            Object object2;
            AttributeList attributeList = new AttributeList();
            attributeList.read(file.getCanonicalPath(), null, true, true, TagFromName.PixelData);
            String string = "";
            CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ConceptNameCodeSequence);
            if (OCR.isDoseScreenInstance(attributeList) || ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                this.doseScreenFilenames.add(file.getCanonicalPath());
            } else if (SOPClass.isStructuredReport(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID)) && codedSequenceItem != null && codedSequenceItem.getCodingSchemeDesignator().equals("DCM") && codedSequenceItem.getCodeValue().equals("113701")) {
                this.doseStructuredReportFilenames.add(file.getCanonicalPath());
            } else {
                string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.IrradiationEventUID);
                if (string.equals("")) {
                    string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
                }
            }
            if (this.patientAgeIsClean && !((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientAge))).equals("")) {
                if (this.patientAge == null || this.patientAge.equals("")) {
                    this.patientAge = object2;
                } else if (!this.patientAge.equals(object2)) {
                    this.patientAgeIsClean = false;
                }
            }
            if (this.patientSexIsClean && !((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientSex))).equals("")) {
                if (this.patientSex == null || this.patientSex.equals("")) {
                    this.patientSex = object2;
                } else if (!this.patientSex.equals(object2)) {
                    this.patientSexIsClean = false;
                }
            }
            if (this.patientWeightIsClean && !((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientWeight))).equals("")) {
                if (this.patientWeight == null || this.patientWeight.equals("")) {
                    this.patientWeight = object2;
                } else if (!this.patientWeight.equals(object2)) {
                    try {
                        double d7 = Double.parseDouble(this.patientWeight);
                        d6 = Double.parseDouble((String)object2);
                        if (Math.abs(d7 - d6) > 0.01) {
                            this.patientWeightIsClean = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.patientWeightIsClean = false;
                        numberFormatException.printStackTrace(System.err);
                    }
                }
            }
            if (this.patientSizeIsClean && !((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientSize))).equals("")) {
                if (this.patientSize == null || this.patientSize.equals("")) {
                    this.patientSize = object2;
                } else if (!this.patientSize.equals(object2)) {
                    try {
                        double d8 = Double.parseDouble(this.patientSize);
                        d6 = Double.parseDouble((String)object2);
                        if (Math.abs(d8 - d6) > 0.01) {
                            this.patientSizeIsClean = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.patientSizeIsClean = false;
                        numberFormatException.printStackTrace(System.err);
                    }
                }
            }
            if (string.equals("")) return;
            this.irradiationEventUIDs.add(string);
            this.studyInstanceUIDByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.studyInstanceUIDByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.StudyInstanceUID));
            this.imageTypeByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.imageTypeByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.ImageType));
            CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexInStringMapIfNumericSortIsEarlier(this.acquisitionNumberByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.AcquisitionNumber));
            this.seriesNumberByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.seriesNumberByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SeriesNumber));
            this.seriesDescriptionByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.seriesDescriptionByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SeriesDescription));
            object2 = "";
            Object object3 = attributeList.get(TagFromName.ImageType);
            if (object3 != null && ((Attribute)object3).getVM() >= 3) {
                object = ((Attribute)object3).getStringValues();
                object2 = object[2];
            }
            this.imageTypeValue3ByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.imageTypeValue3ByEvent, string, (String)object2);
            object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ExposureTime);
            if (!((String)object2).equals("")) {
                object3 = "";
                try {
                    object3 = new Double(new Double((String)object2) / 1000.0).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.exposureTimeByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.exposureTimeByEvent, string, (String)object3);
            }
            this.kvpByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.kvpByEvent, string, Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.KVP));
            object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.XRayTubeCurrent);
            this.tubeCurrentByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.tubeCurrentByEvent, string, (String)object2);
            if (((String)object2).length() > 0) {
                try {
                    object3 = new Double((String)object2);
                    object = this.tubeCurrentCountByEvent.get(string);
                    if (object == null) {
                        this.tubeCurrentCountByEvent.put(string, new Double(1.0));
                        this.tubeCurrentTotalByEvent.put(string, (Double)object3);
                        this.tubeCurrentMaximumByEvent.put(string, (Double)object3);
                    } else {
                        d6 = (Double)object3;
                        d5 = this.tubeCurrentTotalByEvent.get(string);
                        d4 = d5;
                        this.tubeCurrentTotalByEvent.put(string, new Double(d4 += d6));
                        d3 = this.tubeCurrentMaximumByEvent.get(string);
                        d2 = d3;
                        if (d6 > d2) {
                            d2 = d6;
                            this.tubeCurrentMaximumByEvent.put(string, new Double(d2));
                        }
                        d = (Double)object;
                        this.tubeCurrentCountByEvent.put(string, new Double(d += 1.0));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 16)).equals("GEMS_ACQU_01") && ((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 4132)))).length() > 0) {
                object3 = new Double((String)object2);
                object = this.midScanTimeCountByEvent.get(string);
                if (object == null) {
                    this.midScanTimeCountByEvent.put(string, new Double(1.0));
                    this.midScanTimeMinimumByEvent.put(string, (Double)object3);
                    this.midScanTimeMaximumByEvent.put(string, (Double)object3);
                } else {
                    try {
                        d6 = (Double)object3;
                        d5 = this.midScanTimeMaximumByEvent.get(string);
                        d4 = d5;
                        if (d6 > d4) {
                            d4 = d6;
                            this.midScanTimeMaximumByEvent.put(string, new Double(d4));
                        }
                        if (d6 < (d2 = (d3 = this.midScanTimeMinimumByEvent.get(string)).doubleValue())) {
                            d2 = d6;
                            this.midScanTimeMinimumByEvent.put(string, new Double(d2));
                        }
                        d = (Double)object;
                        this.midScanTimeCountByEvent.put(string, new Double(d += 1.0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (((String)(object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.RevolutionTime))).equals("") && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 16)).equals("GEMS_ACQU_01")) {
                object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 4135));
            }
            this.exposureTimePerRotationByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.exposureTimePerRotationByEvent, string, (String)object2);
            object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SingleCollimationWidth);
            if (((String)object2).equals("") && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_HELIOS_01")) {
                object2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 4098));
            }
            this.nominalSingleCollimationWidthInMMByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.nominalSingleCollimationWidthInMMByEvent, string, (String)object2);
            object3 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.TotalCollimationWidth);
            if (((String)object3).equals("") && !((String)object2).equals("") && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_HELIOS_01")) {
                try {
                    double d9 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(69, 4097), 0.0);
                    double d10 = Double.valueOf((String)object2);
                    if (d9 > 0.0 && d10 > 0.0) {
                        d4 = d9 * d10;
                        object3 = Double.toString(d4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace(System.err);
                }
            }
            this.nominalTotalCollimationWidthInMMByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.nominalTotalCollimationWidthInMMByEvent, string, (String)object3);
            String string2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SpiralPitchFactor);
            if (string2.equals("")) {
                if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(67, 16)).equals("GEMS_PARM_01")) {
                    string2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(67, 4135));
                    string2 = string2.trim().replace(":1", "");
                }
                if (string2.equals("") && !((String)object3).equals("")) {
                    try {
                        double d11;
                        double d12 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.TableFeedPerRotation, 0.0);
                        if (d12 == 0.0 && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_ACQU_01")) {
                            d12 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(25, 4131), 0.0);
                        }
                        if (d12 > 0.0 && (d11 = Double.valueOf((String)object3).doubleValue()) > 0.0) {
                            double d13 = d12 / d11;
                            string2 = Double.toString(d13);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace(System.err);
                    }
                }
            }
            this.pitchFactorByEventIsClean = CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.pitchFactorByEvent, string, string2);
            object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDateTime);
            if (((String)object2).equals("")) {
                object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDate) + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionTime);
            }
            CTIrradiationEventDataFromImages.putStringValueByStringIndexIfLexicographicSortIsEarlier(this.startAcquisitionDateTimeByEvent, string, (String)object2);
            CTIrradiationEventDataFromImages.putStringValueByStringIndexIfLexicographicSortIsLater(this.endAcquisitionDateTimeByEvent, string, (String)object2);
            object3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyInstanceUID);
            if (object3 != null) {
                String string3;
                string2 = this.overallEarliestAcquisitionDateTimeByStudy.get(object3);
                if (string2 == null || ((String)object2).compareTo(string2) < 0) {
                    this.overallEarliestAcquisitionDateTimeByStudy.put((String)object3, (String)object2);
                }
                if ((string3 = this.overallLatestAcquisitionDateTimeByStudy.get(object3)) == null || ((String)object2).compareTo(string3) > 0) {
                    this.overallLatestAcquisitionDateTimeByStudy.put((String)object3, (String)object2);
                }
            }
            object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SliceLocation).trim();
            CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsEarlier(this.lowestSliceLocationByEvent, string, (String)object2);
            CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsLater(this.highestSliceLocationByEvent, string, (String)object2);
            object2 = CTAnatomy.findAnatomicConcept(attributeList);
            if (object2 == null || (object3 = ((CodedConcept)object2).getCodedSequenceItem()) == null) return;
            this.anatomyByEventIsClean = CTIrradiationEventDataFromImages.putCodedSequenceItemByStringIndexIfNotDifferentElseFlagAsUnclean(this.anatomyByEvent, string, (CodedSequenceItem)object3);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected static String toStringCodedSequenceItem(String string, Map<String, CodedSequenceItem> map, boolean bl, String string2) {
        CodedSequenceItem codedSequenceItem;
        String string3 = bl ? ((codedSequenceItem = map.get(string2)) == null ? "-- not found --" : codedSequenceItem.toString()) : "-- inconsistent values for event --";
        return "\t\t" + string + " = " + string3 + "\n";
    }

    protected static String toString(String string, String string2, boolean bl) {
        if (bl) {
            if (string2 == null) {
                string2 = "-- not found --";
            }
        } else {
            string2 = "-- inconsistent values for event --";
        }
        return "\t\t" + string + " = " + string2 + "\n";
    }

    protected static String toString(String string, Map<String, String> map, boolean bl, String string2) {
        String string3;
        if (bl) {
            string3 = map.get(string2);
            if (string3 == null) {
                string3 = "-- not found --";
            }
        } else {
            string3 = "-- inconsistent values for event --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    protected static String toString(String string, Map<String, Double> map, String string2) {
        Double d = map.get(string2);
        String string3 = d == null ? "-- not found --" : d.toString();
        return "\t\t" + string + " = " + string3 + "\n";
    }

    protected static String getLocationAsString(Double d) {
        String string;
        if (d == null) {
            string = "";
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.setGroupingUsed(false);
            decimalFormat.setMinimumFractionDigits(3);
            decimalFormat.setMaximumFractionDigits(3);
            string = decimalFormat.format(d);
            string = string.startsWith("-") ? "I" + string.substring(1) : "S" + string;
        }
        return string;
    }

    protected static String toStringLocation(String string, Map<String, Double> map, String string2) {
        String string3 = CTIrradiationEventDataFromImages.getLocationAsString(map.get(string2));
        if (string3.equals("")) {
            string3 = "-- not found --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.irradiationEventUIDs) {
            stringBuffer.append("\tIrradiationEventUID = " + string + "\n");
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientAge", this.patientAge, this.patientAgeIsClean));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientSex", this.patientSex, this.patientSexIsClean));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientWeight", this.patientWeight, this.patientWeightIsClean));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientSize", this.patientSize, this.patientSizeIsClean));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ImageType", this.imageTypeByEvent, this.imageTypeByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("AcquisitionNumber", this.acquisitionNumberByEvent, this.acquisitionNumberByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("SeriesNumber", this.seriesNumberByEvent, this.seriesNumberByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("SeriesDescription", this.seriesDescriptionByEvent, this.seriesDescriptionByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toStringCodedSequenceItem("Anatomy", this.anatomyByEvent, this.anatomyByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("StartAcquisitionDateTime", this.startAcquisitionDateTimeByEvent, true, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("EndAcquisitionDateTime", this.endAcquisitionDateTimeByEvent, true, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toStringLocation("LowestSliceLocation", this.lowestSliceLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toStringLocation("HighestSliceLocation", this.highestSliceLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ExposureTime", this.exposureTimeByEvent, this.exposureTimeByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("KVP", this.kvpByEvent, this.kvpByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("TubeCurrent", this.tubeCurrentByEvent, this.tubeCurrentByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("TubeCurrentTotal", this.tubeCurrentTotalByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("TubeCurrentCount", this.tubeCurrentCountByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("TubeCurrentMaximum", this.tubeCurrentMaximumByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ExposureTimePerRotation", this.exposureTimePerRotationByEvent, this.exposureTimePerRotationByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("NominalSingleCollimationWidthInMM", this.nominalSingleCollimationWidthInMMByEvent, this.nominalSingleCollimationWidthInMMByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("NominalTotalCollimationWidthInMM", this.nominalTotalCollimationWidthInMMByEvent, this.nominalTotalCollimationWidthInMMByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PitchFactor", this.pitchFactorByEvent, this.pitchFactorByEventIsClean, string));
        }
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) {
        try {
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(stringArray[0]);
            System.err.print(cTIrradiationEventDataFromImages);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

