/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;

public class CTScanType {
    private String description;
    public static final CTScanType LOCALIZER = new CTScanType("Localizer");
    public static final CTScanType HELICAL = new CTScanType("Helical");
    public static final CTScanType AXIAL = new CTScanType("Axial");
    public static final CTScanType STATIONARY = new CTScanType("Stationary");
    public static final CTScanType FREE = new CTScanType("Free");
    public static final CTScanType UNKNOWN = new CTScanType("Unknown");

    private CTScanType() {
    }

    private CTScanType(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public static CTScanType selectFromDescription(String string) {
        CTScanType cTScanType = UNKNOWN;
        if (string != null) {
            if ((string = string.trim().toUpperCase()).equals(HELICAL.toString().toUpperCase()) || string.equals("SPIRAL")) {
                cTScanType = HELICAL;
            } else if (string.equals(AXIAL.toString().toUpperCase()) || string.equals("SEQUENCED")) {
                cTScanType = AXIAL;
            } else if (string.equals(FREE.toString().toUpperCase()) || string.equals("SMARTVIEW")) {
                cTScanType = FREE;
            } else if (string.equals(STATIONARY.toString().toUpperCase()) || string.equals("CINE")) {
                cTScanType = STATIONARY;
            } else if (string.equals(LOCALIZER.toString().toUpperCase()) || string.equals("SCOUT") || string.equals("CONSTANT_ANGLE") || string.equals("TOPOGRAM")) {
                cTScanType = LOCALIZER;
            }
        }
        return cTScanType;
    }

    public static CTScanType selectFromCode(CodedSequenceItem codedSequenceItem) {
        CTScanType cTScanType = UNKNOWN;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string2.equals("SRT") && string.equals("P5-08001")) {
                cTScanType = HELICAL;
            } else if (string2.equals("DCM") && string.equals("113804")) {
                cTScanType = AXIAL;
            } else if (string2.equals("DCM") && string.equals("113805")) {
                cTScanType = LOCALIZER;
            } else if (string2.equals("DCM") && string.equals("113806")) {
                cTScanType = STATIONARY;
            } else if (string2.equals("DCM") && string.equals("113807")) {
                cTScanType = FREE;
            }
        }
        return cTScanType;
    }

    public static CodedSequenceItem getCodedSequenceItem(CTScanType cTScanType) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        if (cTScanType != null) {
            if (cTScanType.equals(LOCALIZER)) {
                codedSequenceItem = new CodedSequenceItem("113805", "DCM", "Constant Angle Acquisition");
            } else if (cTScanType.equals(HELICAL)) {
                codedSequenceItem = new CodedSequenceItem("P5-08001", "SRT", "Spiral Acquisition");
            } else if (cTScanType.equals(AXIAL)) {
                codedSequenceItem = new CodedSequenceItem("113804", "DCM", "Sequenced Acquisition");
            } else if (cTScanType.equals(STATIONARY)) {
                codedSequenceItem = new CodedSequenceItem("113806", "DCM", "Stationary Acquisition");
            } else if (cTScanType.equals(FREE)) {
                codedSequenceItem = new CodedSequenceItem("113807", "DCM", "FREE Acquisition");
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItem() throws DicomException {
        return CTScanType.getCodedSequenceItem(this);
    }
}

