/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;

public class CompositeInstanceContext {
    protected AttributeList list;
    protected AttributeTag[] patientModuleAttributeTags = new AttributeTag[]{TagFromName.PatientName, TagFromName.PatientID, TagFromName.IssuerOfPatientID, TagFromName.IssuerOfPatientIDQualifiersSequence, TagFromName.PatientBirthDate, TagFromName.PatientSex, TagFromName.PatientBirthTime, TagFromName.ReferencedPatientSequence, TagFromName.OtherPatientIDs, TagFromName.OtherPatientIDsSequence, TagFromName.OtherPatientNames, TagFromName.EthnicGroup, TagFromName.PatientComments, TagFromName.PatientSpeciesDescription, TagFromName.PatientSpeciesCodeSequence, TagFromName.PatientBreedDescription, TagFromName.PatientBreedCodeSequence, TagFromName.BreedRegistrationSequence, TagFromName.ResponsiblePerson, TagFromName.ResponsiblePersonRole, TagFromName.ResponsibleOrganization, TagFromName.PatientIdentityRemoved, TagFromName.DeidentificationMethod, TagFromName.DeidentificationMethodCodeSequence};
    protected AttributeTag[] generalStudyModuleAttributeTags = new AttributeTag[]{TagFromName.StudyInstanceUID, TagFromName.StudyDate, TagFromName.StudyTime, TagFromName.ReferringPhysicianName, TagFromName.ReferringPhysicianIdentificationSequence, TagFromName.StudyID, TagFromName.AccessionNumber, TagFromName.IssuerOfAccessionNumberSequence, TagFromName.StudyDescription, TagFromName.PhysiciansOfRecord, TagFromName.PhysiciansOfRecordIdentificationSequence, TagFromName.NameOfPhysiciansReadingStudy, TagFromName.PhysiciansReadingStudyIdentificationSequence, TagFromName.RequestingServiceCodeSequence, TagFromName.ReferencedStudySequence, TagFromName.ProcedureCodeSequence, TagFromName.ReasonForPerformedProcedureCodeSequence};
    protected AttributeTag[] patientStudyModuleAttributeTags = new AttributeTag[]{TagFromName.AdmittingDiagnosesDescription, TagFromName.AdmittingDiagnosesCodeSequence, TagFromName.PatientAge, TagFromName.PatientSize, TagFromName.PatientWeight, TagFromName.PatientSizeCodeSequence, TagFromName.Occupation, TagFromName.AdditionalPatientHistory, TagFromName.AdmissionID, TagFromName.IssuerOfAdmissionID, TagFromName.IssuerOfAdmissionIDSequence, TagFromName.ServiceEpisodeID, TagFromName.IssuerOfServiceEpisodeIDSequence, TagFromName.ServiceEpisodeDescription, TagFromName.PatientSexNeutered};
    protected AttributeTag[] generalSeriesModuleAttributeTags = new AttributeTag[]{TagFromName.Modality, TagFromName.SeriesInstanceUID, TagFromName.SeriesNumber, TagFromName.Laterality, TagFromName.SeriesDate, TagFromName.SeriesTime, TagFromName.PerformingPhysicianName, TagFromName.PerformingPhysicianIdentificationSequence, TagFromName.ProtocolName, TagFromName.SeriesDescription, TagFromName.SeriesDescriptionCodeSequence, TagFromName.OperatorsName, TagFromName.OperatorIdentificationSequence, TagFromName.ReferencedPerformedProcedureStepSequence, TagFromName.RelatedSeriesSequence, TagFromName.BodyPartExamined, TagFromName.PatientPosition, TagFromName.RequestAttributesSequence, TagFromName.PerformedProcedureStepID, TagFromName.PerformedProcedureStepStartDate, TagFromName.PerformedProcedureStepStartTime, TagFromName.PerformedProcedureStepDescription, TagFromName.PerformedProtocolCodeSequence, TagFromName.CommentsOnThePerformedProcedureStep, TagFromName.AnatomicalOrientationType};
    protected AttributeTag[] generalEquipmentModuleAttributeTags = new AttributeTag[]{TagFromName.Manufacturer, TagFromName.InstitutionName, TagFromName.InstitutionAddress, TagFromName.StationName, TagFromName.InstitutionalDepartmentName, TagFromName.ManufacturerModelName, TagFromName.DeviceSerialNumber, TagFromName.SoftwareVersions, TagFromName.GantryID, TagFromName.SpatialResolution, TagFromName.DateOfLastCalibration, TagFromName.TimeOfLastCalibration, TagFromName.PixelPaddingValue};
    protected AttributeTag[] frameOfReferenceModuleAttributeTags = new AttributeTag[]{TagFromName.FrameOfReferenceUID, TagFromName.PositionReferenceIndicator};
    protected AttributeTag[] sopCommonModuleAttributeTags = new AttributeTag[]{TagFromName.SOPClassUID, TagFromName.SOPInstanceUID, TagFromName.InstanceCreationDate, TagFromName.InstanceCreationTime, TagFromName.InstanceCreatorUID, TagFromName.RelatedGeneralSOPClassUID, TagFromName.OriginalSpecializedSOPClassUID, TagFromName.CodingSchemeIdentificationSequence, TagFromName.TimezoneOffsetFromUTC, TagFromName.ContributingEquipmentSequence, TagFromName.InstanceNumber, TagFromName.SOPInstanceStatus, TagFromName.SOPAuthorizationDateTime, TagFromName.SOPAuthorizationComment, TagFromName.AuthorizationEquipmentCertificationNumber, TagFromName.OriginalAttributesSequence, TagFromName.HL7StructuredDocumentReferenceSequence};
    protected AttributeTag[] srDocumentGeneralModuleAttributeTags = new AttributeTag[]{TagFromName.ReferencedRequestSequence, TagFromName.PerformedProcedureCodeSequence};

    public AttributeList getAttributeList() {
        return this.list;
    }

    protected void addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(AttributeList attributeList, AttributeTag attributeTag) {
        Attribute attribute = attributeList.get(attributeTag);
        if (attribute != null) {
            if (attribute.getVM() > 0 || attribute instanceof SequenceAttribute && ((SequenceAttribute)attribute).getNumberOfItems() > 0) {
                if (this.list.get(attributeTag) == null) {
                    this.list.put(attributeTag, attribute);
                }
            } else {
                this.list.put(attributeTag, attribute);
            }
        }
    }

    public CompositeInstanceContext() {
        this.list = new AttributeList();
    }

    public CompositeInstanceContext(AttributeList attributeList) {
        this.list = new AttributeList();
        this.updateFromSource(attributeList);
    }

    public void updateFromSource(AttributeList attributeList) {
        SequenceAttribute sequenceAttribute;
        int n;
        SequenceItem sequenceItem;
        int n2;
        SequenceAttribute sequenceAttribute2;
        SequenceAttribute sequenceAttribute3;
        int n3;
        for (AttributeTag attributeTag : this.patientModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.generalStudyModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.patientStudyModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.generalSeriesModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.generalEquipmentModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.frameOfReferenceModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.sopCommonModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        for (AttributeTag attributeTag : this.srDocumentGeneralModuleAttributeTags) {
            this.addOrReplaceIfNotEmptyOtherwiseLeaveUnchanged(attributeList, attributeTag);
        }
        Attribute attribute = this.list.get(TagFromName.ReferencedRequestSequence);
        Attribute attribute2 = this.list.get(TagFromName.RequestAttributesSequence);
        if ((attribute == null || !(attribute instanceof SequenceAttribute) || ((SequenceAttribute)attribute).getNumberOfItems() == 0) && attribute2 != null && attribute2 instanceof SequenceAttribute && (n3 = (sequenceAttribute3 = (SequenceAttribute)attribute2).getNumberOfItems()) > 0) {
            sequenceAttribute2 = new SequenceAttribute(TagFromName.ReferencedRequestSequence);
            for (n2 = 0; n2 < n3; ++n2) {
                sequenceItem = sequenceAttribute3.getItem(n2);
                sequenceAttribute2.addItem(sequenceItem);
            }
            this.list.put(sequenceAttribute2);
        }
        Attribute attribute3 = this.list.get(TagFromName.PerformedProcedureCodeSequence);
        attribute2 = this.list.get(TagFromName.ProcedureCodeSequence);
        if ((attribute3 == null || !(attribute3 instanceof SequenceAttribute) || ((SequenceAttribute)attribute3).getNumberOfItems() == 0) && attribute2 != null && attribute2 instanceof SequenceAttribute && (n = (sequenceAttribute = (SequenceAttribute)attribute2).getNumberOfItems()) > 0) {
            sequenceAttribute2 = new SequenceAttribute(TagFromName.PerformedProcedureCodeSequence);
            for (n2 = 0; n2 < n; ++n2) {
                sequenceItem = sequenceAttribute.getItem(n2);
                sequenceAttribute2.addItem(sequenceItem);
            }
            this.list.put(sequenceAttribute2);
        }
    }

    public void updateFromSource(CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages) {
        if (cTIrradiationEventDataFromImages != null) {
            StringAttribute stringAttribute;
            String string;
            try {
                string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientAge);
                if (string.length() == 0 && (string = cTIrradiationEventDataFromImages.getPatientAge()) != null && string.length() > 0) {
                    stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
                    ((Attribute)stringAttribute).addValue(string);
                    this.list.put(stringAttribute);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            try {
                string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientSex);
                if (string.length() == 0 && (string = cTIrradiationEventDataFromImages.getPatientSex()) != null && string.length() > 0) {
                    stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
                    ((Attribute)stringAttribute).addValue(string);
                    this.list.put(stringAttribute);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            try {
                string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientWeight);
                if (string.length() == 0 && (string = cTIrradiationEventDataFromImages.getPatientWeight()) != null && string.length() > 0) {
                    stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
                    ((Attribute)stringAttribute).addValue(string);
                    this.list.put(stringAttribute);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            try {
                string = Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.PatientSize);
                if (string.length() == 0 && (string = cTIrradiationEventDataFromImages.getPatientSize()) != null && string.length() > 0) {
                    stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
                    ((Attribute)stringAttribute).addValue(string);
                    this.list.put(stringAttribute);
                }
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
        }
    }

    public void removePatient() {
        for (AttributeTag attributeTag : this.patientModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeStudy() {
        for (AttributeTag attributeTag : this.generalStudyModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
        for (AttributeTag attributeTag : this.patientStudyModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeSeries() {
        for (AttributeTag attributeTag : this.generalSeriesModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeEquipment() {
        for (AttributeTag attributeTag : this.generalEquipmentModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeFrameOfReference() {
        for (AttributeTag attributeTag : this.frameOfReferenceModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeInstance() {
        for (AttributeTag attributeTag : this.sopCommonModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void removeSRDocumentGeneral() {
        for (AttributeTag attributeTag : this.srDocumentGeneralModuleAttributeTags) {
            this.list.remove(attributeTag);
        }
    }

    public void put(Attribute attribute) {
        this.list.put(attribute);
    }

    public void putAll(AttributeList attributeList) {
        this.list.putAll(attributeList);
    }

    public String toString() {
        return this.list.toString();
    }
}

