/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ScanRange {
    protected String startDirection;
    protected String startLocation;
    protected String endDirection;
    protected String endLocation;
    protected String absoluteRange;

    public ScanRange(String string, String string2, String string3, String string4) {
        this.startDirection = string;
        this.startLocation = string2;
        this.endDirection = string3;
        this.endLocation = string4;
        this.absoluteRange = null;
    }

    public String getStartDirection() {
        return this.startDirection;
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public String getEndDirection() {
        return this.endDirection;
    }

    public String getEndLocation() {
        return this.endLocation;
    }

    public String getAbsoluteRange() {
        if (this.absoluteRange == null) {
            double d;
            double d2 = Double.parseDouble(this.startLocation);
            if (this.startDirection == "I") {
                d2 = -d2;
            }
            double d3 = Double.parseDouble(this.endLocation);
            if (this.endDirection == "I") {
                d3 = -d3;
            }
            if ((d = d2 - d3) < 0.0) {
                d = -d;
            }
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.setMaximumFractionDigits(3);
            decimalFormat.setMinimumFractionDigits(3);
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
            decimalFormat.setGroupingUsed(false);
            this.absoluteRange = decimalFormat.format(d);
        }
        return this.absoluteRange;
    }

    public String toString() {
        return this.startDirection + this.startLocation + "-" + this.endDirection + this.endLocation;
    }

    public boolean equals(Object object) {
        ScanRange scanRange;
        boolean bl = false;
        bl = object instanceof ScanRange ? (scanRange = (ScanRange)object).getStartDirection().equals(this.getStartDirection()) && scanRange.getStartLocation().equals(this.getStartLocation()) && scanRange.getEndDirection().equals(this.getEndDirection()) && scanRange.getEndLocation().equals(this.getEndLocation()) : false;
        return bl;
    }

    public int hashCode() {
        return this.getStartDirection().hashCode() + this.getStartLocation().hashCode() + this.getEndDirection().hashCode() + this.getEndLocation().hashCode();
    }
}

