/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnknownAttribute;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.doseocr.GenerateRadiationDoseStructuredReport;
import com.pixelmed.utils.FloatFormatter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExposureDoseSequence {
    private static AttributeTag privateDLPTag = new AttributeTag(225, 4129);

    public static String getValuesFromCommentsOnRadiationDose(AttributeList attributeList, Map<String, String> map, Map<String, String> map2, int n) throws IOException {
        if (n > 0) {
            System.err.println("ExposureDoseSequence.getValuesFromCommentsOnRadiationDose():");
        }
        String string = "";
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CommentsOnRadiationDose).toUpperCase().trim();
        if (string2.length() > 0) {
            Pattern pattern = Pattern.compile("[ \t]*SERIES #[ \t]*([0-9]+)[ \t]*.*CTDIVOL[ \t]*=[ \t]*([0-9]*[.][0-9]*)[ \t]+DLP[ \t]*=[ \t]*([0-9]*[.][0-9]*).*");
            Pattern pattern2 = Pattern.compile("[ \t]*TOTAL[ \t]*DLP=[ \t]*([0-9]*[.][0-9]*).*");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2.toString()));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n2;
                Matcher matcher;
                string3 = string3.toUpperCase();
                if (n > 0) {
                    System.err.println(string3);
                }
                if (string3.contains("SERIES")) {
                    matcher = pattern.matcher(string3);
                    if (!matcher.matches()) continue;
                    if (n > 0) {
                        System.err.println("matches");
                    }
                    n2 = matcher.groupCount();
                    if (n > 0) {
                        System.err.println("groupCount = " + n2);
                    }
                    if (n2 < 3) continue;
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    String string6 = matcher.group(3);
                    if (n > 0) {
                        System.err.println("series = " + string4 + ", CTDIVol = " + string5 + ", DLP = " + string6);
                    }
                    if (string4.length() <= 0) continue;
                    map2.put(string4, string5);
                    map.put(string4, string6);
                    continue;
                }
                if (!string3.contains("TOTAL") || !(matcher = pattern2.matcher(string3)).matches()) continue;
                if (n > 0) {
                    System.err.println("matches");
                }
                n2 = matcher.groupCount();
                if (n > 0) {
                    System.err.println("groupCount = " + n2);
                }
                if (n2 < 1) continue;
                string = matcher.group(1);
                if (n <= 0) continue;
                System.err.println("totalDLPFromCommentsOnRadiationDose = " + string);
            }
        }
        return string;
    }

    public static String getPhilipsPrivateDLPValue(AttributeList attributeList) throws DicomException {
        String string = "";
        Attribute attribute = attributeList.get(privateDLPTag);
        if (attribute instanceof UnknownAttribute) {
            byte[] byArray = attribute.getByteValues();
            string = new String(byArray);
            string = FloatFormatter.toString(new Double(string));
        } else {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, privateDLPTag);
        }
        return string;
    }

    public static boolean isPossiblyPhilipsDoseScreenSeries(String string, String string2, String string3) {
        return string != null && string.equals("CT") && string3 != null && string3.toLowerCase().trim().equals("dose info");
    }

    public static boolean isPossiblyPhilipsDoseScreenSeries(AttributeList attributeList) {
        return ExposureDoseSequence.isPossiblyPhilipsDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), null, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
    }

    public static boolean isPossiblyPhilipsDoseScreenInstance(String string, String string2) {
        return string2 != null && (string2.contains("DOSE_INFO") || string2.contains("DOSE-INFO") || string2.contains("LOCALIZER"));
    }

    public static boolean isPossiblyPhilipsDoseScreenInstance(AttributeList attributeList) {
        return ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isPhilipsDoseScreenInstance(AttributeList attributeList) {
        String string = Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, "").trim();
        return Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription).toLowerCase().trim().equals("dose info") && ExposureDoseSequence.isPossiblyPhilipsDoseScreenInstance(attributeList) && attributeList.get(TagFromName.ExposureDoseSequence) != null;
    }

    public static CTDose getCTDoseFromPhilipsDoseScreen(AttributeList attributeList, int n, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException, DicomException {
        if (n > 0) {
            System.err.println("ExposureDoseSequence.getCTDoseFromPhilipsDoseScreen():");
        }
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        String string3 = null;
        String string4 = null;
        if (cTIrradiationEventDataFromImages != null) {
            string3 = cTIrradiationEventDataFromImages.getOverallEarliestAcquisitionDateTimeForStudy(string);
            string4 = cTIrradiationEventDataFromImages.getOverallLatestAcquisitionDateTimeForStudy(string);
        }
        if ((string3 == null || string3.trim().length() == 0 && attributeList != null) && (string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string3.length() == 8) {
            string3 = string3 + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string3, string4, string2);
        CodedSequenceItem codedSequenceItem = null;
        Object object = CTAnatomy.findAnatomicConcept(attributeList);
        if (object != null) {
            codedSequenceItem = ((CodedConcept)object).getCodedSequenceItem();
        }
        object = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string5 = ExposureDoseSequence.getValuesFromCommentsOnRadiationDose(attributeList, (Map<String, String>)object, hashMap, n);
        Object object2 = ExposureDoseSequence.getPhilipsPrivateDLPValue(attributeList);
        if (object2 == null || ((String)object2).length() == 0) {
            if (n > 0) {
                System.err.println("Cannot get total DLP from private attribute - using value parsed from CommentsOnRadiationDose if present");
            }
            object2 = string5;
        }
        cTDose.setDLPTotal((String)object2);
        object2 = attributeList.get(TagFromName.ExposureDoseSequence);
        if (object2 != null && object2 instanceof SequenceAttribute) {
            Iterator iterator = ((SequenceAttribute)object2).iterator();
            while (iterator.hasNext()) {
                String string6;
                SequenceItem sequenceItem = (SequenceItem)iterator.next();
                if (sequenceItem == null) continue;
                AttributeList attributeList2 = sequenceItem.getAttributeList();
                if (n > 1) {
                    System.err.print(attributeList2);
                }
                String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionDateTime);
                String string8 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesDescription);
                String string9 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.KVP);
                double d = Attribute.getSingleDoubleValueOrDefault(attributeList2, TagFromName.ExposureTime, 0.0);
                String string10 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.RadiationMode);
                String string11 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.FilterType);
                String string12 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.ScanLength);
                double d2 = Attribute.getSingleDoubleValueOrDefault(attributeList2, TagFromName.XRayTubeCurrentInuA, 0.0);
                String string13 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.AcquisitionType);
                String string14 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SingleCollimationWidth);
                String string15 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.TotalCollimationWidth);
                String string16 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SpiralPitchFactor);
                String string17 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.EstimatedDoseSaving);
                String string18 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.CTDIvol);
                String string19 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SeriesNumber);
                String string20 = Attribute.getSingleStringValueOrEmptyString(attributeList2, TagFromName.SliceLocation);
                String string21 = ExposureDoseSequence.getPhilipsPrivateDLPValue(attributeList2);
                String string22 = d > 0.0 ? FloatFormatter.toString(new Double(d) / 1000.0) : null;
                String string23 = string6 = d2 > 0.0 ? FloatFormatter.toString(new Double(d2) / 1000.0) : null;
                if (string19.length() > 0) {
                    if (string18.length() == 0) {
                        if (n > 0) {
                            System.err.println("Cannot get per series CTDIvol from private attribute - using value parsed from CommentsOnRadiationDose if present");
                        }
                        if ((string18 = (String)hashMap.get(string19)) == null) {
                            string18 = "";
                        }
                    }
                    if (string21.length() == 0) {
                        if (n > 0) {
                            System.err.println("Cannot get per series DLP from private attribute - using value parsed from CommentsOnRadiationDose if present");
                        }
                        if ((string21 = (String)object.get(string19)) == null) {
                            string21 = "";
                        }
                    }
                }
                if (string18.equals("0")) {
                    string18 = "";
                }
                if (string21.equals("0")) {
                    string21 = "";
                }
                if (n > 0) {
                    System.err.println("acquisitionType = " + string13);
                }
                CTScanType cTScanType = CTScanType.selectFromDescription(string13);
                if (n > 0) {
                    System.err.println("recognizedScanType = " + cTScanType);
                }
                CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string, true, string19, cTScanType, null, string18, string21, null);
                CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(null, CTScanType.UNKNOWN, codedSequenceItem, string22, string12, string14, string15, string16, string9, string6, string6, null);
                if (n > 0) {
                    System.err.println("CTDIvol = " + string18);
                }
                if (n > 0) {
                    System.err.println("DLP = " + string21);
                }
                if (string18.length() > 0 && string21.length() > 0) {
                    cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVol(string21, string18);
                }
                cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
                cTDose.addAcquisition(cTDoseAcquisition);
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static final void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 && !stringArray[0].equals("-") ? stringArray[0] : null;
            String string2 = stringArray.length > 1 && !stringArray[1].equals("-") ? stringArray[1] : null;
            String string3 = stringArray.length > 2 && !stringArray[2].equals("-") ? stringArray[2] : null;
            int n = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : -1;
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = null;
            if (string2 != null) {
                cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(string2);
                System.err.print(cTIrradiationEventDataFromImages);
                if (string == null) {
                    string = cTIrradiationEventDataFromImages.getDoseScreenOrStructuredReportFilenames(true, false).get(0);
                }
            }
            AttributeList attributeList = new AttributeList();
            attributeList.read(string);
            CTDose cTDose = ExposureDoseSequence.getCTDoseFromPhilipsDoseScreen(attributeList, n, cTIrradiationEventDataFromImages, string3 != null);
            System.err.print(cTDose.toString(true, true));
            if (!cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions()) {
                System.err.println("############ specified DLP total (" + cTDose.getDLPTotal() + ") does not match DLP total from acquisitions (" + cTDose.getDLPTotalFromAcquisitions() + ")");
            }
            if (string3 != null) {
                cTDose.write(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

