/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.CompositeInstanceContext;
import com.pixelmed.dose.DeviceParticipant;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import java.util.ArrayList;
import java.util.Vector;

public class GenerateRadiationDoseStructuredReport {
    public static CTDose generateDoseReportInformationFromFiles(Vector vector) {
        CTDose cTDose = null;
        CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(vector);
        ArrayList<String> arrayList = cTIrradiationEventDataFromImages.getDoseScreenOrStructuredReportFilenames();
        for (String string : arrayList) {
            try {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                if (OCR.isDoseScreenInstance(attributeList)) {
                    OCR oCR = new OCR(attributeList, 0);
                    cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, 0, cTIrradiationEventDataFromImages, true);
                    break;
                }
                if (!ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) continue;
                cTDose = ExposureDoseSequence.getCTDoseFromPhilipsDoseScreen(attributeList, 0, cTIrradiationEventDataFromImages, true);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return cTDose;
    }

    public static void createContextForNewRadiationDoseStructuredReportFromExistingInstance(AttributeList attributeList, CTDose cTDose, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages) {
        if (attributeList != null) {
            Object object;
            cTDose.setSourceSOPInstanceUID(Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID));
            CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext(attributeList);
            compositeInstanceContext.removeSeries();
            compositeInstanceContext.removeInstance();
            UIDGenerator uIDGenerator = new UIDGenerator();
            try {
                object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
                ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
                compositeInstanceContext.put((Attribute)object);
                object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
                compositeInstanceContext.put((Attribute)object);
                object = new IntegerStringAttribute(TagFromName.SeriesNumber);
                ((Attribute)object).addValue("897");
                compositeInstanceContext.put((Attribute)object);
                object = new IntegerStringAttribute(TagFromName.InstanceNumber);
                ((Attribute)object).addValue("1");
                compositeInstanceContext.put((Attribute)object);
                object = new DateAttribute(TagFromName.SeriesDate);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDate));
                compositeInstanceContext.put((Attribute)object);
                object = new TimeAttribute(TagFromName.SeriesTime);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesTime));
                compositeInstanceContext.put((Attribute)object);
                object = new DateAttribute(TagFromName.ContentDate);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentDate));
                compositeInstanceContext.put((Attribute)object);
                object = new TimeAttribute(TagFromName.ContentTime);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentTime));
                compositeInstanceContext.put((Attribute)object);
                object = new LongStringAttribute(TagFromName.SeriesDescription);
                ((Attribute)object).addValue("Radiation Dose Information");
                compositeInstanceContext.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.CompletionFlag);
                ((Attribute)object).addValue("COMPLETE");
                compositeInstanceContext.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.VerificationFlag);
                ((Attribute)object).addValue("UNVERIFIED");
                compositeInstanceContext.put((Attribute)object);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            object = attributeList.get(TagFromName.ReferencedPerformedProcedureStepSequence);
            if (object == null) {
                object = new SequenceAttribute(TagFromName.ReferencedPerformedProcedureStepSequence);
            }
            compositeInstanceContext.put((Attribute)object);
            object = compositeInstanceContext.getAttributeList().get(TagFromName.PerformedProcedureCodeSequence);
            if (object == null) {
                object = new SequenceAttribute(TagFromName.PerformedProcedureCodeSequence);
            }
            compositeInstanceContext.put((Attribute)object);
            object = compositeInstanceContext.getAttributeList();
            String string = DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative((AttributeList)object, true);
            compositeInstanceContext.updateFromSource(cTIrradiationEventDataFromImages);
            cTDose.setCompositeInstanceContext(compositeInstanceContext);
            String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PerformingPhysicianName);
            if (string2 == null) {
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhysiciansOfRecord);
            }
            if (string2 == null) {
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.NameOfPhysiciansReadingStudy);
            }
            CommonDoseObserverContext commonDoseObserverContext = new CommonDoseObserverContext("", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StationName), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ManufacturerModelName), string, "", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.OperatorsName), "", string2, "", "", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InstitutionName));
            cTDose.setObserverContext(commonDoseObserverContext);
        }
    }

    public static final void main(String[] stringArray) {
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
            CTDose cTDose = GenerateRadiationDoseStructuredReport.generateDoseReportInformationFromFiles(vector);
            System.err.println(cTDose);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

