/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.doseocr.GenerateRadiationDoseStructuredReport;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OCR {
    public static String defaultFileNameOfKnownGlyphs = "OCR_Glyphs_DoseScreen.xml";
    private static int debugLevel;
    private static int maximumNumberOfConnections;
    private static int defaultGEHorizontalGapTolerance;
    private static int defaultGEVerticalGapTolerance;
    private static int defaultSiemensHorizontalGapTolerance;
    private static int defaultSiemensVerticalGapTolerance;
    private BufferedImage image;
    private int height;
    private int width;
    private BitSet thresholdedPixels;
    private BitSet processedPixels;
    private Map<Glyph, String> mapOfGlyphsToStrings;
    private Map<Location, Glyph> mapOfRecognizedLocationsToGlyphs;
    private Map<Location, Glyph> mapOfUnrecognizedLocationsToGlyphs;
    private boolean trainingMode;
    private AttributeList list;

    public AttributeList getAttributeList() {
        return this.list;
    }

    private static final int getBitSetIndex(int n, int n2, int n3) {
        return n2 * n3 + n;
    }

    private static final int getXFromBitSetIndex(int n, int n2) {
        return n % n2;
    }

    private static final int getYFromBitSetIndex(int n, int n2) {
        return n / n2;
    }

    private final int getBitSetIndex(int n, int n2) {
        return n2 * this.width + n;
    }

    private final int getXFromBitSetIndex(int n) {
        return n % this.width;
    }

    private final int getYFromBitSetIndex(int n) {
        return n / this.width;
    }

    private final boolean isPixelOn(int n, int n2) {
        return this.thresholdedPixels.get(OCR.getBitSetIndex(n, n2, this.width));
    }

    private final boolean isProcessed(int n, int n2) {
        return this.processedPixels.get(OCR.getBitSetIndex(n, n2, this.width));
    }

    private final void setProcessed(int n, int n2) {
        this.processedPixels.set(OCR.getBitSetIndex(n, n2, this.width));
    }

    private static int findLowestXSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getXFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 < n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static int findLowestYSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getYFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 < n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static int findHighestXSetInBitSet(BitSet bitSet, int n) {
        if (debugLevel > 1) {
            System.err.println("findHighestXSetInBitSet(): width = " + n + ", set =" + bitSet);
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = bitSet.cardinality();
        if (debugLevel > 1) {
            System.err.println("findHighestXSetInBitSet(): cardinality = " + n3);
        }
        if (n3 > 0) {
            int n4 = bitSet.length();
            if (debugLevel > 1) {
                System.err.println("findHighestXSetInBitSet(): length = " + n4);
            }
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getXFromBitSetIndex(n5, n);
                    if (debugLevel > 1) {
                        System.err.println("findHighestXSetInBitSet(): testing x = " + n7);
                    }
                    ++n6;
                    if (n7 > n2) {
                        if (debugLevel > 1) {
                            System.err.println("findHighestXSetInBitSet(): found x = " + n7);
                        }
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        if (debugLevel > 1) {
            System.err.println("findHighestXSetInBitSet(): returning x = " + n2);
        }
        return n2;
    }

    private static int findHighestYSetInBitSet(BitSet bitSet, int n) {
        int n2 = Integer.MIN_VALUE;
        int n3 = bitSet.cardinality();
        if (n3 > 0) {
            int n4 = bitSet.length();
            assert (n4 > 0);
            int n5 = n4 - 1;
            int n6 = 0;
            while (n6 < n3) {
                if (bitSet.get(n5)) {
                    int n7 = OCR.getYFromBitSetIndex(n5, n);
                    ++n6;
                    if (n7 > n2) {
                        n2 = n7;
                    }
                }
                --n5;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static BitSet threshold(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getColorModel().getPixelSize();
        if (debugLevel > 2) {
            System.err.println("OCR.threshold(): image pixel size (bpp) = " + n2);
        }
        int n3 = n = n2 > 1 ? 127 : 0;
        if (debugLevel > 2) {
            System.err.println("OCR.threshold(): thresholdValue = " + n);
        }
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage.getWidth();
        WritableRaster writableRaster = bufferedImage.getRaster();
        BitSet bitSet = new BitSet(n4 * n5);
        int[] nArray = new int[1];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                writableRaster.getPixel(j, i, nArray);
                if (debugLevel > 3) {
                    System.err.println("(" + j + "," + i + ") pixelValue = " + nArray[0]);
                }
                if (nArray[0] <= n) continue;
                if (debugLevel > 1) {
                    System.err.println("Setting (" + j + "," + i + ") for pixelValue = " + nArray[0]);
                }
                bitSet.set(OCR.getBitSetIndex(j, i, n5));
            }
        }
        return bitSet;
    }

    private int checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(int n, int n2, BitSet bitSet, int n3, int n4, int n5) throws ConnectednessException {
        if (n5 > maximumNumberOfConnections) {
            throw new ConnectednessException();
        }
        if (debugLevel > 2) {
            System.err.println("Check\t(" + n + "," + n2 + ")");
        }
        if (debugLevel > 2) {
            System.err.println("\t(" + n + "," + n2 + ") in bounds=" + (n > 0 && n < this.width && n2 > 0 && n2 < this.height));
        }
        if (debugLevel > 2) {
            System.err.println("\t(" + n + "," + n2 + ") isProcessed()=" + this.isProcessed(n, n2));
        }
        if (debugLevel > 2) {
            System.err.println("\t(" + n + "," + n2 + ") isPixelOn()=" + this.isPixelOn(n, n2));
        }
        if (n > 0 && n < this.width && n2 > 0 && n2 < this.height && !this.isProcessed(n, n2) && this.isPixelOn(n, n2)) {
            if (debugLevel > 2) {
                System.err.println("Doing\t(" + n + "," + n2 + ")");
            }
            this.setProcessed(n, n2);
            bitSet.set(this.getBitSetIndex(n, n2));
            ++n5;
            n5 = this.walkConnectionsRecordingThem(n, n2, bitSet, n3, n4, n5);
        }
        return n5;
    }

    private int walkConnectionsRecordingThem(int n, int n2, BitSet bitSet, int n3, int n4, int n5) throws ConnectednessException {
        for (int i = 1; i <= n4; ++i) {
            for (int j = 1; j <= n3; ++j) {
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n - j, n2 + i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2 + i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2 - i, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2, bitSet, n3, n4, n5);
                n5 = this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n + j, n2 + i, bitSet, n3, n4, n5);
            }
        }
        return n5;
    }

    private String processCandidate(int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException, ConnectednessException {
        String string = null;
        if (!this.isProcessed(n, n2) && this.isPixelOn(n, n2)) {
            if (debugLevel > 1) {
                System.err.println("Candidate at (" + n + "," + n2 + ")");
            }
            if (debugLevel > 1) {
                System.err.println("\t(" + n + "," + n2 + ") isProcessed()=" + this.isProcessed(n, n2));
            }
            if (debugLevel > 1) {
                System.err.println("\t(" + n + "," + n2 + ") isPixelOn()=" + this.isPixelOn(n, n2));
            }
            Location location = new Location(n, n2);
            BitSet bitSet = new BitSet();
            try {
                this.checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse(n, n2, bitSet, n4, n5, 0);
            }
            catch (ConnectednessException connectednessException) {
                throw new ConnectednessException();
            }
            if (bitSet.isEmpty()) {
                if (debugLevel > 1) {
                    System.err.println("\tduring connectedness search, get empty set back from checkInBoundsAndNotProcessedAndPixelIsOnAndIfSoRecordAndRecurse() for candidate at (" + n + "," + n2 + ")");
                }
            } else {
                Location location2;
                int n6;
                int n7 = OCR.findLowestXSetInBitSet(bitSet, this.width);
                if (n7 < 0) {
                    if (debugLevel > 1) {
                        System.err.println("\tduring connectedness search, lowestX for TLHC is out of bounds = " + n7 + ", using 0");
                    }
                    n7 = 0;
                }
                if ((n6 = OCR.findLowestYSetInBitSet(bitSet, this.width)) < 0) {
                    if (debugLevel > 1) {
                        System.err.println("\tduring connectedness search, lowestY for TLHC is out of bounds = " + n6 + ", using 0");
                    }
                    n6 = 0;
                }
                if (!(location2 = new Location(n7, n6)).equals(location) && debugLevel > 1) {
                    System.err.println("\tduring connectedness search, TLHC moved from " + location + " to " + location2);
                }
                Glyph glyph = new Glyph(bitSet, this.width, false);
                if (debugLevel > 1) {
                    System.err.print(glyph);
                }
                if ((string = this.mapOfGlyphsToStrings.get(glyph)) != null) {
                    if (debugLevel > 1) {
                        System.err.println("Recognized " + string);
                    }
                    if (bl) {
                        this.mapOfRecognizedLocationsToGlyphs.put(location2, glyph);
                    }
                } else {
                    if (this.trainingMode) {
                        System.out.print(glyph + "Please enter string match: ");
                        string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    }
                    if (string != null && string.length() > 0) {
                        this.mapOfGlyphsToStrings.put(glyph, string);
                        if (debugLevel > 1) {
                            System.err.println("Map " + string + " = \n" + glyph);
                        }
                        if (bl) {
                            this.mapOfRecognizedLocationsToGlyphs.put(location2, glyph);
                        }
                    } else {
                        string = null;
                        if (debugLevel > 1) {
                            System.err.println("Adding unrecognized glyph at location " + location2 + ", width = " + glyph.getWidth() + ", BRHC = (" + (location2.getX() + glyph.getWidth() - 1) + "," + (location2.getY() + glyph.getHeight() - 1) + ")\n" + glyph);
                        }
                        this.mapOfUnrecognizedLocationsToGlyphs.put(location2, glyph);
                    }
                }
            }
        }
        return string;
    }

    private boolean findConnectedCandidatesAnywhereInImage(int n, int n2) throws IOException, ConnectednessException {
        boolean bl = false;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.processCandidate(j, i, i, n, n2, true) == null) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean findConnectedCandidatesWithinUnrecognizedGlyphs(int n, int n2) throws IOException, ConnectednessException {
        boolean bl = false;
        Location[] locationArray = this.mapOfUnrecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        for (int i = 0; i < locationArray.length; ++i) {
            int n3;
            Location location = locationArray[i];
            Glyph glyph = this.mapOfUnrecognizedLocationsToGlyphs.get(location);
            this.mapOfUnrecognizedLocationsToGlyphs.remove(location);
            String string = "";
            int n4 = location.getX();
            int n5 = location.getY();
            int n6 = n4 + glyph.getWidth() - 1;
            int n7 = n3 = n5 + glyph.getHeight() - 1;
            if (debugLevel > 1) {
                System.err.println("findConnectedCandidatesWithinUnrecognizedGlyphs(): scan within box from TLHC (" + n4 + "," + n5 + ") to BRHC (" + n6 + "," + n3 + ")");
            }
            for (int j = n4; j <= n6; ++j) {
                for (int k = n5; k <= n3; ++k) {
                    String string2 = this.processCandidate(j, k, n7, n, n2, false);
                    if (string2 == null) continue;
                    string = string + string2;
                }
            }
            if (string.length() <= 0) continue;
            bl = true;
            this.mapOfGlyphsToStrings.put(glyph, string);
            this.mapOfRecognizedLocationsToGlyphs.put(location, glyph);
        }
        return bl;
    }

    private void flagAsProcessedLocationsAlreadyRecognized() {
        Location[] locationArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        for (int i = 0; i < locationArray.length; ++i) {
            Location location = locationArray[i];
            Glyph glyph = this.mapOfRecognizedLocationsToGlyphs.get(location);
            int n = location.getX();
            int n2 = location.getY();
            int n3 = n + glyph.getWidth() - 1;
            int n4 = n2 + glyph.getHeight() - 1;
            if (debugLevel > 1) {
                System.err.println("flagAsProcessedLocationsAlreadyRecognized box from TLHC (" + n + "," + n2 + ") to BRHC (" + n3 + "," + n4 + ")");
            }
            for (int j = n2; j <= n4; ++j) {
                for (int k = n; k <= n3; ++k) {
                    this.setProcessed(k, j);
                }
            }
        }
    }

    private String dumpGlyphsAsXML(boolean bl, boolean bl2) throws IOException {
        Iterator<Glyph> iterator = this.mapOfGlyphsToStrings.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<glyphs>\n");
        while (iterator.hasNext()) {
            Glyph glyph = iterator.next();
            if (bl && glyph.getWasKnown()) continue;
            boolean bl3 = false;
            if (bl2 && !glyph.getWasKnown()) {
                System.out.print(glyph + "Record it in dictionary, Y or N [N]: ");
                String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (string != null && string.length() > 0 && string.trim().toUpperCase().equals("Y")) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (!bl3) continue;
            System.err.println("Recorded \"" + glyph.getString() + "\"");
            stringBuffer.append(glyph.toXML());
        }
        stringBuffer.append("</glyphs>\n");
        return stringBuffer.toString();
    }

    private String dumpStrings() {
        Object[] objectArray = this.mapOfGlyphsToStrings.values().toArray(new String[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append((String)objectArray[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String dumpLocations() {
        Object[] objectArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append(object);
            stringBuffer.append(": \"");
            stringBuffer.append(this.mapOfRecognizedLocationsToGlyphs.get(object).getString());
            stringBuffer.append("\"\n");
        }
        return stringBuffer.toString();
    }

    private String dumpLines(boolean bl) {
        Object[] objectArray = this.mapOfRecognizedLocationsToGlyphs.keySet().toArray(new Location[0]);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (((Location)object).getY() != n) {
                if (n != -1) {
                    if (bl) {
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("\n");
                }
                n = ((Location)object).getY();
                if (bl) {
                    stringBuffer.append(n);
                    stringBuffer.append(": \"");
                }
                n2 = 0;
            }
            if (((Location)object).getX() - n2 > 5) {
                stringBuffer.append("\t");
            }
            Glyph glyph = this.mapOfRecognizedLocationsToGlyphs.get(object);
            stringBuffer.append(glyph.getString());
            n2 = ((Location)object).getX() + glyph.getWidth();
        }
        if (bl) {
            stringBuffer.append("\"");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void initializeGlyphsFromFile(String string) throws IOException, ParserConfigurationException, SAXException {
        Element element;
        InputStream inputStream;
        Object object;
        try {
            object = Thread.currentThread().getContextClassLoader();
            inputStream = ((ClassLoader)object).getResourceAsStream("com/pixelmed/doseocr/" + string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            inputStream = null;
        }
        if (inputStream == null) {
            if (debugLevel > 1) {
                System.err.println("initializeGlyphsFromFile(): could not get from class loader as resource, loading from file system");
            }
            inputStream = new FileInputStream(string);
        }
        if ((element = (object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream)).getDocumentElement()).getNodeType() == 1 && element.getNodeName().toLowerCase().equals("glyphs")) {
            if (debugLevel > 1) {
                System.err.print("initializeGlyphsFromFile(): got glyphs node");
            }
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object2;
                if (node.getNodeType() != 1 || !node.getNodeName().toLowerCase().equals("glyph")) continue;
                if (debugLevel > 1) {
                    System.err.print("initializeGlyphsFromFile(): got glyph node");
                }
                int n = 0;
                String string2 = "";
                BitSet bitSet = new BitSet();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1) continue;
                    object2 = node2.getNodeName().toLowerCase();
                    if (((String)object2).equals("bits")) {
                        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            if (node3.getNodeType() != 1 || !node3.getNodeName().toLowerCase().equals("bit")) continue;
                            bitSet.set(Integer.parseInt(node3.getTextContent().trim()));
                        }
                        continue;
                    }
                    if (((String)object2).equals("width")) {
                        n = Integer.parseInt(node2.getTextContent().trim());
                        continue;
                    }
                    if (!((String)object2).equals("string")) continue;
                    string2 = node2.getTextContent().trim();
                }
                if (n <= 0 || string2.length() <= 0 || bitSet.isEmpty()) continue;
                object2 = new Glyph(bitSet, n, true);
                this.mapOfGlyphsToStrings.put((Glyph)object2, string2);
                if (debugLevel <= 1) continue;
                System.err.print("initializeGlyphsFromFile(): stored glyph\n" + object2 + "\n");
            }
        }
    }

    public static BufferedImage getEightBitImageSuitableForThresholding(AttributeList attributeList, int n) throws DicomException {
        if (n > 1) {
            System.err.println("OCR(): supplied WindowWidth " + Attribute.getSingleStringValueOrNull(attributeList, TagFromName.WindowWidth));
        }
        if (n > 1) {
            System.err.println("OCR(): supplied WindowCenter " + Attribute.getSingleStringValueOrNull(attributeList, TagFromName.WindowCenter));
        }
        if (n > 1) {
            System.err.println("OCR(): supplied BitsStored " + Attribute.getSingleStringValueOrNull(attributeList, TagFromName.BitsStored));
        }
        if (n > 1) {
            System.err.println("OCR(): supplied PixelRepresentation " + Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PixelRepresentation));
        }
        if (n > 1) {
            System.err.println("OCR(): supplied RescaleIntercept " + Attribute.getSingleStringValueOrNull(attributeList, TagFromName.RescaleIntercept));
        }
        if (Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.WindowWidth, 0) != 1) {
            if (n > 1) {
                System.err.println("OCR(): window width is not 1, removing window values and leaving to statistical default");
            }
            attributeList.remove(TagFromName.WindowWidth);
            attributeList.remove(TagFromName.WindowCenter);
        } else if (n > 1) {
            System.err.println("OCR(): window width is 1, so leaving window values alone");
        }
        return ConsumerFormatImageMaker.makeEightBitImage(attributeList, n);
    }

    public OCR(String string) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(string, defaultFileNameOfKnownGlyphs, null, 0);
    }

    public OCR(String string, String string2, String string3, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        if (n > 0) {
            System.err.println("OCR(): file " + string);
        }
        BufferedImage bufferedImage = null;
        if (DicomFileUtilities.isDicomOrAcrNemaFile(string)) {
            AttributeList attributeList = new AttributeList();
            attributeList.read(string);
            this.doCommonConstructorStuff(attributeList, string2, string3, n);
        } else {
            this.list = null;
            bufferedImage = ImageIO.read(new File(string));
            this.doCommonConstructorStuff(bufferedImage, string2, string3, n);
        }
    }

    public OCR(AttributeList attributeList) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(attributeList, defaultFileNameOfKnownGlyphs, null, 0);
    }

    public OCR(AttributeList attributeList, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this(attributeList, defaultFileNameOfKnownGlyphs, null, n);
    }

    public OCR(AttributeList attributeList, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.doCommonConstructorStuff(attributeList, string, string2, n);
    }

    public OCR(BufferedImage bufferedImage, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.doCommonConstructorStuff(bufferedImage, string, string2, n);
    }

    protected void doCommonConstructorStuff(AttributeList attributeList, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.list = attributeList;
        BufferedImage bufferedImage = null;
        Overlay overlay = new Overlay(attributeList);
        if (overlay.getNumberOfOverlays(0) > 0) {
            if (n > 0) {
                System.err.println("OCR(): using overlay rather than pixel data");
            }
            bufferedImage = overlay.getOverlayAsBinaryBufferedImage(0, 0);
        } else {
            bufferedImage = OCR.getEightBitImageSuitableForThresholding(attributeList, n);
        }
        this.doCommonConstructorStuff(bufferedImage, string, string2, n);
    }

    protected void doCommonConstructorStuff(BufferedImage bufferedImage, String string, String string2, int n) throws IOException, ParserConfigurationException, SAXException, Exception {
        debugLevel = n;
        this.image = bufferedImage;
        this.height = bufferedImage.getHeight();
        this.width = bufferedImage.getWidth();
        this.thresholdedPixels = OCR.threshold(bufferedImage);
        this.processedPixels = new BitSet(this.height * this.width);
        this.mapOfGlyphsToStrings = new HashMap<Glyph, String>();
        this.mapOfRecognizedLocationsToGlyphs = new HashMap<Location, Glyph>();
        this.mapOfUnrecognizedLocationsToGlyphs = new HashMap<Location, Glyph>();
        if (string != null && string.length() > 0) {
            this.initializeGlyphsFromFile(string);
        }
        boolean bl = this.trainingMode = string2 != null && string2.length() > 0;
        if (OCR.isGEDoseScreenInstance(this.list)) {
            this.findConnectedCandidatesAnywhereInImage(defaultGEHorizontalGapTolerance, defaultGEVerticalGapTolerance);
        } else if (OCR.isSiemensDoseScreenInstance(this.list)) {
            this.findConnectedCandidatesAnywhereInImage(defaultSiemensHorizontalGapTolerance, defaultSiemensVerticalGapTolerance);
        }
        this.processedPixels.clear();
        this.findConnectedCandidatesWithinUnrecognizedGlyphs(1, 1);
        if (n > 1) {
            System.err.print(this.dumpStrings());
        }
        if (n > 1) {
            System.err.print(this.dumpGlyphsAsXML(true, false));
        }
        if (this.trainingMode) {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(this.dumpGlyphsAsXML(false, true));
            fileWriter.close();
        }
        if (n > 1) {
            System.err.print(this.dumpLocations());
        }
        if (n > 0) {
            System.err.print(this.dumpLines(true));
        }
    }

    public String toString() {
        return this.dumpLines(false);
    }

    public static boolean isPossiblyGEDoseScreenSeries(String string, String string2, String string3) {
        return string != null && string.equals("CT") && string2 != null && string2.trim().equals("999");
    }

    public static boolean isPossiblyGEDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber), null);
    }

    public static boolean isPossiblyGEDoseScreenInstance(String string, String string2) {
        return string2 != null && string2.trim().equals("DERIVED\\SECONDARY\\SCREEN SAVE");
    }

    public static boolean isPossiblyGEDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isGEDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(attributeList) && Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).trim().equals("999");
    }

    public static boolean isPossiblySiemensDoseScreenSeries(String string, String string2, String string3) {
        return string != null && string.equals("CT") && string2 != null && string2.equals("501");
    }

    public static boolean isPossiblySiemensDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblySiemensDoseScreenSeries(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber), null);
    }

    public static boolean isPossiblySiemensDoseScreenInstance(String string, String string2) {
        return string2 != null && string2.trim().equals("DERIVED\\SECONDARY\\OTHER\\CT_SOM5 PROT");
    }

    public static boolean isPossiblySiemensDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblySiemensDoseScreenInstance(null, Attribute.getDelimitedStringValuesOrDefault(attributeList, TagFromName.ImageType, ""));
    }

    public static boolean isSiemensDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblySiemensDoseScreenInstance(attributeList) && Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber).trim().equals("501");
    }

    public static boolean isPossiblyDoseScreenSeries(String string, String string2, String string3) {
        return OCR.isPossiblyGEDoseScreenSeries(string, string2, string3) || OCR.isPossiblySiemensDoseScreenSeries(string, string2, string3);
    }

    public static boolean isPossiblyDoseScreenSeries(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenSeries(attributeList) || OCR.isPossiblySiemensDoseScreenSeries(attributeList);
    }

    public static boolean isPossiblyDoseScreenInstance(String string, String string2) {
        return OCR.isPossiblyGEDoseScreenInstance(string, string2) || OCR.isPossiblySiemensDoseScreenInstance(string, string2);
    }

    public static boolean isPossiblyDoseScreenInstance(AttributeList attributeList) {
        return OCR.isPossiblyGEDoseScreenInstance(attributeList) || OCR.isPossiblySiemensDoseScreenInstance(attributeList);
    }

    public static boolean isDoseScreenInstance(AttributeList attributeList) {
        return OCR.isGEDoseScreenInstance(attributeList) || OCR.isSiemensDoseScreenInstance(attributeList);
    }

    public static CTDose getCTDoseFromOCROfGEDoseScreen(OCR oCR, int n, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        Object object;
        AttributeList attributeList = oCR.getAttributeList();
        if ((string == null || string.trim().length() == 0 && attributeList != null) && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string.length() == 8) {
            string = string + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string, string2, string4);
        Pattern pattern = Pattern.compile("[ \t]*([0-9]+)[ \t]+(HELICAL|AXIAL|SMARTVIEW|CINE)[ \t]+([SI])([0-9]*[.]*[0-9]*)[-]([SI])([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+(.*)[ \t]*");
        Object object2 = Pattern.compile("[ \t]*TOTAL[ \t]*EXAM[ \t]*DLP:[ \t]*([0-9]*[.]*[0-9]*)[ \t]*");
        Object object3 = new BufferedReader(new StringReader(oCR.toString()));
        String string5 = null;
        while ((string5 = ((BufferedReader)object3).readLine()) != null) {
            String string6;
            int n2;
            if ((string5 = string5.toUpperCase()).contains("HELICAL") || string5.contains("AXIAL") || string5.contains("SMARTVIEW") || string5.contains("CINE")) {
                CTScanType cTScanType;
                if (n > 0) {
                    System.err.println(string5);
                }
                if (!((Matcher)(object = pattern.matcher(string5))).matches()) continue;
                if (n > 0) {
                    System.err.println("matches");
                }
                n2 = ((Matcher)object).groupCount();
                if (n > 0) {
                    System.err.println("groupCount = " + n2);
                }
                if (n2 < 9) continue;
                string6 = ((Matcher)object).group(1);
                if (n > 0) {
                    System.err.println("series = " + string6);
                }
                String string7 = ((Matcher)object).group(2);
                if (n > 0) {
                    System.err.println("scanType = " + string7);
                }
                String string8 = ((Matcher)object).group(3);
                String string9 = ((Matcher)object).group(4);
                String string10 = ((Matcher)object).group(5);
                String string11 = ((Matcher)object).group(6);
                if (n > 0) {
                    System.err.println("range from = " + string8 + " " + string9 + " mm to " + string10 + " " + string11 + " mm");
                }
                String string12 = ((Matcher)object).group(7);
                if (n > 0) {
                    System.err.println("CTDIvol = " + string12 + " mGy");
                }
                String string13 = ((Matcher)object).group(8);
                if (n > 0) {
                    System.err.println("DLP = " + string13 + " mGy-cm");
                }
                String string14 = ((Matcher)object).group(9).replaceAll("[ \t]+", "").trim();
                if (n > 0) {
                    System.err.println("phantom = " + string14);
                }
                if ((cTScanType = CTScanType.selectFromDescription(string7)) == null || cTScanType.equals(CTScanType.LOCALIZER)) continue;
                cTDose.addAcquisition(new CTDoseAcquisition(string3, true, string6, cTScanType, new ScanRange(string8, string9, string10, string11), string12, string13, CTPhantomType.selectFromDescription(string14)));
                continue;
            }
            if (!string5.contains("TOTAL")) continue;
            if (n > 0) {
                System.err.println(string5);
            }
            if (!((Matcher)(object = ((Pattern)object2).matcher(string5))).matches()) continue;
            if (n > 0) {
                System.err.println("matches");
            }
            n2 = ((Matcher)object).groupCount();
            if (n > 0) {
                System.err.println("groupCount = " + n2);
            }
            if (n2 < 1) continue;
            string6 = ((Matcher)object).group(1);
            if (n > 0) {
                System.err.println("Total DLP = " + string6 + " mGy-cm");
            }
            cTDose.setDLPTotal(string6);
        }
        if (cTIrradiationEventDataFromImages != null) {
            for (int i = 0; i < cTDose.getNumberOfAcquisitions(); ++i) {
                object2 = cTDose.getAcquisition(i);
                if (object2 == null) continue;
                object3 = ((CTDoseAcquisition)object2).getScanRange();
                string5 = ((CTDoseAcquisition)object2).getSeriesOrAcquisitionNumber() + "+" + ((ScanRange)object3).getStartDirection() + ((ScanRange)object3).getStartLocation() + "+" + ((ScanRange)object3).getEndDirection() + ((ScanRange)object3).getEndLocation() + "+" + ((CTDoseAcquisition)object2).getScopeUID();
                object = cTIrradiationEventDataFromImages.getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID(string5);
                if (object == null) continue;
                ((CTAcquisitionParameters)object).deriveScanningLengthFromDLPAndCTDIVol(((CTDoseAcquisition)object2).getDLP(), ((CTDoseAcquisition)object2).getCTDIvol());
                ((CTDoseAcquisition)object2).setAcquisitionParameters((CTAcquisitionParameters)object);
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static CTDose getCTDoseFromOCROfSiemensDoseScreen(OCR oCR, int n, String string, String string2, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        AttributeList attributeList = oCR.getAttributeList();
        if ((string == null || string.trim().length() == 0 && attributeList != null) && (string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate)) != null && string.length() == 8) {
            string = string + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string, string2, string4);
        Pattern pattern = Pattern.compile("(.*TOPOGRAM.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]*MA[ \t]+([0-9]*[.]*[0-9]*)[(]*([ABLS])[)]*[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+/[ \t]*([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[(]*([ABLS])[)]*[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object2 = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+/[ \t]*([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Object object3 = Pattern.compile("(.*)[ \t]+([0-9A-Z-]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*)[ \t]+([0-9]*[.]*[0-9]*).*");
        Pattern pattern2 = Pattern.compile("[ \t]*TOTAL[ \t]*MAS[ \t]*([0-9]*[.]*[0-9]*)[ \t]+TOTAL[ \t]*DLP[ \t]*([0-9]*[.]*[0-9]*).*");
        Pattern pattern3 = Pattern.compile("[ \t]*MAS[ \t]*TOTAL[ \t]*([0-9]*[.]*[0-9]*)[ \t]+DLP[ \t]*TOTAL[ \t]*([0-9]*[.]*[0-9]*).*");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(oCR.toString()));
        String string5 = null;
        while ((string5 = bufferedReader.readLine()) != null) {
            Object object4;
            String string6;
            Object object5;
            String string7;
            Object object6;
            String string8;
            String string9;
            String string10;
            String string11;
            int n2;
            Matcher matcher;
            string5 = string5.toUpperCase();
            if (n > 0) {
                System.err.println(string5);
            }
            if (string5.contains("TOTALDLP")) {
                String string12;
                matcher = pattern2.matcher(string5);
                if (!matcher.matches()) continue;
                if (n > 0) {
                    System.err.println("matches pTotal1");
                }
                int n3 = matcher.groupCount();
                for (n2 = 1; n2 <= n3; ++n2) {
                    if (n <= 0) continue;
                    System.err.println("m.group(" + n2 + "):" + matcher.group(n2));
                }
                if (n > 0) {
                    System.err.println("groupCount = " + n3);
                }
                if (n3 < 1) continue;
                String string13 = matcher.group(1);
                if (n > 0) {
                    System.err.println("Total mAs = " + string13);
                }
                if (!(string12 = matcher.group(2)).contains(".")) {
                    string12 = string12 + ".00";
                }
                if (n > 0) {
                    System.err.println("Total DLP = " + string12 + " mGy-cm");
                }
                cTDose.setDLPTotal(string12);
                continue;
            }
            if (string5.contains("DLPTOTAL")) {
                String string14;
                matcher = pattern3.matcher(string5);
                if (!matcher.matches()) continue;
                if (n > 0) {
                    System.err.println("matches pTotal2");
                }
                int n4 = matcher.groupCount();
                for (n2 = 1; n2 <= n4; ++n2) {
                    if (n <= 0) continue;
                    System.err.println("m.group(" + n2 + "):" + matcher.group(n2));
                }
                if (n > 0) {
                    System.err.println("groupCount = " + n4);
                }
                if (n4 < 1) continue;
                String string15 = matcher.group(1);
                if (n > 0) {
                    System.err.println("Total mAs = " + string15);
                }
                if (!(string14 = matcher.group(2)).contains(".")) {
                    string14 = string14 + ".00";
                }
                if (n > 0) {
                    System.err.println("Total DLP = " + string14 + " mGy-cm");
                }
                cTDose.setDLPTotal(string14);
                continue;
            }
            matcher = ((Pattern)object).matcher(string5);
            if (matcher.matches()) {
                if (n > 0) {
                    System.err.println("matches pEventWithRefExposureAndPhantomType");
                }
                int n5 = matcher.groupCount();
                if (n > 0) {
                    System.err.println("groupCount = " + n5);
                }
                for (n2 = 1; n2 <= n5; ++n2) {
                    if (n <= 0) continue;
                    System.err.println("mEventWithRefExposureAndPhantomType.group(" + n2 + "):" + matcher.group(n2));
                }
                if (n5 < 10) continue;
                String string16 = matcher.group(1);
                if (n > 0) {
                    System.err.println("protocol = " + string16);
                }
                String string17 = matcher.group(2).replaceAll("[A-Z]", "");
                if (n > 0) {
                    System.err.println("acquisitionNumber = " + string17);
                }
                String string18 = null;
                if (n > 0) {
                    System.err.println("scanType = " + string18);
                }
                String string19 = matcher.group(3);
                if (n > 0) {
                    System.err.println("KV = " + string19);
                }
                string11 = matcher.group(4);
                if (n > 0) {
                    System.err.println("mAs = " + string11);
                }
                string10 = matcher.group(5);
                if (n > 0) {
                    System.err.println("ref = " + string10);
                }
                string9 = matcher.group(6);
                if (n > 0) {
                    System.err.println("CTDIvol = " + string9 + " mGy");
                }
                string8 = matcher.group(7);
                if (n > 0) {
                    System.err.println("phantom = " + string8);
                }
                object6 = null;
                if (string8.equals("A") || string8.equals("L")) {
                    object6 = CTPhantomType.BODY32;
                } else if (string8.equals("B") || string8.equals("S")) {
                    object6 = CTPhantomType.HEAD16;
                }
                string7 = matcher.group(8);
                if (!string7.contains(".")) {
                    string7 = string7 + ".00";
                }
                if (n > 0) {
                    System.err.println("DLP = " + string7 + " mGy-cm");
                }
                object5 = matcher.group(9);
                if (n > 0) {
                    System.err.println("TI = " + (String)object5);
                }
                string6 = matcher.group(10);
                if (n > 0) {
                    System.err.println("cSL = " + string6);
                }
                object4 = CTScanType.selectFromDescription(string18);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string17, (CTScanType)object4, null, string9, string7, (CTPhantomType)object6));
                continue;
            }
            Matcher matcher2 = ((Pattern)object2).matcher(string5);
            if (matcher2.matches()) {
                if (n > 0) {
                    System.err.println("matches pEventWithRefExposure");
                }
                n2 = matcher2.groupCount();
                if (n > 0) {
                    System.err.println("groupCount = " + n2);
                }
                for (int i = 1; i <= n2; ++i) {
                    if (n <= 0) continue;
                    System.err.println("mEventWithRefExposure.group(" + i + "):" + matcher2.group(i));
                }
                if (n2 < 9) continue;
                String string20 = matcher2.group(1);
                if (n > 0) {
                    System.err.println("protocol = " + string20);
                }
                String string21 = matcher2.group(2).replaceAll("[A-Z]", "");
                if (n > 0) {
                    System.err.println("acquisitionNumber = " + string21);
                }
                String string22 = null;
                if (n > 0) {
                    System.err.println("scanType = " + string22);
                }
                string11 = matcher2.group(3);
                if (n > 0) {
                    System.err.println("KV = " + string11);
                }
                string10 = matcher2.group(4);
                if (n > 0) {
                    System.err.println("mAs = " + string10);
                }
                string9 = matcher2.group(5);
                if (n > 0) {
                    System.err.println("ref = " + string9);
                }
                string8 = matcher2.group(6);
                if (n > 0) {
                    System.err.println("CTDIvol = " + string8 + " mGy");
                }
                if (!((String)(object6 = matcher2.group(7))).contains(".")) {
                    object6 = (String)object6 + ".00";
                }
                if (n > 0) {
                    System.err.println("DLP = " + (String)object6 + " mGy-cm");
                }
                string7 = matcher2.group(8);
                if (n > 0) {
                    System.err.println("TI = " + string7);
                }
                object5 = matcher2.group(9);
                if (n > 0) {
                    System.err.println("cSL = " + (String)object5);
                }
                string6 = "Unknown";
                object4 = CTScanType.selectFromDescription(string22);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string21, (CTScanType)object4, null, string8, (String)object6, CTPhantomType.selectFromDescription(string6)));
                continue;
            }
            Matcher matcher3 = ((Pattern)object3).matcher(string5);
            if (matcher3.matches()) {
                if (n > 0) {
                    System.err.println("matches pEventWithoutRefExposure");
                }
                int n6 = matcher3.groupCount();
                if (n > 0) {
                    System.err.println("groupCount = " + n6);
                }
                for (int i = 1; i <= n6; ++i) {
                    if (n <= 0) continue;
                    System.err.println("mEventWithoutRefExposure.group(" + i + "):" + matcher3.group(i));
                }
                if (n6 < 8) continue;
                String string23 = matcher3.group(1);
                if (n > 0) {
                    System.err.println("protocol = " + string23);
                }
                String string24 = matcher3.group(2).replaceAll("[A-Z]", "");
                if (n > 0) {
                    System.err.println("acquisitionNumber = " + string24);
                }
                string11 = null;
                if (n > 0) {
                    System.err.println("scanType = " + string11);
                }
                string10 = matcher3.group(3);
                if (n > 0) {
                    System.err.println("KV = " + string10);
                }
                string9 = matcher3.group(4);
                if (n > 0) {
                    System.err.println("mAs = " + string9);
                }
                string8 = matcher3.group(5);
                if (n > 0) {
                    System.err.println("CTDIvol = " + string8 + " mGy");
                }
                if (!((String)(object6 = matcher3.group(6))).contains(".")) {
                    object6 = (String)object6 + ".00";
                }
                if (n > 0) {
                    System.err.println("DLP = " + (String)object6 + " mGy-cm");
                }
                string7 = matcher3.group(7);
                if (n > 0) {
                    System.err.println("TI = " + string7);
                }
                object5 = matcher3.group(8);
                if (n > 0) {
                    System.err.println("cSL = " + (String)object5);
                }
                string6 = "Unknown";
                object4 = CTScanType.selectFromDescription(string11);
                cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string24, (CTScanType)object4, null, string8, (String)object6, CTPhantomType.selectFromDescription(string6)));
                continue;
            }
            Matcher matcher4 = pattern.matcher(string5);
            if (!matcher4.matches()) continue;
            if (n > 0) {
                System.err.println("matches mEventLocalizerWithDoseAndPhantomType");
            }
            int n7 = matcher4.groupCount();
            if (n > 0) {
                System.err.println("groupCount = " + n7);
            }
            for (int i = 1; i <= n7; ++i) {
                if (n <= 0) continue;
                System.err.println("mEventLocalizerWithDoseAndPhantomType.group(" + i + "):" + matcher4.group(i));
            }
            if (n7 < 9) continue;
            String string25 = matcher4.group(1);
            if (n > 0) {
                System.err.println("protocol = " + string25);
            }
            string11 = matcher4.group(2).replaceAll("[A-Z]", "");
            if (n > 0) {
                System.err.println("acquisitionNumber = " + string11);
            }
            string10 = null;
            if (n > 0) {
                System.err.println("scanType = " + string10);
            }
            string9 = matcher4.group(3);
            if (n > 0) {
                System.err.println("KV = " + string9);
            }
            string8 = matcher4.group(4);
            if (n > 0) {
                System.err.println("mAs = " + string8);
            }
            object6 = matcher4.group(5);
            if (n > 0) {
                System.err.println("CTDIvol = " + (String)object6 + " mGy");
            }
            string7 = matcher4.group(6);
            if (n > 0) {
                System.err.println("phantom = " + string7);
            }
            object5 = null;
            if (string7.equals("A") || string7.equals("L")) {
                object5 = CTPhantomType.BODY32;
            } else if (string7.equals("B") || string7.equals("S")) {
                object5 = CTPhantomType.HEAD16;
            }
            string6 = matcher4.group(7);
            if (!string6.contains(".")) {
                string6 = string6 + ".00";
            }
            if (n > 0) {
                System.err.println("DLP = " + string6 + " mGy-cm");
            }
            object4 = matcher4.group(8);
            if (n > 0) {
                System.err.println("TI = " + (String)object4);
            }
            String string26 = matcher4.group(9);
            if (n > 0) {
                System.err.println("cSL = " + string26);
            }
            CTScanType cTScanType = CTScanType.LOCALIZER;
            cTDose.addAcquisition(new CTDoseAcquisition(string3, false, string11, cTScanType, null, (String)object6, string6, (CTPhantomType)object5));
        }
        if (cTIrradiationEventDataFromImages != null) {
            for (int i = 0; i < cTDose.getNumberOfAcquisitions(); ++i) {
                object = cTDose.getAcquisition(i);
                if (object == null || (object3 = cTIrradiationEventDataFromImages.getAcquisitionParametersByAcquisitionNumberAndStudyInstanceUID((String)(object2 = ((CTDoseAcquisition)object).getSeriesOrAcquisitionNumber() + "+" + ((CTDoseAcquisition)object).getScopeUID()))) == null) continue;
                ((CTAcquisitionParameters)object3).deriveScanningLengthFromDLPAndCTDIVol(((CTDoseAcquisition)object).getDLP(), ((CTDoseAcquisition)object).getCTDIvol());
                ((CTDoseAcquisition)object).setAcquisitionParameters((CTAcquisitionParameters)object3);
            }
        }
        if (bl) {
            GenerateRadiationDoseStructuredReport.createContextForNewRadiationDoseStructuredReportFromExistingInstance(attributeList, cTDose, cTIrradiationEventDataFromImages);
        }
        return cTDose;
    }

    public static CTDose getCTDoseFromOCROfDoseScreen(OCR oCR, int n, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages, boolean bl) throws IOException {
        CTDose cTDose = null;
        AttributeList attributeList = oCR.getAttributeList();
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
        String string2 = null;
        String string3 = null;
        if (cTIrradiationEventDataFromImages != null) {
            string2 = cTIrradiationEventDataFromImages.getOverallEarliestAcquisitionDateTimeForStudy(string);
            string3 = cTIrradiationEventDataFromImages.getOverallLatestAcquisitionDateTimeForStudy(string);
        }
        if (OCR.isGEDoseScreenInstance(attributeList)) {
            cTDose = OCR.getCTDoseFromOCROfGEDoseScreen(oCR, n, string2, string3, cTIrradiationEventDataFromImages, bl);
        } else if (OCR.isSiemensDoseScreenInstance(attributeList)) {
            cTDose = OCR.getCTDoseFromOCROfSiemensDoseScreen(oCR, n, string2, string3, cTIrradiationEventDataFromImages, bl);
        }
        return cTDose;
    }

    public static final void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 && !stringArray[0].equals("-") ? stringArray[0] : null;
            String string2 = stringArray.length > 1 && !stringArray[1].equals("-") ? stringArray[1] : null;
            String string3 = stringArray.length > 2 && !stringArray[2].equals("-") ? stringArray[2] : null;
            String string4 = stringArray.length > 3 && !stringArray[3].equals("-") ? stringArray[3] : defaultFileNameOfKnownGlyphs;
            String string5 = stringArray.length > 4 && !stringArray[4].equals("-") ? stringArray[4] : null;
            int n = stringArray.length > 5 ? Integer.parseInt(stringArray[5]) : -1;
            Object var7_8 = null;
            Object var8_9 = null;
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = null;
            if (string2 != null) {
                cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(string2);
                System.err.print(cTIrradiationEventDataFromImages);
                if (string == null) {
                    string = cTIrradiationEventDataFromImages.getDoseScreenOrStructuredReportFilenames(true, false).get(0);
                }
            }
            OCR oCR = new OCR(string, string4, string5, n);
            if (n > 0) {
                System.err.print(oCR);
            }
            CTDose cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, n, cTIrradiationEventDataFromImages, string3 != null);
            System.err.print(cTDose.toString(true, true));
            if (!cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions()) {
                System.err.println("############ specified DLP total (" + cTDose.getDLPTotal() + ") does not match DLP total from acquisitions (" + cTDose.getDLPTotalFromAcquisitions() + ")");
            }
            if (string3 != null) {
                cTDose.write(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        maximumNumberOfConnections = 1200;
        defaultGEHorizontalGapTolerance = 6;
        defaultGEVerticalGapTolerance = 4;
        defaultSiemensHorizontalGapTolerance = 6;
        defaultSiemensVerticalGapTolerance = 2;
    }

    class Glyph {
        BitSet set;
        int width;
        int height;
        boolean wasKnown;

        public BitSet getSet() {
            return this.set;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean getWasKnown() {
            return this.wasKnown;
        }

        public String getString() {
            return (String)OCR.this.mapOfGlyphsToStrings.get(this);
        }

        Glyph(BitSet bitSet, int n, boolean bl) throws IllegalArgumentException {
            if (debugLevel > 1) {
                System.err.println("Glyph.Glyph(): srcSet = " + bitSet);
            }
            if (debugLevel > 1) {
                System.err.println("Glyph.Glyph(): srcSetWidth = " + n);
            }
            if (bitSet.isEmpty()) {
                throw new IllegalArgumentException("Cannot create Glyph from empty BitSet");
            }
            int n2 = OCR.findLowestXSetInBitSet(bitSet, n);
            int n3 = OCR.findLowestYSetInBitSet(bitSet, n);
            int n4 = OCR.findHighestXSetInBitSet(bitSet, n);
            int n5 = OCR.findHighestYSetInBitSet(bitSet, n);
            if (debugLevel > 1) {
                System.err.println("Glyph.Glyph(): srcSet TLHC (" + n2 + "," + n3 + "), BRHC = (" + n4 + "," + n5 + ")");
            }
            this.height = n5 - n3 + 1;
            this.width = n4 - n2 + 1;
            if (debugLevel > 1) {
                System.err.println("Glyph.Glyph(): new width = " + this.width + ", height = " + this.height);
            }
            this.set = new BitSet();
            int n6 = n3;
            int n7 = 0;
            while (n7 < this.height) {
                int n8 = n2;
                int n9 = 0;
                while (n9 < this.width) {
                    if (bitSet.get(OCR.getBitSetIndex(n8, n6, n))) {
                        this.set.set(OCR.getBitSetIndex(n9, n7, this.width));
                    }
                    ++n9;
                    ++n8;
                }
                ++n7;
                ++n6;
            }
            this.wasKnown = bl;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Glyph) {
                Glyph glyph = (Glyph)object;
                bl = this.set.equals(glyph.getSet()) && this.width == glyph.getWidth() && this.height == glyph.getHeight();
            }
            return bl;
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public String toString() {
            if (debugLevel > 1) {
                System.err.println("Set = " + this.set);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    if (this.set.get(OCR.getBitSetIndex(j, i, this.width))) {
                        stringBuffer.append("# ");
                        continue;
                    }
                    stringBuffer.append(". ");
                }
                stringBuffer.append("\n");
            }
            String string = this.getString();
            if (string != null) {
                stringBuffer.append("String: \"" + string + "\"\n");
            }
            return stringBuffer.toString();
        }

        public String toXML() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getString();
            if (string != null && string.length() > 0) {
                stringBuffer.append("\t<glyph>\n");
                stringBuffer.append("\t\t<bits>\n");
                int n = this.set.length();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (!this.set.get(i)) continue;
                        stringBuffer.append("\t\t\t<bit>" + i + "</bit>\n");
                    }
                }
                stringBuffer.append("\t\t</bits>\n");
                stringBuffer.append("\t\t<width>" + this.width + "</width>\n");
                stringBuffer.append("\t\t<string>" + string + "</string>\n");
                stringBuffer.append("\t</glyph>\n");
            }
            return stringBuffer.toString();
        }

        public String toSourceCode() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getString();
            if (string != null && string.length() > 0) {
                stringBuffer.append("\t{\n");
                stringBuffer.append("\t\tBitSet set = new BitSet();\n");
                int n = this.set.length();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        if (!this.set.get(i)) continue;
                        stringBuffer.append("\t\tset.set(" + i + ");\n");
                    }
                }
                stringBuffer.append("\t\tmapOfGlyphsToStrings.put(new Glyph(set," + this.width + ",true),\"" + string + "\");\n");
                stringBuffer.append("\t}\n");
            }
            return stringBuffer.toString();
        }
    }

    class Location
    implements Comparable {
        int x;
        int y;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        Location(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public int compareTo(Object object) {
            if (debugLevel > 3) {
                System.err.println("Location.compareTo(): comparing " + this + " to " + object);
            }
            int n = -1;
            if (object instanceof Location) {
                Location location = (Location)object;
                n = this.y == location.getY() ? this.x - location.getX() : this.y - location.getY();
            }
            if (debugLevel > 3) {
                System.err.println("Location.compareTo(): result = " + n);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (debugLevel > 3) {
                System.err.println("Location.equals(): comparing " + this + " to " + object);
            }
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this.x + this.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }

    class ConnectednessException
    extends Exception {
        public ConnectednessException() {
            super("Exceeded maximum number of connections ... probably not a validly thresholded image");
        }
    }
}

