/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CompositeInstanceContext;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import java.util.ArrayList;
import java.util.Vector;

public class RenderedDoseReport {
    public static String generateDoseReportInformationFromFiles(Vector vector, boolean bl) {
        return RenderedDoseReport.generateDoseReportInformationFromFiles(vector, bl, null);
    }

    public static String generateDoseReportInformationFromFiles(Vector vector, boolean bl, String string) {
        Object object;
        String string2 = "";
        boolean bl2 = false;
        if (string != null && ((String)(object = string.trim().toLowerCase())).equals("text/html")) {
            bl2 = true;
        }
        object = new CTIrradiationEventDataFromImages(vector);
        ArrayList<String> arrayList = ((CTIrradiationEventDataFromImages)object).getDoseScreenOrStructuredReportFilenames();
        for (String string3 : arrayList) {
            try {
                Object object2;
                AttributeList attributeList = new AttributeList();
                attributeList.read(string3);
                CTDose cTDose = null;
                if (SOPClass.isStructuredReport(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID))) {
                    cTDose = new CTDose(attributeList);
                } else if (OCR.isDoseScreenInstance(attributeList)) {
                    object2 = new OCR(attributeList, 0);
                    cTDose = OCR.getCTDoseFromOCROfDoseScreen((OCR)object2, 0, (CTIrradiationEventDataFromImages)object, true);
                } else if (ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                    cTDose = ExposureDoseSequence.getCTDoseFromPhilipsDoseScreen(attributeList, 0, (CTIrradiationEventDataFromImages)object, true);
                }
                if (cTDose == null) continue;
                if (attributeList != null) {
                    object2 = new CompositeInstanceContext(attributeList);
                    ((CompositeInstanceContext)object2).updateFromSource((CTIrradiationEventDataFromImages)object);
                    cTDose.setCompositeInstanceContext((CompositeInstanceContext)object2);
                }
                if (bl2) {
                    string2 = string2 + cTDose.getHTMLTableRow(!bl);
                    continue;
                }
                string2 = string2 + cTDose.toString(!bl, true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return string2;
    }

    public static final void main(String[] stringArray) {
        try {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
            String string = RenderedDoseReport.generateDoseReportInformationFromFiles(vector, false);
            System.err.println(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

