/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.doseocr.OCR;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOCRAgainstTabulatedData
extends TestCase {
    public TestOCRAgainstTabulatedData(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestOCRAgainstTabulatedData");
        testSuite.addTest((Test)new TestOCRAgainstTabulatedData("testOCRAgainstTabulatedData_AllFiles"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void recursiveDirectorySearch(Map<String, File> map, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.recursiveDirectorySearch(map, fileArray[i]);
                continue;
            }
            String string = fileArray[i].getName();
            if (string.startsWith(".")) continue;
            map.put(string, fileArray[i]);
        }
    }

    public void testOCRAgainstTabulatedData_AllFiles() throws Exception {
        String string = "../../../testpaths/DoseFilesCopied";
        String string2 = "./doseocrcheck.dat";
        String string3 = "./OCR_Glyphs_DoseScreen.xml";
        HashMap<String, File> hashMap = new HashMap<String, File>();
        this.recursiveDirectorySearch(hashMap, new File(string));
        Pattern pattern = Pattern.compile("FILENAME\t(.+)");
        Pattern pattern2 = Pattern.compile("STUDYINSTANCEUID\t(.+)");
        Pattern pattern3 = Pattern.compile("([0-9]+)[ \t]+([A-Z]+)[ \t]+([SI])[ \t]+([0-9]*[.][0-9]*)[ \t]+([SI])[ \t]+([0-9]*[.][0-9]*)[ \t]+([0-9]*[.][0-9]*)[ \t]+([0-9]*[.][0-9]*)[ \t]+(.*)[ \t]*");
        Pattern pattern4 = Pattern.compile("([0-9-]+)[ \t]+(TOPOGRAM|-)[ \t]+([0-9]*[.][0-9]*)[ \t]+([0-9]*[.][0-9]*)[ \t]+([A-Z0-9-]*).*");
        Pattern pattern5 = Pattern.compile("TOTAL[ \t]+([0-9]*[.][0-9]*)");
        CTDose cTDose = null;
        CTDose cTDose2 = null;
        String string4 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        String string5 = null;
        while ((string5 = bufferedReader.readLine()) != null) {
            String string6;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Matcher matcher = pattern.matcher(string5 = string5.toUpperCase());
            if (matcher.matches()) {
                object6 = matcher.group(1);
                object5 = (File)hashMap.get(object6);
                System.err.println("Processing file " + object5);
                object4 = new OCR(((File)object5).getCanonicalPath(), string3, null, 0);
                cTDose = OCR.getCTDoseFromOCROfDoseScreen((OCR)object4, 0, null, false);
                TestOCRAgainstTabulatedData.assertFalse((String)"check parse returned something", (cTDose == null ? 1 : 0) != 0);
                cTDose2 = new CTDose(ScopeOfDoseAccummulation.STUDY, "0.0.0.0", null, null, "");
                continue;
            }
            object6 = pattern2.matcher(string5);
            if (((Matcher)object6).matches()) {
                string4 = ((Matcher)object6).group(1);
                continue;
            }
            object5 = pattern5.matcher(string5);
            if (((Matcher)object5).matches()) {
                object4 = ((Matcher)object5).group(1);
                cTDose2.setDLPTotal((String)object4);
                continue;
            }
            object4 = pattern3.matcher(string5);
            if (((Matcher)object4).matches()) {
                object3 = ((Matcher)object4).group(1);
                String string7 = ((Matcher)object4).group(2);
                String string8 = ((Matcher)object4).group(3);
                object2 = ((Matcher)object4).group(4);
                object = ((Matcher)object4).group(5);
                string6 = ((Matcher)object4).group(6);
                String string9 = ((Matcher)object4).group(7);
                String string10 = ((Matcher)object4).group(8);
                String string11 = ((Matcher)object4).group(9).replaceAll("[ \t]+", "").trim();
                CTScanType cTScanType = CTScanType.selectFromDescription(string7);
                if (cTScanType == null || cTScanType.equals(CTScanType.LOCALIZER)) continue;
                cTDose2.addAcquisition(new CTDoseAcquisition(string4, true, (String)object3, cTScanType, new ScanRange(string8, (String)object2, (String)object, string6), string9, string10, CTPhantomType.selectFromDescription(string11)));
                continue;
            }
            object3 = pattern4.matcher(string5);
            if (((Matcher)object3).matches()) {
                String string12 = ((Matcher)object3).group(1);
                String string13 = ((Matcher)object3).group(2);
                object2 = ((Matcher)object3).group(3);
                object = ((Matcher)object3).group(4);
                string6 = ((Matcher)object3).group(5);
                cTDose2.addAcquisition(new CTDoseAcquisition(string4, false, string12, CTScanType.selectFromDescription(string13), null, (String)object2, (String)object, CTPhantomType.selectFromDescription(string6)));
                continue;
            }
            if (!string5.startsWith("ENDFILE")) continue;
            System.err.println("From OCR:\n" + cTDose);
            System.err.println("From Data:\n" + cTDose2);
            TestOCRAgainstTabulatedData.assertEquals((String)"Checking DLP Total", (String)cTDose2.getDLPTotal(), (String)cTDose.getDLPTotal());
            TestOCRAgainstTabulatedData.assertEquals((String)"Checking totalNumberOfIrradiationEvents", (int)cTDose2.getTotalNumberOfIrradiationEvents(), (int)cTDose.getTotalNumberOfIrradiationEvents());
            int n = cTDose2.getTotalNumberOfIrradiationEvents();
            for (int i = 0; i < n; ++i) {
                object2 = cTDose.getAcquisition(i);
                object = cTDose2.getAcquisition(i);
                System.err.println("From OCR:\n" + object2);
                System.err.println("From Data:\n" + object);
                TestOCRAgainstTabulatedData.assertTrue((String)("Checking CTDoseAcquisition " + i + " equality"), (boolean)((CTDoseAcquisition)object2).equals(object));
            }
        }
    }
}

