/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.ftp;

import com.pixelmed.ftp.FTPException;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPSecurityType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FTPRemoteHostInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/ftp/FTPRemoteHostInformation.java,v 1.2 2010/12/01 13:31:38 dclunie Exp $";
    public static final String propertyName_FtpRemoteHosts = "Ftp.RemoteHosts";
    protected static final String propertyNameSuffix_HostNameOrIPAddress = "HostNameOrIPAddress";
    protected static final String propertyNameSuffix_User = "User";
    protected static final String propertyNameSuffix_Password = "Password";
    protected static final String propertyNameSuffix_Directory = "Directory";
    protected static final String propertyNameSuffix_Security = "Security";
    protected static final String propertyDelimitersForTokenizer_FtpRemoteAEs = ", ";
    protected final TreeMap<String, FTPRemoteHost> localNameToRemoteHostMap = new TreeMap();

    public FTPRemoteHostInformation() {
    }

    public FTPRemoteHostInformation(Properties properties) throws FTPException {
        this();
        String string = properties.getProperty(propertyName_FtpRemoteHosts);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, propertyDelimitersForTokenizer_FtpRemoteAEs);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = properties.getProperty("Ftp.RemoteHosts." + string2 + "." + propertyNameSuffix_HostNameOrIPAddress);
                String string4 = properties.getProperty("Ftp.RemoteHosts." + string2 + "." + propertyNameSuffix_User);
                String string5 = properties.getProperty("Ftp.RemoteHosts." + string2 + "." + propertyNameSuffix_Password);
                String string6 = properties.getProperty("Ftp.RemoteHosts." + string2 + "." + propertyNameSuffix_Directory);
                String string7 = properties.getProperty("Ftp.RemoteHosts." + string2 + "." + propertyNameSuffix_Security);
                FTPSecurityType fTPSecurityType = FTPSecurityType.selectFromDescription(string7);
                this.add(string2, string3, string4, string5, string6, fTPSecurityType);
            }
        }
    }

    public Properties getProperties(Properties properties) {
        Object object;
        CharSequence charSequence;
        if (properties == null) {
            properties = new Properties();
        } else {
            charSequence = properties.getProperty(propertyName_FtpRemoteHosts);
            if (charSequence != null && ((String)charSequence).length() > 0) {
                object = new StringTokenizer((String)charSequence, propertyDelimitersForTokenizer_FtpRemoteAEs);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    properties.remove("Ftp.RemoteHosts." + (String)string + "." + propertyNameSuffix_HostNameOrIPAddress);
                    properties.remove("Ftp.RemoteHosts." + (String)string + "." + propertyNameSuffix_User);
                    properties.remove("Ftp.RemoteHosts." + (String)string + "." + propertyNameSuffix_Password);
                    properties.remove("Ftp.RemoteHosts." + (String)string + "." + propertyNameSuffix_Directory);
                    properties.remove("Ftp.RemoteHosts." + (String)string + "." + propertyNameSuffix_Security);
                }
            }
            properties.remove(propertyName_FtpRemoteHosts);
            System.err.println("FTPRemoteHostInformation.getProperties(): after removing existing remote AEs, properties = \n" + properties);
        }
        charSequence = new StringBuffer();
        object = "";
        for (String string : this.getListOfLocalNames()) {
            FTPRemoteHost fTPRemoteHost;
            if (string == null || (fTPRemoteHost = this.localNameToRemoteHostMap.get(string)) == null) continue;
            properties.setProperty("Ftp.RemoteHosts." + string + "." + propertyNameSuffix_HostNameOrIPAddress, fTPRemoteHost.getHost());
            properties.setProperty("Ftp.RemoteHosts." + string + "." + propertyNameSuffix_User, fTPRemoteHost.getUser());
            properties.setProperty("Ftp.RemoteHosts." + string + "." + propertyNameSuffix_Password, fTPRemoteHost.getPassword());
            properties.setProperty("Ftp.RemoteHosts." + string + "." + propertyNameSuffix_Directory, fTPRemoteHost.getDirectory());
            properties.setProperty("Ftp.RemoteHosts." + string + "." + propertyNameSuffix_Security, fTPRemoteHost.getSecurity().toString());
            ((StringBuffer)charSequence).append((String)object);
            ((StringBuffer)charSequence).append(string);
            object = propertyDelimitersForTokenizer_FtpRemoteAEs;
        }
        properties.setProperty(propertyName_FtpRemoteHosts, ((StringBuffer)charSequence).toString());
        System.err.println("FTPRemoteHostInformation.getProperties(): at end, properties = \n" + properties);
        return properties;
    }

    public void removeAll() {
        this.localNameToRemoteHostMap.clear();
    }

    public void remove(String string) {
        if (string != null && string.length() > 0) {
            this.localNameToRemoteHostMap.remove(string);
        }
    }

    public void add(String string, FTPRemoteHost fTPRemoteHost) throws FTPException {
        if (string != null && string.length() > 0) {
            FTPRemoteHost fTPRemoteHost2 = this.localNameToRemoteHostMap.get(string);
            if (fTPRemoteHost2 != null) {
                throw new FTPException("Cannot use local name [" + string + "] - already used");
            }
        } else {
            throw new FTPException("Cannot use empty local name [" + string + "]");
        }
        this.localNameToRemoteHostMap.put(string, fTPRemoteHost);
    }

    public void add(String string, String string2, String string3, String string4, String string5, FTPSecurityType fTPSecurityType) throws FTPException {
        FTPRemoteHost fTPRemoteHost = new FTPRemoteHost(string2, string3, string4, string5, fTPSecurityType);
        this.add(string, fTPRemoteHost);
    }

    public FTPRemoteHost getRemoteHost(String string) {
        return this.localNameToRemoteHostMap.get(string);
    }

    public Set getListOfLocalNames() {
        return this.localNameToRemoteHostMap.keySet();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.localNameToRemoteHostMap != null) {
            for (String string : this.getListOfLocalNames()) {
                FTPRemoteHost fTPRemoteHost = this.localNameToRemoteHostMap.get(string);
                printWriter.println("localName=" + string + "," + (fTPRemoteHost == null ? "-null-" : fTPRemoteHost.toString()));
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }
}

