/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.AReleasePDU;
import com.pixelmed.network.AssociationOutputStream;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PDataPDU;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.PresentationDataValue;
import com.pixelmed.network.ReceivedDataHandler;
import com.pixelmed.utils.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public class Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/Association.java,v 1.51 2009/08/14 12:37:51 dclunie Exp $";
    private static int associationReleaseToTransportConnectionCloseTimeoutInMilliseconds = 5000;
    private static int associationCounter = 0;
    protected int associationNumber = associationCounter++;
    protected int debugLevel;
    protected String calledAETitle;
    protected String callingAETitle;
    protected LinkedList presentationContexts;
    protected LinkedList scuSCPRoleSelections;
    protected int maximumLengthReceived;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;
    private ReceivedDataHandler receivedDataHandler;
    private static final String cipherSuiteForAES = "TLS_RSA_WITH_AES_128_CBC_SHA";
    private static final String cipherSuiteFor3DES = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    private static final String protocolForTLS = "TLSv1";

    protected void setSocketOptions(Socket socket, int n, int n2, int n3, int n4) throws IOException {
        if (n4 > 1) {
            System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): getReceiveBufferSize() = " + socket.getReceiveBufferSize());
        }
        if (n4 > 1) {
            System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): getSendBufferSize() = " + socket.getSendBufferSize());
        }
        if (n4 > 1) {
            System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): getSoLinger() = " + socket.getSoLinger());
        }
        if (n4 > 1) {
            System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): getSoTimeout() = " + socket.getSoTimeout());
        }
        if (n4 > 1) {
            System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): getTcpNoDelay() = " + socket.getTcpNoDelay());
        }
        if (n2 != 0 && socket.getReceiveBufferSize() != n2) {
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): asking to change receiveBufferSize to = " + n2);
            }
            socket.setReceiveBufferSize(n2);
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): receiveBufferSize changed to = " + socket.getReceiveBufferSize());
            }
        }
        if (n3 != 0 && socket.getSendBufferSize() != n3) {
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): asking to change sendBufferSize to = " + n3);
            }
            socket.setSendBufferSize(n3);
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "].setSocketOptions(): sendBufferSize changed to = " + socket.getSendBufferSize());
            }
        }
    }

    protected static void readInsistently(InputStream inputStream, byte[] byArray, int n, int n2, String string) throws DicomNetworkException, IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new DicomNetworkException("Connection closed while reading " + string);
            }
            n2 -= n3;
            n += n3;
        }
    }

    protected static byte[] getRestOfPDU(InputStream inputStream, byte[] byArray, int n) throws DicomNetworkException, IOException {
        int n2;
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n + n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        Association.readInsistently(inputStream, byArray2, n2, n, "PDU");
        return byArray2;
    }

    protected Association(int n) {
        this.debugLevel = n;
    }

    public void release() throws DicomNetworkException {
        block20: {
            try {
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Us: A-RELEASE-RQ");
                }
                AReleasePDU aReleasePDU = new AReleasePDU(5);
                this.out.write(aReleasePDU.getBytes());
                this.out.flush();
                byte[] byArray = new byte[6];
                Association.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
                int n = byArray[0] & 0xFF;
                int n2 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Them: PDU Type: 0x" + Integer.toHexString(n) + " (length 0x" + Integer.toHexString(n2) + ")");
                }
                if (n == 6) {
                    AReleasePDU aReleasePDU2 = new AReleasePDU(Association.getRestOfPDU(this.in, byArray, n2));
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + aReleasePDU2);
                    }
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                    break block20;
                }
                if (n == 5) {
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them: A-RELEASE-RQ (collision)\n");
                    }
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: A-RELEASE-RP");
                    }
                    AReleasePDU aReleasePDU3 = new AReleasePDU(6);
                    this.out.write(aReleasePDU3.getBytes());
                    this.out.flush();
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                    break block20;
                }
                if (n == 7) {
                    AAbortPDU aAbortPDU = new AAbortPDU(Association.getRestOfPDU(this.in, byArray, n2));
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + aAbortPDU);
                    }
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + aAbortPDU.getInfo());
                }
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Aborting");
                }
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Us: A-ABORT");
                }
                AAbortPDU aAbortPDU = new AAbortPDU(2, 2);
                this.out.write(aAbortPDU.getBytes());
                this.out.flush();
                this.waitForARTIMBeforeTransportConnectionClose();
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                }
                this.socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + aAbortPDU.getInfo());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                try {
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DicomNetworkException("A-P-ABORT indication - " + exception);
            }
        }
    }

    public void abort() throws DicomNetworkException {
        try {
            if (this.debugLevel > 1) {
                System.err.println("Association[" + this.associationNumber + "]: Us: A-ABORT");
            }
            AAbortPDU aAbortPDU = new AAbortPDU(1, 0);
            this.out.write(aAbortPDU.getBytes());
            this.out.flush();
            this.waitForARTIMBeforeTransportConnectionClose();
            if (this.debugLevel > 1) {
                System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
            }
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new DicomNetworkException("A-P-ABORT indication - " + exception);
        }
    }

    public void send(byte by, byte[] byArray, byte[] byArray2) throws DicomNetworkException {
        LinkedList<PresentationDataValue> linkedList = new LinkedList<PresentationDataValue>();
        if (byArray != null) {
            linkedList.add(new PresentationDataValue(by, byArray, true, true));
        }
        if (byArray2 != null) {
            linkedList.add(new PresentationDataValue(by, byArray2, false, true));
        }
        try {
            byte[] byArray3;
            PDataPDU pDataPDU = new PDataPDU(linkedList);
            if (this.debugLevel > 1) {
                System.err.println("Association[" + this.associationNumber + "].send(): Us: P-DATA-TF=\n" + pDataPDU);
            }
            if ((byArray3 = pDataPDU.getBytes()).length % 2 != 0) {
                this.socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - internal error - illegal odd length PDU write requested");
            }
            this.out.write(byArray3);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DicomNetworkException("A-P-ABORT indication - " + iOException);
        }
    }

    public AssociationOutputStream getAssociationOutputStream(byte by) throws DicomNetworkException {
        return new AssociationOutputStream(this.out, this.maximumLengthReceived, by, this.debugLevel);
    }

    public void setReceivedDataHandler(ReceivedDataHandler receivedDataHandler) throws DicomNetworkException {
        this.receivedDataHandler = receivedDataHandler;
    }

    private synchronized void waitForARTIMBeforeTransportConnectionClose() throws InterruptedException {
        if (this.debugLevel > 1) {
            System.err.println("Association[" + this.associationNumber + "]: Waiting to close transport connection.");
        }
        this.wait(associationReleaseToTransportConnectionCloseTimeoutInMilliseconds);
        if (this.debugLevel > 1) {
            System.err.println("Association[" + this.associationNumber + "]: Closing transport connection.");
        }
    }

    public void waitForPDataPDUs(int n, boolean bl, boolean bl2, boolean bl3) throws DicomNetworkException, AReleaseException {
        while (n == -1 || n-- > 0) {
            try {
                Object object;
                byte[] byArray = new byte[6];
                Association.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
                int n2 = byArray[0] & 0xFF;
                int n3 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Them: PDU Type: 0x" + Integer.toHexString(n2) + " (length " + n3 + " dec 0x" + Integer.toHexString(n3) + ")");
                }
                if (n2 == 4) {
                    object = new PDataPDU(Association.getRestOfPDU(this.in, byArray, n3));
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + object);
                    }
                    this.receivedDataHandler.sendPDataIndication((PDataPDU)object, this);
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: stopAfterLastFragmentOfCommand=" + bl);
                    }
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: pdata.containsLastCommandFragment()=" + ((PDataPDU)object).containsLastCommandFragment());
                    }
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: stopAfterLastFragmentOfData=" + bl2);
                    }
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: pdata.containsLastDataFragment()=" + ((PDataPDU)object).containsLastDataFragment());
                    }
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: stopAfterHandlerReportsDone=" + bl3);
                    }
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: receivedDataHandler.isDone()=" + this.receivedDataHandler.isDone());
                    }
                    if (!(bl && ((PDataPDU)object).containsLastCommandFragment() || bl2 && ((PDataPDU)object).containsLastDataFragment()) && (!bl3 || !this.receivedDataHandler.isDone())) continue;
                    if (this.debugLevel > 2) {
                        System.err.println("Association[" + this.associationNumber + "]: waitForPDataPDUs is stopping");
                    }
                    break;
                }
                if (n2 == 5) {
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them: A-RELEASE-RQ");
                    }
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: A-RELEASE-RP");
                    }
                    object = new AReleasePDU(6);
                    this.out.write(((AReleasePDU)object).getBytes());
                    this.out.flush();
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Awaiting Transport connection close");
                    }
                    this.waitForARTIMBeforeTransportConnectionClose();
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                    throw new AReleaseException("A-RELEASE indication while waiting for P-DATA");
                }
                if (n2 == 7) {
                    object = new AAbortPDU(Association.getRestOfPDU(this.in, byArray, n3));
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + object);
                    }
                    if (this.debugLevel > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                    }
                    this.socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + ((AAbortPDU)object).getInfo());
                }
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Aborting");
                }
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Us: A-ABORT");
                }
                object = new AAbortPDU(2, 2);
                this.out.write(((AAbortPDU)object).getBytes());
                this.out.flush();
                this.waitForARTIMBeforeTransportConnectionClose();
                if (this.debugLevel > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Us: close transport connection");
                }
                this.socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + ((AAbortPDU)object).getInfo());
            }
            catch (AReleaseException aReleaseException) {
                throw new AReleaseException(aReleaseException.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DicomNetworkException("A-P-ABORT indication - " + exception);
            }
        }
    }

    public void waitForOnePDataPDU() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(1, false, false, false);
    }

    public void waitForCommandPDataPDUs() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, true, false, false);
    }

    public void waitForDataPDataPDUs() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, false, true, false);
    }

    public void waitForPDataPDUsUntilHandlerReportsDone() throws DicomNetworkException, AReleaseException {
        this.waitForPDataPDUs(-1, false, false, true);
    }

    public byte getSuitablePresentationContextID(String string) throws DicomNetworkException {
        String string2;
        PresentationContext presentationContext;
        ListIterator listIterator = null;
        byte by = 0;
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !string2.equals("1.3.6.1.4.1.5962.300.1")) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !string2.equals("1.2.840.10008.1.2.1.99")) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !TransferSyntax.isExplicitVR(string2) || !TransferSyntax.isLittleEndian(string2)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string) || (string2 = presentationContext.getTransferSyntaxUID()) == null || !TransferSyntax.isExplicitVR(string2)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by == 0) {
            listIterator = this.presentationContexts.listIterator();
            while (listIterator.hasNext()) {
                presentationContext = (PresentationContext)listIterator.next();
                if (!presentationContext.getAbstractSyntaxUID().equals(string)) continue;
                by = presentationContext.getIdentifier();
            }
        }
        if (by != 0) {
            return by;
        }
        throw new DicomNetworkException("No presentation context for Abstract Syntax " + string);
    }

    public byte getSuitablePresentationContextID(String string, String string2) throws DicomNetworkException {
        ListIterator listIterator = this.presentationContexts.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext = (PresentationContext)listIterator.next();
            if (!presentationContext.getAbstractSyntaxUID().equals(string) || !presentationContext.getTransferSyntaxUID().equals(string2)) continue;
            return presentationContext.getIdentifier();
        }
        throw new DicomNetworkException("No presentation context for Abstract Syntax " + string + " and Transfer Syntax " + string2);
    }

    public String getTransferSyntaxForPresentationContextID(byte by) throws DicomNetworkException {
        ListIterator listIterator = this.presentationContexts.listIterator();
        while (listIterator.hasNext()) {
            PresentationContext presentationContext = (PresentationContext)listIterator.next();
            if (presentationContext.getIdentifier() != by) continue;
            return presentationContext.getTransferSyntaxUID();
        }
        throw new DicomNetworkException("No such presentation context as " + Integer.toHexString(by & 0xFF));
    }

    public int getAssociationNumber() {
        return this.associationNumber;
    }

    public String getCalledAETitle() {
        return this.calledAETitle;
    }

    public String getCallingAETitle() {
        return this.callingAETitle;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Association[" + this.associationNumber + "]: Called AE Title:  ");
        stringBuffer.append(this.calledAETitle);
        stringBuffer.append("\n");
        stringBuffer.append("Association[" + this.associationNumber + "]: Calling AE Title: ");
        stringBuffer.append(this.callingAETitle);
        stringBuffer.append("\n");
        stringBuffer.append(this.presentationContexts);
        return stringBuffer.toString();
    }

    static final String[] getCipherSuitesToEnable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            boolean bl = Arrays.asList(stringArray).contains(cipherSuiteForAES);
            System.err.println("getCipherSuitesToEnable() useAES " + bl);
            boolean bl2 = Arrays.asList(stringArray).contains(cipherSuiteFor3DES);
            System.err.println("getCipherSuitesToEnable() use3DES " + bl2);
            if (bl && !bl2) {
                String[] stringArray3;
                stringArray2 = stringArray3 = new String[]{cipherSuiteForAES};
            } else if (!bl && bl2) {
                String[] stringArray4 = new String[]{cipherSuiteFor3DES};
                stringArray2 = stringArray4;
            } else if (bl && bl2) {
                String[] stringArray5 = new String[]{cipherSuiteForAES, cipherSuiteFor3DES};
                stringArray2 = stringArray5;
            }
        }
        return stringArray2;
    }

    static final String[] getProtocolsToEnable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            boolean bl = Arrays.asList(stringArray).contains(protocolForTLS);
            System.err.println("getProtocolsToEnable() useTLS " + bl);
            if (bl) {
                String[] stringArray3;
                stringArray2 = stringArray3 = new String[]{protocolForTLS};
            }
        }
        return stringArray2;
    }
}

