/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.AAbortPDU;
import com.pixelmed.network.AssociateAcceptPDU;
import com.pixelmed.network.AssociateRejectPDU;
import com.pixelmed.network.AssociateRequestPDU;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContextSelectionPolicy;
import com.pixelmed.utils.ByteArray;
import com.pixelmed.utils.StringUtilities;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;

class AssociationAcceptor
extends Association {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociationAcceptor.java,v 1.25 2008/09/25 16:35:37 dclunie Exp $";
    protected PresentationContextSelectionPolicy presentationContextSelectionPolicy;

    protected AssociationAcceptor(Socket socket, String string, String string2, String string3, int n, int n2, int n3, PresentationContextSelectionPolicy presentationContextSelectionPolicy, int n4) throws DicomNetworkException, IOException {
        super(n4);
        this.socket = socket;
        this.calledAETitle = string;
        this.callingAETitle = null;
        this.presentationContexts = null;
        this.presentationContextSelectionPolicy = presentationContextSelectionPolicy;
        try {
            LinkedList linkedList;
            AssociateRequestPDU associateRequestPDU;
            this.setSocketOptions(socket, n, n2, n3, n4);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            byte[] byArray = new byte[6];
            AssociationAcceptor.readInsistently(this.in, byArray, 0, 6, "type and length of PDU");
            int n5 = byArray[0] & 0xFF;
            int n6 = ByteArray.bigEndianToUnsignedInt(byArray, 2, 4);
            if (n4 > 1) {
                System.err.println("Association[" + this.associationNumber + "]: Them: PDU Type: 0x" + Integer.toHexString(n5) + " (length 0x" + Integer.toHexString(n6) + ")");
            }
            if (n5 == 1) {
                associateRequestPDU = new AssociateRequestPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n6));
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Them:\n" + associateRequestPDU);
                }
                this.presentationContexts = associateRequestPDU.getRequestedPresentationContexts();
                this.maximumLengthReceived = associateRequestPDU.getMaximumLengthReceived();
                this.callingAETitle = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCallingAETitle());
                if (!string.equals(StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(associateRequestPDU.getCalledAETitle()))) {
                    AssociateRejectPDU associateRejectPDU = new AssociateRejectPDU(1, 1, 7);
                    this.out.write(associateRejectPDU.getBytes());
                    this.out.flush();
                    socket.close();
                    throw new DicomNetworkException("Called AE title requested (" + associateRequestPDU.getCalledAETitle() + ") doesn't match ours (" + string + ") - rejecting association");
                }
                presentationContextSelectionPolicy.applyPresentationContextSelectionPolicy(this.presentationContexts, this.associationNumber, n4);
                linkedList = AssociateAcceptPDU.sanitizePresentationContextsForAcceptance(this.presentationContexts);
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Presentation contexts for A-ASSOCIATE-AC:\n" + linkedList);
                }
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: OurMaximumLengthReceived=" + n);
                }
            } else {
                if (n5 == 7) {
                    AAbortPDU aAbortPDU = new AAbortPDU(AssociationAcceptor.getRestOfPDU(this.in, byArray, n6));
                    if (n4 > 1) {
                        System.err.println("Association[" + this.associationNumber + "]: Them:\n" + aAbortPDU);
                    }
                    socket.close();
                    throw new DicomNetworkException("A-ABORT indication - " + aAbortPDU.getInfo());
                }
                if (n4 > 1) {
                    System.err.println("Association[" + this.associationNumber + "]: Aborting");
                }
                AAbortPDU aAbortPDU = new AAbortPDU(0, 0);
                this.out.write(aAbortPDU.getBytes());
                this.out.flush();
                socket.close();
                throw new DicomNetworkException("A-P-ABORT indication - " + aAbortPDU.getInfo());
            }
            LinkedList linkedList2 = associateRequestPDU.getSCUSCPRoleSelections();
            AssociateAcceptPDU associateAcceptPDU = new AssociateAcceptPDU(string, this.callingAETitle, string2, string3, n, linkedList, linkedList2);
            this.out.write(associateAcceptPDU.getBytes());
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DicomNetworkException("A-P-ABORT indication - " + iOException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

