/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationAddress;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class NetworkApplicationInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationInformation.java,v 1.12 2010/11/15 20:30:23 dclunie Exp $";
    public static final String propertyName_DicomRemoteAEs = "Dicom.RemoteAEs";
    private static final String propertyNameSuffix_CalledAETitle = "CalledAETitle";
    private static final String propertyNameSuffix_HostNameOrIPAddress = "HostNameOrIPAddress";
    private static final String propertyNameSuffix_Port = "Port";
    private static final String propertyNameSuffix_QueryModel = "QueryModel";
    private static final String propertyNameSuffix_PrimaryDeviceType = "PrimaryDeviceType";
    private static final String propertyDelimitersForTokenizer_DicomRemoteAEs = ", ";
    private final ApplicationEntityMap applicationEntityMap = new ApplicationEntityMap();
    private final TreeMap localNameToApplicationEntityTitleMap = new TreeMap();
    private final TreeMap applicationEntityTitleToLocalNameMap = new TreeMap();

    public NetworkApplicationInformation() {
    }

    public NetworkApplicationInformation(Properties properties) throws DicomNetworkException {
        this();
        String string = properties.getProperty(propertyName_DicomRemoteAEs);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, propertyDelimitersForTokenizer_DicomRemoteAEs);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = properties.getProperty("Dicom.RemoteAEs." + string2 + "." + propertyNameSuffix_CalledAETitle);
                String string4 = properties.getProperty("Dicom.RemoteAEs." + string2 + "." + propertyNameSuffix_HostNameOrIPAddress);
                String string5 = properties.getProperty("Dicom.RemoteAEs." + string2 + "." + propertyNameSuffix_Port);
                int n = string5 == null ? -1 : Integer.parseInt(string5);
                String string6 = properties.getProperty("Dicom.RemoteAEs." + string2 + "." + propertyNameSuffix_QueryModel);
                String string7 = properties.getProperty("Dicom.RemoteAEs." + string2 + "." + propertyNameSuffix_PrimaryDeviceType);
                this.add(string2, string3, string4, n, string6, string7);
            }
        }
    }

    public Properties getProperties(Properties properties) {
        Object object;
        CharSequence charSequence;
        if (properties == null) {
            properties = new Properties();
        } else {
            charSequence = properties.getProperty(propertyName_DicomRemoteAEs);
            if (charSequence != null && ((String)charSequence).length() > 0) {
                object = new StringTokenizer((String)charSequence, propertyDelimitersForTokenizer_DicomRemoteAEs);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    properties.remove("Dicom.RemoteAEs." + (String)string + "." + propertyNameSuffix_CalledAETitle);
                    properties.remove("Dicom.RemoteAEs." + (String)string + "." + propertyNameSuffix_HostNameOrIPAddress);
                    properties.remove("Dicom.RemoteAEs." + (String)string + "." + propertyNameSuffix_Port);
                    properties.remove("Dicom.RemoteAEs." + (String)string + "." + propertyNameSuffix_QueryModel);
                    properties.remove("Dicom.RemoteAEs." + (String)string + "." + propertyNameSuffix_PrimaryDeviceType);
                }
            }
            properties.remove(propertyName_DicomRemoteAEs);
        }
        charSequence = new StringBuffer();
        object = "";
        for (String string : this.getListOfLocalNamesOfApplicationEntities()) {
            ApplicationEntity applicationEntity;
            String string2 = this.getApplicationEntityTitleFromLocalName(string);
            if (string2 == null || (applicationEntity = (ApplicationEntity)this.applicationEntityMap.get(string2)) == null) continue;
            PresentationAddress presentationAddress = applicationEntity.getPresentationAddress();
            properties.setProperty("Dicom.RemoteAEs." + string + "." + propertyNameSuffix_CalledAETitle, applicationEntity.getDicomAETitle());
            properties.setProperty("Dicom.RemoteAEs." + string + "." + propertyNameSuffix_HostNameOrIPAddress, presentationAddress.getHostname());
            properties.setProperty("Dicom.RemoteAEs." + string + "." + propertyNameSuffix_Port, Integer.toString(presentationAddress.getPort()));
            if (applicationEntity.getQueryModel() != null) {
                properties.setProperty("Dicom.RemoteAEs." + string + "." + propertyNameSuffix_QueryModel, applicationEntity.getQueryModel());
            }
            if (applicationEntity.getPrimaryDeviceType() != null) {
                properties.setProperty("Dicom.RemoteAEs." + string + "." + propertyNameSuffix_PrimaryDeviceType, applicationEntity.getPrimaryDeviceType());
            }
            ((StringBuffer)charSequence).append((String)object);
            ((StringBuffer)charSequence).append(string);
            object = propertyDelimitersForTokenizer_DicomRemoteAEs;
        }
        properties.setProperty(propertyName_DicomRemoteAEs, ((StringBuffer)charSequence).toString());
        return properties;
    }

    public void removeAll() {
        this.applicationEntityMap.clear();
        this.localNameToApplicationEntityTitleMap.clear();
        this.applicationEntityTitleToLocalNameMap.clear();
    }

    public void remove(String string) {
        if (string != null && string.length() > 0) {
            String string2 = this.getApplicationEntityTitleFromLocalName(string);
            this.localNameToApplicationEntityTitleMap.remove(string);
            if (string2 != null && string2.length() > 0) {
                this.applicationEntityTitleToLocalNameMap.remove(string2);
                this.applicationEntityMap.remove(string2);
            }
        }
    }

    public void add(String string, ApplicationEntity applicationEntity) throws DicomNetworkException {
        String string2;
        String string3 = applicationEntity.getDicomAETitle();
        if (string3 != null && string3.length() > 0) {
            if (this.applicationEntityMap.get(string3) != null && (string2 = this.getLocalNameFromApplicationEntityTitle(string3)) != null && string != null && !string.equals(string2)) {
                throw new DicomNetworkException("Cannot use AET [" + string3 + "] for local name [" + string + "] - already used for [" + string2 + "]");
            }
        } else {
            throw new DicomNetworkException("Cannot use empty AET [" + string3 + "]");
        }
        this.applicationEntityMap.put((Object)string3, (Object)applicationEntity);
        if (string != null && string.length() > 0 && string3 != null && string3.length() > 0) {
            ApplicationEntity applicationEntity2;
            string2 = (String)this.localNameToApplicationEntityTitleMap.get(string);
            if (string2 != null && string2.length() > 0 && (applicationEntity2 = (ApplicationEntity)this.applicationEntityMap.get(string3)) != null && !applicationEntity2.equals(applicationEntity)) {
                throw new DicomNetworkException("Cannot use local name [" + string + "] - already used for AE [" + string2 + "]");
            }
        } else {
            throw new DicomNetworkException("Cannot use empty AET [" + string3 + "] or empty local name [" + string + "]");
        }
        this.localNameToApplicationEntityTitleMap.put(string, string3);
        this.applicationEntityTitleToLocalNameMap.put(string3, string);
    }

    public void add(String string, String string2, String string3, int n, String string4, String string5) throws DicomNetworkException {
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            if (this.applicationEntityMap.get(string2) != null) {
                throw new DicomNetworkException("Cannot use AET [" + string2 + "] for local name [" + string + "] - already used for [" + this.getLocalNameFromApplicationEntityTitle(string2) + "]");
            }
        } else {
            throw new DicomNetworkException("Cannot use empty AET [" + string2 + "] or hostname [" + string3 + "] or port [" + n + "]");
        }
        this.applicationEntityMap.put(string2, new PresentationAddress(string3, n), string4, string5);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            if (this.localNameToApplicationEntityTitleMap.get(string) != null) {
                throw new DicomNetworkException("Cannot use local name [" + string + "] - already used");
            }
        } else {
            throw new DicomNetworkException("Cannot use empty AET [" + string2 + "] or empty local name [" + string + "]");
        }
        this.localNameToApplicationEntityTitleMap.put(string, string2);
        this.applicationEntityTitleToLocalNameMap.put(string2, string);
    }

    public void addAll(NetworkApplicationInformation networkApplicationInformation) {
        if (networkApplicationInformation != null) {
            Set set = networkApplicationInformation.getListOfLocalNamesOfApplicationEntities();
            ApplicationEntityMap applicationEntityMap = networkApplicationInformation.getApplicationEntityMap();
            if (set != null && applicationEntityMap != null) {
                for (String string : set) {
                    String string2;
                    if (string == null || string.length() <= 0 || (string2 = networkApplicationInformation.getApplicationEntityTitleFromLocalName(string)) == null || string2.length() <= 0 || this.localNameToApplicationEntityTitleMap.get(string) != null || this.applicationEntityMap.get(string2) != null) continue;
                    ApplicationEntity applicationEntity = (ApplicationEntity)applicationEntityMap.get(string2);
                    this.applicationEntityMap.put((Object)string2, (Object)applicationEntity);
                    this.localNameToApplicationEntityTitleMap.put(string, string2);
                    this.applicationEntityTitleToLocalNameMap.put(string2, string);
                }
            }
        }
    }

    public ApplicationEntityMap getApplicationEntityMap() {
        return this.applicationEntityMap;
    }

    public Set getListOfLocalNamesOfApplicationEntities() {
        return this.localNameToApplicationEntityTitleMap.keySet();
    }

    public Set getListOfApplicationEntityTitlesOfApplicationEntities() {
        return this.applicationEntityTitleToLocalNameMap.keySet();
    }

    public String getApplicationEntityTitleFromLocalName(String string) {
        return (String)this.localNameToApplicationEntityTitleMap.get(string);
    }

    public String getLocalNameFromApplicationEntityTitle(String string) {
        return (String)this.applicationEntityTitleToLocalNameMap.get(string);
    }

    public String getLDIFRepresentation(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("version: 1");
        printWriter.println("");
        printWriter.println("dn: cn=DICOM Configuration," + string);
        printWriter.println("objectClass: dicomConfigurationRoot");
        printWriter.println("cn: DICOM Configuration");
        printWriter.println("");
        printWriter.println("dn: cn=Devices,cn=DICOM Configuration," + string);
        printWriter.println("objectClass: dicomDevicesRoot");
        printWriter.println("cn: Devices");
        printWriter.println("");
        printWriter.println("dn: cn=Unique AE Titles Registry,cn=DICOM Configuration," + string);
        printWriter.println("objectClass: dicomUniqueAETitlesRegistryRoot");
        printWriter.println("cn: Unique AE Titles Registry");
        printWriter.println("");
        ApplicationEntityMap applicationEntityMap = this.getApplicationEntityMap();
        if (this.localNameToApplicationEntityTitleMap != null) {
            for (String string2 : this.getListOfLocalNamesOfApplicationEntities()) {
                printWriter.println("dn: dicomDeviceName=" + string2 + ",cn=Devices,cn=DICOM Configuration," + string);
                printWriter.println("objectClass: dicomDevice");
                printWriter.println("dicomDeviceName: " + string2);
                printWriter.println("dicomInstalled: TRUE");
                printWriter.println("");
                String string3 = this.getApplicationEntityTitleFromLocalName(string2);
                PresentationAddress presentationAddress = applicationEntityMap.getPresentationAddress(string3);
                String string4 = presentationAddress.getHostname();
                int n = presentationAddress.getPort();
                String string5 = "TRUE";
                String string6 = "TRUE";
                String string7 = string2;
                String string8 = "cn=" + string7 + ",dicomDeviceName=" + string2 + ",cn=Devices,cn=DICOM Configuration," + string;
                printWriter.println("dn: " + string8);
                printWriter.println("objectClass: dicomNetworkConnection");
                printWriter.println("cn: " + string7);
                printWriter.println("dicomHostname: " + string4);
                printWriter.println("dicomPort: " + n);
                printWriter.println("");
                printWriter.println("dn: dicomAETitle=" + string3 + ",dicomDeviceName=" + string2 + ",cn=Devices,cn=DICOM Configuration," + string);
                printWriter.println("objectClass: dicomNetworkAE");
                printWriter.println("dicomAETitle: " + string3);
                printWriter.println("dicomNetworkConnectionReference: " + string8);
                printWriter.println("dicomAssociationAcceptor: TRUE");
                printWriter.println("dicomAssociationInitiator: TRUE");
                printWriter.println("");
                printWriter.println("dn: dicomAETitle=" + string3 + ",cn=Unique AE Titles Registry,cn=DICOM Configuration," + string);
                printWriter.println("objectClass: dicomUniqueAETitle");
                printWriter.println("dicomAETitle: " + string3);
                printWriter.println("");
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ApplicationEntityMap applicationEntityMap = this.getApplicationEntityMap();
        if (this.localNameToApplicationEntityTitleMap != null) {
            for (String string : this.getListOfLocalNamesOfApplicationEntities()) {
                String string2 = this.getApplicationEntityTitleFromLocalName(string);
                ApplicationEntity applicationEntity = string2 == null ? null : (ApplicationEntity)applicationEntityMap.get(string2);
                printWriter.println("localName=" + string + "," + (applicationEntity == null ? "-null-" : applicationEntity.toString()));
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }
}

