/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.network.PresentationAddress;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

public class NetworkConfigurationFromMulticastDNS
extends NetworkConfigurationSource {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkConfigurationFromMulticastDNS.java,v 1.9 2010/05/31 11:33:40 dclunie Exp $";
    private static final String DICOMServiceName = "_dicom._tcp.local.";
    private static final String ACRNEMAServiceName = "_acr-nema._tcp.local.";
    private static final String DICOMTLSServiceName = "_dicom-tls._tcp.local.";
    private static final String AETTXTRecordPropertyName = "AET";
    private static final String PrimaryDeviceTypeTXTRecordPropertyName = "PrimaryDeviceType";
    private static final String AETTXTRecordPropertyNameAsLowerCase = "AET".toLowerCase();
    private static final String PrimaryDeviceTypeTXTRecordPropertyNameAsLowerCase = "PrimaryDeviceType".toLowerCase();
    private static final String WADOServiceName = "_http._tcp.local.";
    private static final String WADOPathTXTRecordPropertyName = "path";
    protected JmDNS jmDNS;

    public void activateDiscovery(int n) {
        if (this.debugLevel > 1) {
            System.err.println("NetworkConfigurationFromMulticastDNS.activateDNSSelfDiscovery():");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.impl.JmDNSImpl");
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            this.jmDNS = (JmDNS)clazz.getConstructor(classArray).newInstance(objectArray);
            OurJmDNSServiceListener ourJmDNSServiceListener = new OurJmDNSServiceListener();
            ServiceListener serviceListener = (ServiceListener)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServiceListener.class}, (InvocationHandler)ourJmDNSServiceListener);
            this.jmDNS.addServiceListener(DICOMServiceName, serviceListener);
            this.jmDNS.addServiceListener(ACRNEMAServiceName, serviceListener);
            this.jmDNS.addServiceListener(DICOMTLSServiceName, serviceListener);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.activateDNSSelfDiscovery(): DNS Self Discovery not available (Could not load JmDNS class)");
                classNotFoundException.printStackTrace(System.err);
            }
            this.jmDNS = null;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.jmDNS = null;
        }
    }

    public void deActivateDiscovery() {
        if (this.debugLevel > 1) {
            System.err.println("NetworkConfigurationFromMulticastDNS.deActivateDiscovery():");
        }
        if (this.jmDNS != null) {
            this.jmDNS.unregisterAllServices();
            this.jmDNS.close();
        }
    }

    public NetworkConfigurationFromMulticastDNS(int n) {
        super(n);
    }

    public void unregisterAllServices() {
        if (this.debugLevel > 1) {
            System.err.println("NetworkConfigurationFromMulticastDNS.unRegisterAllServices():");
        }
        if (this.jmDNS != null) {
            this.jmDNS.unregisterAllServices();
        }
    }

    public void registerDicomService(String string, int n, String string2) {
        if (this.debugLevel > 1) {
            System.err.println("NetworkConfigurationFromMulticastDNS.registerDicomService():");
        }
        if (this.jmDNS != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string != null && string.length() > 0) {
                hashtable.put(AETTXTRecordPropertyName, string);
            }
            if (string2 != null && string2.length() > 0) {
                hashtable.put(PrimaryDeviceTypeTXTRecordPropertyName, string2);
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.impl.ServiceInfoImpl");
                Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Hashtable.class};
                Object[] objectArray = new Object[]{DICOMServiceName, string, n, 0, 0, hashtable};
                ServiceInfo serviceInfo = (ServiceInfo)clazz.getConstructor(classArray).newInstance(objectArray);
                this.jmDNS.registerService(serviceInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void registerWADOService(String string, int n, String string2) {
        if (this.jmDNS != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string2 != null && string2.length() > 0) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                hashtable.put(WADOPathTXTRecordPropertyName, string2);
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.jmdns.impl.ServiceInfoImpl");
                Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Hashtable.class};
                Object[] objectArray = new Object[]{WADOServiceName, string, n, 0, 0, hashtable};
                ServiceInfo serviceInfo = (ServiceInfo)clazz.getConstructor(classArray).newInstance(objectArray);
                if (this.debugLevel > 1) {
                    System.err.println("NetworkConfigurationFromMulticastDNS.registerWADOService(): info = " + serviceInfo);
                }
                this.jmDNS.registerService(serviceInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void main(String[] stringArray) {
        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS(99);
        networkConfigurationFromMulticastDNS.activateDiscovery();
        if (stringArray.length > 1) {
            networkConfigurationFromMulticastDNS.registerDicomService(stringArray[0], Integer.parseInt(stringArray[1]), stringArray.length > 2 ? stringArray[2] : null);
        }
        networkConfigurationFromMulticastDNS.activateDumper();
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            networkConfigurationFromMulticastDNS.close();
            return;
        }
    }

    protected class OurJmDNSServiceListener
    implements InvocationHandler {
        protected OurJmDNSServiceListener() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == ServiceListener.class) {
                String string = method.getName();
                if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                    System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener.invoke(): methodName = " + string);
                }
                if (string.equals("serviceAdded")) {
                    this.serviceAdded((ServiceEvent)objectArray[0]);
                } else if (string.equals("serviceRemoved")) {
                    this.serviceRemoved((ServiceEvent)objectArray[0]);
                } else if (string.equals("serviceResolved")) {
                    this.serviceResolved((ServiceEvent)objectArray[0]);
                }
            }
            return null;
        }

        public void serviceAdded(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service added   : Name = " + string);
            }
            String string2 = serviceEvent.getType();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service added   : Type = " + string2);
            }
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service added   : Info = " + serviceInfo);
            }
            if (serviceInfo == null) {
                if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                    System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: issuing request for info");
                }
                NetworkConfigurationFromMulticastDNS.this.jmDNS.requestServiceInfo(string2, string);
                if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                    System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: back from issuing request for info");
                }
            }
        }

        public void serviceRemoved(ServiceEvent serviceEvent) {
            String string = serviceEvent.getName();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service removed : Name = " + string);
            }
            String string2 = serviceEvent.getType();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service removed : Type = " + string2);
            }
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service removed : Info = " + serviceInfo);
            }
            NetworkConfigurationFromMulticastDNS.this.getNetworkApplicationInformation().remove(string);
        }

        public void serviceResolved(ServiceEvent serviceEvent) {
            Object object;
            Object object2;
            String string = serviceEvent.getName();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: Name = " + string);
            }
            String string2 = serviceEvent.getType();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: Type = " + string2);
            }
            ServiceInfo serviceInfo = serviceEvent.getInfo();
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: Info = " + serviceInfo);
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = -1;
            if (serviceInfo != null) {
                if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                    System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: Info getServer() = " + serviceInfo.getServer());
                }
                string5 = serviceInfo.getHostAddress();
                n = serviceInfo.getPort();
                object2 = serviceInfo.getPropertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (object == null) continue;
                    String string6 = serviceInfo.getPropertyString((String)object);
                    String string7 = ((String)object).toLowerCase();
                    if (string7.equals(AETTXTRecordPropertyNameAsLowerCase)) {
                        string3 = string6;
                        continue;
                    }
                    if (string7.equals(PrimaryDeviceTypeTXTRecordPropertyNameAsLowerCase)) {
                        string4 = string6;
                        continue;
                    }
                    if (NetworkConfigurationFromMulticastDNS.this.debugLevel <= 1) continue;
                    System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: Unrecognized property name = " + (String)object + " value = " + string6);
                }
            }
            if (string3 == null) {
                string3 = string;
            }
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: hostname = " + string5);
            }
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: port = " + n);
            }
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: aet = " + string3);
            }
            if (NetworkConfigurationFromMulticastDNS.this.debugLevel > 1) {
                System.err.println("NetworkConfigurationFromMulticastDNS.OurJmDNSServiceListener: Service resolved: primaryDeviceType = " + string4);
            }
            if (string != null && string.length() > 0 && string5 != null && string5.length() > 0 && string3 != null && string3.length() > 0 && n != -1) {
                object2 = new PresentationAddress(string5, n);
                object = new ApplicationEntity(string3, (PresentationAddress)object2, null, string4);
                try {
                    NetworkConfigurationFromMulticastDNS.this.getNetworkApplicationInformation().add(string, (ApplicationEntity)object);
                }
                catch (DicomNetworkException dicomNetworkException) {
                    dicomNetworkException.printStackTrace(System.err);
                }
            }
        }
    }
}

