/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.XMLRepresentationOfStructuredReportObjectFactory;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTDoseAcquisition;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.CompositeInstanceContext;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.dose.ScopeOfDoseAccummulation;
import com.pixelmed.utils.FloatFormatter;
import com.pixelmed.validate.DicomSRValidator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestCTDose
extends TestCase {
    private CommonDoseObserverContext observerContext;
    private CompositeInstanceContext compositeInstanceContext;
    private String deviceUID = "1.2.3.4";
    private String deviceName = "station1";
    private String manufacturer = "Acme";
    private String modelName = "Scanner";
    private String serialNumber = "72349236741";
    private String location = "Suite1";
    private String operatorName = "Smith^John";
    private String operatorID = "26354781234";
    private String physicianName = "Jones^Mary";
    private String physicianID = "23491234234";
    private String idIssuer = "99BLA";
    private String organization = "St. Elsewhere's";
    private String patientName = "Smith^Mary";
    private String patientID = "3764913624";
    private String patientBirthDate = "19600101";
    private String patientAge = "041Y";
    private String patientWeight = "68";
    private String patientSize = "1.55";
    private String patientSex = "F";
    private String studyID = "612386812";
    private String seriesNumber = "12";
    private String instanceNumber = "38";
    private String referringPhysicianName = "Jones^Harriet";
    private String studyDate = "20010203";
    private String studyTime = "043000";
    private UIDGenerator u = new UIDGenerator("9999");
    private String sopInstanceUID;
    private String seriesInstanceUID;
    private String studyInstanceUID;

    public TestCTDose(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTDose");
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithAllParameters"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithAllParametersAndThreeAcquisitionsInTwoSeries"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_WithOneAcquisitionsAndNoTotalDLP"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_PropagationOfDescriptionToAttributeList_IfNoStudyDescriptionInCompositeInstanceContext"));
        testSuite.addTest((Test)new TestCTDose("testCTDoseConstructor_PropagationOfDescriptionToAttributeList_DoesNotOverwriteIfStudyDescriptionAlreadyInCompositeInstanceContext"));
        return testSuite;
    }

    protected void setUp() {
        this.observerContext = new CommonDoseObserverContext(this.deviceUID, this.deviceName, this.manufacturer, this.modelName, this.serialNumber, this.location, this.operatorName, this.operatorID, this.physicianName, this.physicianID, this.idIssuer, this.organization);
        try {
            UIDGenerator uIDGenerator = new UIDGenerator("9999");
            this.sopInstanceUID = uIDGenerator.getNewSOPInstanceUID(this.studyID, this.seriesNumber, this.instanceNumber);
            this.seriesInstanceUID = uIDGenerator.getNewSeriesInstanceUID(this.studyID, this.seriesNumber);
            this.studyInstanceUID = uIDGenerator.getNewStudyInstanceUID(this.studyID);
            AttributeList attributeList = new AttributeList();
            StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            ((Attribute)stringAttribute).addValue(this.sopInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)stringAttribute).addValue(this.seriesInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)stringAttribute).addValue(this.studyInstanceUID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
            ((Attribute)stringAttribute).addValue(this.patientName);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.PatientID);
            ((Attribute)stringAttribute).addValue(this.patientID);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
            ((Attribute)stringAttribute).addValue(this.patientBirthDate);
            attributeList.put(stringAttribute);
            stringAttribute = new AgeStringAttribute(TagFromName.PatientAge);
            ((Attribute)stringAttribute).addValue(this.patientAge);
            attributeList.put(stringAttribute);
            stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
            ((Attribute)stringAttribute).addValue(this.patientSex);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientWeight);
            ((Attribute)stringAttribute).addValue(this.patientWeight);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.PatientSize);
            ((Attribute)stringAttribute).addValue(this.patientSize);
            attributeList.put(stringAttribute);
            stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
            ((Attribute)stringAttribute).addValue(this.studyID);
            attributeList.put(stringAttribute);
            stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
            ((Attribute)stringAttribute).addValue(this.referringPhysicianName);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
            ((Attribute)stringAttribute).addValue(this.seriesNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
            ((Attribute)stringAttribute).addValue(this.instanceNumber);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
            attributeList.put(stringAttribute);
            stringAttribute = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)stringAttribute).addValue(this.studyDate);
            attributeList.put(stringAttribute);
            stringAttribute = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)stringAttribute).addValue(this.studyTime);
            attributeList.put(stringAttribute);
            this.compositeInstanceContext = new CompositeInstanceContext(attributeList);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    protected void tearDown() {
    }

    public void testCTDoseConstructor_WithAllParameters() throws Exception {
        String string = "1299.58";
        int n = 4;
        String string2 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string3 = "20010203043000+0000";
        String string4 = "20010203043500+0000";
        String string5 = "CAP";
        String string6 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string3 + "\tEnd=" + string4 + "\tModality=CT\tDescription=" + string5 + "\tScope=Study\tUID=" + string2 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string + " mGy.cm\n";
        String string7 = "Dose\tPatient ID=3764913624\tName=Smith^Mary\tSex=F\tDOB=19600101\tAge=041Y\tWeight=68 kg\tHeight=1.55 m\tAccession=\tStart=" + string3 + "\tModality=CT\tDescription=" + string5 + "\tDLP Total=" + string + " mGy.cm\n";
        CTDose cTDose = new CTDose(string, n, ScopeOfDoseAccummulation.STUDY, string2, string3, string4, string5);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string, (String)cTDose.getDLPTotal());
        TestCTDose.assertEquals((String)"Checking totalNumberOfIrradiationEvents", (int)n, (int)cTDose.getTotalNumberOfIrradiationEvents());
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation equality", (Object)ScopeOfDoseAccummulation.STUDY, (Object)cTDose.getScopeOfDoseAccummulation());
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation string equality", (String)"Study", (String)cTDose.getScopeOfDoseAccummulation().toString());
        TestCTDose.assertEquals((String)"Checking scopeUID string equality", (String)string2, (String)cTDose.getScopeUID());
        TestCTDose.assertEquals((String)"Checking startDateTime string equality", (String)string3, (String)cTDose.getStartDateTime());
        TestCTDose.assertEquals((String)"Checking endDateTime string equality", (String)string4, (String)cTDose.getEndDateTime());
        TestCTDose.assertEquals((String)"Checking description string equality", (String)string5, (String)cTDose.getDescription());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string6, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string6, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string7, (String)cTDose.toString(false, false));
        TestCTDose.assertFalse((String)"Checking SR is not null", (cTDose.getStructuredReport() == null ? 1 : 0) != 0);
    }

    public void testCTDoseConstructor_WithAllParametersAndThreeAcquisitionsInTwoSeries() throws Exception {
        String[] stringArray = new String[]{"20.23", "20.23", "20.23"};
        String[] stringArray2 = new String[]{"1362.24", "107.73", "172.99"};
        String string = "BODY32";
        ScanRange[] scanRangeArray = new ScanRange[]{new ScanRange("S", "14.250", "I", "635.750"), new ScanRange("I", "635.250", "I", "665.250"), new ScanRange("S", "14.250", "S", "84.250")};
        String string2 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string2, true, "2", CTScanType.HELICAL, scanRangeArray[0], stringArray[0], stringArray2[0], CTPhantomType.selectFromDescription(string));
        CTDoseAcquisition cTDoseAcquisition2 = new CTDoseAcquisition(string2, true, "2", CTScanType.HELICAL, scanRangeArray[1], stringArray[1], stringArray2[1], CTPhantomType.selectFromDescription(string));
        CTDoseAcquisition cTDoseAcquisition3 = new CTDoseAcquisition(string2, true, "3", CTScanType.HELICAL, scanRangeArray[2], stringArray[2], stringArray2[2], CTPhantomType.selectFromDescription(string));
        String string3 = "1642.96";
        int n = 3;
        String string4 = "20010203043000+0000";
        String string5 = "2001/02/03 04:30:00";
        String string6 = "20010203043500+0000";
        String string7 = "2001/02/03 04:35:00";
        String string8 = "CAP";
        String string9 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\tStart=" + string4 + "\tEnd=" + string6 + "\tModality=CT\tDescription=" + string8 + "\tScope=Study\tUID=" + string2 + "\tEvents=" + Integer.toString(n) + "\tDLP Total=" + string3 + " mGy.cm\n" + "\tSeries=2\tHelical\tRange=S14.250-I635.750 mm\tCTDIvol=" + stringArray[0] + " mGy\tDLP=" + stringArray2[0] + " mGy.cm\tPhantom=BODY32\n" + "\tSeries=2\tHelical\tRange=I635.250-I665.250 mm\tCTDIvol=" + stringArray[1] + " mGy\tDLP=" + stringArray2[1] + " mGy.cm\tPhantom=BODY32\n" + "\tSeries=3\tHelical\tRange=S14.250-S84.250 mm\tCTDIvol=" + stringArray[2] + " mGy\tDLP=" + stringArray2[2] + " mGy.cm\tPhantom=BODY32\n";
        String string10 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\tStart=" + string4 + "\tModality=CT\tDescription=" + string8 + "\tDLP Total=" + string3 + " mGy.cm\n";
        String string11 = "Dose\tPatient ID=\tName=\tSex=\tDOB=\tAge=\tWeight= kg\tHeight= m\tAccession=\t" + string5 + "\tCT\t" + string8 + "\tDLP Total=" + string3 + " mGy.cm\n";
        String string12 = "<tr><td></td><td></td><td></td><td></td><td align=right></td><td align=right></td><td align=right></td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1642.96</td></tr>\n";
        String string13 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th></tr>\n<tr><td></td><td></td><td></td><td></td><td align=right></td><td align=right></td><td align=right></td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1642.96</td></tr>\n<tr><td colspan=2></td><td colspan=10><table><tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th></tr>\n<tr><td>Series=2</td><td>Helical</td><td>S14.250-I635.750</td><td>" + stringArray[0] + "</td><td>" + stringArray2[0] + "</td><td>BODY32</td></tr>\n" + "<tr><td>Series=2</td><td>Helical</td><td>I635.250-I665.250</td><td>" + stringArray[1] + "</td><td>" + stringArray2[1] + "</td><td>BODY32</td></tr>\n" + "<tr><td>Series=3</td><td>Helical</td><td>S14.250-S84.250</td><td>" + stringArray[2] + "</td><td>" + stringArray2[2] + "</td><td>BODY32</td></tr>\n" + "</table></td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string2, string4, string6, string8);
        cTDose.addAcquisition(cTDoseAcquisition);
        cTDose.addAcquisition(cTDoseAcquisition2);
        cTDose.addAcquisition(cTDoseAcquisition3);
        cTDose.setDLPTotal(string3);
        TestCTDose.assertEquals((String)"Checking DLP Total", (String)string3, (String)cTDose.getDLPTotal());
        TestCTDose.assertTrue((String)"Checking DLP Total as double", (Double.parseDouble(string3) == Double.parseDouble(cTDose.getDLPTotal()) ? 1 : 0) != 0);
        TestCTDose.assertEquals((String)"Checking totalNumberOfIrradiationEvents", (int)n, (int)cTDose.getTotalNumberOfIrradiationEvents());
        TestCTDose.assertTrue((String)"Checking ScopeOfDoseAccummulation equality", (boolean)ScopeOfDoseAccummulation.STUDY.equals(cTDose.getScopeOfDoseAccummulation()));
        TestCTDose.assertEquals((String)"Checking ScopeOfDoseAccummulation string equality", (String)"Study", (String)cTDose.getScopeOfDoseAccummulation().toString());
        TestCTDose.assertEquals((String)"Checking scopeUID string equality", (String)string2, (String)cTDose.getScopeUID());
        TestCTDose.assertEquals((String)"Checking startDateTime string equality", (String)string4, (String)cTDose.getStartDateTime());
        TestCTDose.assertEquals((String)"Checking endDateTime string equality", (String)string6, (String)cTDose.getEndDateTime());
        TestCTDose.assertEquals((String)"Checking description string equality", (String)string8, (String)cTDose.getDescription());
        TestCTDose.assertEquals((String)"Checking number of acquisitions", (int)n, (int)cTDose.getNumberOfAcquisitions());
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 1 equality", (boolean)cTDoseAcquisition.equals(cTDose.getAcquisition(0)));
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 2 equality", (boolean)cTDoseAcquisition2.equals(cTDose.getAcquisition(1)));
        TestCTDose.assertTrue((String)"Checking CTDoseAcquisition 3 equality", (boolean)cTDoseAcquisition3.equals(cTDose.getAcquisition(2)));
        TestCTDose.assertTrue((String)"Checking DLP Total as double with total from acquisitions", (boolean)cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking toString default", (String)string9, (String)cTDose.toString());
        TestCTDose.assertEquals((String)"Checking toString detail", (String)string9, (String)cTDose.toString(true, false));
        TestCTDose.assertEquals((String)"Checking toString no detail", (String)string10, (String)cTDose.toString(false, false));
        TestCTDose.assertEquals((String)"Checking toString no detail pretty", (String)string11, (String)cTDose.toString(false, true));
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string12, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string13, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking document title", (String)"X-Ray Radiation Dose Report", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/concept/@cm", document));
        TestCTDose.assertEquals((String)"Checking procedure reported", (String)"Computed Tomography X-Ray", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking diagnostic intent", (String)"Diagnostic Intent", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/code[concept/@cv='G-C0E8']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Start of X-Ray Irradiation", (String)string4, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113809']/value", document));
        TestCTDose.assertEquals((String)"Checking End of X-Ray Irradiation", (String)string6, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113810']/value", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation", (String)"Study", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation UIDREF", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/uidref/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events", (String)Integer.toString(n), (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events units", (String)"events", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/units/@cm", document));
        NodeList nodeList = (NodeList)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']", document, XPathConstants.NODESET);
        TestCTDose.assertTrue((String)"CT Acquisitions not null", (nodeList != null ? 1 : 0) != 0);
        TestCTDose.assertTrue((String)"CT Acquisitions count", (nodeList.getLength() == n ? 1 : 0) != 0);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            TestCTDose.assertEquals((String)"Checking Target Region", (String)"Entire body", (String)xPathFactory.newXPath().evaluate("./code[concept/@cv='123014']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking CT Acquisition Type", (String)"Spiral Acquisition", (String)xPathFactory.newXPath().evaluate("./code[concept/@cv='113820']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking Scanning Length", (String)scanRangeArray[i].getAbsoluteRange(), (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113822']/num[concept/@cv='113825']/value", node));
            TestCTDose.assertEquals((String)"Checking Scanning Length units", (String)"mm", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113822']/num[concept/@cv='113825']/units/@cm", node));
            TestCTDose.assertEquals((String)"Checking Mean CTDIvol", (String)stringArray[i], (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113830']/value", node));
            TestCTDose.assertEquals((String)"Checking Mean CTDIvol units", (String)"mGy", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113830']/units/@cm", node));
            TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/code[concept/@cv='113835']/value/@cm", node));
            TestCTDose.assertEquals((String)"Checking DLP", (String)stringArray2[i], (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113838']/value", node));
            TestCTDose.assertEquals((String)"Checking DLP units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("./container[concept/@cv='113829']/num[concept/@cv='113838']/units/@cm", node));
        }
    }

    public void testCTDoseConstructor_WithOneAcquisitionsAndNoTotalDLP() throws Exception {
        String string = "1362.24";
        String string2 = "20.23";
        String string3 = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        CTDoseAcquisition cTDoseAcquisition = new CTDoseAcquisition(string3, true, "2", CTScanType.HELICAL, new ScanRange("S", "14.250", "I", "635.750"), string2, string, CTPhantomType.selectFromDescription("BODY32"));
        String string4 = "1.2.3.4";
        CTScanType cTScanType = CTScanType.HELICAL;
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem("R-FAB56", "SRT", "Chest, Abdomen and Pelvis");
        String string5 = "1";
        String string6 = "120";
        String string7 = "397";
        String string8 = "433";
        String string9 = "0.6";
        String string10 = "0.625";
        String string11 = "40";
        String string12 = "0.984";
        CTAcquisitionParameters cTAcquisitionParameters = new CTAcquisitionParameters(string4, cTScanType, codedSequenceItem, string5, null, string10, string11, string12, string6, string7, string8, string9);
        cTAcquisitionParameters.deriveScanningLengthFromDLPAndCTDIVol(string, string2);
        String string13 = FloatFormatter.toString(673.3761739990114);
        String string14 = string;
        String string15 = null;
        boolean bl = true;
        String string16 = "20010203043000+0000";
        String string17 = "20010203043500+0000";
        String string18 = "CAP";
        String string19 = "<tr><td>3764913624</td><td>Smith^Mary</td><td>F</td><td>19600101</td><td align=right>041Y</td><td align=right>68</td><td align=right>1.55</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1362.24</td></tr>\n";
        String string20 = "<tr><th>ID</th><th>Name</th><th>Sex</th><th>DOB</th><th>Age</th><th>Weight kg</th><th>Height m</th><th>Accession</th><th>Date</th><th>Modality</th><th>Description</th><th>DLP Total mGy.cm</th></tr>\n<tr><td>3764913624</td><td>Smith^Mary</td><td>F</td><td>19600101</td><td align=right>041Y</td><td align=right>68</td><td align=right>1.55</td><td></td><td>2001/02/03 04:30:00</td><td>CT</td><td>CAP</td><td align=right>1362.24</td></tr>\n<tr><td colspan=2></td><td colspan=10><table><tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th><th>Type</th><th>Anatomy</th><th>Scanning Length mm</th><th>Collimation Single/Total mm</th><th>Pitch Factor</th><th>kVP</th><th>Tube Current Mean/Max mA</th><th>Exposure Time/Per Rotation s</th></tr>\n<tr><td>Series=2</td><td>Helical</td><td>S14.250-I635.750</td><td>20.23</td><td>1362.24</td><td>BODY32</td><td>Helical</td><td>Chest, Abdomen and Pelvis</td><td>673.4</td><td>0.625/40</td><td>0.984:1</td><td>120</td><td>397/433</td><td>1/0.6</td></tr>\n</table></td></tr>\n";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string3, string16, string17, string18);
        cTDoseAcquisition.setAcquisitionParameters(cTAcquisitionParameters);
        cTDose.addAcquisition(cTDoseAcquisition);
        cTDose.setDLPTotal(string15);
        cTDose.setObserverContext(this.observerContext);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking null DLP Total", string15, (String)cTDose.getDLPTotal());
        TestCTDose.assertFalse((String)"Checking null DLP Total does not match total from acquisitions", (boolean)cTDose.specifiedDLPTotalMatchesDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking DLP total from acquisitions", (String)string14, (String)cTDose.getDLPTotalFromAcquisitions());
        TestCTDose.assertEquals((String)"Checking getHTML no detail", (String)string19, (String)cTDose.getHTMLTableRow(false));
        TestCTDose.assertEquals((String)"Checking getHTML detail", (String)string20, (String)cTDose.getHTMLTableRow(true));
        StructuredReport structuredReport = cTDose.getStructuredReport();
        TestCTDose.assertFalse((String)"Checking SR is not null", (structuredReport == null ? 1 : 0) != 0);
        AttributeList attributeList = cTDose.getAttributeList();
        TestCTDose.assertFalse((String)"Checking SR AttributeList is not null", (attributeList == null ? 1 : 0) != 0);
        Document document = new XMLRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
        TestCTDose.assertFalse((String)"Checking SR document is not null", (document == null ? 1 : 0) != 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        TestCTDose.assertEquals((String)"Checking document title", (String)"X-Ray Radiation Dose Report", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/concept/@cm", document));
        TestCTDose.assertEquals((String)"Checking procedure reported", (String)"Computed Tomography X-Ray", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking diagnostic intent", (String)"Diagnostic Intent", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121058']/code[concept/@cv='G-C0E8']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking observer type", (String)"Device", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='121005']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Observer UID", (String)this.deviceUID, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/uidref[concept/@cv='121012']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Name", (String)this.deviceName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121013']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Manufacturer", (String)this.manufacturer, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121014']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Model Name", (String)this.modelName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121015']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Serial Number", (String)this.serialNumber, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121016']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Observer Physical Location during observation", (String)this.location, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/text[concept/@cv='121017']/value", document));
        TestCTDose.assertEquals((String)"Checking Start of X-Ray Irradiation", (String)string16, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113809']/value", document));
        TestCTDose.assertEquals((String)"Checking End of X-Ray Irradiation", (String)string17, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/datetime[concept/@cv='113810']/value", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation", (String)"Study", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking scope of accumulation UIDREF", (String)string3, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/code[concept/@cv='113705']/uidref/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/value", document));
        TestCTDose.assertEquals((String)"Checking Total Number of Irradiation Events units", (String)"events", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113812']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total", (String)string14, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/value", document));
        TestCTDose.assertEquals((String)"Checking CT Dose Length Product Total units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113811']/num[concept/@cv='113813']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Target Region", (String)"Chest, Abdomen and Pelvis", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='123014']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking CT Acquisition Type", (String)"Spiral Acquisition", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113820']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Irradiation Event UID", (String)string4, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/uidref[concept/@cv='113769']/value", document));
        TestCTDose.assertEquals((String)"Checking ExposureTime", (String)string5, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113824']/value", document));
        TestCTDose.assertEquals((String)"Checking ExposureTime units", (String)"s", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113824']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Scanning Length", (String)string13, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113825']/value", document));
        TestCTDose.assertEquals((String)"Checking Scanning Length units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113825']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Nominal Single Collimation Width", (String)string10, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113826']/value", document));
        TestCTDose.assertEquals((String)"Checking Nominal Single Collimation Width units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113826']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Nominal Total Collimation Width", (String)string11, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113827']/value", document));
        TestCTDose.assertEquals((String)"Checking Nominal Total Collimation Width units", (String)"mm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113827']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Pitch Factor", (String)string12, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113828']/value", document));
        TestCTDose.assertEquals((String)"Checking Pitch Factor units", (String)"ratio", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113828']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Number of X-Ray Sources", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113823']/value", document));
        TestCTDose.assertEquals((String)"Checking Number of X-Ray Sources units", (String)"X-Ray sources", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/num[concept/@cv='113823']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Identification Number of the X-Ray Source", (String)"1", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/text[concept/@cv='113832']/value", document));
        TestCTDose.assertEquals((String)"Checking KVP", (String)string6, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113733']/value", document));
        TestCTDose.assertEquals((String)"Checking KVP units", (String)"kV", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113733']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Maximum X-Ray Tube Current", (String)string8, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113833']/value", document));
        TestCTDose.assertEquals((String)"Checking Maximum X-Ray Tube Current units", (String)"mA", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113833']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking X-Ray Tube Current", (String)string7, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113734']/value", document));
        TestCTDose.assertEquals((String)"Checking X-Ray Tube Current units", (String)"mA", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113734']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Exposure Time per Rotation", (String)string9, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113834']/value", document));
        TestCTDose.assertEquals((String)"Checking Exposure Time per Rotation", (String)"s", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113822']/container[concept/@cv='113831']/num[concept/@cv='113834']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Mean CTDIvol", (String)string2, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113830']/value", document));
        TestCTDose.assertEquals((String)"Checking Mean CTDIvol units", (String)"mGy", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113830']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking CTDIw Phantom Type", (String)"IEC Body Dosimetry Phantom", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/code[concept/@cv='113835']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking DLP", (String)string, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113838']/value", document));
        TestCTDose.assertEquals((String)"Checking DLP units", (String)"mGy.cm", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/container[concept/@cv='113829']/num[concept/@cv='113838']/units/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Role in Procedure", (String)"Irradiating Device", (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/value/@cm", document));
        TestCTDose.assertEquals((String)"Checking Device Manufacturer", (String)this.manufacturer, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113878']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Model Name", (String)this.modelName, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113879']/value", document));
        TestCTDose.assertEquals((String)"Checking Device Serial Number", (String)this.serialNumber, (String)xPathFactory.newXPath().evaluate("/DicomStructuredReport/DicomStructuredReportContent/container[concept/@cv='113701']/container[concept/@cv='113819']/code[concept/@cv='113876']/text[concept/@cv='113880']/value", document));
        String string21 = "Found XRayRadiationDoseSR IOD\nParent content item (1.12.7: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.12.7.1: CODE)\nParent content item (1.12.7: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.12.7.2: TEXT)\nParent content item (1.12.7: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.12.7.3: TEXT)\nParent content item (1.12.7: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.12.7.4: TEXT)\nParent content item (1.12.7: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.12.7.5: CODE)\nParent content item (1.15: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.15.1: CODE)\nParent content item (1.15: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.15.2: TEXT)\nParent content item (1.15: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.15.3: TEXT)\nParent content item (1.15: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.15.4: TEXT)\nParent content item (1.15: PNAME) has illegal relationship HAS PROPERTIES with child content item (1.15.5: CODE)\nFound Root Template TID_10011 (CTRadiationDose)\nRoot Template Validation Complete\nIOD validation complete\n";
        DicomSRValidator dicomSRValidator = new DicomSRValidator();
        System.err.println("validate =\n" + dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking validation from StructuredReport Document", (String)string21, (String)dicomSRValidator.validate(attributeList));
        TestCTDose.assertEquals((String)"Checking PatientName", (String)this.patientName, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
        TestCTDose.assertEquals((String)"Checking PatientID", (String)this.patientID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
        TestCTDose.assertEquals((String)"Checking PatientBirthDate", (String)this.patientBirthDate, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate));
        TestCTDose.assertEquals((String)"Checking PatientSex", (String)this.patientSex, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex));
        TestCTDose.assertEquals((String)"Checking PatientAge", (String)this.patientAge, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientAge));
        TestCTDose.assertEquals((String)"Checking PatientWeight", (String)this.patientWeight, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientWeight));
        TestCTDose.assertEquals((String)"Checking PatientSize", (String)this.patientSize, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSize));
        TestCTDose.assertEquals((String)"Checking StudyInstanceUID", (String)this.studyInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID));
        TestCTDose.assertEquals((String)"Checking StudyID", (String)this.studyID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
        TestCTDose.assertEquals((String)"Checking ReferringPhysicianName", (String)this.referringPhysicianName, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ReferringPhysicianName));
        TestCTDose.assertEquals((String)"Checking AccessionNumber", (String)"", (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber));
        TestCTDose.assertEquals((String)"Checking StudyDate", (String)this.studyDate, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
        TestCTDose.assertEquals((String)"Checking StudyTime", (String)this.studyTime, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime));
        TestCTDose.assertEquals((String)"Checking SeriesInstanceUID", (String)this.seriesInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID));
        TestCTDose.assertEquals((String)"Checking SeriesNumber", (String)this.seriesNumber, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        TestCTDose.assertEquals((String)"Checking SOPInstanceUID", (String)this.sopInstanceUID, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID));
        TestCTDose.assertEquals((String)"Checking InstanceNumber", (String)this.instanceNumber, (String)Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber));
        String string22 = structuredReport.toString();
        CTDose cTDose2 = new CTDose(structuredReport);
        StructuredReport structuredReport2 = cTDose2.getStructuredReport();
        String string23 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR alone) as string", (String)string22, (String)string23);
        String string24 = attributeList.toString();
        AttributeList attributeList2 = cTDose2.getAttributeList();
        String string25 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR alone) as string", (String)string24, (String)string25);
        string22 = structuredReport.toString();
        cTDose2 = new CTDose(structuredReport, attributeList);
        structuredReport2 = cTDose2.getStructuredReport();
        string23 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from SR and AttributeList) as string", (String)string22, (String)string23);
        string24 = attributeList.toString();
        attributeList2 = cTDose2.getAttributeList();
        string25 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from SR and AttributeList) as as string", (String)string24, (String)string25);
        string22 = structuredReport.toString();
        cTDose2 = new CTDose(attributeList);
        structuredReport2 = cTDose2.getStructuredReport();
        string23 = structuredReport2.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR (from AttributeList alone) as string", (String)string22, (String)string23);
        string24 = attributeList.toString();
        attributeList2 = cTDose2.getAttributeList();
        string25 = attributeList.toString();
        TestCTDose.assertEquals((String)"Checking round trip SR AttributeList (from AttributeList alone) as as string", (String)string24, (String)string25);
    }

    public void testCTDoseConstructor_PropagationOfDescriptionToAttributeList_IfNoStudyDescriptionInCompositeInstanceContext() throws Exception {
        String string = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string2 = "20010203043000+0000";
        String string3 = "20010203043500+0000";
        String string4 = "Wanted";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string2, string3, string4);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking description is set correctly", (String)string4, (String)cTDose.getDescription());
        AttributeList attributeList = cTDose.getAttributeList();
        String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription);
        TestCTDose.assertEquals((String)"Checking description is copied into StudyDescription", (String)string4, (String)string5);
    }

    public void testCTDoseConstructor_PropagationOfDescriptionToAttributeList_DoesNotOverwriteIfStudyDescriptionAlreadyInCompositeInstanceContext() throws Exception {
        String string = "1.2.124.113532.172.16.11.4.20090807.144612.3424396";
        String string2 = "20010203043000+0000";
        String string3 = "20010203043500+0000";
        String string4 = "Replacement";
        String string5 = "Existing";
        CTDose cTDose = new CTDose(ScopeOfDoseAccummulation.STUDY, string, string2, string3, string4);
        Object object = new LongStringAttribute(TagFromName.StudyDescription);
        ((Attribute)object).addValue(string5);
        this.compositeInstanceContext.put((Attribute)object);
        cTDose.setCompositeInstanceContext(this.compositeInstanceContext);
        TestCTDose.assertEquals((String)"Checking description is set correctly", (String)string4, (String)cTDose.getDescription());
        object = cTDose.getAttributeList();
        String string6 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.StudyDescription);
        TestCTDose.assertEquals((String)"Checking description does not overwrite StudyDescription", (String)string5, (String)string6);
    }
}

