/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CTScanType;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCTIrradiationEventDataFromImages
extends TestCase {
    public TestCTIrradiationEventDataFromImages(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCTIrradiationEventDataFromImages");
        testSuite.addTest((Test)new TestCTIrradiationEventDataFromImages("TestCTIrradiationEventDataFromImages_PitchFactorZero"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCTIrradiationEventDataFromImages_PitchFactorZero() throws Exception {
        double d = 0.0;
        String string = "0";
        String string2 = "1.2.3.4";
        String string3 = "1.2.3.4.5";
        File file = File.createTempFile("TestCTIrradiationEventDataFromImages_PitchFactorZero", ".tmp");
        file.deleteOnExit();
        Object object = new AttributeList();
        Object object2 = new FloatDoubleAttribute(TagFromName.SpiralPitchFactor);
        ((Attribute)object2).addValue(d);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.IrradiationEventUID);
        ((Attribute)object2).addValue(string2);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object2).addValue(string3);
        ((AttributeList)object).put((Attribute)object2);
        ((AttributeList)object).write(file, "1.2.840.10008.1.2.1", false, true);
        object = new AttributeList();
        ((AttributeList)object).read(file);
        object2 = ((AttributeList)object).get(TagFromName.SpiralPitchFactor);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking SpiralPitchFactor value", (String)string, (String)((Attribute)object2).getSingleStringValueOrNull());
        object2 = ((AttributeList)object).get(TagFromName.IrradiationEventUID);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking IrradiationEventUID value", (String)string2, (String)((Attribute)object2).getSingleStringValueOrNull());
        object2 = ((AttributeList)object).get(TagFromName.SOPInstanceUID);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking SOPInstanceUID value", (String)string3, (String)((Attribute)object2).getSingleStringValueOrNull());
        object = new CTIrradiationEventDataFromImages();
        ((CTIrradiationEventDataFromImages)object).add(file);
        object2 = ((CTIrradiationEventDataFromImages)object).getAcquisitionParametersForIrradiationEvent(string2);
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters SpiralPitchFactor value", (String)string, (String)((CTAcquisitionParameters)object2).getPitchFactor());
        TestCTIrradiationEventDataFromImages.assertEquals((String)"Checking CTAcquisitionParameters ScanType stationary because of zero pitch", (Object)CTScanType.STATIONARY, (Object)((CTAcquisitionParameters)object2).getScanType());
    }
}

